<?php
/**
 * Created by PhpStorm.
 * User: raja
 * Date: 12/26/15
 * Time: 5:01 PM
 */

namespace App\Forms;

use App\Models\Academic\AcademicClass;
use App\Models\Attendance\StudentAttendance;
use App\Models\Designation\Designation;
use App\Models\District\District;
use App\Models\Edu\WeekdayName;
use App\Models\EmployeeCategory\EmpCategory;
use App\Models\EmployeePosition\EmpPosition;
use App\Models\Gender\Gender;
use App\Models\Department\Department;
use App\Models\Holydays\HolyDayType;
use App\Models\Leave\Leave;
use App\Models\Marks\MarksType;
use App\Models\Menu\Menu;
use App\Models\Meta\MetaSetting;
use App\Models\Permission\Permission;
use App\Models\Punch\Punch;
use App\Models\Religion\Religion;
use App\Models\Religion\ReligionTranslation;
use App\Models\Result\ResultSystem;
use App\Models\Result\TotalResultSystem;
use App\Models\Role\Role;
use App\Models\Salary\BonusRule;
use App\Models\Salary\OvertimeRule;
use App\Models\Salary\SalaryCutRule;
use App\Models\Salary\SalaryRule;
use App\Models\Salary\SalaryType;
use App\Models\Shift\Shift;
use App\Models\Meta;
use App\Models\Shift\ShiftTranslation;
use App\Models\Site\Role\SiteRole;
use App\Models\Site\SiteGroup;
use App\Models\Site\SiteType;
use App\Models\Status\Status;
use App\Models\Student\AcademicClassModel;
use App\Models\Student\Section;
use App\Models\SubjectGroup\SubjectGroup;
use App\Models\Subject\Subject;
use App\Models\Thana\Thana;
use App\User;
use App\Models\Building\Building;
use App\Models\Email\Email;
use App\Models\Floor\Floor;
use App\Models\Room\Room;
use App\Models\Examinations\Examination;
use App\Models\Country\Country;
use App\Models\Division\Division;
use App\Models\Account\AccountType;
use App\Models\Amount\AmountType;
use App\Models\Amount\AmountCategory;
use App\Models\Book\BookCategory;
use App\Models\Author\Author;
use App\Models\ExperienceCategory\ExperienceCategory;
use App\Models\SkillCategory\SkillCategory;
use App\Models\Skill\Skill;
use App\Models\CvLanguage\CvLanguage;
use App\Models\Relation\Relation;
use App\Models\BusinessType\BusinessType;
use App\Models\Experience\Experience;
use App\Models\EducationLevel\EducationLevel;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteMembership;
use App\Models\Account\Account;
use App\Models\Timetable\ClassTiming;
use App\Models\Timetable\ClassTimingDetail;
use App\Models\Timetable\TimetableWeekdayClasstimingHistory;
use App\Models\Timetable\WeekdayClassTiming;
use App\Models\Timetable\Timetable;
use Carbon\Carbon;
use Illuminate\Support\Facades\Session;
use Auth;

trait DataHelper
{
    public function siteMembershipList()
    {
        $siteMemShips = new SiteMembership();
        $siteMemShipList = ['select'];

        foreach ($siteMemShips->all() as $siteMemShip) {
            $siteMemShipList[$siteMemShip->id] = $siteMemShip->name;
        }
        return $siteMemShipList;
    }

    public function getWeekDays()
    {
        return array('Saturday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday');
    }

    public function getWeekDay()
    {

        $w = new WeekdayName();
        return $w->orderBy('id', 'ASC')->get();// array('Saturday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday');
    }

    /**
     * @return string
     */
    public function siteTypeKeys()
    {
        $siteTypeKeys = implode(',', array_except(array_keys($this->siteMembershipList()), [0]));

        //dd($siteTypeKeys);

        return $siteTypeKeys;
    }

    public function siteGroupList()
    {
        $siteGroups = new SiteGroup();
        $siteGroupList = ['select'];

        foreach ($siteGroups->all() as $siteGroup) {
            $siteGroupList[$siteGroup->id] = $siteGroup->name;
        }
        return $siteGroupList;
    }

    public function siteGender()
    {
        //$siteGroups = new SiteGroup();
        $siteGroupList = [0 => 'select', 1 => 'Boys', 2 => 'Girls', 3 => 'Both'];
        // $siteGroupList = $siteGroupList.'Girls';

        return $siteGroupList;
    }

    public function paymentItems()
    {

        $siteGroupList = [0 => 'select', 1 => 'SMS', 2 => 'DUE', 3 => 'Payment'];

        return $siteGroupList;
    }

    public function issueTypes()
    {

        $list = [
            'user:log' => 'User:Log',
            'fetch:log' => 'fetch:log',
            'organize:log' => 'organize:log',
            'job' => 'Jobs',
            'sms' => 'SMS',
            'sms_failed' => 'SMS Failed',
            'mail' => 'Mail',
            'payment-gateway-setting' => 'Gateway Setting',
            'online-transaction-start:site-student' => 'Student Transaction Start',
            'online-transaction-success:site-student' => 'Student Transaction Success',
            'online-transaction-failed:site-student' => 'Student Transaction Failed',
            'online-transaction-receive-error:site-student' => 'Student Transaction Receive Failed',

            'payment-auto-update-success:site-student' => 'Student Payment Auto Updated',
            'payment-auto-update-failed:site-student' => 'Student Payment Auto Update Failed',
            'payment-auto-update-success:site-admission' => 'Admission Payment Auto Updated',
            'payment-auto-update-failed:site-admission' => 'Admission Payment Auto Update Failed',
        ];

        return $list;
    }

    public function maskingList()
    {
        $list = [
            'non_masking' => 'Non Masking',
         //   'EDU WORLD' => 'EDU WORLD(mobireach)',
         //   'Edu World' => 'Edu World',
            'EDU WORLD' => 'EDU WORLD',
         //   'Guardian ES' => 'Guardian ES',
        ];
        return $list;
    }

    public function smsCompany()
    {
        $list = [
            'smsinbd' => 'Sms In BD',
            'mobireach' => 'mobireach',
            'zamanit' => 'Zaman It',
            'viatech' => 'Via Tech',
            'rtcom' => 'RT Com',
        ];
        return $list;
    }

    /**
     * @return string
     */
    public function siteGroupKeys()
    {
        $siteGroupKeys = implode(',', array_except(array_keys($this->siteGroupList()), [0]));

        return $siteGroupKeys;
    }

    /**
     * @param $role
     * @return mixed
     */
    public function role($role)
    {
        $roles = new SiteRole();
        $role = $roles->whereName($role)->first();

//        dd();
        /*   $roleEmployee = $roles->whereName('employee')->first()->id;*/
        if ($role) {
            return $role->id;
        }

        return null;
    }

    /**
     * @return array
     */
    public function shiftList()
    {
        $shifts = new Shift();
        $shiftList = ['select'];
        foreach ($shifts->all() as $shift) {
            $shiftList[$shift->id] = $shift->name;
        }
        return $shiftList;
    }


    public function shiftKeys()
    {
        $shiftKeys = implode(',', array_except(array_keys($this->shiftList()), [0]));
        return $shiftKeys;
    }

    /**
     * @return array
     */
    public function permissionsList()
    {
        $permissions = new Permission();
        $permissionList = ['select'];
        foreach ($permissions->all() as $permission) {
            $permissionList[$permission->id] = $permission->name;
        }
        return $permissionList;
    }

    /**
     * @return string
     */
    public function permissionKeys()
    {
        $permissionKeys = implode(',', array_except(array_keys($this->permissionsList()), [0]));
        return $permissionKeys;
    }

    /**
     * @return array
     */
    public function rolesList()
    {
        $roles = new SiteRole();
        $roleList = ['Select User Group'];
        foreach ($roles->all() as $role) {
            $roleList[$role->id] = $role->name;
        }

        return $roleList;
    }

    public function roleKeys()
    {
        $roleKeys = implode(',', array_except(array_keys($this->rolesList()), [0]));

        return $roleKeys;
    }

    public function menusList()
    {
        $menus = new Menu();
        $menuList = ['Select Menu'];
        foreach ($menus->whereIsDisplayable(1)->get() as $menu) {
            $menuList[$menu->id] = $menu->menu_name;
        }

        return $menuList;
    }

    public function menuForList()
    {
        $menus = [
            'none' => 'None',
            'all' => 'All',
            'website' => 'Web Site',
            'api' => 'API',
            'eduworld' => 'Edu World',
            'site_group' => 'Site Group',
            'site' => 'Site',
            'student' => 'Student',
            'guardian' => 'Guardian',

        ];


        return $menus;
    }

    public function boardList()
    {
        $menus = [
            1 => 'Chattogram Board',
            2 => 'Dhaka Board',
            3 => 'Dinajpur Board',
            4 => 'Jessore Board',
            5 => 'Rajshahi Board',
            6 => 'Sylhet Board',
            7 => 'Madrasah Board',
            8 => 'Technical Board',
            9 => 'Comillag Board',
            10 => 'DIBS(Dhaka) Board'

        ];


        return $menus;
    }

    public function menuKeys()
    {
        $menuKeys = implode(',', array_except(array_keys($this->menusList()), [0]));

        return $menuKeys;
    }

    public function roleListForUser()
    {
        $roles = new Role();
        $roleListForUser = ['select'];
        $teacherId = $this->role('Teacher');
        $studentId = $this->role('Student');
        $guardianId = $this->role('Guardian');

        $userRole = $roles->where('id', '<>', $teacherId)
            ->where('id', '<>', $studentId)
            ->where('id', '<>', $guardianId)
            ->get();

        foreach ($userRole as $role) {
            $roleListForUser[$role->id] = $role->name;
        }

        return $roleListForUser;
    }

    public function roleKeysForUser()
    {
        $roleKeysForUser = implode(',', array_except(array_keys($this->roleListForUser()), [0]));
        return $roleKeysForUser;
    }

    /**
     * @return array
     */
    public function usersList()
    {
        $users = new User();

        $userList = ['select'];
        foreach ($users->all() as $user) {

            $firstName = $user->translate('en') ? $user->translate('en')->first_name : $user->first_name;
            $lastName = $user->translate('en') ? $user->translate('en')->last_name : $user->last_name;
//            dd($user->translate('en'));
            $userList[$user->id] = $firstName . ' ' . $lastName;
        }

        return $userList;
    }

    /**
     * @return string
     */
    public function userKeys()
    {
        $userKeys = implode(',', array_except(array_keys($this->usersList()), [0]));

        return $userKeys;
    }

    /**
     * @return array
     */
    public function employeeListForSalary()
    {
        $users = new User();
        $role = new Role();
        $guardianRoleId = $this->role('Guardian');
        $studentRoleId = $this->role('Student');

        $userList = ['select'];
        foreach ($users->all() as $user) {
            if (!$user->hasRole('Student')
                && !$user->hasRole('Guardian')
            ) {

                $firstName = $user->translate('en') ? $user->translate('en')->first_name : $user->first_name;
                $lastName = $user->translate('en') ? $user->translate('en')->last_name : $user->last_name;
                $userList[$user->id] = $firstName . ' ' . $lastName;
            }
        }

        return $userList;
    }

    /**
     * @return string
     */
    public function employeeKeysForSalary()
    {
        $userKeys = implode(',', array_except(array_keys($this->employeeListForSalary()), [0]));

        return $userKeys;
    }


    /**
     * @return array
     */
    public function genderList()
    {
        $genders = new Gender();
        $genderList = ['Select Gender'];


        foreach ($genders->active()->get() as $gender) {
            $genderList[$gender->id] = $gender->translate('en')->gender_name;
        }
        //dd($genderList);
        return $genderList;
    }


    /**
     * @return string
     */
    public function genderKeys()
    {
        $genKeys = implode(',', array_except(array_keys($this->genderList()), [0]));

        //  dd($genKeys);

        return $genKeys;
    }

    /**
     * @return array
     */
    public function multiGenderList()
    {
        $gender = new Gender();
        $locales = config('app.locales');
        $multiGenderList = [];
        foreach ($locales as $locale => $language) {
            $gen = ['select'];
            foreach ($gender->all() as $genList) {
                app()->setLocale($locale);
                if ($genList->gender_name)
                    $gen[$genList->id] = $genList->gender_name;
            }
            $multiGenderList[$locale] = $gen;
        }

        return $multiGenderList;
    }

    /**
     * @return array
     */
    public function guardianList()
    {
        $roleObject = new Role();
        $roleId = $this->role('Guardian');
        $roleOfGuardian = $roleObject->findOrFail($roleId);
        $guardians = $roleOfGuardian->users;
        $guardianList = ["Select Guardian"];


        foreach ($guardians->all() as $guardian) {
            $guardianList[$guardian->id] = $guardian->translate('en')->first_name . ' ' . $guardian->translate('en')->last_name;
//            $guardianList[$guardian->id][$guardian->photos->last()->id] = $guardian->photos->last()->name;
            // $guardianList->prepend('Define New', '1');
        }
        return $guardianList;
    }

    public function guardianImageList()
    {
        $roleObject = new Role();
        $roleId = $this->role('Guardian');
        $roleOfGuardian = $roleObject->findOrFail($roleId);
        $guardians = $roleOfGuardian->users;
        $guardianList = ["Select Guardian"];
//Create an array of option attribute
        $opt_attributes = collect($guardians->all())
            ->mapWithKeys(function ($item) {
                return [$item->id => ['data-img' => $item->photos->last()->name ?? 'no']];
            })->all();
        return $opt_attributes;
    }

    /**
     * @return string
     */
    public function guardianKeys()
    {
        $guardianKeys = implode(',', array_except(array_keys($this->guardianList()), [0]));

        return $guardianKeys;
    }


    /**
     * @return array
     */
    public function teacherList()
    {
        $roleObject = new Role();
        $roleId = $this->role('Teacher');
        $roleOfTeacher = $roleObject->findOrFail($roleId);
        $teachers = $roleOfTeacher->users;
        $teacherList = ['Select Teacher'];

        foreach ($teachers->all() as $teacher) {
            $teacherList[$teacher->id] = $teacher->translate('en')->first_name . ' ' . $teacher->translate('en')->last_name;
        }
        return $teacherList;
    }

    public function markTypeList()
    {
        $roleObject = new MarksType();
        $teacherList = [];
        foreach ($roleObject->all() as $teacher) {
            $teacherList[$teacher->id] = $teacher->marks_type;
        }
        return $teacherList;
    }

    public function teacherKeys()
    {
        $teacherKeys = implode(',', array_except(array_keys($this->teacherList()), [0]));

        return $teacherKeys;
    }

    /**
     * @return array
     */
    public function studentList()
    {
        $roleObject = new Role();
        $roleId = $this->role('Student');
        $roleOfStudent = $roleObject->findOrFail($roleId);
        $students = $roleOfStudent->users;
        $studentList = ['Select Student'];

        foreach ($students->all() as $student) {
            $studentList[$student->id] = $student->translate('en')->first_name . ' ' . $student->translate('en')->last_name;
        }
        return $studentList;
    }

    public function studentKeys()
    {
        $studentKeys = implode(',', array_except(array_keys($this->studentList()), [0]));

        return $studentKeys;
    }

    /**
     * @return array
     */
    public function relegionList()
    {
        $religion = new Religion();
        $rel = ['Select Religion'];
        foreach ($religion->all() as $reliList) {
            $rel[$reliList->id] = $reliList->name;
        }

        return $rel;
    }

    public function shiftData()
    {
        $shift = new Shift();
        $rel = ['Select Shift'];
        foreach ($shift->all() as $shfList) {
            $rel[$shfList->id] = $shfList->name;
        }

        return $rel;
    }

    /**
     * @return string
     */
    public function relegionKeys()
    {
        $relKeys = implode(',', array_except(array_keys($this->relegionList()), [0]));

        return $relKeys;
    }

    /**
     * @return array
     */
    public function departmentList()
    {
        $department = new Department();
        $dept = ['Select Department'];
        foreach ($department->all()->where('type', 'Student') as $deptList) {
            $dept[$deptList->id] = $deptList->name;
        }

        return $dept;
    }

    /**
     * @return array
     */


    public function hrDepartmentList()
    {
        $department = new Department();
        $dept = ['Select Department'];
        foreach ($department->all()->where('type', 'HR') as $deptList) {
            $dept[$deptList->id] = $deptList->name;
        }

        return $dept;
    }


    /**
     * @return string
     */
    public function departmentKeys()
    {
        $deptKeys = implode(',', array_except(array_keys($this->departmentList()), [0]));

        return $deptKeys;
    }


    /**
     * @return string
     */
    public function hrDepartmentKeys()
    {
        $deptKeys = implode(',', array_except(array_keys($this->hrDepartmentList()), [0]));


        return $deptKeys;
    }


    public function designationList()
    {
        $designation = new Designation();
        $des = ['Select Designation'];
        foreach ($designation->all() as $designationList) {
            $des[$designationList->id] = $designationList->name;
        }
//dd($des);
        return $des;
    }

    public function designationKeys()
    {
        $desKeys = implode(',', array_except(array_keys($this->designationList()), [0]));


        return $desKeys;
    }

    /**
     *
     * @return array
     */
    public function empcategoryList()
    {
        $empcategory = new EmpCategory();
        $empcat = ['Select Category'];
        foreach ($empcategory->all() as $empcategoryList) {
            $empcat[$empcategoryList->id] = $empcategoryList->name;
        }

        return $empcat;
    }


    /**
     * @return string
     */
    public function empcategoryKeys()
    {
        $empcategoryKeys = implode(',', array_except(array_keys($this->empcategoryList()), [0]));

        return $empcategoryKeys;
    }

    public function empopositionList()
    {
        $empposition = new EmpPosition();
        $empop = ['Select Position'];
        foreach ($empposition->all() as $empopositionList) {
            $empop[$empopositionList->id] = $empopositionList->name;
        }

        return $empop;
    }


    /**
     * @return string
     */
    public function empopositionKeys()
    {
        $empoposKeys = implode(',', array_except(array_keys($this->empopositionList()), [0]));

        return $empoposKeys;
    }

    /**
     * @return array
     */
    public function sectionList()
    {
        $sections = new Section();
        $sectionList = ['Select Section'];
        foreach ($sections->all() as $section) {
            $sectionList[$section->id] = $section->section_name;
        }

        return $sectionList;
    }

    /**
     * @return string
     */
    public function sectionKeys()
    {
        $sectionKeys = implode(',', array_except(array_keys($this->sectionList()), [0]));

        return $sectionKeys;
    }

    /**
     *
     */
    public function subjectGroupList()
    {
        $subjectGroups = new SubjectGroup();
        $subjectGroupList = ['Select Subject Group'];
//        dd($subjectGroups->all());
        foreach ($subjectGroups->all() as $subjectGroup) {
            $subjectGroupList[$subjectGroup->id] = $subjectGroup->subject_group_name;
        }
//        dd($subjectGroupList);
        return $subjectGroupList;
    }

    /**
     * @return string
     */
    public function subjectGroupKeys()
    {
        $subjectGroupKeys = implode(',', array_except(array_keys($this->subjectGroupList()), [0]));

        return $subjectGroupKeys;
    }

    /**
     * @return array
     */
    public function classList()
    {
        $classes = new AcademicClass();
        $classList = ['Select Class'];
        foreach ($classes->all() as $clList) {
            $classList[$clList->id] = $clList->class_name;
        }

        return $classList;
    }

    /**
     * @return string
     */
    public function classKeys()
    {
        $classKeys = implode(',', array_except(array_keys($this->classList()), [0]));

        return $classKeys;
    }

    /**
     * @return array
     */
    public function subjectList()
    {
        $subjects = new Subject();
        $subjectList = ['Select Subject'];
        foreach ($subjects->all() as $subject) {
            $subjectList[$subject->id] = $subject->subject_name;
        }

        //dd($subjectList);
        return $subjectList;
    }

    public function combineNameKeys()
    {
        $subjectGroupKeys = implode(',', array_except(array_keys($this->subjectList()), [0]));

        return $subjectGroupKeys;
    }


    public function optionList()
    {
        $options = new Option();
        $optionList = ['select'];
        foreach ($options->all() as $option) {

            $optionList[$option->id] = $option->value;

        }

        return $optionList;
    }


    /**
     * @return string
     */
    public function subjectKeys()
    {
        $subjectKeys = implode(',', array_except(array_keys($this->subjectList()), [0]));

        return $subjectKeys;
    }


    /**
     * @return array
     */
    public function resultSystemList()
    {
        $resultSystems = new ResultSystem();
        $resultSystemList = ['Select Result System'];
        foreach ($resultSystems->all() as $rsList) {
            $resultSystemList[$rsList->id] = $rsList->name;
        }
        return $resultSystemList;
    }

    /**
     * @return string
     */
    public function resultSystemKeys()
    {
        $resultSystemKeys = implode(',', array_except(array_keys($this->resultSystemList()), [0]));

        return $resultSystemKeys;
    }

    /**
     * @return array
     */
    public function totalResultSystemList()
    {
        $totalResultSystems = new TotalResultSystem();
        $totalResultSystemList = ['select'];
        foreach ($totalResultSystems->all() as $rsList) {
            $totalResultSystemList[$rsList->id] = $rsList->name;
        }
        return $totalResultSystemList;
    }

    /**
     * @return string
     */
    public function totalResultSystemKeys()
    {
        $totalResultSystemKeys = implode(',', array_except(array_keys($this->totalResultSystemList()), [0]));

        return $totalResultSystemKeys;
    }

    /**
     * @return mixed
     */
    public function emailerId($emailerId)
    {
//        dd($emailerId);
        $email = new Email();

        $emailId = $email->where('emailer_id', $emailerId)->firstOrFail();

        return $emailId;
    }

    /**
     * @return array
     */
    public function statusList()
    {
        $statuses = new Status();
        $statusList = ['select'];
        foreach ($statuses->all() as $status) {
            $statusList[$status->id] = $status->name;
        }

        return $statusList;
    }

    /**
     * @return string
     */
    public function statusKeys()
    {
        $statusKeys = implode(',', array_except(array_keys($this->statusList()), [0]));

        return $statusKeys;
    }

    /**
     * @return array
     */
    public function leaveList()
    {
        $leaves = new Leave();
        $leaveList = ['select'];
        foreach ($leaves->all() as $leave) {
            $leaveList[$leave->id] = $leave->type;
        }

        return $leaveList;
    }

    /**
     * @return string
     */
    public function leaveKeys()
    {
        $leaveKeys = implode(',', array_except(array_keys($this->leaveList()), [0]));

        return $leaveKeys;
    }

    /**
     * @return array
     */
    public function holydayTypeList()
    {
        $holidayTypes = new HolyDayType();
        $holydayTypeList = ['select'];
        foreach ($holidayTypes->all() as $holydayType) {
            $holydayTypeList[$holydayType->id] = $holydayType->type;
        }

        return $holydayTypeList;
    }

    /**
     * @return string
     */
    public function holydayTypeKeys()
    {
        $holydayTypeKeys = implode(',', array_except(array_keys($this->holydayTypeList()), [0]));
        return $holydayTypeKeys;
    }

    /**
     * @return array
     */
    public function salaryAmountTypeList()
    {
        $amountTypeList = ['select', 'fixed' => 'Fixed', 'percent' => 'Percent'];
        return $amountTypeList;
    }

    /**
     * @return array
     */
    public function salaryAmountTypeListForOthers()
    {
        $amountTypeList = ['' => 'Select', 'fixed' => 'Fixed', 'percent' => 'Percent', 'plus' => 'Plus', 'minus' => 'Minus'];
        return $amountTypeList;
    }

    /**
     * @return string
     */
    public function salaryAmountTypeKeysForOthers()
    {
        $salaryAmountTypeKeys = implode(',', array_except(array_keys($this->salaryAmountTypeListForOthers()), [0]));
        return $salaryAmountTypeKeys;
    }

    /**
     * @return string
     */
    public function salaryAmountTypeKeys()
    {
        $salaryAmountTypeKeys = implode(',', array_except(array_keys($this->salaryAmountTypeList()), [0]));
        return $salaryAmountTypeKeys;
    }

    /**
     * @return array
     */
    public function monthList()
    {
        $monthList = ['Select Month'];
        for ($m = 1; $m <= 12; $m++) {
            $month = date("F", mktime(0, 0, 0, $m));
            $monthList[$m] = $month;
        }

        return $monthList;
    }

    /**
     * @return string
     */
    public function monthKeys()
    {
        $monthKeys = implode(',', array_except(array_keys($this->monthList()), [0]));
        return $monthKeys;

    }

    /**
     * @return array
     */
    public function yearList()
    {
        $yearList = ['select Year'];
        $starting_year = date('Y', strtotime('-10 year'));
        $ending_year = date('Y', strtotime('+10 year'));
        $current_year = date('Y');

        for ($starting_year; $starting_year <= $ending_year; $starting_year++) {

            $yearList[$starting_year] = $starting_year;
        }

        return $yearList;
    }

    /**
     * @return string
     */
    public function yearKeys()
    {
        $yearKeys = implode(',', array_except(array_keys($this->yearList()), [0]));
        return $yearKeys;
    }

    /**
     * @return array
     */
    public function salaryType()
    {
        $salaryTypeObject = new SalaryType();

        $salaryTypes = $salaryTypeObject->all();

        $salaryTypeDetails = [];


        foreach ($salaryTypes as $salaryType) {

            $salaryTypeDetails[] = [
                [
                    'type' => 'label',
                    'value' => $salaryType->name . ' Details',
                    'labclass' => 'col-sm-12',
                    'wrapclass' => 'col-sm-12',
                    'others' => [
                        'class' => 'form-control',
                        'style' => 'background-color:#aaa; color:white'
                    ],
                ],
                [
                    'type' => 'text',
                    'name' => str_slug($salaryType->name, '_') . '_amount',
                    'label' => 'Amount',
                    'labclass' => 'col-sm-12',
                    'wrapclass' => 'col-sm-12',
                    'others' => [
                        'class' => 'form-control',
                    ],
                    'validation' => 'required'

                ],
                [
                    'type' => 'select',
                    'name' => str_slug($salaryType->name, '_') . '_amount_type',
                    'label' => 'Amount Type',
                    'others' => ['class' => 'form-control'],
                    'labclass' => 'col-sm-12',
                    'wrapclass' => 'col-sm-12',
                    'trans' => false,
                    'options' => $this->salaryAmountTypeList(),
                    'value' => 0,
                    'validation' => "required|in:" . $this->salaryAmountTypeKeys()
                ]
            ];


        }
        return $salaryTypeDetails;

    }

    public function marksTypes()
    {
        $marksTypeObject = new MarksType();

        $markTypes = $marksTypeObject->all();

        $markTypeDetails = [];


        foreach ($markTypes as $markType) {

            $markTypeDetails[] = [

                [
                    'type' => 'text',
                    'name' => str_slug($markType->marks_type, '_') . '_total',
                    'label' => $markType->marks_type . ' ' . 'Total',
                    'others' => ['class' => 'form-control'],
                    'labclass' => 'col-sm-12',
                    'wrapclass' => 'col-sm-12',
                    'trans' => false,
                    'value' => null,
                    'validation' => "required"
                ],
                [
                    'type' => 'text',
                    'name' => str_slug($markType->marks_type),
                    'label' => $markType->marks_type,
                    'labclass' => 'col-sm-12',
                    'wrapclass' => 'col-sm-12',
                    'others' => [
                        'class' => 'form-control',
                    ],
                    'validation' => 'required'

                ],
            ];


        }
        return $markTypeDetails;

    }

    /**
     * @return array
     */
    public function salaryTypeList()
    {
        $salaryTypeObject = new SalaryType();
        $salaryTypes = $salaryTypeObject->all();
        $salaryTypeList = [];
        foreach ($salaryTypes->all() as $salaryType) {
            $salaryTypeList[snake_case($salaryType->name)] = $salaryType->id;
        }
        return $salaryTypeList;
    }

    public function salaryTypeKeys()
    {
        $salaryTypeKeys = implode(',', array_except(array_keys($this->salaryTypeList()), [0]));
        return $salaryTypeKeys;
    }

    /**
     * @return array
     */
    public function salaryTypeListForOvertime()
    {
        $salaryTypeObject = new SalaryType();

        $salaryTypes = $salaryTypeObject->all();
        $salaryTypeList = [];
//        dd($salaryTypes->all());
        foreach ($salaryTypes->all() as $salaryType) {
            $salaryTypeList[snake_case($salaryType->name) . '_overtime'] = $salaryType->name;
        }
//        dd($salaryTypeList) ;
        return $salaryTypeList;
    }

    /**
     * @return array
     */
    public function salaryTypeListForBonus()
    {
        $salaryTypeObject = new SalaryType();

        $salaryTypes = $salaryTypeObject->all();
        $salaryTypeList = [];
//        dd($salaryTypes->all());
        foreach ($salaryTypes->all() as $salaryType) {
            $salaryTypeList[snake_case($salaryType->name) . '_bonus'] = $salaryType->name;
        }
//        dd($salaryTypeList) ;
        return $salaryTypeList;
    }

    /**
     * @return array
     */
    public function salaryTypeListForSalaryCut()
    {
        $salaryTypeObject = new SalaryType();

        $salaryTypes = $salaryTypeObject->all();
        $salaryTypeList = [];
//        dd($salaryTypes->all());
        foreach ($salaryTypes->all() as $salaryType) {
            $salaryTypeList[snake_case($salaryType->name) . '_salarycut'] = $salaryType->name;
        }
//        dd($salaryTypeList) ;
        return $salaryTypeList;
    }

    /**
     * @return array
     */
    public function salaryAllowanceList()
    {
        $allowanceObject = new SalaryRule();
        $allowances = $allowanceObject->all();
        $allowanceList = ['select'];
        foreach ($allowances as $allowance) {
            $allowanceList[$allowance->id] = $allowance->name;
        }

        return $allowanceList;
    }

    /**
     * @return string
     */
    public function allowanceKeys()
    {
        $allowanceKeys = implode(',', array_except(array_keys($this->salaryAllowanceList()), [0]));
        return $allowanceKeys;
    }

    /**
     * @return array
     */
    public function overtimeList()
    {
        $overtimeObject = new OvertimeRule();
        $overtimes = $overtimeObject->all();
        $overtimeList = ['select'];
        foreach ($overtimes as $overtime) {
            $overtimeList[$overtime->id] = $overtime->name;
        }

        return $overtimeList;
    }

    /**
     * @return string
     */
    public function overtimeKeys()
    {
        $overtimeKeys = implode(',', array_except(array_keys($this->OvertimeList()), [0]));
        return $overtimeKeys;
    }

    /**
     * @return array
     */
    public function salaryCutList()
    {
        $salaryCutObject = new SalaryCutRule();
        $salaryCuts = $salaryCutObject->all();
        $salaryCutList = ['select'];
        foreach ($salaryCuts as $salaryCut) {
            $salaryCutList[$salaryCut->id] = $salaryCut->name;
        }

        return $salaryCutList;
    }

    /**
     * @return string
     */
    public function salaryCutKeys()
    {
        $salaryCutKeys = implode(',', array_except(array_keys($this->salaryCutList()), [0]));
        return $salaryCutKeys;
    }

    /**
     * @return array
     */
    public function bonusList()
    {
        $bonusObject = new BonusRule();
        $bonuses = $bonusObject->all();
        $bonusList = ['select'];
        foreach ($bonuses as $bonus) {
            $bonusList[$bonus->id] = $bonus->name;
        }

        return $bonusList;
    }


    /**
     * @return string
     */
    public function bonusKeys()
    {
        $bonusKeys = implode(',', array_except(array_keys($this->bonusList()), [0]));
        return $bonusKeys;
    }

    /**
     * @return array of punch years
     */
    public function punchYearList()
    {
        $punchYearObject = new Punch();
        $punches = $punchYearObject->all();
        $yearList = ['Select Year'];
        foreach ($punches as $punch) {
            $yearList[$punch->punch_year] = $punch->punch_year;
        }

        return $yearList;
    }


    /**
     * @return string
     */
    public function punchYearKeys()
    {
        $punchYearKeys = implode(',', array_except(array_keys($this->punchYearList()), [0]));
        return $punchYearKeys;
    }

    /**
     * @return array of punch years
     */
    public function stdAttendanceYeayList()
    {
        $attendanceYearObject = new StudentAttendance();
        $attendances = $attendanceYearObject->all();
        $yearList = ['Select Year'];
        foreach ($attendances as $attendance) {
            $yearList[$attendance->present_year] = $attendance->present_year;
        }

        return $yearList;
    }

    /**
     * @return string
     */
    public function stdAttendanceYearKeys()
    {
        $attendanceYearKeys = implode(',', array_except(array_keys($this->stdAttendanceYeayList()), [0]));
        return $attendanceYearKeys;
    }

    /**
     * get all the classNames(form names) under a single namespace ERP\Forms
     *
     * @return array
     */
    public function formClassList()
    {
        $allFiles = new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator(base_path('app/Forms')));
        $phpFiles = new \RegexIterator($allFiles, '/\.php$/');

        foreach ($phpFiles as $phpFile) {

            $content = file_get_contents($phpFile->getRealPath());

            $tokens = token_get_all($content);
            $namespace = '';
            for ($index = 0; isset($tokens[$index]); $index++) {
                if (!isset($tokens[$index][0])) {
                    continue;
                }
                if (T_NAMESPACE === $tokens[$index][0]) {
                    $index += 2; // Skip namespace keyword and whitespace
                    while (isset($tokens[$index]) && is_array($tokens[$index])) {
                        $namespace .= $tokens[$index++][1];
                    }
                }
                if (T_CLASS === $tokens[$index][0]) {
                    $index += 2; // Skip class keyword and whitespace
                    $fqcns[] = $namespace . '\\' . $tokens[$index][1];
                }
            }
        }
        $formNames = ['select'];
        foreach ($fqcns as $fqcn) {
            $jj = explode('\\', $fqcn);
            $formName = end($jj);

            $formNames[$formName] = $formName;

        }
        return $formNames;
    }

    /**
     * @return string
     */
    public function formClassKeys()
    {
        $formClassKeys = implode(',', array_except(array_keys($this->formClassList()), [0]));

        return $formClassKeys;
    }

    /**
     * @return array
     */
    public function buildingList()
    {
        $building = new Building();
        $buil = ['Select Building'];
        foreach ($building->all() as $builList) {
            $buil[$builList->id] = $builList->building_name;
        }

        return $buil;
    }

    /**
     * @return string
     */
    public function buildingKeys()
    {
        $builKeys = implode(',', array_except(array_keys($this->buildingList()), [0]));

        return $builKeys;
    }

    /**
     * @return array
     */
    public function floorList()
    {
        $floor = new Floor();
        $fl = ['Select Floor'];
        foreach ($floor->all() as $flList) {
            $fl[$flList->id] = $flList->floor_name;
        }
        return $fl;
    }

    /**
     * @return string
     */
    public function floorKeys()
    {
        $flKeys = implode(',', array_except(array_keys($this->floorList()), [0]));

        return $flKeys;
    }

    /**
     * @return array
     */
    public function roomList()
    {
        $room = new Room();
        $ro = ['Select Room'];
        foreach ($room->all() as $rList) {
            $ro[$rList->id] = $rList->room_name;
        }
        return $ro;
    }

    /**
     * @return string
     */
    public function roomKeys()
    {
        $rKeys = implode(',', array_except(array_keys($this->roomList()), [0]));

        return $rKeys;
    }

    /**
     * @return array
     */
    public function examinationList()
    {
        $examination = new Examination();
        $exam = ['Select Exam'];
        foreach ($examination->all() as $examList) {
            $exam[$examList->id] = $examList->examination_name;
        }
        return $exam;
    }

    /**
     * @return string
     */
    public function examinationKeys()
    {
        $examKeys = implode(',', array_except(array_keys($this->examinationList()), [0]));

        return $examKeys;
    }

    /**
     * @return array
     */
    public function countryList()
    {
        $countries = new Country();
        $countryList = ['Select Country'];
        foreach ($countries->all() as $country) {
            $countryList[$country->id] = $country->country_name;
        }
//        dd($countryList)
        return $countryList;
    }

    /**
     * @return string
     */
    public function countryKeys()
    {
        $countryKeys = implode(',', array_except(array_keys($this->countryList()), [0]));

        return $countryKeys;
    }

    /**
     * @return array
     */
    public function divisionList()
    {
        $divisions = new Division();
        $divisionList = ['select division'];

        foreach ($divisions->all() as $division) {
            //$divisionList[$division->id] = $division->translate('en')->division_name;
            $divisionList[$division->id] = $division->division_name;
        }
        return $divisionList;
    }

    /**
     * @return string
     */
    public function divisionKeys()
    {
        $divisionKeys = implode(',', array_except(array_keys($this->divisionList()), [0]));

        //dd($divisionKeys);

        return $divisionKeys;
    }


    public function districtList()
    {
        $districts = new District();
        $districtList = ['select district'];

        foreach ($districts->all() as $district) {
            //$divisionList[$division->id] = $division->translate('en')->division_name;
            $districtList[$district->id] = $district->district_name;
        }
        return $districtList;
    }

    public function districtKeys()
    {
        $districtKeys = implode(',', array_except(array_keys($this->districtList()), [0]));

        return $districtKeys;
    }


    public function thanaList()
    {
        $thanas = new Thana();
        $thanaList = ['select thana'];

        foreach ($thanas->all() as $thana) {
            //$divisionList[$division->id] = $division->translate('en')->division_name;
            $thanaList[$thana->id] = $thana->thana_name;
        }
        return $thanaList;
    }

    public function thanaKeys()
    {
        $thanaKeys = implode(',', array_except(array_keys($this->thanaList()), [0]));

        return $thanaKeys;
    }

    public function emcategoryList()
    {
        $categories = new EmpCategory();
        $emcategoryList = ['select category'];

        foreach ($categories->all() as $category) {
            //$divisionList[$division->id] = $division->translate('en')->division_name;
            $emcategoryList[$category->id] = $category->name;
        }
        return $emcategoryList;
    }

    public function emcategoryKeys()
    {
        $emcategoryKey = implode(',', array_except(array_keys($this->emcategoryList()), [0]));

        return $emcategoryKey;
    }

    /**
     * @return array
     */
    public function accountTypeList()
    {
        $accountTypes = new AccountType();
        $accountTypeList = ['select'];

        foreach ($accountTypes->all() as $accountType) {
            $accountTypeList[$accountType->id] = $accountType->translate('en')->account_type_name;
        }
        return $accountTypeList;
    }

    /**
     * @return string
     */
    public function accountTypeKeys()
    {
        $accountTypeKeys = implode(',', array_except(array_keys($this->accountTypeList()), [0]));

        return $accountTypeKeys;
    }

    /**
     * @return array
     */
    public function amountTypeList()
    {
        $amountTypes = new AmountType();
        $amountTypeList = ['select'];

        foreach ($amountTypes->all() as $amountType) {
            $amountTypeList[$amountType->id] = $amountType->translate('en')->amount_type_name;
        }
        return $amountTypeList;
    }

    /**
     * @return string
     */
    public function amountTypeKeys()
    {
        $amountTypeKeys = implode(',', array_except(array_keys($this->amountTypeList()), [0]));

        return $amountTypeKeys;
    }

    /**
     * @return array
     */
    public function amountCategoryList()
    {
        $amountCategories = new AmountCategory();
        $amountCategoryList = ['select'];

        foreach ($amountCategories->all() as $amountCategory) {
            $amountCategoryList[$amountCategory->id] = $amountCategory->translate('en')->amount_category_name;
        }
        return $amountCategoryList;
    }

    /**
     * @return string
     */
    public function amountCategoryKeys()
    {
        $amountCategoryKeys = implode(',', array_except(array_keys($this->amountCategoryList()), [0]));

        return $amountCategoryKeys;
    }

    /**
     * @return array
     */
    public function bookCategoryList()
    {
        $bookCategories = new BookCategory();
        $bookCategoryList = ['Select Book Category'];

        foreach ($bookCategories->all() as $bookCategory) {
            $bookCategoryList[$bookCategory->id] = $bookCategory->translate('en')->book_category_name;
        }
        return $bookCategoryList;
    }

    /**
     * @return string
     */
    public function bookCategoryKeys()
    {
        $bookCategoryKeys = implode(',', array_except(array_keys($this->bookCategoryList()), [0]));

        return $bookCategoryKeys;
    }

    /**
     * @return array
     */
    public function authorList()
    {
        $authors = new Author();
        $authorList = ['Select Author'];

        foreach ($authors->all() as $author) {
            $authorList[$author->id] = $author->translate('en')->author_name;
        }
        return $authorList;
    }

    /**
     * @return string
     */
    public function authorKeys()
    {
        $authorKeys = implode(',', array_except(array_keys($this->authorList()), [0]));

        return $authorKeys;
    }

    /**
     *
     * Training Year List
     *
     * @return array
     */
    public function trainingYearList()
    {
        $dt = Carbon::now();
        $currentYear = $dt->year;
//        dd($currentYear);
        $trainingYearList = ['Select Year'];

        for ($i = $currentYear; $i >= 1953; $i--) {
            $trainingYearList[$i] = $i;
        }
        return $trainingYearList;
    }

    /**
     * @return string
     */
    public function trainingYearKeys()
    {
        $trainingYearKeys = implode(',', array_except(array_keys($this->trainingYearList()), [0]));

        return $trainingYearKeys;
    }

    /**
     * @return array
     */
    public function experienceCategoryList()
    {
        $experienceCategories = new ExperienceCategory();
        $experienceCategoryList = ['Select Experience Category'];

        foreach ($experienceCategories->all() as $experienceCategory) {
            $experienceCategoryList[$experienceCategory->id] = $experienceCategory->translate('en')->experience_category_name;
        }
        return $experienceCategoryList;
    }

    /**
     * @return string
     */
    public function experienceCategoryKeys()
    {
        $experienceCategoryKeys = implode(',', array_except(array_keys($this->experienceCategoryList()), [0]));

        return $experienceCategoryKeys;
    }

    /**
     * @return array
     */
    public function skillCategoryList()
    {
        $skillCategories = new SkillCategory();
        $skillCategoryList = ['Select Skill Category'];

        foreach ($skillCategories->all() as $skillCategory) {
            $skillCategoryList[$skillCategory->id] = $skillCategory->translate('en')->skill_category_name;
        }
        return $skillCategoryList;
    }

    /**
     * @return string
     */
    public function skillCategoryKeys()
    {
        $skillCategoryKeys = implode(',', array_except(array_keys($this->skillCategoryList()), [0]));

        return $skillCategoryKeys;
    }

    /**
     * @return array
     */
    public function skillList()
    {
        $skills = new Skill();
        $skillList = ['Select Skill'];

        foreach ($skills->all() as $skill) {
            $skillList[$skill->id] = $skill->translate('en')->skill_name;
        }

        return $skillList;
    }

    /**
     * @return mixed
     */
    public function languageList()
    {
        $languages = new CvLanguage();
        $languageList = ['Select Language'];
        foreach ($languages->all() as $language) {
            $languageList[$language->id] = $language->cv_language_name;
        }

        return $languageList;
    }

    /**
     * @return string
     */
    public function languageKeys()
    {
        $languageKeys = implode(',', array_except(array_keys($this->languageList()), [0]));

        return $languageKeys;
    }

    /**
     * @return array
     */
    public function relationList()
    {
        $relations = new Relation();
        $relationList = ['Select Relation'];
        foreach ($relations->all() as $relation) {
            $relationList[$relation->id] = $relation->relation_name;
        }

        return $relationList;
    }

    /**
     * @return string
     */
    public function relationKeys()
    {
        $relationKeys = implode(',', array_except(array_keys($this->relationList()), [0]));

        return $relationKeys;
    }

    /**
     * @return array
     */
    public function businessTypeList()
    {
        $businessTypes = new BusinessType();
        $businessTypeList = ['Select Business'];
        foreach ($businessTypes->all() as $businessType) {
            $businessTypeList[$businessType->id] = $businessType->business_type_name;
        }

        return $businessTypeList;
    }

    /**
     * @return string
     */
    public function businessTypeKeys()
    {
        $businessTypeKeys = implode(',', array_except(array_keys($this->businessTypeList()), [0]));

        return $businessTypeKeys;
    }

    /**
     * @return array
     */
    public function experienceList()
    {
        $experiences = new Experience();
        $experienceList = ['Select Experience'];
        foreach ($experiences->all() as $experience) {
            $experienceList[$experience->id] = $experience->experience_name;
        }

        return $experienceList;
    }

    /**
     * @return string
     */
    public function experienceKeys()
    {
        $experienceKeys = implode(',', array_except(array_keys($this->experienceList()), [0]));

        return $experienceKeys;
    }

    /**
     * @return array
     */
    public function educationLevelList()
    {
        $educationLevels = new EducationLevel();
        $educationLevelList = ['Select Education Level'];
        foreach ($educationLevels->all() as $educationLevel) {
            $educationLevelList[$educationLevel->id] = $educationLevel->education_level_name;
        }

        return $educationLevelList;
    }

    /**
     * @return string
     */
    public function educationLevelKeys()
    {
        $educationLevelKeys = implode(',', array_except(array_keys($this->educationLevelList()), [0]));

        return $educationLevelKeys;
    }

    /**
     * @return array
     */
    public function passingYearList()
    {
        $dt = Carbon::now();
        $currentYear = $dt->year;
//        dd($currentYear);
        $advancedYear = $currentYear + 5;
        $passingYearList = ['Select Year'];

        for ($i = $advancedYear; $i >= 1953; $i--) {
            $passingYearList[$i] = $i;
        }
        return $passingYearList;
    }

    /**
     * @return string
     */
    public function passingYearKeys()
    {
        $passingYearKeys = implode(',', array_except(array_keys($this->passingYearList()), [0]));

        return $passingYearKeys;
    }

    /**
     * @return array
     */
    public function siteInfoList()
    {
        $siteInfos = new SiteInfo();
        $siteInfoList = ['Select Institution'];
        foreach ($siteInfos->all() as $siteInfo) {
            $siteInfoList[$siteInfo->id] = $siteInfo->site_name;
        }

        return $siteInfoList;
    }

    /**
     * @return array
     */
    public function paymentTypeList()
    {
        $list = ['Select Payment Type'];
        $list['service_charge'] = 'Service Charge';
        $list['sms'] = 'SMS';
        $list['device'] = 'Device';
        $list['due'] = 'Previous Due';
        $list['late_fine'] = 'Late Fee';


        return $list;
    }

    /**
     * @return string
     */
    public function siteInfoKeys()
    {
        $siteInfoKeys = implode(',', array_except(array_keys($this->siteInfoList()), [0]));

        return $siteInfoKeys;
    }

    /**
     * @return array
     */
    public function receiptNoList()
    {
        $receiptNos = new Account();
        $receiptNoList = ['select'];

        foreach ($receiptNos->all() as $receiptNo) {
            $receiptNoList[$receiptNo->receipt_no] = $receiptNo->receipt_no;
        }
        return $receiptNoList;
    }

    public function getSubjectMarksTypeInfo($id = null)
    {
        $subject = (new Subject())->findOrFail($id);

//       return dd($subject->marks_type_info);

        $subjectMarkTypeInfo = json_decode($subject->marks_type_info);
        $markTypeInfos = [];

        if (isset($subjectMarkTypeInfo) && is_object($subjectMarkTypeInfo) && !empty($subjectMarkTypeInfo)) {
            foreach ($subjectMarkTypeInfo as $markTypeInfoKey => $markTypeInfo) {
                $markTypeInfos[$markTypeInfoKey] = $markTypeInfo;
            }
        }
//        dd($markTypeInfos);
        return $markTypeInfos;
    }
}
