<?php
/**
 * Created by PhpStorm.
 * User: HP
 * Date: 1/12/2016
 * Time: 4:13 PM
 */

namespace App\Forms;


use App\Models\Department\Department;

class DepartmentForm extends Department implements FormInterface
{
    use FormControll;

    protected $nonEditableFields = [];

    public function formInputFields ($id = null, $mode=null)
    {
        return [
            [
                'type'=>'text',
                'name'=>self::NAME,
                'label' => 'Department Name',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>false,
                'others'=>[
                    'class'=>'form-control',
                ],
             //   'validation'=>'required|unique:departments,name,'.$id,'|unique:departments,site_id,'.\Session::get(SITE_ID)
            ],
            [
                'type'=>'radio',
                'name'=>self::TYPE,
                'label' => 'Type',
                'radval'=> ['Student'=>'Student Department','HR'=>'HR Department'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'checked'=>'Student',
                'others'=>[
                    'class'=>'form-control',

                ],
              //  'validation'=>'required|unique:departments,name,'.$id,'|unique:departments,site_id,'.\Session::get(SITE_ID),

            ],
            [
                'type'=>'radio',
                'name'=>self::STATUS,
                'label' => 'Status',
                'radval'=> ['Active'=>'Active','Inactive'=>'Inactive'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'checked'=>'Active',
                'others'=>[
                    'class'=>'form-control',

                ],
                'validation'=>'required',

            ],
            /*[
                'type'=>'submit',
                'label' => 'Submit',
                'others'=>[
                    'class'=>'btn btn-success',
                    'readonly'=>'readonly'
                ],
            ]*/
            submitBtn($id),
        ];

    }

} 