<?php
/**
 * Created by PhpStorm.
 * User: raja
 * Date: 6/6/16
 * Time: 4:15 PM
 */

namespace App\Forms;


use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoTranslation;


class SiteInfoForm extends SiteInfo implements FormInterface
{
    use FormControll,DataHelper;

    public function formInputFields($id = null, $mode = null)
    {
        return [

            [
                'type'=>'select',
                'name'=>self::SITE_MEMBERSHIP_ID,
                'label' => 'Membership',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'options'=>$this->siteMembershipList(),
                'value'=>$id ?null: 0 ,
                'validation'=>"required|in:".$this->siteTypeKeys()
            ],

            [
                'type'=>'select',
                'name'=>self::SITE_GROUP_ID,
                'label' => 'Institution Group',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'options'=>$this->siteGroupList(),
                'value'=>$id ?null: 0 ,
                'validation'=>"required|in:".$this->siteGroupKeys()
            ],
            [
                'type'=>'select',
                'name'=>self::SITE_GENDER,
                'label' => 'Site Gender',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                //'trans'=>true,
                'options'=>$this->siteGender(),
                //'value'=>$id ?null: 0 ,
                //'validation'=>"required|in:".$this->siteGroupKeys()
            ],
            [
                'type'=>'text',
                'name'=>self::SITE_NAME,
                'label' => 'Institution Name',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>true,
                'others'=>[
                    'class'=>'form-control',
                ],
                'validation'=>'required',

            ],
            [
                'type'=>'select',
                'name'=>self::COUNTRY,
                'label' => 'Country',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'options'=>$this->countryList(),
                'value'=>$id ?null: 0 ,
                'validation'=>"required|in:".$this->countryKeys()
            ],
            [
                'type'=>'select',
                'name'=>self::DIVISION,
                'label' => 'Division',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'options'=>$this->divisionList(),
                //'value'=>$id ?null: 0 ,
                'validation'=>"required|in:".$this->divisionKeys()
            ],
            [
                'type'=>'select',
                'name'=>self::DISTRICT,
                'label' => 'District',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'options'=>$this->districtList(),
                //'options'=>$this->districtList(),
                //'value'=>$id ?null: 0 ,
                'validation'=>"required|in:".$this->districtKeys()
            ],
            [
                'type'=>'select',
                'name'=>self::THANA,
                'label' => 'Thana',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'options'=>$this->thanaList(),
                //'value'=>$id ?null: 0 ,
                'validation'=>"required|in:".$this->thanaKeys()
            ],
            [
                'type'=>'text',
                'name'=>self::SITE_ADDRESS,
                'label' => 'Institution Address',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>true,
                'others'=>[
                    'class'=>'form-control',
                ]

            ],
            [
                'type'=>'text',
                'name'=>self::SITE_ALIAS,
                'label' => 'Institution Alias',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>false,
                'others'=>[
                    'class'=>'form-control',
                ],
                'validation'=>"required|unique:site_infos,site_alias,".$id

            ],
            [
                'type'=>'file',
                'name'=>self::SITE_LOGO,
                'label' => 'Institution  Logo',
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>false,
                'others'=>[
                    'class'=>'form-control',
                    'id'=>'file'
                ],
                'validation'=>"image"
            ],
            [
                'type'=>'email',
                'name'=>self::SITE_EMAIL,
                'label' => 'Institution Email',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>false,
                'others'=>[
                    'class'=>'form-control',
                ],
                'validation'=>"required|unique:site_infos,site_email," .$id
                //                'validation'=>"required|unique:site_infos, site_email|unique:users,email"

            ],
            [
                'type'=>'number',
                'name'=>self::SITE_PHONE,
                'label' => 'Institution Phone No',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>false,
                'others'=>[
                    'class'=>'form-control',
                ]

            ],
            [
                'type'=>'radio',
                'name'=>self::STATUS,
                'label' => 'Status',
                'radval'=> ['1'=>'Active','0'=>'Inactive'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'others'=>[
                    'class'=>'form-control',
                ],
                'checked'=> '1',
                'validation'=>'required',

            ],
            /*[
                'type'=>'submit',
                'label' => 'Submit',
                'others'=>[
                    'class'=>'btn btn-success',
                    'style'=>'background-color:#0073b7',
                    'readonly'=>'readonly'
                ],
            ]*/
            submitBtn($id),
        ];
    }

}