<?php
/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 6/23/2016
 * Time: 10:30 PM
 */

namespace App\Forms;

use App\Models\SitePayment\SitePayment;

class SitePaymentForm extends SitePayment implements FormInterface
{
    use FormControll, DataHelper;


    public function formInputFields($id = null, $mode = null)
    {
        return [

            [
                'type' => 'text',
                'name' => self::INVOICE_ID,
                'label' => 'Invoice Id',
                'value' => null,
                'labclass' => 'col-sm-12',
                'wrapclass' => 'col-sm-12',
                'trans' => false,
                'validation' => 'required',
                'others' => ['class' => 'form-control']
            ],

            [
                'type' => 'select',
                'name' => 'site_id',
                'label' => 'Site Name',
                'others' => ['class' => 'form-control'],
                'labclass' => 'col-sm-12',
                'wrapclass' => 'col-sm-12 punch-user',
                'options' => $this->siteInfoList(),
                'value' => 0,
                'validation' => "required|in:" . $this->siteInfoKeys()
            ],

            [
                'type' => 'select',
                'name' => self::PAYMENT_TYPE,
                'label' => 'Payment Type',
                'others' => ['class' => 'form-control'],
                'labclass' => 'col-sm-12',
                'wrapclass' => 'col-sm-12 punch-user',
                'options' => $this->paymentTypeList(),
                'validation' => 'required',
                'value' => 0,
            ],
            [
                'type' => 'text',
                'name' => self::PRICE,
                'label' => 'Per Piece Price',
                'value' => null,
                'labclass' => 'col-sm-12',
                'wrapclass' => 'col-sm-12',
                'trans' => false,
                'others' => ['class' => 'form-control']
            ],
            [
                'type' => 'text',
                'name' => self::PIECE,
                'label' => 'Piece',
                'value' => null,
                'labclass' => 'col-sm-12',
                'wrapclass' => 'col-sm-12',
                'trans' => false,
                'others' => ['class' => 'form-control']
            ],

            [
                'type' => 'text',
                'name' => self::AMOUNT,
                'label' => 'Paid Amount',
                'value' => null,
                'labclass' => 'col-sm-12',
                'wrapclass' => 'col-sm-12',
                'trans' => false,
                'others' => ['class' => 'form-control']
            ],
            [
                'type' => 'text',
                'name' => self::DUE,
                'label' => 'Due Amount',
                'labclass' => 'col-sm-12',
                'wrapclass' => 'col-sm-12',
                'trans' => false,
                'value' => 0,
                'others' => ['class' => 'form-control']
            ],


            [
                'type' => 'select',
                'name' => self::MONTH_FOR,
                'label' => 'Month For',
                'others' => ['class' => 'form-control'],
                'labclass' => 'col-sm-12',
                'wrapclass' => 'col-sm-12 punch-user',
                'options' => $this->monthList(),
                'validation' => 'required',
                'value' => 0,
            ],
            [
                'type' => 'text',
                'name' => self::DESCRIPTION,
                'label' => 'Payment Description',
                'others' => ['class' => 'form-control'],
                'labclass' => 'col-sm-12',
                'wrapclass' => 'col-sm-12',
                'value' => null,
            ], [
                'type' => 'text',
                'name' => self::DATE,
                'label' => 'Payment Date',
                'others' => ['class' => 'form-control', 'data-date-format' => "yyyy-mm-dd"],
                'labclass' => 'col-sm-12',
                'wrapclass' => 'col-sm-12',
                'value' => null,
                'validation' => "required"
            ],
            [
                'type' => 'radio',
                'name' => self::STATUS,
                'label' => 'Status',
                'radval' => [1 => 'Active', 0 => 'Inactive'],
                'labclass' => 'col-sm-12',
                'wrapclass' => 'col-sm-12',
                'validation' => 'required',
                'value' => 1,
                'others' => ['class' => 'form-control']
            ],
            /*[
                'type'=>'submit',
                'label' => 'Submit',
                'others'=>[
                    'class'=>'btn btn-success',
                    'style'=>'background-color:#0073b7 ; color:white'
                ]

            ]*/
            submitBtn($id),
        ];
    }
}
