<?php
/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 4/30/2016
 * Time: 4:24 PM
 */

namespace App\Forms;

use App\Models\Timetable\Timetable;


class TimeTableForm extends Timetable implements FormInterface
{
    use FormControll, DataHelper;

   // protected $nonEditableFields = [];

    public function formInputFields($id = null, $mode = null)
    {

        return [
            [
                'type'=>'text',
                'name'=>self::STARTDATE,
                'label' => 'Start Date',
                'others'=>[
                    'class'=>'form-control',
                    'data-date-format'=>'yyyy-mm-dd'
                ],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                //'value'=>date('m/d/Y'),
                'value'=>null,
                'validation'=>"required"
            ],
            [
                'type'=>'text',
                'name'=>self::ENDDATE,
                'label' => 'End Date',
                'others'=>[
                    'class'=>'form-control',
                    'data-date-format'=>'yyyy-mm-dd'
                ],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                //'value'=>date('m/d/Y'),
                'value'=>null,
                'validation'=>"required"
            ],
            [
                'type'=>'radio',
                'name'=>self::STATUS,
                'label' => 'Status',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'radval'=> [1=>'Active',0=>'Inactive'],
                'validation'=>"required",
                'checked'=>1
            ],
            /*[
                'type'=>'submit',
                'label' => $submitButton,
                'others'=>[
                    'class'=>'btn btn-success',
                    'style'=>'background-color:#0073b7',
                    'readonly'=>'readonly'
                ],
            ]*/
            submitBtn($id),
        ];
    }

}