<?php

namespace App\Http\Controllers\AcademicAll;

use App\Models\Academic\AcademicAdmissionFeeType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class AcademicAdmissionFeeTypeController extends Controller
{
    private $academicAdmissionFeeType;

    public function __construct(AcademicAdmissionFeeType $academicAdmissionFeeType)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->academicAdmissionFeeType = $academicAdmissionFeeType;

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Academic Admission Fee Type List';
        return view('default.admin.academic-admission-fee-type.view', compact('viewType'));
    }

    public function getAdmissionFeeTypeList()
    {
        $admission_fee_type_list = AcademicAdmissionFeeType::get();
        return $admission_fee_type_list;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:academic_admission_fee_types',

        ]);

        $accAdmFeeType=AcademicAdmissionFeeType::create([
            'name' => $request->name,
            'status' => $request->status
        ]);
        return ['message' => 'Successfully Saved!'];
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $accAdmFeeTypeUpdate = AcademicAdmissionFeeType::findOrFail($id);

        $accAdmFeeTypeUpdate->update([
            'name'=>$request->get('name'),
            'status'=>$request->get('status'),
        ]);

        return ['message' => 'Successfully Updated!'];
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $academicAdmissionFeeelete = AcademicAdmissionFeeType::findOrFail($id);

        $academicAdmissionFeeelete->delete();
        return ['message' => 'Successfully Deleted!'];
    }
}
