<?php

namespace App\Http\Controllers\AcademicAll;

use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicFiscalYear;
use App\Models\AcademicYear\AcademicYear;
use Session;

class AcademicFiscalYearController extends Controller
{
    private $academicFiscalYear;

    public function __construct(AcademicFiscalYear $academicFiscalYear)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->academicFiscalYear = $academicFiscalYear;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        
//        $academicFiscalYearList = $this->academicFiscalYear->paginate(5);
//
//        dd($academicFiscalYearList);
//        return view('default.admin.academic-year.index',compact('academicYearList'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $viewType = 'Academic Year';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.academic-year.create', compact('viewType', 'academicYearList', 'mode'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            "year_name" => "required",
            "start_date" => "required",
            "end_date" => "required"
        ]);
        //$current_date_time = Carbon::now();

        if ($request->startdate > $request->enddate) {
            return back()->withInput()->withError('Start Date must be ');
        }

        $this->academicFiscalYear->start_date = date("Y/m/d", strtotime($request->startdate));
        $this->academicFiscalYear->end_date = date("Y/m/d", strtotime($request->enddate));
        $this->academicFiscalYear->year_name = $request->year_name;
        $this->academicFiscalYear->status = $request->status;
        $this->academicFiscalYear->serial_no = $request->serial_no;
        $this->academicFiscalYear->save();


        return response()->json(['message' => 'Successfully Created'], 200);

    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $viewType = 'Edit AcademicGroup Year';
        $mode = false;
        $singleAcademicYear = $this->academicFiscalYear->findOrFail($id);
        $academicFiscalYearList = $this->academicFiscalYear->paginate(5);
        return view('default.admin.academic-year.create', compact('viewType', 'academicYearList', 'singleAcademicYear', 'mode'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
      //  dd('sf');
        $academicFiscalYear_Update =$this->academicFiscalYear->findOrFail($request->id);

        $academicFiscalYear_Update->start_date = date("Y-m-d", strtotime($request->start_date));
        $academicFiscalYear_Update->end_date = date("Y-m-d", strtotime($request->end_date));
        $academicFiscalYear_Update->year_name = $request->year_name;
        $academicFiscalYear_Update->serial_no = $request->serial_no;
        $academicFiscalYear_Update->status = $request->status;
        $academicFiscalYear_Update->save();

        return response()->json(['message' => 'Successfully Update']);
    }


    public function active_inactive($id)
    {
        $academicFiscalYear_Activate = $this->academicFiscalYear->findOrFail($id);
        if ($academicFiscalYear_Activate->status == 0) {
            $academicFiscalYear_Activate->status = 1;
        } else {
            $academicFiscalYear_Activate->status = 0;
        }
        $academicFiscalYear_Activate->save();
        return redirect()->route('academic-year-create')->withSuccess('Successfully Activated');
    }


    public function academicFiscalYearList()
    {
     //   dd('sf');
        if (Session::get('SITE_ID')) {
           
           // $siteSessionlist = SiteInfo::select('academic_year_ids')->where('id', Session::get('SITE_ID'))->first();
           $siteSessionlist = SiteInfoSetting::first();
           $Sessionlistsplite = explode(',', $siteSessionlist->academic_year_ids);
           $year_list = AcademicFiscalYear::whereIn('id', $Sessionlistsplite)->orderBy('id','desc')->get();

        } else {
            $year_list = AcademicFiscalYear::orderBy('serial_no','DESC')->paginate(50);
        }
        return $year_list;
    }


    public function academicFiscalYearListBySiteId($site_id, $acc_group_id)
    {

        $siteSessionlist = SiteInfoSetting::select('academic_year_ids')->where('site_id', $site_id)->where('academic_group_id', $acc_group_id)->first();
        $Sessionlistsplite = explode(',', $siteSessionlist->academic_year_ids);
        $year_list = AcademicFiscalYear::whereIn('id', $Sessionlistsplite)->get();
        return $year_list;

    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return response()->json(['message' => 'Contact to DevTeam!'],413);

        $academicFiscalYear_Delete = $this->academicFiscalYear->findOrFail($id);
        $academicFiscalYear_Delete->delete();

    }
}
