<?php

namespace App\Http\Controllers\AcademicAll;

use App\Models\Academic\AcademicStudentCategory;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Session;

class AcademicStudentCategoryController extends Controller
{
    private $academicStudentCategory;
    public function __construct(AcademicStudentCategory $academicStudent)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

        $this->academicStudentCategory = $academicStudent;

    }



    public function siteBaseStudentCategory()
    {
        if(Session::get('SITE_ID')){
            $siteStudentCategorylist=SiteInfoSetting::select('academic_student_category_ids')
                ->first();

            $studentCategorylistsplite = explode(',', $siteStudentCategorylist->academic_student_category_ids);
            $studentCategorylist = AcademicStudentCategory::whereIn('id', $studentCategorylistsplite)->get();

            return $studentCategorylist;
        }
        else{
            $studentCategorylist = AcademicStudentCategory::get();
        }

        return $studentCategorylist;
    }




}
