<?php

namespace App\Http\Controllers\AcademicAll;

use App\Models\Academic\AcademicStudentType;
use App\Models\Site\SiteInfo;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Session;

class AcademicStudentTypeController extends Controller
{


    private $academicStudentType;

    public function __construct(AcademicStudentType $academicStudentType)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->academicStudentQuata = $academicStudentType;
    }


    public function siteBaseStudentTypeList()
    {

        $SiteInfoTableData=SiteInfo::select('academic_student_type_ids')
            ->where('id',(Session::get(SITE_ID)))->first();


        $academicStudentTypeIDs=explode(',',$SiteInfoTableData->academic_student_type_ids);

        $academicStudentTypeList  = AcademicStudentType::select ('id','student_type_name')
            ->whereIn('id',$academicStudentTypeIDs)
            ->get();


        return $academicStudentTypeList;
    }
}
