<?php

namespace App\Http\Controllers\AcademicAll;


use App\Models\Academic\AcademicWaiverType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteInfo;
use Session;


class AcademicWaiverTypeController extends Controller
{
    private $academicWaiverType;

    public function __construct(AcademicWaiverType $academicWaiverType)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->academicWaiverType = $academicWaiverType;

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Fee Head List';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.sites.site-waiver-type.view', compact('viewType'));
    }

    public function getAcademicWaiverTypeList()
    {
        $academicWaiverTypes = new AcademicWaiverType();
        $academicWaiverTypeList = $academicWaiverTypes->get();

        return $academicWaiverTypeList;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:academic_waiver_types',

        ]);

        $academicWaiverTypeList = AcademicWaiverType::create([
            'name' => $request->name,
            'status' => $request->status
        ]);
        return ['message' => 'Successfully Saved!'];
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|unique:academic_waiver_types',

        ]);
        $academicWaiverTypeUpdate = $this->academicWaiverType->findOrFail($id);

        $academicWaiverTypeUpdate->update([
            'name'=>$request->get('name'),
            'status'=>$request->get('status'),
        ]);

        return ['message' => 'Successfully Updated!'];
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $academicWaiverTypeDelete = $this->academicWaiverType->findOrFail($id);

        $academicWaiverTypeDelete->delete();
        return ['message' => 'Successfully Deleted!'];
    }
}
