<?php

namespace App\Http\Controllers\AcademicAll;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Forms\FormControll;
use App\Models\Department\Department;
use App\Models\Designation\Designation;
use App\Models\User\User;
use Response;

class DesignationController extends Controller
{
    use FormControll;

    private $designation;

    /**
     * DesignationController constructor.
     * @param Designation $designation
     */
    public function __construct(Designation $designation)
    {

        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

        $this->designation = $designation;
    }

    public function index()
    {

        $viewType = 'Designation List';

        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.designation.index', compact('viewType', 'model'));

    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function createDesignationForm()
    {
        $viewType = 'Create Designation';
        return view('default.admin.designation.create', compact('viewType'));
    }

    /**
     * @param Request $validatedRequest
     * @return \Illuminate\Http\RedirectResponse|null
     */
    public function createDesignation(Request $validatedRequest)
    {

        $this->validate($validatedRequest, [
            'name' => 'required|unique:designations',
            'status' => 'required|in:0,1'

        ]);

        $this->designation->create([
            'name' => ucwords($validatedRequest->get('name')),
            'status' => ucwords($validatedRequest->get('status'))
        ]);

        return response()->json(['message' => 'Successfully Created', 'mode' => 'Success'], 200);

    }

    /**
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function editDesignationForm($id)
    {
        $viewType = 'Edit Designation';

        $designationToEdit = $this->editFormModel($this->designation->findOrFail($id));

        return view('default.admin.designation.edit', compact('designationToEdit', 'viewType'));
    }


    public function editDesignation(Request $validatedRequest)
    {

        $this->validate($validatedRequest, [
            'name' => 'required|unique:designations,id,' . $validatedRequest->id,
            'status' => 'required|in:0,1'

        ]);
        $designationToEdit = $this->designation->findOrFail($validatedRequest->id);

        $isEdited = $designationToEdit->update([
            'name' => ucwords($validatedRequest->get('name')),
            'status' => $validatedRequest->get('status')
        ]);

        return response()->json(['message' => 'Subject Condition Successfully Updated!'], 200);

    }

    /**
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function getDesignationList(Request $request)
    {

        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';
        $class_list = $this->designation
            ->when($search_txt, function ($q) use ($txt) {
                $q->where('name', 'LIKE', $txt);
            })->orderBy('id', 'DESC')
            ->paginate($paginate);

        return response()->json($class_list, 200);
    }

    /**
     * @param $id
     * @return $this|\Illuminate\Http\RedirectResponse
     */
    public function deleteDesignation($id)
    {
        $designationToDelete = $this->designation->findOrFail($id);

        if ($designationToDelete->delete()) {
            return redirect()->route('designation-list')->with('success', 'Successfully Deleted!');
        }
        return redirect()->route('designation-list')->withErrors('Not successfully deleted');

        /*if($designationToDelete->delete()){

            return back();
        }
        return back()->withErrors('Not successfully deleted');*/


    }

    /**
     * @param $deptId
     * @param Department $department
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function designationOfDept($deptId, Department $department, Request $request)
    {
        $selectedDepertment = $department->findOrFail($deptId);
        $designationForDept = $selectedDepertment->designations;
        $shiftForDetp = $selectedDepertment->shifts;
        $defalutLangShift = [];
        if (!$shiftForDetp->isEmpty()) {
            foreach ($shiftForDetp as $key => $item) {
                if (!is_null($item)) {
                    $defalutLangShift[$item->id] = $item->translate('en')->name;
                }
            }
        }

        if ($request->ajax()) {
            return response()->json([$designationForDept, $defalutLangShift]);
        }
    }

    public function designationToEdit($userId, User $user, Request $request)
    {
        $userToEdit = $user->findOrFail($userId);
        $designationToEdit = $this->designation->findOrFail($userToEdit->designation_id);

        if ($request->ajax()) {
            return response()->json($designationToEdit);
        }

    }
}
