<?php

namespace App\Http\Controllers\AcademicAll;

use App\Forms\SubjectConditionForm;
use App\Forms\DataHelper;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\Academic\SubjectCondition;
use Illuminate\Http\Request;
use Response;

class SubjectConditionController extends ProjectController
{
    use Lang, FormControll, DataHelper;


    private $subjectCondition;

    /**
     * @param SubjectCondition $subjectCondition
     */
    public function __construct(SubjectCondition $subjectCondition)
    {

        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

        $this->subjectCondition = $subjectCondition;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Subject List';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.subject_condition.index', compact('viewType'));
    }

    public function getAcademicSubjectConditionList()
    {
        $list = $this->subjectCondition->paginate(20);
        return $list;
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function createSubjectConditionForm()
    {
        $viewType = 'Create Subject Condition';
        return view('default.admin.subject_condition.create', compact('viewType'));
    }


    public function createSubjectCondition(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:academic_subject_conditions',
            'status' => 'required|in:0,1'

        ]);

        $this->subjectCondition->create([
            'name' => $request->get('name'),
            'status' => $request->get('status'),
        ]);

        return Response::json(['message' => 'Subject Condition Successfully Created!']);

    }


    public function getSubjectConditionEditForm($id, SubjectConditionForm $subjectConditionForm)
    {
        $viewType = 'Edit Subject Condition';

        $editSubjectCondition = $subjectConditionForm;

        $subjectConditionData = $this->editFormModel($this->subjectCondition->findOrFail($id));

        return view('default.admin.subject_condition.edit', compact('subjectConditionData', 'viewType', 'editSubjectCondition'));

    }


    public function editSubjectCondition(Request $request, $id)
    {

        $this->validate($request, [
            'name' => 'required|unique:academic_subject_conditions,id,' . $id,
            'status' => 'required|in:0,1'
        ]);

        $subCondition = $this->subjectCondition->findOrFail($id);

        $subCondition->update([
            'name' => $request->get('name'),
            'status' => $request->get('status'),
        ]);

        return Response::json(['message' => 'Subject Condition Successfully Updated!']);


    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function viewSubjectCondition($id)
    {
        $viewType = 'Student Condition';
        $studentConditionToView = $this->subjectCondition->findOrFail($id);
        return view('default.admin.subject_condition.view', compact('viewType', 'studentConditionToView'));

    }

//   delete student condition


    public function deleteSubjectCondition($id)
    {
        $studentConditionToDelete = $this->subjectCondition->findOrFail($id);

        $studentConditionToDelete->delete();
        return Response::json(['message' => 'Subject Condition Successfully Deleted!']);
    }

}
