<?php

namespace App\Http\Controllers\Admin;

use App\Events\SendNotification;
use App\Http\Controllers\ProjectController;
use App\Mail\SendMailToUserWithQueue;
use App\Models\Attendance\GlobalStudentAttendance;
use App\Models\Attendance\StudentAttendance;
use App\Models\Company\GlobalCompany;
use App\Models\Edu\DashboardPalette\DashboardPalette;
use App\Models\Image\Photo;
use App\Models\Menu\Menu;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Employee\EmployeeAttendance;
use App\Models\Site\Employee\GlobalEmployee;
use App\Models\Site\Employee\GlobalEmployeeAttendance;
use App\Models\Site\Permission\SiteRoleAccess;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\SiteGroup\Site\Employee\SiteGroupEmployeeAttendance;
use App\Models\SiteGroup\Site\Student\Student;
use App\Models\Site\Student\Student as Academic_student;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicSection;
use App\Models\Site\Fee\GlobalSiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentHeadWiseFeePaymentHistory;
use App\Models\Site\Payment\GlobalSitePaymentGateway;
use App\Models\Student\StudentHistory;
use App\Models\User\GlobalUser;
use App\Models\User\User;
use App\Traits\Device\OrganizeSavedDeviceLogTrait;
use App\Traits\RequestHandlingWithMachine;
use App\Traits\Site\Attendance\AbsentSmsTrait;
use Artisan;
// use Auth;
use Carbon\Carbon;
///use Illuminate\Support\Carbon;
use DB;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\ValidationException;
use Image;
use Mail;
use Response;
use Session;
use View;
use App\Traits\TimeRelatedFunctionTrait;
use Illuminate\Support\Facades\Auth;

class AdminController extends ProjectController
{

    use RequestHandlingWithMachine, TimeRelatedFunctionTrait, AbsentSmsTrait, OrganizeSavedDeviceLogTrait;

    private $user;
    private $employeeAttendance;
    private $studentAttendance;
    private $siteGroupEmployeeAttendance;
    private $globalStudentAttendance;
    private $studentHistory;
    private $academic_student;


    public $carbon_now;

    private $siteInfoSetting;
    public function __construct(User $user, GlobalSiteInfoSetting $siteInfoSetting, EmployeeAttendance $employeeAttendance, StudentAttendance $studentAttendance, SiteGroupEmployeeAttendance $siteGroupEmployeeAttendance,
                                GlobalStudentAttendance $globalStudentAttendance, StudentHistory $studentHistory, Academic_student $academic_student)
    {

        $this->carbon_now = Carbon::now();
        $this->middleware('auth');

        $this->employeeAttendance = $employeeAttendance;
        $this->studentAttendance = $studentAttendance;
        $this->siteGroupEmployeeAttendance = $siteGroupEmployeeAttendance;
        $this->globalStudentAttendance = $globalStudentAttendance;
        $this->studentHistory = $studentHistory;
        $this->user = $user;
        $this->siteInfoSetting = $siteInfoSetting;

    }

    public function testFunction(){

        // $feeGen=GlobalSiteStudentFeeGenerate::where('site_id',35)
        //  //   ->where('academic_fee_head_id',3)
        // //    ->where('academic_fee_sub_head_id',3)
        // //    ->where('fee_head_type_id',6)
        //     ->where('demand_slip_create_status',false)
        // //    ->where('site_student_fee_demand_slip_detail_id',null)
        //     ->pluck('id');

        //  $teste_arass=SiteStudentHeadWiseFeePaymentHistory::whereIn('student_fee_generate_id',$feeGen)->get();

        //  dd($teste_arass);

     

        //  return $teste_ara;


        dd('sf');
        $now = Carbon::now();
        $start = $now->copy()->subMinutes(30); // সর্বশেষ ২ ঘণ্টা
        $end = $now;
        $start_date = $start->toDateString();
        $end_date = $end->toDateString();
        $s_time = $start->format('H:i:s');
        $e_time = $end->format('H:i:s');
      
        $start_time = $s_time;

    //    dd($e_time);

        $t = strtotime("+15 minutes", strtotime($start_time));
        $end_time = $e_time ?? date('H:i:s', $t);

        $mx_access_unique_id = 27774600;
      
        $data = array("operation" => "fetch_log",
          //  "auth_user"=> "chorjapod",
            "auth_code"=> "hy6s4fu3fodflkm7e9048mz1pjfku2w",
            "start_date" => $start_date, 
            "end_date" =>$end_date, 
            "start_time"=>$start_time, 
            "end_time" => $end_time, 
            "access_id"=>$mx_access_unique_id);
     

        $data_pay_load = json_encode($data);
        $api_request = curl_init('https://rumytechnologies.com/rams/json_api');
        curl_setopt($api_request, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($api_request, CURLINFO_HEADER_OUT, true);
        curl_setopt($api_request, CURLOPT_POST, true);
        curl_setopt($api_request, CURLOPT_POSTFIELDS, $data_pay_load);
        curl_setopt($api_request, CURLOPT_HTTPHEADER, array('Content-Type:application/json', 'Content-Length: ' . strlen($data_pay_load)));

        $result = curl_exec($api_request);

       // dd($result);

        $replace_syntax = str_replace('{"log":', "", $result);
        $replace_syntax1 = substr_replace($replace_syntax, "", -1);
        $moderateData = json_decode($replace_syntax1);

        dd($moderateData);
    }

    public function tsttwetwetwtwt(){

    

    }


    public function dashboard()
    {



  

        if (isset($_GET['task'])) {

            if ($_GET['task'] == 's') {
                // Artisan::call('migrate', ['--force' => true]);
                Artisan::call('schedule:run');
                /* var_dump($test);
                 die();*/
            }
            if ($_GET['task'] == 'm') {
                Artisan::call('migrate', ['--force' => true]);
            }
        }

        // \Log::info('dashboard');

        $viewType = 'Dashboard';


        return view('default.admin.layouts.master', compact('viewType'));
//        $view = view('default.admin.site.accounts.admission-form-details-pdf', compact('viewType'));
//        $view = View::make('admission-form-details-pdf', compact('viewType','report_tittle', 'report_tittle2'));
//
//        $contents = $view->render();
////            return $contents;
//        $mpdf = new \Mpdf\Mpdf();
//        $mpdf->autoScriptToLang = true;
//        $mpdf->autoLangToFont = true;
//        $mpdf->allow_charset_conversion = false;
//        $mpdf->WriteHTML($contents);
//        $mpdf->Output();
//        return $contents;

    }

    public function dashboardGetStudentAttendanceList($att_date1)
    {
        try {


            $att_date = date('Y-m-d', strtotime($att_date1));
            //$att_date = "2022-03-05";

            if (Session::get('SITE_ID')) {

                    $st_att = $this->studentAttendance
                    ->with('studentHistory.student')
                    ->where('present_date', $att_date)
                    ->orderBy('in_time', 'DESC')
                    ->take(10)
                    ->get();

            }



            return response()->json($st_att, 200);


        } catch (Exception $exception) {
            return response()->json($exception->getMessage(), 411, []);
        }

    }
    public function dashboardGetEmployeeAttendanceList($att_date1)
    {
        try {


            $att_date = date('Y-m-d', strtotime($att_date1));

            if (Session::get('SITE_ID')) {
                $final_emp = $this->employeeAttendance
                    ->with(['employee' => function ($query) {
                        $query->select(['id']);
                    }])
                    ->where('present_date', $att_date)
                    ->orderBy('in_time', 'DESC')
                    ->limit(5)
                    ->get();
            } else {
                //dd($site_ids->pluck('id'));

                $final_emp = SiteGroupEmployeeAttendance::
                with(['employee' => function ($query) {
                    $query->select(['id']);
                }])
                    ->where('present_date', $att_date)
                    ->orderBy('in_time', 'DESC')
                    ->limit(5)
                    ->get();
            }


            return response()->json([$final_emp], 200, []);


        } catch (Exception $exception) {
            return response()->json($exception->getMessage(), 411, []);
        }

    }

    public function dashboardGetEmployeeAttendanceGraph($att_month = null)
    {
        try {

            $att_month = $att_month ? $att_month : date('m');


            if (Session::get('SITE_ID')) {


                $final_emp = $this->employeeAttendance
                    ->where('present_month', $att_month)
                    ->select(DB::raw('DATE(present_date) as present_date'), DB::raw('count(*) as present'))
                    ->groupBy('present_date')
                    ->get();
            } elseif (Session::get('SITE_GROUP_ID')) {

                $site_ids = Auth::user()->siteInfoes->pluck('id') ?? null;

                $final_emp = $this->siteGroupEmployeeAttendance
                    ->whereIn('site_id', $site_ids)
                    ->where('present_month', $att_month)
                    ->select(DB::raw('DATE(present_date) as present_date'), DB::raw('count(*) as present'))
                    ->groupBy('present_date')
                    ->get();
            } else {
                $final_emp = $this->siteGroupEmployeeAttendance
                    ->where('present_month', $att_month)
                    ->select(DB::raw('DATE(present_date) as present_date'), DB::raw('count(*) as present'))
                    ->groupBy('present_date')
                    ->get();
            }


            $response = [];
            $office_day = 70;
            $holy_day = 18;
            $friday = 12;

            foreach ($final_emp as $k => $value) {
                $response[$k]['y'] = $value->present_date;
                $response[$k]['Employee'] = $value->present;
            }

            return response()->json([$response, $office_day, $holy_day, $friday], 200, []);

        } catch (Exception $exception) {
            return response()->json([$exception->getMessage()], 411);

        }

    }


    //----------dashboard palette============


    public function getDashboardData(Request $request)
    {
        try {

            $roles = Auth::user()->roles->pluck('id');

            $user_palettes = SiteRoleAccess::whereIn('site_role_id', $roles)->pluck('dashboard_palettes')->toArray();


            $final_palette = [];
            foreach ($user_palettes as $k => $palette) {
                $final_palette = array_unique(array_merge($final_palette, explode(',', $palette)));
            }

            $user_type = Session::get('USER_TYPE');
            $dash = DashboardPalette::whereIn('id', $final_palette)->where('palette_for', 'site')->orderBy('key_id','ASC')->get();

          //  dd($dash);

            return response()->json($dash, 200);


            $att_date = Carbon::now()->toDateString();


            if (Session::get('SITE_ID')) {

                $response['st_att'] = $this->studentAttendance
                    ->where('present_date', $att_date)
                    ->orderBy('in_time', 'DESC')
                    ->take(5)
                    ->get();
                $response['total_student'] = $this->user->where('user_type', 'student')->count();
                $response['total_emp'] = $this->user->where('user_type', 'employee')->count();


                $response['latest_emp'] = Employee::with('latestPhoto')->take(8)->get();

            } elseif (Session::get('SITE_GROUP_ID')) {

                $site_ids = Auth::user()->siteInfoes->pluck('id') ?? null;
                $response['total_school'] = GlobalSiteInfo::whereIn('id', $site_ids)->count();

                $response['st_att'] = $this->globalStudentAttendance
                    ->whereIn('site_id', $site_ids)
                    ->where('present_date', $att_date)
                    ->orderBy('in_time', 'DESC')
                    ->take(5)
                    ->get();

                $response['latest_emp'] = \App\Models\SiteGroup\Site\Employee\Employee::whereIn('site_id', $site_ids)->with('latestPhoto')->take(8)->get();
                $response['total_emp'] = \App\Models\SiteGroup\Site\Employee\Employee::whereIn('site_id', $site_ids)->where('user_type', 'employee')->count();
                $response['total_teacher'] = \App\Models\SiteGroup\Site\Employee\Employee::whereIn('site_id', $site_ids)
                    ->whereHas('empHistories', function ($q) {
                        return $q->where('is_teacher', 1);
                    })->count();
                $response['total_staff'] = \App\Models\SiteGroup\Site\Employee\Employee::whereIn('site_id', $site_ids)
                    ->whereHas('empHistories', function ($q) {
                        return $q->where('is_teacher', 0);
                    })->count();


                $response['total_student'] = (new Student())->whereIn('site_id', $site_ids)->where('user_type', 'student')->count();
                $response['male_student'] = (new Student())->whereIn('site_id', $site_ids)->where('user_type', 'student')->where('gender_id', 30)->count();
                $response['female_student'] = (new Student())->whereIn('site_id', $site_ids)->where('user_type', 'student')->where('gender_id', 31)->count();


            }


            return response()->json($response, 200);

        } catch (Exception $exception) {
            return response()->json($exception->getMessage(), 411);
        }

    }


    public function getStudentTotalCount()
    {
        $response = [
            "total_student" => null,
        ];

        $response['total_student'] = $this->studentHistory
            ->whereHas('student')
            ->where('status', true)
            ->count();


        return response()->json($response, 200);
    }

    public function getStudentTotalCountDetails(Request $request){
       
      //  $data = $request->all();
        $device_using_student = $request->input('device_using_student');
        $site_id = Session::get('SITE_ID');
        $SiteInfoTableData = $this->siteInfoSetting->select('device_using_class_ids')->where('site_id',$site_id)->first();
        $availableClass = explode(',', $SiteInfoTableData->device_using_class_ids);
      
        // for present and absent
        $total_present_student = $request->input('total_present_student');
        $total_absent_student = $request->input('total_absent_student');
        $att_date = date('Y-m-d');
       // $att_date = date('2022-03-05');
        
                $st_att = $this->studentAttendance
                ->with('studentHistory')
                ->where('present_date', $att_date)
                ->orderBy('in_time', 'DESC')
                ->get();

                $student_ids =[];
                foreach($st_att as $key=>$student){
                    $student_ids[] = $student->studentHistory->id;
                }
         
        $get_student_ids = collect($student_ids);

        // get student list for get student list

        $getStudentList = $this->studentHistory->select('id', 'academic_year_id', 'academic_version_id', 'academic_shift_id',
            'academic_class_id', 'academic_department_id', 'academic_section_id', 'academic_class_group_id',
            'academic_student_category_id', 'academic_student_admission_type_id')
            
            ->when($device_using_student, function ($query) use ($availableClass) {
               return $query->whereIn('academic_class_id', $availableClass);
            })
            ->when($total_present_student, function ($query) use ($get_student_ids) {
                return $query->whereIn('id', $get_student_ids);
            })
            ->when($total_absent_student, function ($query) use ($get_student_ids) {
                return $query->whereNotIn('id', $get_student_ids);
            })

            ->where('status', 1)
            ->where('transfer_status', 0)
            ->whereHas('student')
            ->get();
      
           // return $query->whereNotIn('id', $get_student_ids);
      
        $totalStudent = count($getStudentList);
       
        $version_ids = $getStudentList->pluck('academic_version_id')->unique()->filter();

        $version_list = AcademicVersion::whereIn('id', $version_ids)->get();


        $check_department_ids = $getStudentList->pluck('academic_department_id')->unique()->filter();
        $check_class_group_ids = $getStudentList->pluck('academic_class_group_id')->unique()->filter();
        $check_section_ids = $getStudentList->pluck('academic_section_id')->unique()->filter();

       

        if (count($check_department_ids) > 0) {
            $department_present = true;
        } else {
            $department_present = false;
        }

        if (count($check_class_group_ids) > 0) {
            $class_group_present = true;
        } else {
            $class_group_present = false;
        }

        if (count($check_section_ids) > 0) {
            $section_present = true;
        } else {
            $section_present = false;
        }

     

        $version_arr = Array();
        $student_count_array = [];
        foreach ($version_list as $keyVersion => $valueVersion) {

            $filtered_version_list = $getStudentList
                ->where('academic_version_id', $valueVersion->id);

            $version_arr['version_name'] = $valueVersion->version_name;
            $version_arr['version_student_count'] = count($filtered_version_list);


            $shift_ids = $filtered_version_list->pluck('academic_shift_id')
                ->unique()
                ->filter();

            $shiftList = AcademicShift::whereIn('id', $shift_ids)
                ->get();


            $shift_arr = Array();
            $shift_array = [];
            foreach ($shiftList as $keyShift => $valueShift) {


                $filtered_shift_list = $filtered_version_list
                    ->where('academic_shift_id', $valueShift->id);


                $shift_arr['shift_name'] = $valueShift->shift_name;
                $shift_arr['shift_student_count'] = count($filtered_shift_list);


                $department_ids = $filtered_shift_list->pluck('academic_department_id')
                    ->unique()
                    ->filter();


                if (count($department_ids) > 0) {
                    $departmentList = AcademicDepartment::whereIn('id', $department_ids)->get();

                    $department_arr = Array();
                    $department_array = [];
                    foreach ($departmentList as $keyDepartment => $valueDepartment) {

                        $filtered_department_list = $filtered_shift_list
                            ->where('academic_department_id', $valueDepartment->id);


                        $department_arr['department_name'] = $valueDepartment->name;
                        $department_arr['department_student_count'] = count($filtered_department_list);


                        $class_ids = $filtered_department_list->pluck('academic_class_id')
                            ->unique()
                            ->filter();

                        $classList = AcademicClass::whereIn('id', $class_ids)->get();

                        $class_array = $this->getClassGroupSectionCount($classList, $filtered_department_list, $class_group_present);

                        $department_arr['class_array'] = $class_array;

                        $department_arr['count_class_row'] = collect($class_array)->sum('count_class_row') + count($class_array);

                        $department_array[$keyDepartment] = $department_arr;

                    }


                } else {

                    $class_ids = $filtered_shift_list->pluck('academic_class_id')
                        ->unique()
                        ->filter();

                    $classList = AcademicClass::whereIn('id', $class_ids)->get();
                    $class_array = $this->getClassGroupSectionCount($classList, $filtered_shift_list, $class_group_present);

                }


                if (count($department_ids) > 0) {

                    $shift_arr['class_array'] = [];
                    $shift_arr['department_array'] = $department_array;

                    $shift_arr['shift_array_row'] = (collect($department_array)->sum('count_class_row')) + count($department_array);

                } else {
                    $shift_arr['class_array'] = $class_array;
                    $shift_arr['department_array'] = [];

                    $shift_arr['shift_array_row'] = (collect($class_array)->sum('count_class_row')) + count($class_array);
                }


                $shift_array[$keyShift] = $shift_arr;


            }


            $version_arr['version_array_row'] = (collect($shift_array)->sum('shift_array_row')) + count($shift_array);

            $version_arr['shift_array'] = $shift_array;
            $version_arr['shift_array'] = $shift_array;

            $student_count_array[$keyVersion] = $version_arr;

        }
     //   dd($student_count_array);
     return compact('student_count_array', 'department_present', 'class_group_present', 'section_present', 'totalStudent');

       // return compact('student_count_array');
    }
    private function getClassGroupSectionCount($classList, $filtered_shift_list, $class_group_present)
    {
        $class_arr = Array();
        $class_array = [];
        foreach ($classList as $keyClass => $valueClass) {

            $filtered_class_list = $filtered_shift_list
                ->where('academic_class_id', $valueClass->id);


            $class_arr['class_name'] = $valueClass->class_name;
            $class_arr['class_student_count'] = count($filtered_class_list);


            $class_group_ids = $filtered_class_list->pluck('academic_class_group_id')
                ->unique()
                ->filter();


            if (count($class_group_ids) > 0) {

                $classGroupList = AcademicClassGroup::whereIn('id', $class_group_ids)->get();


                $class_group_arr = Array();
                $class_group_array = [];
                foreach ($classGroupList as $keyClassGroup => $valueClassGroup) {

                    $filtered_class_group_list = $filtered_class_list
                        ->where('academic_class_group_id', $valueClassGroup->id);


                    $class_group_arr['group_name'] = $valueClassGroup->group_name;
                    $class_group_arr['class_group_student_count'] = count($filtered_class_group_list);


                    $section_ids = $filtered_class_group_list->pluck('academic_section_id')
                        ->unique()
                        ->filter();

                    $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                    $class_group_arr['count_class_group_row'] = count($sectionList);


                    $section_arr = Array();
                    $section_array = [];
                    foreach ($sectionList as $keySection => $valueSection) {

                        $filtered_section_list = $filtered_class_group_list
                            ->where('academic_section_id', $valueSection->id);


                        $section_arr['section_name'] = $valueSection->section_name;
                        $section_arr['class_section_count'] = count($filtered_section_list);


                        $section_array[$keySection] = $section_arr;
                    }

                    $class_group_arr['section_array'] = $section_array;

                    $class_group_array[$keyClassGroup] = $class_group_arr;


                }


            } else {

                $section_ids = $filtered_class_list->pluck('academic_section_id')
                    ->unique()
                    ->filter();

                $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                $section_arr = Array();
                $section_array = [];
                foreach ($sectionList as $keySection => $valueSection) {

                    $filtered_section_list = $filtered_class_list
                        ->where('academic_section_id', $valueSection->id);


                    $section_arr['section_name'] = $valueSection->section_name;
                    $section_arr['class_section_count'] = count($filtered_section_list);

                    $section_array[$keySection] = $section_arr;

                }

//                            $class_group_arr['section_array']=$section_array;
//                            $class_group_array[]=$class_group_arr;


            }


            if (count($class_group_ids) > 0) {
                $class_arr['class_group_array'] = $class_group_array;
                $class_arr['section_array'] = [];

                $class_arr['count_class_row'] = (collect($class_group_array)->sum('count_class_group_row')) + count($class_group_array);
            } else {
                $class_arr['section_array'] = $section_array;
                $class_arr['class_group_array'] = [];

//                if($class_group_present){
//                    $class_arr['count_class_row']=count($section_array)*2;
//                }else{
                $class_arr['count_class_row'] = count($section_array);
//                }


            }


            $class_array[$keyClass] = $class_arr;

        }

        return $class_array;
    }


    public function getPresentStudentTotalCount(){
        try {

            $att_date = date('Y-m-d');
           // $att_date = "2022-03-05";

            if (Session::get('SITE_ID')) {

                $st_att = $this->studentAttendance
                    ->where('present_date', $att_date)
                    ->orderBy('in_time', 'DESC')
                   // ->take(5)
                    ->count();

            }
            elseif (Session::get('SITE_GROUP_ID')) {

                $site_ids = Auth::user()->siteInfoes->pluck('id') ?? null;

                $st_att = $this->globalStudentAttendance
                    ->whereIn('site_id', $site_ids)
                    ->where('present_date', $att_date)
                    ->orderBy('in_time', 'DESC')
                  //  ->take(5)
                    ->count();
            } else {
                $st_att = $this->globalStudentAttendance
                    ->where('present_date', $att_date)
                    ->orderBy('in_time', 'DESC')
                  //  ->take(5)
                    ->count();
            }

            // $final_st = [];

            // foreach ($st_att as $k => $item) {

            //     $final_st[$k]['full_name'] = ($item->studentHistory->student->full_name ?? 'N/A');

            //     $final_st[$k]['username'] = ($item->studentHistory->student->username ?? 'N/A');
            //     $final_st[$k]['in_time'] = $item->in_time;
            //     $final_st[$k]['out_time'] = $item->out_time;
            //     //   $final_st[$k]['picture'] = $item->studentHistory->student->latestPhotoName ?? 'image-not.png';

            //     $final_st[$k]['late_status'] = $item->late_status;

            // }


           // return response()->json($st_att, 200, []);
           return $st_att;

        } catch (Exception $exception) {
            return response()->json($exception->getMessage(), 411, []);
        }
    }



    public function getDeviceUsingStudentTotalCount()
    {
        $site_id = Session::get('SITE_ID');
        $SiteInfoTableData = $this->siteInfoSetting->select('device_using_class_ids')->where('site_id',$site_id)->first();
        $availableClass = explode(',', $SiteInfoTableData->device_using_class_ids);


        $students = $this->studentHistory
            ->whereHas('student')
            ->where('status', true)
            ->whereIn('academic_class_id',$availableClass)
            ->pluck('id')
            ->unique()
            ->count();
          
         return $students;
      
    }
    public function getAbsentStudentTotalCount(){
        try {
            $total_device_using_students = $this->getDeviceUsingStudentTotalCount();
            $get_present_students = $this->getPresentStudentTotalCount();
            $total_apsent_student = $total_device_using_students - $get_present_students;

            return $total_apsent_student;
           // return response()->json($total_apsent_student, 200);

        } catch (Exception $exception) {
            return response()->json($exception->getMessage(), 411, []);
        }
    }

    public function getEmployeeTotalCount()
    {
        $response = [
            "total_employee" => null,
        ];

        $response['total_employee'] = $this->user->where('user_type', 'employee')
            ->where('status', true)
            ->count();


        return response()->json($response, 200);
    }

    public function getDeviceUsingEmployeeTotalCount()
     {

        $total_device_using_employee = $this->user->where('user_type', 'employee')
            ->where('status', true)
            ->count();
        return $total_device_using_employee;

       // return response()->json($response, 200);
    }
    public function getPresentEmployeeTotalCount()
    {
        $att_date = date('Y-m-d');

        $final_emp = $this->employeeAttendance
        ->where('present_date', $att_date)
        ->count();
       return $final_emp;

      // return response()->json($response, 200);
   }
   public function getAbsentEmployeeTotalCount()
    {
        $device_using_employees = $this->getDeviceUsingEmployeeTotalCount();
        $present_employees = $this->getPresentEmployeeTotalCount();

        return $absent_employees = $device_using_employees - $present_employees;
   }


    public function laravelPassport()
    {
        $viewType = 'All Settings';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.laravel-passport.index', compact('viewType', 'menus'));
    }


    public function backToMainPanel()
    {

        $user_type = Session::get('USER_TYPE');

//         dd($user_type);

        if ($user_type == 'eduworld') {

            Session::put('USER_TYPE', 'eduworld');
            Session::put('ALIAS', 'eduworld');
            Session::put('ALIAS1', 'eduworld');

            Session::forget('SITE_ID');
            Session::forget('SITE_GROUP_ID');
            Session::forget('FULL_NAME');
            Session::forget('ACADEMIC_GROUP_ID');
            Session::forget('ACADEMIC_GROUP_NAME');


        }  elseif ($user_type == 'site_group') {

            $site_group = GlobalSiteGroup::where('id', Session::get('SITE_GROUP_ID'))->first();
            Session::put('FULL_NAME', $site_group->name);
            Session::forget('SITE_ID');
            //  Session::forget('SITE_GROUP_ID');
            Session::forget('ACADEMIC_GROUP_ID');
            Session::put('ALIAS1', Session::get('ALIAS'));


        } elseif ($user_type == 'site') {

        }
//        dd(Session::get('ALIAS'));


        if (file_exists(base_path("resources/views/default/sidebars/" . Session::get('ALIAS') . '/' . request()->user()->id . '.blade.php'))) {
            unlink(base_path("resources/views/default/sidebars/" . Session::get('ALIAS') . '/' . request()->user()->id . '.blade.php'));
            generateSideBar();
        }


        return redirect()->route('admin');

    }


    public function removeSiteGroupSiteFromUser(Request $request)
    {


        $type = $request->type;
        $user_id = $request->user_id;
        $ids = $request->ids;


        if (is_array($ids)) {
            $ids = $request->ids;
        } else {
            $ids = explode(',', $ids);
        }


        $toEdit = $this->user->findOrFail($user_id);

        if ($type == 'site_group') {
            $toEdit->siteGroups()->sync($ids);

        } elseif ($type == 'site') {
            \Log::info($request);
            \Log::info($ids);

            $toEdit->siteInfoes()->detach($ids);
            return Response::json(['message' => 'Removed Site From ' . $toEdit->username], 200);
        }
    }


    public function changeProfile(Request $request)
    {
        try {
            //image upload only
            if ($request->image) {
                $user_id = Auth::user()->id;
                $the_user = $this->user->findOrFail($user_id);
                $this->savePhoto($the_user, $request);
                $message = 'Your  Picture Successfully Updated !';
                return Response::json(['message' => $message, 'mode' => 'Update'], 200);
            }

            $this->validate($request, [
                'current_password' => 'required',
                'new_password' => 'required|min:8',
                'confirm_password' => 'required|same:new_password',
            ]);


            $user_id = Auth::user()->id;
            $the_user = $this->user->findOrFail($user_id);
            $send_sms = $request->sendSms;
            // $the_site = SiteInfo::findOrFail(Session::get('SITE_ID'));

            $url = $this->getDomain($the_user->alias);


            $user_name = $the_user->username;
            $password = $request->new_password;
            $phone = $the_user->contact_number ?? null;


            $current_password = $the_user->password;
            if (Hash::check($request->current_password, $current_password)) {

                $the_user->password = trim($password);
                $the_user->save();

            } else {
                throw new \Error('Current Password Not Matched!');
            }


            /*  if ($send_sms && $phone) {

                  $sms_txt = "Login Info";
                  $sms_txt .='nl'.$eduUserToEdit->full_name;
                  $sms_txt .= 'nl' .$url;
                  $sms_txt .= 'nl' . 'Username: ' . $user_name;
                  $sms_txt .= 'nl' . 'Password: ' . $request->password;
                  $sms_txt .= 'nl' . 'Regards: ' . $the_site->site_name;

                  $tt = $this->sendSms($the_site->id, [$phone],$sms_txt );

              }*/


            $subject = "Login Info: ";//. $the_site->site_name;

            $data = [
                'name' => $the_user->full_name,
                'username' => '',
                'sub_domain' => $url,
                'password' => $password,
                'message' => 'Requested User Login Info!',
                'user_id' => Auth::user()->username
            ];
            

            $user_mail = $the_user->email ?? 'edudeskbd@gmail.com';

            Mail::to([/*$the_site->site_email,*/
                $user_mail, 'eduworlderp@gmail.com'])->send(new SendMailToUserWithQueue($subject, $data));


            $this->clearDatabaseSessionForSiteUsers(0, $user_id);


            return Response::json(['message' => 'Login Info Successfully Generated!', 'mode' => 'Success'], 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    private function savePhoto(User $newlyCreatedUser, Request $request)
    {


        if ($request->image == "image-not.png") {
            $fileName = $request->image;
        } else {
            $name = time() . '.' . explode('/', explode(':', substr($request->image, 0, strpos($request->image, ';')))[1])[1];
            $fileName = $name;
            Image::make($request->image)->resize(150, 150)->save(public_path('uploads/') . $name);
        }

        $photo = new Photo();
        $photo->name = $fileName;
        $photo->user_id = $newlyCreatedUser->id;
        $newlyCreatedUser->photo()->save($photo);


    }

    public function getNotification($id)
    {
        $user=Auth::user();
        $notification = $user->notifications()->findOrFail($id);
        $notification->markAsRead();
        return response()->json($notification, 200);

    }


}
