<?php

namespace App\Http\Controllers\Api\Academic;

use App\Forms\DataHelper;
use App\Models\Academic\AcademicBoard;
use App\Models\Division\Division;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Relation\Relation;
use App\Models\Site\Batch\GlobalBatchDetail;
use App\Models\Site\GlobalSiteClassSessionSerialSetting;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\Result\GlobalSiteStudentPrimaryResultDetail;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\Student\GlobalStudentHistory;
use Exception;
use Response;
use Session;

class AcademicApiController extends Controller
{
    use DataHelper;
    private $division;

    
    private $SiteShiftClassGroupSectionSetting;

    public function __construct(GlobalSiteShiftClassGroupSectionSetting $SiteShiftClassGroupSectionSetting)
    {
        $this->SiteShiftClassGroupSectionSetting = $SiteShiftClassGroupSectionSetting;
        $this->middleware('api.access');
      //  $this->middleware('api.app.access');
      //  $this->middleware('site_id.check');
    }

    
    private function getSiteId($request){
         
        if(empty($request->site_id)){
            $domain = "";
            if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
                $getHost = explode(".", $_SERVER['HTTP_HOST']);
                $domain = array_shift($getHost);
            }
            $site_info = GlobalSiteInfo::where('site_alias', $domain)->first();
            $site_id = $site_info->id;
            Session::put('SITE_ID', $site_id);
        }else{
            Session::put('SITE_ID', $request->site_id);
            $site_id = $request->site_id;
        }
        return $site_id;
    }


    public function getBoardList()
    {
       // $data = $this->boardList();
        $data = AcademicBoard::all();
        return response()->json($data, 200);
    }

    public function getVersionYearShift(Request $request)
    {
        try {
          //  dd('sf');

           // $site_id=$this->getSiteId($request);

            $data=$request->all();

            $the_site_info_setting = GlobalSiteInfoSetting::where('site_id', $data['site_id'])
                ->where('academic_group_id', $request->academic_group_id)
                ->first();

            $the_site_info = GlobalSiteInfo::findOrFail($data['site_id']);

            if (!$the_site_info_setting) {
                return Response::json(['message' => 'No "SiteInfoSetting" Found'], 422);
            }

            $academicShift = explode(',', $the_site_info_setting->shift_ids ?? null);
            $academicShiftList = AcademicShift::whereIn('id', $academicShift)
                ->get();

            $academicYear = explode(',', $the_site_info_setting->academic_year_ids ?? null);
            $academicYearList = AcademicYear::whereIn('id', $academicYear)->orderBy('serial_no', 'desc')->get();

         //   dd($academicYearList);

            $academicStudentCategory = explode(',', $the_site_info_setting->academic_student_category_ids ?? null);
            $academicStudentCategoryList = AcademicStudentCategory::whereIn('id', $academicStudentCategory)->get();


            $admissionlist = explode(',', $the_site_info_setting->academic_admission_type_ids ?? null);
            $admissionlistdata = AcademicAdmissionType::whereIn('id', $admissionlist)->get();



            $academicVersionIDs = explode(',', $the_site_info_setting->academic_version_ids);
            $academicVersionList = AcademicVersion::whereIn('id', $academicVersionIDs)->get();

            $academicStudentTypeIDs = explode(',', $the_site_info_setting->academic_student_type_ids);
            $academicStudentTypeList = AcademicStudentType::whereIn('id', $academicStudentTypeIDs)->get();
            $Sessionlistsplite = explode(',', $the_site_info_setting->academic_session_ids);
            $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();

            $data=[
                'academic_version_list'=>$academicVersionList,
                'academic_year_list'=>$academicYearList,
                'academic_shift_list'=>$academicShiftList,
                'academic_admission_type_list'=>$admissionlistdata,
                'academic_student_category_list'=>$academicStudentCategoryList,
                'academic_session_list'=>$Sessionlist,
                'academic_student_type_list'=>$academicStudentTypeList,
                'mode'=>'success',
                'status'=>'200',
            ];


        return response()->json($data, 200);

        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }

    }


    public function getYearVersionAndShiftBasedDepartmentClass(Request $request)
    {
        try{
        $site_id=$this->getSiteId($request);

        
        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;


        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id']) {
            return Response::json(['message' => 'Select Version, Year And Shift For Class List'], 411);
        }

        $academic_class_list = [];
        $academic_department_list = [];


        $SiteInfoTableData = GlobalSiteInfoSetting::where('site_id', $site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->select('academic_class_ids')
            ->first();


        $academicClassIds = explode(',', $SiteInfoTableData->academic_class_ids);

        $academicDepartment = $this->SiteShiftClassGroupSectionSetting
            ->where('site_id', $site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->whereNotNull('academic_department_id')
//            ->groupBy('academic_department_id', 'academic_class_id')
            //   ->get()
            ->pluck('academic_department_id')
            ->unique()
            ->filter()
            ->toArray();

        // dd($academicDepartment);


        if (count($academicDepartment) > 0) {
            $academic_department_list = AcademicDepartment::whereIn('id', $academicDepartment)
                ->get();
        } else {

//test
            $plucked_class_ids = $this->SiteShiftClassGroupSectionSetting
                ->where('site_id', $site_id)
                ->where('academic_group_id', $request->academic_group_id)
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->whereIn('academic_class_id', $academicClassIds)
//                ->groupBy('academic_class_id')
                ->pluck('academic_class_id')
                ->unique()
                ->filter()
                ->toArray();

            if (count($plucked_class_ids) == 0) {
                return Response::json(['message' => 'No Class Found For The Year! Go: <a target="_blank" href="' . route('site-shift-class-group-section-setting-opening-page') . '">Click</a>'], 411);

            }


            $academic_class_list = AcademicClass::whereIn('id', $plucked_class_ids)
                ->orderBy('serial_no', 'ASC')
                ->get();
        }


        $countDepartment = count($academic_department_list);

        $data=[
            'academic_class_list'=>$academic_class_list,
            'academic_department_list'=>$academic_department_list,
            'countDepartment'=>$countDepartment,
            'mode'=>'success',
            'status'=>'200',
        ];

        return response()->json($data, 200);

    }catch (Exception $exception) {
        return Response::json(['message' => $exception->getMessage()], 410);
    }
}

   

    public function getVersionYearShiftBaseDepartmentClass(Request $request)
    {

        try{

        $site_id = $this->getSiteId($request);

        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;


        if (!$data['academic_version_id'] || !$data['academic_year_id']) {
            return Response::json(['message' => 'Select Version, Year And Shift For Class List'], 411);
        }

        $academic_class_list = [];
        $academic_department_list = [];


        $SiteInfoTableData = GlobalSiteInfoSetting::where('site_id', $site_id)->select('academic_class_ids')->first();


        $academicClassIds = explode(',', $SiteInfoTableData->academic_class_ids);

        $academicDepartment = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_id)
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->whereNotNull('academic_department_id')
            //            ->groupBy('academic_department_id', 'academic_class_id')
            //   ->get()
            ->pluck('academic_department_id')
            ->unique()
            ->filter()
            ->toArray();

        // dd($academicDepartment);


        if (count($academicDepartment) > 0) {
            $academic_department_list = AcademicDepartment::whereIn('id', $academicDepartment)
                ->get();
        } else {

            //test
            $plucked_class_ids = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_id)
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->whereIn('academic_class_id', $academicClassIds)
                //                ->groupBy('academic_class_id')
                ->pluck('academic_class_id')
                ->unique()
                ->filter()
                ->toArray();

            if (count($plucked_class_ids) == 0) {
                return Response::json(['message' => 'No Class Found For The Year! Go: <a target="_blank" href="' . route('site-shift-class-group-section-setting-opening-page') . '">Click</a>'], 411);
            }


            $academic_class_list = AcademicClass::whereIn('id', $plucked_class_ids)
                ->orderBy('serial_no', 'ASC')
                ->get();
        }


        $countDepartment = count($academic_department_list);

        
        $data=[
            'academic_class_list'=>$academic_class_list,
            'academic_department_list'=>$academic_department_list,
            'countDepartment'=>$countDepartment,
            'mode'=>'success',
            'status'=>'200',
        ];

            return response()->json($data, 200);
    
        }catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    public function getYearVersionAndShiftBasedDepartmentClassAndExamList(Request $request)
    {
        try{
        $site_id=$this->getSiteId($request);
  
         $data = $request->all();
         $group_id  =   $data['academic_group_id'];
         $version_id  =   $data['academic_version_id'];
         $year_id     =   $data['academic_year_id'];
         $shift_id    =   $data['academic_shift_id'];
         $class_id    =   $data['academic_class_id'];
      
  //   dd($data);
 
        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id'] || !$data['academic_class_id']) {
            return Response::json(['message' => 'Select * Marked Field!'], 411);
        }
 
 
        $SiteInfoTableData = GlobalSiteInfoSetting::where('site_id', $site_id)->where('academic_group_id',$group_id)->select('id', 'batch_present_status')
            ->first();
 
 
        if ($SiteInfoTableData->batch_present_status) {
            $batch_list = GlobalBatchDetail::where('academic_class_id', $class_id)
                ->where('academic_group_id', $group_id)
                ->where('site_id', $site_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_shift_id', $shift_id)
                ->where('academic_year_id', $year_id)
                ->select('id', 'batch_name', 'batch_code')
                ->get();
 
            //   dd($class_id,$version_id,$shift_id,$year_id);
 
 
        } else {
            $batch_list = [];
        }
 
 
        $group_list = [];
        $section_list = [];
 
        $group_present = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_id)
            ->where('academic_group_id', $group_id)
            ->where('academic_version_id', $version_id)
            ->where('academic_year_id', $year_id)
            ->where('academic_shift_id', $shift_id)
            ->where('academic_class_id', $class_id)
            ->whereNotNull('academic_class_group_id')
            ->get();
 //        return $group_present;
 
 
        if (count($group_present) > 0) {
            $group_ids = $group_present->pluck('academic_class_group_id')->toArray();
            $group_list = AcademicClassGroup::whereIn('id', $group_ids)
                ->get();
 
 
        } else {
 
            $section_present = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_id)
                 ->where('academic_group_id', $group_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_shift_id', $shift_id)
                ->where('academic_class_id', $class_id)
                ->first();
 
            $exploded_section_ids = explode(',', $section_present->academic_section_ids ?? null);
 
            $section_list = AcademicSection::select('id', 'section_name')
                ->whereIn('id', $exploded_section_ids)
                ->get();
             }
 
        $session_exist = GlobalSiteClassSessionSerialSetting::where('academic_class_id', $data['academic_class_id'])
             ->where('site_id', $site_id)
            ->where('academic_group_id', $group_id)
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            // ->when($data['academic_department_id'],function($q) use ($data){
            //      $q->where('academic_department_id', $data['academic_department_id']);
            // })
            ->first();
 
        if ($session_exist && $session_exist->session_present) {
            $exploded_session_list = explode(',', $session_exist->session_ids);
            $session_list = AcademicSession::whereIn('id', $exploded_session_list)->get();
        } else {
            $session_list = [];
        }

        $resultList=$this->getResultListForPublic($request);
 
        $data=[
            'academic_class_group_list'=>$group_list,
            'section_list'=>$section_list,
            'session_list'=>$session_list,
            'batch_list'=>$batch_list,
            'result_list'=>$resultList,
            'mode'=>'success',
            'status'=>'200',
        ];

            return response()->json($data, 200);
    
        }catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    private function getResultListForPublic($request){

        $site_id = $this->getSiteId($request);
    
          $studentList=$this->getStudenthistoryIDs($request, $site_id);
          $student_ids=$studentList->pluck('id');
         
    
          $primary_exam_type_ids=GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
              ->where('result_public_publish_status', true)
              ->pluck('academic_result_primary_type_id')
              ->unique()
              ->filter();
    
              $result_primary_type_list=AcademicResultPrimaryType::whereIn('id', $primary_exam_type_ids)->get(['id', 'name']);
    
             
          return $result_primary_type_list;
    
       }

       private function getStudenthistoryIDs(Request $request, $site_id){
        $data = $request->all();
        
     
        $studentList = GlobalStudentHistory::select('id', 'user_id','student_roll_number')
            ->with(['student' => function ($q) {
                $q->with('latestPhoto');
                $q->select('id');
                $q->where('user_type', 'student');
            },
                'year', 'shift','department','stClass','classGroup','session','section'
            ])
            ->where('site_id', $site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            // ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            //     return $query->where('academic_department_id', $data['academic_department_id']);
            // })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->orderBy('student_roll_number')
            ->orderBy('academic_department_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_section_id')
            ->get();
   
        return $studentList;
     }


        
   public function getSiteClassGroupBaseSectionSessionList(Request $requests)
   {
    try{

       $data = $requests->all();
       $group_id  =   $data['academic_group_id'];
       $version_id  =   $data['academic_version_id'];
       $year_id     =   $data['academic_year_id'];
       $shift_id    =   $data['academic_shift_id'];
       $class_id    =   $data['academic_class_id'];
       $class_group_id  =   $data['academic_class_group_id'];
    // dd($year_id);
       $site_id = $this->getSiteId($requests);
        //$site_id = $site_list->id;

        $groupPresentCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_class_group_id')
        ->where('academic_version_id', $version_id)
        ->where('academic_year_id', $year_id)
        ->where('academic_class_id', $class_id)
        ->whereNotNull('academic_class_group_id')
        ->count();

        $sessionPresentCheck = GlobalSiteClassSessionSerialSetting::where('site_id', $site_id)
        ->where('academic_group_id', $group_id)->where('academic_class_id', $class_id)->first();

        if ($sessionPresentCheck) {
        if ($sessionPresentCheck->session_present) {
            $SiteInfoTableData = GlobalSiteInfoSetting::where('site_id', $site_id)->where('academic_group_id',$group_id)->first();
            $Sessionlistsplite = explode(',', $SiteInfoTableData->academic_session_ids);
            $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
        } else {
            $Sessionlist = [];
        }
        } else {
        $Sessionlist = [];
        }


        if (!$groupPresentCount) {

        $SiteClassBaseSectionCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_shift_id')
            ->where('site_id', $site_id)
            ->where('academic_group_id', $group_id)
            ->where('academic_version_id', $version_id)
            ->where('academic_year_id', $year_id)
            ->where('academic_class_id', $class_id)
            ->count();


        if (!$shift_id && $SiteClassBaseSectionCount > 1) {
            return 4001;
        } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
            $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                ->where('site_id', $site_id)
                ->where('academic_group_id', $group_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_class_id', $class_id)
                ->first();

        } else if ($shift_id && $class_id) {
            $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                ->where('site_id', $site_id)
                ->where('academic_group_id', $group_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_class_id', $class_id)
                ->where('academic_shift_id', $shift_id)
                ->first();

            }
        } else {
        if (!$shift_id && !$class_group_id) {
            return 4001;
        } else if ($shift_id && !$class_group_id) {
            $SiteGroup = GlobalSiteShiftClassGroupSectionSetting::select('academic_class_group_id')
                ->where('site_id', $site_id)
                ->where('academic_group_id', $group_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_class_id', $class_id)
                ->where('academic_shift_id', $shift_id)
                ->get();

            $sectionDataList = AcademicClassGroup::select('id', 'group_name')
                ->whereIn('id', $SiteGroup)
                ->get();


            return [2001, $sectionDataList, $Sessionlist];
        } else {
            $SiteClassBaseSectionCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_shift_id')
                ->where('site_id', $site_id)
                ->where('academic_group_id', $group_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_class_id', $class_id)
                ->where('academic_class_group_id', $class_group_id)
                ->get()
                ->count();


            if (!$shift_id && $SiteClassBaseSectionCount > 1) {
                return 4001;
            } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
                $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('site_id', $site_id)
                    ->where('academic_group_id', $group_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_class_group_id', $class_group_id)
                    ->first();
            } else if ($shift_id && $class_id) {
                $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('site_id', $site_id)
                    ->where('academic_group_id', $group_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_shift_id', $shift_id)
                    ->where('academic_class_group_id', $class_group_id)
                //    ->where('site_id',$site_id)
                    ->first();
                  //  dd($SiteClassBaseSection);
            }
        }
        }

        $SectionData = explode(',', $SiteClassBaseSection->academic_section_ids ?? null);

        $SectionDataList = AcademicSection::select('id', 'section_name')
        ->whereIn('id', $SectionData)
        ->get();

        $data=[
            'academic_section_list'=>$SectionDataList,
            'section_list'=>$Sessionlist,
            'mode'=>'success',
            'status'=>'200',
        ];

            return response()->json($data, 200);
    
        }catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
   }


   


}
