<?php

namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use Auth;
use Session;

class ApiProjectController extends Controller
{

    public function authInfoSessionPut(){
     
        $auth= Auth::user();
        $academic_group_id=$auth->academic_group_id;
        $site_id=$auth->site_id;
        $user_type=$auth->user_type;
        $alias=$auth->alias;

        Session::put('SITE_ID',$site_id);
        Session::put('ACADEMIC_GROUP_ID',$academic_group_id);
        Session::put('USER_TYPE',$user_type);
        Session::put('ALIAS1',$alias);
    
    }

    

    public function siteInfoSessionPut($request){
      //  dd($request->all());
        $auth= Auth::user();
        
        $site_id=$auth->site_id;
        $user_type=$auth->user_type;
        $alias=$auth->alias;

        $academic_group_id= (int) $request->academic_group_id;

        Session::put('SITE_ID',$site_id);
        Session::put('ACADEMIC_GROUP_ID', $academic_group_id);
        Session::put('USER_TYPE',$user_type);
        Session::put('ALIAS1',$alias);
    }


  public function convertNumberToWord($num = false)
    {
        $num = str_replace(array(',', ' '), '', trim($num));
        if (!$num) {
            return false;
        }
        $num = (int)$num;
        $words = array();
        $list1 = array('', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'ten', 'eleven',
            'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen'
        );
        $list2 = array('', 'ten', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety', 'hundred');
        $list3 = array('', 'thousand', 'million', 'billion', 'trillion', 'quadrillion', 'quintillion', 'sextillion', 'septillion',
            'octillion', 'nonillion', 'decillion', 'undecillion', 'duodecillion', 'tredecillion', 'quattuordecillion',
            'quindecillion', 'sexdecillion', 'septendecillion', 'octodecillion', 'novemdecillion', 'vigintillion'
        );
        $num_length = strlen($num);
        $levels = (int)(($num_length + 2) / 3);
        $max_length = $levels * 3;
        $num = substr('00' . $num, -$max_length);
        $num_levels = str_split($num, 3);
        for ($i = 0; $i < count($num_levels); $i++) {
            $levels--;
            $hundreds = (int)($num_levels[$i] / 100);
            $hundreds = ($hundreds ? ' ' . $list1[$hundreds] . ' hundred' . ' ' : '');
            $tens = (int)($num_levels[$i] % 100);
            $singles = '';
            if ($tens < 20) {
                $tens = ($tens ? ' ' . $list1[$tens] . ' ' : '');
            } else {
                $tens = (int)($tens / 10);
                $tens = ' ' . $list2[$tens] . ' ';
                $singles = (int)($num_levels[$i] % 10);
                $singles = ' ' . $list1[$singles] . ' ';
            }
            $words[] = $hundreds . $tens . $singles . (($levels && ( int )($num_levels[$i])) ? ' ' . $list3[$levels] . ' ' : '');
        } //end for loop
        $commas = count($words);
        if ($commas > 1) {
            $commas = $commas - 1;
        }
        return implode(' ', $words);
    }
    


    public function getSiteId($request){
         
        if(empty($request->site_id)){
            $domain = "";
            if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
                $getHost = explode(".", $_SERVER['HTTP_HOST']);
                $domain = array_shift($getHost);
            }
            $site_info = GlobalSiteInfo::where('site_alias', $domain)->first();
            $site_id = $site_info->id;
            Session::put('SITE_ID', $site_id);
        }else{
            Session::put('SITE_ID', $request->site_id);
            $site_id = $request->site_id;
        }
        return $site_id;
    }



}
