<?php

namespace App\Http\Controllers\Api\EmployeePanel;

use App\Forms\DataHelper;
use App\Http\Controllers\Api\ApiProjectController;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Jobs\EmployeeLeaveApplication\EmployeeLeaveApplicationJob;
use App\Models\Academic\AcademicLeaveCategory;
use App\Models\Academic\AcademicLeaveType;
use App\Models\Academic\AcademicPeriodType;
use App\Models\Site\EmployeeLeave\GlobalSiteEmployeeLeaveGenerate;
use App\Models\Site\EmployeeLeave\GlobalSiteEmployeeLeaveHistory;
use App\Models\Site\EmployeeLeave\GlobalSiteLeavePolicy;
use App\Models\Site\EmployeeLeave\SiteEmployeeLeaveGenerate;
use App\Models\Site\EmployeeLeave\SiteEmployeeLeaveHistory;
use App\Models\Site\EmployeeLeave\SiteLeavePolicy;
use App\Models\Site\Role\SiteRole;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\Site\SiteInfo;
use App\Models\User\EmployeeHistory;
use App\Models\User\GlobalEmployeeHistory;
use App\Traits\Site\Routine\RoutineFunction;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Dotenv\Exception\ValidationException;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response as FacadesResponse;
use Session;
use Response;
use PDF;
use Illuminate\Support\Facades\DB ;


class EmployeeLeaveApiController extends ApiProjectController
{
    use DataHelper, RoutineFunction;

    public function __construct()
    {
        $this->middleware('auth:apps-api');
        $this->middleware('api.app.access');
        $this->middleware('employee.check');

    }


    public function getLeaveTypeLeaveCategoryList($id = null)
    {
      try{
        $employee = Auth::user();
        
        $employee_id = $employee->id;
        $employee_history = GlobalEmployeeHistory::where('user_id', $employee_id)->where('status', 1)->with('user')->first();
      
        if($employee_history){
          //  dd($employee_history->user);
            $gender_id =  $employee_history->user['gender_id'];
          

            $leave_policy_without_gender = GlobalSiteLeavePolicy::where('employee_designation_id', $employee_history->designation_id)
                ->where('status', 1)
                ->where('gender_id', null)
                ->where('site_id', $employee->site_id)
                ->get();

            $leave_policy_with_gender = GlobalSiteLeavePolicy::where('employee_designation_id', $employee_history->designation_id)
                ->where('status', 1)
                ->where('gender_id', $gender_id)
                ->where('site_id', $employee->site_id)
                ->get();

                if(count($leave_policy_with_gender)){
                $leave_policy = array_merge($leave_policy_without_gender->toArray(), $leave_policy_with_gender->toArray());
            }else{
                $leave_policy = $leave_policy_without_gender;
            }

            $leave_type_ids = array();
            $leave_category_ids = array();
            foreach ($leave_policy as $key => $vlue){
                $leave_type_ids[] = $vlue['academic_leave_type_id'];
                $leave_category_ids[] = $vlue['academic_leave_category_id'];
            }


            $leave_type_list = AcademicLeaveType::whereIn('id', $leave_type_ids)->get();

            $leave_category_list = AcademicLeaveCategory::whereIn('id', $leave_category_ids)->get();


            $data=[
                'leave_type_list'=>$leave_type_list,
                'leave_category_list'=>$leave_category_list,
                'mode'=>'success',
                'status'=>'200',
            ];
    
            return response()->json($data,200);
    

        }

      

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    }


    
    public function getLeaveTypeCategoryWiseEmployeeLeaveDays(Request $request)
    {

        try{

        $employee = Auth::user();
        $employee_id = $employee->id;
        $employee_history = GlobalEmployeeHistory::where('user_id', $employee_id)->where('status', 1)->with('user')->first();


        $employee_history = GlobalEmployeeHistory::where('user_id', $employee_id)->where('status', 1)->with('user')->first();

        $check_leave_generate = GlobalSiteEmployeeLeaveGenerate::where('employee_history_id', $employee_history->id)->where('status', 1)->first();
        $exist_leave_generate_id = 0;
        if($check_leave_generate){
            $exist_leave_generate_id = $check_leave_generate->id;
        }

        $pending_txt = 'pending';
        $approved_txt = 'approved';

        $leave_history =  GlobalSiteEmployeeLeaveHistory::orderBy('id','DESC')->where('site_employee_leave_generate_id', $exist_leave_generate_id)
                            ->whereHas('siteEmployeeLeaveGenerate', function ($query) use($request){
                                $query->whereHas('siteLeavePolicy', function ($qr) use($request){
                                    $qr->where('academic_leave_type_id', $request->academic_type_id)
                                        ->where('academic_leave_category_id', $request->academic_category_id);
                                });
                            })
                            ->where(function ($query) use($pending_txt,$approved_txt){
                                $query->where('leave_status', $pending_txt)
                                        ->orwhere('leave_status', $approved_txt);
                            })
                            ->where('status', 1)
                            ->first();
                
        if($leave_history){
            $leave_days =  $leave_history->remaining_days;
            $leave_generate_id =  $leave_history->site_employee_leave_generate_id;
            $employee_history_id =  $leave_history->employee_history_id;
            return [$leave_days, $leave_generate_id, $employee_history_id];
        }else{
            $leave_generate = GlobalSiteEmployeeLeaveGenerate::where('employee_history_id', $employee_history->id)
            ->whereHas('siteLeavePolicy', function ($query) use($request){
                $query->where('academic_leave_type_id', $request->academic_type_id)
                    ->where('academic_leave_category_id', $request->academic_category_id);
            })
            ->where('status', 1)
            ->first();
          
            if($leave_generate){
                $leave_days = $leave_generate->previous_leave_days_remaining + $leave_generate->leave_days;
                $leave_generate_id =  $leave_generate->id;
                $employee_history_id =  $leave_generate->employee_history_id;

                
            $data=[
                'leave_days'=>$leave_days,
                'leave_generate_id'=>$leave_generate_id,
                'employee_history_id'=>$employee_history_id,
                'mode'=>'success',
                'status'=>'200',
            ];
    
           
                }else{

                $data=[
                    'leave_days'=>'',
                    'leave_generate_id'=>'',
                    'employee_history_id'=>'',
                    'mode'=>'success',
                    'status'=>'200',
                ];
            }
        }

        return response()->json($data,200);

        
    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }

    }


    public function employeeLeaveApplicationList(Request $request)
    {
        try{
        $search_leave_type = $request->academic_leave_type_id;
        $search_leave_category = $request->academic_leave_category_id;
        $search_leave_policy = $request->search_leave_policy;
        $search_designation = $request->search_designation;
        $search_text = $request->search_text;
        $search_date = $request->date;
        $search_leave_status = $request->leave_status;
        $paginate = $request->paginate ?? 20;

//        return $request;

        $txt = '%' . $search_text . '%';

        $leave_history =  GlobalSiteEmployeeLeaveHistory::
                with(['siteEmployeeLeaveGenerate'=>function($query){
                    $query->with(['siteLeavePolicy'=>function($q){
                        $q->with('academicLeaveType','academicLeaveCategory','designation');
                    }]);
                }])
                ->with(['employeeHistory'=>function ($qr){
                    $qr->with('user');
                }])
                ->when($search_leave_type, function ($query) use($search_leave_type){
                    return $query->whereHas('siteEmployeeLeaveGenerate', function ($qr) use($search_leave_type){
                        $qr->whereHas('siteLeavePolicy', function ($q) use($search_leave_type){
                            $q->where('academic_leave_type_id', $search_leave_type);


                        });
                    });
                })
                ->when($search_leave_category, function ($query) use($search_leave_category){
                    return $query->whereHas('siteEmployeeLeaveGenerate', function ($qr) use($search_leave_category){
                        $qr->whereHas('siteLeavePolicy', function ($q) use($search_leave_category){
                            $q->where('academic_leave_category_id', $search_leave_category);
                        });
                    });
                })
                ->when($search_leave_policy, function ($query) use($search_leave_policy){
                    return $query->whereHas('siteEmployeeLeaveGenerate', function ($qr) use($search_leave_policy){
                        $qr->whereHas('siteLeavePolicy', function ($q) use($search_leave_policy){
                            $q->where('id', $search_leave_policy);
                        });
                    });
                })
                ->when($search_designation, function ($query) use($search_designation){
                    return $query->whereHas('siteEmployeeLeaveGenerate', function ($qr) use($search_designation){
                        $qr->whereHas('siteLeavePolicy', function ($q) use($search_designation){
                            $q->where('employee_designation_id', $search_designation);
                        });
                    });
                })
                ->when($search_text, function($query) use($txt){
                    return $query->whereHas('employeeHistory', function ($qr) use ($txt){
                        $qr->whereHas('employee', function ($q) use ($txt){
                            $q->where(function ($query) use ($txt) {
                                $query->whereTranslationLike('first_name', $txt)
                                    ->orWhereTranslationLike('last_name', $txt);

                            });
                        });
                    });
                })

                ->when($search_date, function($query) use($search_date){
                    $query->where(function ($query) use ($search_date) {
                        return $query->where('request_date', $search_date)
                                    ->orWhere('cancel_date', $search_date)
                                    ->orWhere('approve_date', $search_date);
                    });

                })
                ->when($search_leave_status, function($query) use($search_leave_status) {
                    $query->where('leave_status', $search_leave_status);
                })
                ->where('status', 1)
                ->orderBy('id', 'DESC')
                ->paginate($paginate);
//                                                    ->get();
        $mytime = Carbon::now();
        $to_date =  $mytime->toDateString();

        $data=[
            'leave_history'=>$leave_history,
            'to_date'=>$to_date,
            'mode'=>'success',
            'status'=>'200',
        ];
       
        return response()->json($data,200);
       
        
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }

    }

    public function getEmployeeLeaveHistoryList(Request $request)
    {
        try{
           
        $this->siteInfoSessionPut($request);

        $search_date = $request->search_date;
        $search_leave_type = $request->search_leave_type;
        $search_leave_status = $request->search_leave_status;
        $paginate = $request->paginate ?? 15;


        $employee_id = Auth::user()->id;

        $employee_history = EmployeeHistory::where('user_id', $employee_id)->orderBy('id','DESC')->where('status', 1)->with('user')->first();

        $leave_history =  SiteEmployeeLeaveHistory::with(['siteEmployeeLeaveGenerate'=>function($query){
                             $query->with(['siteLeavePolicy'=>function($q){
                                    $q->with('academicLeaveType','academicLeaveCategory');
                            }]);
                        }])
                        ->when($search_leave_type, function ($query) use($search_leave_type){
                            return $query->whereHas('siteEmployeeLeaveGenerate', function ($qrr) use($search_leave_type){
                                $qrr->whereHas('siteLeavePolicy', function ($qr) use($search_leave_type){
                                   $qr->whereHas('academicLeaveType', function ($q) use($search_leave_type){
                                     $q->where('id',$search_leave_type);
                                   });
                                });
                            });
                        })
                        ->when($search_date, function ($query) use($search_date){
                            return $query->where('request_date', $search_date)
                                        ->orWhere('approve_date', $search_date)
                                        ->orWhere('cancel_date', $search_date)
                                        ->orWhere('from_date', $search_date)
                                        ->orWhere('to_date', $search_date);
                        })
                        ->when($search_leave_status, function ($query) use($search_leave_status){
                            $query->where('leave_status', $search_leave_status);
                        })
                        ->where('employee_history_id', $employee_history->id)
                        ->where('status', 1)
//                        ->get();
                        ->orderBy('id', 'DESC')
                        ->paginate($paginate);

        if($leave_history != null){

            $data=[
                'leave_history'=>$leave_history,
                'mode'=>'success',
                'status'=>'200',
            ];
           
            return response()->json($data,200);
        }else{
            return Response::json(['message' => 'Sorry! Data not found!'], 411);

        }
    
           
    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }


    }

    public function createEmployeeLeaveApplication(Request $request)
    {
        DB::beginTransaction();
        try{

        $this->validate($request,[
            'academic_leave_type_id' => 'required',
            'academic_leave_category_id' => 'required',
            'date_range' => 'required',
        ]);

        $this->siteInfoSessionPut($request);
        $range=json_decode($request->date_range);
        $start_date = $range->start;
        $end_date = $range->end;
       // dd($start_date);
      
       $employee_id = Auth::user()->id;
       // $range=json_decode($request->date_range);  
      
      //  $end_date_empty_check = $request->date_range['end'];
        $end_date_empty_check = $request->date_range ? json_decode($request->date_range) : null;

        if(!$end_date_empty_check){
            return Response::json(['message' => 'Please, enter To date!','mode'=>'error','status'=>'411',], 411);
        }


        if($request->id !=0){
            //==================update=====================

            $update_application = $this->updateApplication($request);
            return $update_application;

        }else{
          

            //==================create=====================

            $academic_type_id = $request->academic_leave_type_id;
            $academic_category_id = $request->academic_leave_category_id;

         //   dd($academic_type_id);

            //================only for non-generated leave===============================

           
          
            $employee_history = EmployeeHistory::where('user_id', $employee_id)->where('status', 1)->with('employee')->first();
            $emp_history_id = $employee_history->id;
            

            $gender_id = $employee_history->employee['gender_id'];
            $leave_policy_with_gender = SiteLeavePolicy::where('employee_designation_id', $employee_history->designation_id)
                                ->where('gender_id', $gender_id)
                                ->where('academic_leave_type_id', $academic_type_id)
                                ->where('academic_leave_category_id', $academic_category_id)
                                ->where('status', 1)
                                ->orderBy('id', 'DESC')
                                ->first();

            $leave_array = $this->getEmployeeLeaveDays($academic_type_id,$academic_category_id, $emp_history_id);

            $leave_days = $leave_array[0];
            $leave_generate_id = $leave_array[1];
            $employee_history_id = $leave_array[2];

                if($leave_policy_with_gender){

                //--------------request days-------------------------

                $st_date = strtotime($start_date);
                $ed_date = strtotime($end_date);
                $datediff = $ed_date - $st_date;
                $days = round($datediff / (60 * 60 * 24)) + 1;
                
            //    dd($st_date);

                //-------------request date--------------------------

                $mytime = Carbon::now();
                $request_date = $mytime->toDateString();

               // $leave_days = $leave_policy_with_gender->leave_days;
                if($days<=$leave_days){

                    //----------------generate leave-----------------------------

                    $leave_generate = SiteEmployeeLeaveGenerate::where('employee_history_id', $employee_history->id)
                        ->where('site_leave_policy_id', $leave_policy_with_gender->id)
                        ->where('status', 1)
                        ->first();

                    if($leave_generate){
                        $leave_generate_data = SiteEmployeeLeaveGenerate::where('site_leave_policy_id', $leave_policy_with_gender->id)
                            ->orderBy('id', 'DESC')
                            ->where('employee_history_id', $employee_history->id)
                            ->where('status', 1)->first();

                        //==============check leave exist===========================
                        $leave_generate_id = $leave_generate_data->id;
                     //   dd($leave_generate_id);
                        $check_leave = $this->checkLeaveIfExist($request, $leave_generate_id);

                        if($check_leave == "found"){
                            DB::rollBack();
                            return Response::json(['message' => 'Request date already exist!','mode'=>'error','status'=>'411',], 411);


                        }
                        //----------------create application-----------------------------

                        $employeeLeaveHistory = SiteEmployeeLeaveHistory::create([
                            'site_employee_leave_generate_id' => $leave_generate_data->id,
                            'employee_history_id' => $employee_history->id,
                            'spend_leave_days' => $days,
                            'remaining_days' => $leave_days - $days,
                            'from_date' => $start_date,
                            'to_date' => $end_date,
                            'reason' => $request->reason,
                            'request_date' => $request_date,
                            'leave_status' => 'pending',
                            'status' => $request->status,
                        ]);

                        return ['message' => 'Successfully Saved!','mode'=>'success','status'=>'200'];
                    }else{
                        $employee_previous_history_list = EmployeeHistory::where('user_id', $employee_id)->orderBy('id', 'DESC')->where('status', 0)->with('user')->first();
                        if($employee_previous_history_list){
                            $employee_previous_history_id = $employee_previous_history_list->id;
                        }else{
                            $employee_previous_history_id = null;
                        }

                        $employeeLeaveGenerate=SiteEmployeeLeaveGenerate::create([
                            'site_leave_policy_id' => $leave_policy_with_gender->id,
                            'employee_previous_history_id' => $employee_previous_history_id,
                            'employee_history_id' => $employee_history->id,
                            'academic_fiscal_year_id' => null,
                            'previous_leave_days_remaining' => null,
                            'leave_days' => $leave_days,
                            'status' => $request->status
                        ]);

                        $leave_generate_data = SiteEmployeeLeaveGenerate::where('site_leave_policy_id', $leave_policy_with_gender->id)
                            ->orderBy('id', 'DESC')
                            ->where('employee_history_id', $employee_history->id)
                            ->where('status', 1)
                            ->first();


                        //----------------create application-----------------------------

                        $employeeLeaveHistory = SiteEmployeeLeaveHistory::create([
                            'site_employee_leave_generate_id' => $leave_generate_data->id,
                            'employee_history_id' => $employee_history->id,
                            'spend_leave_days' => $days,
                            'remaining_days' => $leave_days - $days,
                            'from_date' => $start_date,
                            'to_date' => $end_date,
                            'reason' => $request->reason,
                            'request_date' => $request_date,
                            'leave_status' => 'pending',
                            'status' => $request->status,
                        ]);

                        //======================notification========================

                        $employee_leave_history =  SiteEmployeeLeaveHistory::where('employee_history_id', $employee_history->id)->orderBy('id', 'DESC')
                            ->with(['employeeHistory' => function ($query) {
                                $query->with('employee');
                            }])->first();

                        // $user_role = SiteRole::with('users')->first();
                        // $admin_user_details =  $user_role->users;
                      //  $admin_user_id =  $admin_user_details[0]->id;

                        $data_array = array();
                        $data_array['employee_name'] = $employee_leave_history->employeeHistory->employee->full_name;
                        $data_array['employee_id'] = $employee_leave_history->employeeHistory->employee->username;
                        $data_array['employee_spend_leave_days'] = $employee_leave_history->spend_leave_days;
                        $data_array['form_date'] = $employee_leave_history->from_date;
                        $data_array['to_date'] = $employee_leave_history->to_date;
                        $data_array['id'] = $employee_leave_history->id;
                        $data_array['admin_user_id'] = $employee_id;

                        $route=route('site-emp-leave-application-notification-view',['']);
                        

                        dispatch(new EmployeeLeaveApplicationJob($data_array, $route));

                        //======================end========================
                        DB::commit();
                        return ['message' => 'Successfully Saved!','mode'=>'success','status'=>'200'];
                    }

                }else{
                    return Response::json(['message' => 'Sorry! you requested for exsessive days!','mode'=>'error','status'=>'411',], 411);
                }
            }else{

                //================only for generated leave===============================
                // $leave_array = $this->getEmployeeLeaveDays($academic_type_id,$academic_category_id, $emp_history_id);
                // $leave_days = $leave_array[0];
                // $leave_generate_id = $leave_array[1];
                // $employee_history_id = $leave_array[2];

                //--------------request days-------------------------
                $st_date = strtotime($start_date);
                $ed_date = strtotime($end_date);
                $datediff = $ed_date - $st_date;
                $days = round($datediff / (60 * 60 * 24)) + 1;

                //-------------request date--------------------------

                $mytime = Carbon::now();
                $request_date = $mytime->toDateString();

                //==============check leave exist===========================
             
                $check_leave = $this->checkLeaveIfExist($request, $leave_generate_id);
              //  dd($check_leave);
                if($check_leave == "found"){
                    return Response::json(['message' => 'Request date already exist!','mode'=>'error','status'=>'411'], 411);
                }

                //----------------create-----------------------------

                if($days<=$leave_days){
                    $employeeLeaveHistory = SiteEmployeeLeaveHistory::create([
                        'site_employee_leave_generate_id' => $leave_generate_id,
                        'employee_history_id' => $employee_history_id,
                        'spend_leave_days' => $days,
                        'remaining_days' => $leave_days - $days,
                        'from_date' => $start_date,
                        'to_date' => $end_date,
                        'reason' => $request->reason,
                        'request_date' => $request_date,
                        'leave_status' => 'pending',
                        'status' => $request->status,
                    ]);

                    //======================notification========================

                    $employee_leave_history =  SiteEmployeeLeaveHistory::where('employee_history_id', $employee_history->id)->orderBy('id', 'DESC')
                        ->with(['employeeHistory' => function ($query) {
                            $query->with('employee');
                        }])->first();

                   // $user_role = SiteRole::with('users')->where('name','admin')->first();

                    // $admin_user_details =  $user_role->users
                    //                 ->where('status',true)
                    //          //       ->where('institute_head',true)
                    //                 ->first();
                     
                    // $admin_user_id =  $admin_user_details->id;

                    $data_array = array();
                    $data_array['employee_name'] = $employee_leave_history->employeeHistory->employee->full_name;
                    $data_array['employee_id'] = $employee_leave_history->employeeHistory->employee->username;
                    $data_array['employee_spend_leave_days'] = $employee_leave_history->spend_leave_days;
                    $data_array['form_date'] = $employee_leave_history->from_date;
                    $data_array['to_date'] = $employee_leave_history->to_date;
                    $data_array['id'] = $employee_leave_history->id;
                    $data_array['admin_user_id'] = $employee_id;
                     
                    $route=route('site-emp-leave-application-notification-view',['']);
                   
                    dispatch(new EmployeeLeaveApplicationJob($data_array, $route));

                    //======================end========================
                    DB::commit();
                    return ['message' => 'Successfully Saved!','mode'=>'success','status'=>'200'];
                }else{
                    return Response::json(['message' => 'Sorry! you requested for exsessive days!','mode'=>'error','status'=>'411',], 411);

                }
            }

        }

        

    } catch (ValidationException $exception) {
        DB::rollBack();
        return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
    } catch (Exception $exception) {
        DB::rollBack();
        return Response::json(['message' => $exception->getMessage()], 410);
    }

    }

    public function checkLeaveIfExist($request, $leave_generate_data)
    {
//        return [$request,$leave_generate_data];
        $range=json_decode($request->date_range);
        $st_date = $range->start;
        $ed_date = $range->end;

        $leave_history = SiteEmployeeLeaveHistory::where('site_employee_leave_generate_id', $leave_generate_data)
                ->where('leave_status', '!=', 'cancelled')
                ->get();

         //   dd($leave_history);

        if(count($leave_history)){
            $period = CarbonPeriod::create($st_date, $ed_date);
            foreach ($period as $date) {
                $dd = $date->format('Y-m-d');

                foreach ($leave_history as $key => $value){
                    $start_date = $value->from_date;
                    $end_date = $value->to_date;
                    $prd = CarbonPeriod::create($start_date, $end_date);

                    foreach ($prd as $dt){
                        $ddd = $dt->format('Y-m-d');
//                        return $ddd;
                        if($dd == $ddd){
//                            return $ddd;
                            return 'found';
                        }
                    }

                }

            }
            return 'not found';



        }
    }


    
    public function updateApplication($request){

        $range=json_decode($request->date_range);
        $st_date = $range->start;
        $ed_date = $range->end;

        $leave_history_data = SiteEmployeeLeaveHistory::findOrFail($request->id);

        $mytime = Carbon::now();
        $request_date = $mytime->toDateString();$fg = strtotime($request_date);
//        ===============new days====================
        $start_date = strtotime($st_date);
        $end_date = strtotime($ed_date);
        $datediff = $end_date - $start_date;
        $new_days = round($datediff / (60 * 60 * 24)) + 1;

//        ==================old days=================
        $rest_days = $leave_history_data->spend_leave_days - $new_days;
        $remainig_days = $leave_history_data->remaining_days + $rest_days;
        $update_application = $leave_history_data->update([
            'spend_leave_days'=>$new_days,
            'remaining_days'=>$remainig_days,
            'from_date'=>$st_date,
            'to_date'=>$ed_date,
            'reason'=>$request->reason,
            'request_date'=>$request_date,

        ]);
        return Response::json(['message' => 'Successfully Saved!','mode'=>'success','status'=>'200',], 200);


    }


    
    public function getEmployeeLeaveDays($academic_type_id, $academic_category_id, $id = null)
    {
//        $employee_id = Auth::user()->id;
//        $employee_history_list =  $this->employeeHistory->where('user_id', $employee_id)->where('status', 1)->first();
//        return  $employee_history_list;

        if($id == null){
            $employee_id = Auth::user()->id;
            $employee_history_list =  EmployeeHistory::where('user_id', $employee_id)->where('status', 1)->first();
        }else{
            $employee_history_list =  EmployeeHistory::where('id', $id)->where('status', 1)->first();
        }

        $gender_id = $employee_history_list->employee['gender_id'];
        $policy = SiteLeavePolicy::where('employee_designation_id', $employee_history_list->designation_id)
            ->where('gender_id', $gender_id)
            ->where('academic_leave_type_id', $academic_type_id)
            ->where('academic_leave_category_id', $academic_category_id)
            ->where('status', 1)
            ->orderBy('id', 'DESC')
            ->first();

        if(!$policy){

            $policy=SiteLeavePolicy::where('academic_leave_type_id',$academic_type_id)
                ->where('academic_leave_category_id',$academic_category_id)
                ->where('employee_designation_id',$employee_history_list->designation_id)
                ->orderBy('id', 'DESC')
                ->where('status', 1)
                ->first();
        }

     //   dd($policy);

    if($policy){
        $check_leave_generate = SiteEmployeeLeaveGenerate::where('employee_history_id', $employee_history_list->id)
            ->where('site_leave_policy_id', $policy->id)
            ->where('status', 1)
            ->first();

        $exist_leave_generate_id = 0;
      
      
        if($check_leave_generate){
            $exist_leave_generate_id = $check_leave_generate->id;
        }

        $pending_txt = 'pending';
        $approved_txt = 'approved';

        $leave_history =  SiteEmployeeLeaveHistory::orderBy('id','DESC')->where('site_employee_leave_generate_id', $exist_leave_generate_id)
                            ->whereHas('siteEmployeeLeaveGenerate', function ($query) use($academic_type_id, $academic_category_id){
                                $query->whereHas('siteLeavePolicy', function ($qr) use($academic_type_id, $academic_category_id){
                                    $qr->where('academic_leave_type_id', $academic_type_id)
                                        ->where('academic_leave_category_id', $academic_category_id);
                                });
                            })
                            ->where(function ($query) use($pending_txt,$approved_txt){
                                $query->where('leave_status', $pending_txt)
                                        ->orwhere('leave_status', $approved_txt);
                            })
                            ->where('status', 1)->first();

        if($leave_history){
            $leave_days =  $leave_history->remaining_days;
            $leave_generate_id =  $leave_history->site_employee_leave_generate_id;
            $employee_history_id =  $leave_history->employee_history_id;
            return [$leave_days, $leave_generate_id, $employee_history_id];
        }else{
            $leave_generate = SiteEmployeeLeaveGenerate::where('employee_history_id', $employee_history_list->id)
                            ->whereHas('siteLeavePolicy', function ($query) use($academic_type_id, $academic_category_id){
                                $query->where('academic_leave_type_id', $academic_type_id)
                                    ->where('academic_leave_category_id', $academic_category_id);
                            })
                            ->where('status', 1)
                            ->first();
                          //  dd($leave_generate);
            if($leave_generate){
                $leave_days = $leave_generate->previous_leave_days_remaining + $leave_generate->leave_days;
                $leave_generate_id =  $leave_generate->id;
                $employee_history_id =  $leave_generate->employee_history_id;
               return [$leave_days, $leave_generate_id, $employee_history_id];
               
            }
        }

    }else{
        return [0, 0, $id];
     }


    

    }


    public function getEmployeeLeaveBalanceList(Request $request)
    {

        $this->siteInfoSessionPut($request);

        $search_leave_type = $request->academic_leave_type_id;
        $search_leave_category = $request->academic_leave_category_id;
        $paginate = $request->paginate ?? 15;


        $employee_id = Auth::user()->id;


        $employee_history =EmployeeHistory::where('user_id', $employee_id)->where('status', 1)->with('user')->first();
       
        if($employee_history){
            
        $leave_generate =  SiteEmployeeLeaveGenerate::with(['siteLeavePolicy'=>function($query){
                                    $query->with('academicLeaveType','academicLeaveCategory');
                            }])
                            ->when($search_leave_type, function ($query) use($search_leave_type){
                                return $query->whereHas('siteLeavePolicy', function ($qr) use($search_leave_type){
                                    $qr->whereHas('academicLeaveType', function ($q) use($search_leave_type){
                                       $q->where('id', $search_leave_type);
                                    });
                                });
                            })
                            ->when($search_leave_category, function ($query) use($search_leave_category){
                                return $query->whereHas('siteLeavePolicy', function ($qr) use($search_leave_category){
                                    $qr->whereHas('academicLeaveCategory', function ($q) use($search_leave_category){
                                       $q->where('id', $search_leave_category);
                                    });
                                });
                            })
                            ->where('status', 1)
                            ->where('employee_history_id', $employee_history->id)
                            ->orderBy('id', 'ASC')
                            ->paginate($paginate);
//return $leave_generate;
                         
        if(count($leave_generate)){

            foreach ($leave_generate as $key => $value){

                    $leave_type_array[$key] = $value->siteLeavePolicy->academicLeaveType;
                    $leave_category_array[$key] = $value->siteLeavePolicy->academicLeaveCategory;

                    //=================leave balance list data===================

                    $leave_history =  SiteEmployeeLeaveHistory::orderBy('id','DESC')->where('site_employee_leave_generate_id', $value->id)
                                        ->where('leave_status', 'approved')
                                        ->where('status', 1)
                                        ->first();
                    if($leave_history){
                        $final_data[$key]['leave_type'] = $value->siteLeavePolicy->academicLeaveType['name'];
                        $final_data[$key]['leave_category'] = $value->siteLeavePolicy->academicLeaveCategory['name'];
                        $final_data[$key]['total_days'] = $value->leave_days;
                        $final_data[$key]['spend_days'] = $value->previous_leave_days_remaining + $value->leave_days - $leave_history->remaining_days;
                        $final_data[$key]['remaining_days'] = $leave_history->remaining_days;
                    }else{
                        $final_data[$key]['leave_type'] = $value->siteLeavePolicy->academicLeaveType['name'];
                        $final_data[$key]['leave_category'] = $value->siteLeavePolicy->academicLeaveCategory['name'];
                        $final_data[$key]['total_days'] = $value->previous_leave_days_remaining + $value->leave_days;
                        $final_data[$key]['spend_days'] = 0;
                        $final_data[$key]['remaining_days'] = $value->previous_leave_days_remaining + $value->leave_days;;
                    }

            }


            return Response::json([
                'leave_balance_list' => $final_data,
                'mode'=>'success',
                'status'=>'200'
            ], 200);

        }
    }

    }
    


   
}
