<?php

namespace App\Http\Controllers\Api\EmployeePanel;

use App\Forms\DataHelper;
use App\Http\Controllers\Api\ApiProjectController;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicPeriodType;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\Site\SiteInfo;
use App\Traits\Site\Routine\RoutineFunction;
use Dotenv\Exception\ValidationException;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Session;
use Response;
use PDF;


class EmployeeRoutineApiController extends ApiProjectController
{
    use DataHelper, RoutineFunction;

    public function __construct()
    {
        $this->middleware('auth:apps-api');
        $this->middleware('api.app.access');
        $this->middleware('employee.check');

    }


    public function getEmployeeRoutineReportPdf(Request $request)
    {
        

        try {
            $message = 'Nothing';

            $this->siteInfoSessionPut($request);
            $auth= Auth::user();
            $data = [];

            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_period_type_id'] = $request->academic_period_type_id == 'null' ? 0 : $request->academic_period_type_id;
            $emp_id = $auth->id;

            // dd($request->teacher_id , Auth::user()->id);

            if (!$data['academic_year_id'] || !$data['academic_period_type_id']) {
                return Response::json(['message' => 'Select * Marked Field!'], 410);
            }

            $headingList = [];

            $get_routine_details = RoutineDetail::whereHas('routineAllocations', function ($q) use ($emp_id) {
                    $q->where('employee_id', $emp_id)
                        ->where('status', 1)
                        ->with(['employee' => function ($q1) use ($emp_id) {
                            $q1->select(['id']);
                        }]);
                })->with(['routineAllocations' => function ($q) use ($emp_id) {
                    $q->where('employee_id', $emp_id)
                        ->where('status', 1);
                }, 'batch'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_period_type_id', $data['academic_period_type_id'])
                ->orderBy('start_time', 'ASC')
                ->get();
           
            if(!count($get_routine_details)){
                return response()->json(['message'=>'Routine Not found', 'status'=>'404', 'mode'=>'errors'],404); 
            }  
              //  return $get_routine_details;
            $week_array = array();
            $max_col_count = 0;

            foreach ($this->getWeekDay() as $k => $weekDay) {
                $week_array[$weekDay->weekday_name] = $get_routine_details->where('weekday', $weekDay->weekday_key) ?? [];
                if (count($week_array[$weekDay->weekday_name]) > $max_col_count) {
                    $max_col_count = count($week_array[$weekDay->weekday_name]);
                }
            }

            // $headingList = $getRoutineDetails->where('weekday', $getRoutineDetails[0]->weekday) ?? [];//$weekDays[0] ->0 index means first day of the week
            //  dd($get_routine_details[0]->routineAllocations);

            $total_period = count($get_routine_details);
            $report_tittle = '';
            $report_tittle2 = "<b>Total Period:</b>" . $total_period;


            $report_tittle .= "Class Routine For <b>" . (auth()->user()->full_name ?? '') . "</b>";
            $report_tittle .= "<br> <b>Year:</b>" . ($get_routine_details[0]->academicYear->year_name ?? '') . "";
            $report_tittle .= "<b> Period Type:</b>" . ($get_routine_details[0]->academicPeriodType->type_name ?? '');

           

            // return view('default.site.employee.routine.routine-report', compact('week_array', 'headingList', 'total_period', 'max_col_count', 'site', 'report_tittle', 'report_tittle2'));
            $pdf = PDF::loadView('default.site.employee.routine.routine-report', compact('week_array', 'total_period', 'max_col_count', 'report_tittle', 'report_tittle2'));
            return $pdf->stream(time() . '-routine.pdf');


        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    }

   
}
