<?php

namespace App\Http\Controllers\Api\EmployeePanel;

use App\Http\Controllers\Api\ApiProjectController;
use Illuminate\Http\Request;
use App\Models\Attendance\StudentAttendance;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Role\Role;
use App\Models\Setting\Setting;
use App\Models\Site\Academic\SitePeriodTypeDuration;
use App\Models\Site\Routine\RoutineAllocation;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\Student\Attendance\StudentAbsentDetail;
use App\Traits\SmsFunctionsTrait;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\Student\Student;
use App\Models\Student\StudentHistory;
use App\Models\User\User;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicClass;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Employee\EmployeeAttendance;
use App\Models\Site\Employee\EmployeeGeolocationSetting;
use App\Models\Site\Employee\GlobalEmployeeAttendance;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use App\Models\Site\SiteShiftDetails;
use App\Models\Site\Student\Attendance\PeriodicAttendance;
use App\Traits\LiveStreamingApiTrait;
use App\Traits\Site\Attendance\AttendanceRequestSave;
use App\Traits\Site\EventTrait;
use App\Traits\Site\Routine\RoutineFunction;
use App\Traits\TimeRelatedFunctionTrait;
use Carbon\Carbon;
use Session;
use PDF;
use Error;
use Response;


class MyAttendanceApiForEmployeeController extends ApiProjectController
{
use  SmsFunctionsTrait, RoutineFunction, EventTrait, TimeRelatedFunctionTrait;

use AttendanceRequestSave;

    private $carbon_now;
    private $studentAttendance;
    private $absentDetail;
    private $setting;
    private $user;
    private $siteShiftDetails;
    private $academicClass;
    private $academicSection;
    private $periodTypeDuration;
    private $routineDetail;
    private $siteShiftClassGroupSectionSetting;
    private $routineAllocation;
    private $studentHistory;
    private $student;
    private $infoSetting;
    private $periodicAttendance;

    public function __construct(RoutineDetail $routineDetail, StudentAttendance $studentAttendance, Setting $setting, User $user, RoutineAllocation $routineAllocation,
    SiteShiftDetails $siteShiftDetails, AcademicSection $academicSection, SiteShiftClassGroupSectionSetting $siteShiftClassGroupSectionSetting,
    AcademicClass $academicClass, SitePeriodTypeDuration $periodTypeDuration, StudentHistory $studentHistory, Student $student,
    StudentAbsentDetail $absentDetail, SiteInfoSetting $infoSetting, PeriodicAttendance $periodicAttendance)
    {
        $this->middleware('auth:apps-api');
        $this->middleware('api.app.access');
        $this->middleware('employee.check');

        $this->carbon_now = Carbon::now();

        $this->studentAttendance = $studentAttendance;
        $this->absentDetail = $absentDetail;
        $this->setting = $setting;
        $this->user = $user;
        $this->studentHistory = $studentHistory;
        $this->student = $student;
        $this->siteShiftDetails = $siteShiftDetails;
        $this->academicClass = $academicClass;
        $this->academicSection = $academicSection;
        $this->routineDetail = $routineDetail;
        $this->routineAllocation = $routineAllocation;
        $this->periodTypeDuration = $periodTypeDuration;
        $this->siteShiftClassGroupSectionSetting = $siteShiftClassGroupSectionSetting;
        $this->absentDetail = $absentDetail;
        $this->infoSetting = $infoSetting;
        $this->periodicAttendance = $periodicAttendance;

    }

    public function getEmployeeIndividualAttendance(Request $request)
    {
       // dd($request->all());
       try{

       $this->validate($request, [
            'date_range' => 'required',
        ]); 
       $date_range = $request->date_range ? json_decode($request->date_range) : null;
       $paginate = $request->paginate ?? 20;

   
       $start_date = $date_range->start;//.' 00:00:00';
       $end_date = $date_range->end;
      //  dd($date_start);

        $this->siteInfoSessionPut($request);

       // $date = $request->attendance_date ?? Carbon::now()->toDateString();
        $id = Auth::user()->id;
        $paginate=$request->paginate ?? 20;

        $emp_att_list = EmployeeAttendance::where('user_id', $id)
            ->where('present_date', '>=', $start_date)
            ->where('present_date', '<=', $end_date)
            ->orderBy('id', 'DESC')
            ->paginate($paginate);


        $emp_att_list->getCollection()->transform(function ($emp_att) {

            return [

                'user_id' => $emp_att->user_id ?? 0,
                'full_name' => $emp_att->employee->full_name ?? 'n/a',
                'contact_number' => $emp_att->employee->contact_number ?? 'n/a',
                'date' => $emp_att->present_date ?? 'n/a',
                'in_time' => $emp_att->in_time ?? null,
                'out_time' => $emp_att->out_time ?? null,
                'status' => $emp_att->late_status ? 'Late' : 'Intime',
            ];
        });

        $data=[
            'emp_att_data'=>$emp_att_list,
            'mode'=>'success',
            'status'=>'200',
        ];

        return response()->json($data,200);

    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }

       return response()->json($emp_att_list,200);
    }


    public function checkEmployeeAttendanceActivityForApi(Request $request){

        $this->siteInfoSessionPut($request);

        $currentDateTime = Carbon::now();
        $att_date = $currentDateTime->toDateString();
        $present_time = $currentDateTime->toTimeString();

        $year = date('Y', strtotime($att_date));
        $month = date('m', strtotime($att_date));
        $day = date('d', strtotime($att_date));
        $week_day = date('D', strtotime($att_date));
        $site_id=Session::get('SITE_ID');

        $username=Auth::user()->username;

        $get_user = Employee::whereHas('empShifts', function ($q) {
                $q->whereNull('release_date');
                $q->orderBy('id', 'DESC');
            })
            ->where('username', $username)
            ->select(['id', 'username', 'contact_number'])
            ->first();

        if(!$get_user){
            return Response::json(['message' => 'This chennel have no permission'], 410);
        }


        $empShifts = $get_user->empShifts[0];

        $emp_shift_id = $empShifts->academic_shift_id ?? 0;

        $get_period_type_duration = $this->periodTypeDuration
            ->where('start_date', '<=', $att_date)
            ->where('end_date', '>=', $att_date)
            ->first();

        $emp_shift_details = $this->siteShiftDetails
            ->where('academic_shift_id', $emp_shift_id)
            ->where('belongs_to', 'employee')
            ->where('academic_period_type_id', $get_period_type_duration->academic_period_type_id)
            ->where('week_day', $week_day)
            ->where('site_id', $site_id)
            ->where('status', true)
            ->first();

            if(!$emp_shift_details){
                return Response::json(['message' => 'You have no shift assigned!'], 410);
            }

        $data=[];

        $checkEmployeeAttendance = GlobalEmployeeAttendance::where('present_date', $att_date)
            ->where('user_id', $get_user->id)
            ->where('site_shift_details_id', $emp_shift_details->id)
            ->first();

        if($checkEmployeeAttendance){
            if($checkEmployeeAttendance->in_time){
                $data['att_in_status']=true;
            }else{
                $data['att_in_status']=false;
            }

            if($checkEmployeeAttendance->out_time){
                $data['att_out_status']=true;
            }else{
                $data['att_out_status']=false;
            }

        }else{
            $data['att_in_status']=false;
            $data['att_out_status']=false;
        }

    //    $data['att_activity_status']=$checkEmployeeAttendance;

        if($this->isAttendanceInvalid($present_time, $emp_shift_details)){
            $data['att_activity_status']=false;
        }else{
            $data['att_activity_status']=true;
        }

        return response()->json($data);


    }

    private function isAttendanceInvalid($a_time, $the_site_shift)
    {

        $in_time_allowed_min = $the_site_shift->in_time_allowed_min;

        $shift_time = strtotime($the_site_shift->in_time);//10:01:00 AM
        $given_access_time = strtotime($a_time);

        $difference = (($shift_time - $given_access_time) / 60);

        if (($in_time_allowed_min != 0 || $in_time_allowed_min != null) && $difference > 0 && ($difference > $in_time_allowed_min)) {
            return true;// in valid
        }

        return false;// valid

    }


    public function submitEmployeeGeoLocationAttendance(Request $request){

        
       $this->validate($request, [
            'latitude' => 'required',
            'longitude' => 'required',
        ]); 


        $this->siteInfoSessionPut($request);

        $checkSettings=EmployeeGeolocationSetting::first();

        if(!$checkSettings){
            return Response::json(['message'=>'Undefine Settings','status'=>'410'],410);
        }

        $latitudeCenter = $checkSettings->latitude;
        $longitudeCenter = $checkSettings->longitude;

        $radius = $checkSettings->radius; 

        // ইউজারের প্রদানকৃত অবস্থান
        $latitudeFrom = $request->latitude;
        $longitudeFrom = $request->longitude;
       
        // $latitudeFrom = 22.3609957;
        // $longitudeFrom = 91.8098733;
       

        // দূরত্ব হিসাব করে ভেরিফিকেশন
        $distance = $this->calculateDistance($latitudeFrom, $longitudeFrom, $latitudeCenter, $longitudeCenter);
    
        if ($distance <= $radius) {
            $request_chennel='android-gps';
            $request_ip_address=$request->ip();
           return $this->saveOwnAttendance($request_chennel,$request_ip_address);
        } else { 

            // check network type
            $clientIp = $request->ip();
            $networkType = 'unknown';
            
            if ($request->header('Network-Type')) {
                $networkType = $request->header('Network-Type');
            } elseif (filter_var($clientIp, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE) !== false) {
                $networkType = 'mobile';
            } else {
                $networkType = 'wifi';
            }

            if($networkType=='wifi'){
                return Response::json(['message' => 'The network has found that you are outside the area. You can try with mobile internet'], 410);
            }

            return response()->json(['message' => 'You are outside the area!','status'=>'410'],410);
        }
    }

    function calculateDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $earthRadius = 6371) {
        $latFrom = deg2rad($latitudeFrom);
        $lonFrom = deg2rad($longitudeFrom);
        $latTo = deg2rad($latitudeTo);
        $lonTo = deg2rad($longitudeTo);
    
        $latDelta = $latTo - $latFrom;
        $lonDelta = $lonTo - $lonFrom; 
    
        $angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
                cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
        return $angle * $earthRadius * 1000; // distance in meters
    }

    


   
}
