<?php

namespace App\Http\Controllers\Api\Payment;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Payment\GlobalSitePaymentGateway;
use App\Traits\Site\Payment\StudentCellfinTransactionTrait;

use Response;
use Auth;
use DB;
use Exception;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use JsonSchema\Exception\ValidationException;


class CellfinPaymentApiController extends Controller
{

    use StudentCellfinTransactionTrait;


    public function acceptPaymentInfoInCellfin(Request $request){

        $userId     =   $request->userId;
        $password   =   $request->password;
        $iid        =   $request->iid;
        $invoiceNo  =   $request->invoiceNo;
        $trId       =   $request->trId;
        $status     =   $request->status;
        $date_time  =   $request->date_time;
        $tr_amount  =   $request->tr_amount;
        $cr_amount  =   $request->cr_amount;
        $source_of_fund = $request->source_of_fund;
        $operation = $request->operation;
   
       $cellfinRequest=[
         'userId'=>$userId,
         'password'=>$password,
         'iid'=>$iid,
         'invoiceNo'=>$invoiceNo,
         'trId'=>$trId,
         'status'=>$status,
         'date_time'=>$date_time,
         'tr_amount'=>$tr_amount,
         'cr_amount'=>$cr_amount,
         'source_of_fund'=>$source_of_fund,
       ];


        DB::beginTransaction();
       try {
            if($userId && $password && $iid && $invoiceNo && $trId && $status && $date_time && $tr_amount
            && $cr_amount && $source_of_fund && $operation){

                $response_message= $this->postingPaymentInfoForStudent($cellfinRequest);
                $res_data=$response_message->getData();

                if($res_data->responseCode=='90'){
                    $response_message= $this->postingPaymentInfoForNewAdmission($cellfinRequest);
                    $res_data=$response_message->getData();

                      if($res_data->responseCode=='90'){
                         $response_message= $this->postingOtherPaymentInfoForNewAdmission($cellfinRequest);
                      }
                }

           
              return $response_message;


            }else{
              
              return Response::json(['responseCode'=>'90','responseMsg'=>'Field Missing'],401);
            }

         } catch (Exception $exception) {
               DB::rollBack();
               return Response::json(['responseCode'=>'90', 'responseMsg' => $exception->getMessage()], 410);
         }
      }
    
    
    public function getFeeInfoForCellfin(Request $request){

        $now = Carbon::now();
        $dateTime=$now->format('d/m/Y h:i A');

         try {
             $userId = $request->userId;
             $password = $request->password;
             $iid = $request->iid;
             $operation = $request->operation;
             $referenceId = $request->referenceId;
             $random = $request->random;

            $cellfinRequest=[
               'userId'=>$userId,
               'password'=>$password,
               'iid'=>$iid,
               'operation'=>$operation,
               'referenceId'=>$referenceId,
               'random'=>$random,
            ];
            
        if($userId && $password && $operation && $referenceId && $random && $iid){
         
                $payment_gateway=GlobalSitePaymentGateway::where('iid',$iid)->first();
                if($payment_gateway){
                  $response_message= $this->getStudentFeeInfo($cellfinRequest,$payment_gateway->id);
                  $res_data=$response_message->getData();

                    if($res_data->responseCode=='90'){
                      $response_message= $this->getApplicantAdmissionInfo($cellfinRequest);
                      $res_data=$response_message->getData();
                      
                        if($res_data->responseCode=='90'){
                          $response_message= $this->getApplicantAdmissionOtherInfo($cellfinRequest);
                        }
                    }

              
                   return $response_message;

                  }else{
                    return $this->failResponseForGetStudentInfo($dateTime,'Payment Gateway Not Found');
                  }
                }else{
                  return $this->failResponseForGetStudentInfo($dateTime,'AUTHENTICATION_FAILED');
                }  
            
            }catch (Exception $exception) {
               DB::rollBack();
               return $this->failResponseForGetStudentInfo($dateTime, $exception->getMessage());

            }    
               
      }


        
    }

