<?php

namespace App\Http\Controllers\Api\Payment;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Payment\GlobalSitePaymentGateway;
use App\Models\Site\Student\Student;
use App\Models\User\GlobalUser;
use App\Traits\Site\Fee\SonaliPayAdmissionFeeTrait;
use App\Traits\Site\Fee\SonaliPayStudentFeeTrait;
use App\Traits\Site\Payment\StudentCellfinTransactionTrait;

use Response;
use Auth;
use DB;
use Exception;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Hash;
use JsonSchema\Exception\ValidationException;


class SonaliPayApiController extends Controller
{

    use SonaliPayStudentFeeTrait, SonaliPayAdmissionFeeTrait;


  public function dataUpdateForSonaliPay(Request $request){

      try {
        
        $this->validate($request, [
          'Username' => 'required',
          'Password' => 'required',
          'InvoiceNo' => 'required',
          'InvoiceDate' => 'required',
          'TransactionId' => 'required',
      ]);
        $data=$request->all();

        $edu_username=$this->eduUserForSonaliPay;
        $edu_password=$this->eduPassForSonaliPay;
        
        if ($edu_username===$data['Username'] && $edu_password===$data['Password']) {

          if (substr($data['InvoiceNo'], 0, 1) === 'A') {
           
            $payment_update= $this->updateSoanliAdmissionPayment($data);
            
          }else{
            $payment_update= $this->updateSoanliPayment($data);
          }
        
       
          if($payment_update['status']=='200'){
            return response()->json(['Message'=>'success', 'Status'=>'200'], 200);
          }else{
            return response()->json(['Message'=>$payment_update['message'], 'Status'=>'410'], 410);
          }

        } else {
            return response()->json(['Message'=>'Auth Failed', 'Status'=>'410'], 410);
        }

        return response()->json(['Message'=>'Site Error', 'Status'=>'410'], 410);

      } catch (Exception $exception) {
        return Response::json(['Status'=>'90', 'Message' => $exception->getMessage()], 410);
      }


  } 


  // public function admissionPaymentUpdateForSonaliPay(Request $request){

  //     try {
  
  //       $this->validate($request, [
  //         'Username' => 'required',
  //         'Password' => 'required',
  //         'InvoiceNo' => 'required',
  //         'InvoiceDate' => 'required',
  //         'TransactionId' => 'required',
  //     ]);
      
  //       $data=$request->all();

  //       $edu_username=$this->eduUserForSonaliPay;
  //       $edu_password=$this->eduPassForSonaliPay;
        
  //       if ($edu_username===$data['Username'] && $edu_password===$data['Password']) {
        
  //         $payment_update= $this->updateSoanliAdmissionPayment($data);
       
  //         if($payment_update['status']=='200'){
  //           return response()->json(['Message'=>'success', 'Status'=>'200'], 200);
  //         }else{
  //           return response()->json(['Message'=>$payment_update['message'], 'Status'=>'410'], 410);
  //         }

  //       } else {
  //           return response()->json(['Message'=>'Auth Failed', 'Status'=>'410'], 410);
  //       }

  //       return response()->json(['Message'=>'Site Error', 'Status'=>'410'], 410);

  //     } catch (Exception $exception) {
  //       return Response::json(['Status'=>'90', 'Message' => $exception->getMessage()], 410);
  //     }


  // } 
    
  


        
  }

