<?php

namespace App\Http\Controllers\Api\Site\Web\Setting;

use App\Models\Image\Photo;
use App\Models\Site\Web\Video\Video;
use Auth;
use Error;
use App\Models\Site\Web\Event\Event;
use Exception;
use File;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Input;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfo;
use App\Models\ProjectModel;

use Image;
use Response;
use Storage;
use Session;

class EventApiController extends Controller
{
    private $event;

    public function __construct(Event $event)
    {
         $this->middleware('auth:api');
         $this->middleware('api.access');
         $this->middleware('sitepagechecker2');
        $this->event = $event;
    }

    public function create(Event $event, Request $request)
    {
    
        $this->validate($request, [
            'event_title' => 'required',
            'event_description' => 'required'
        ]);
    

        $files = range(1, $request->length);
        $live_url = $request->live_url;
        $file_path = null;
        $user_id = Auth::user()->id;

        $event->event_title = $request->event_title;
        $event->event_description = $request->event_description;
        $event->type = $request->type;
        $event->created_by = request()->user()->id;
        $event->site_id = $request->site_id;
        $event->status = $request->status;
        $event->save();


        if ($live_url) {
            $event->files()->create([
                'user_id' => $user_id,
                'path' => $live_url,
                'name' => "Live Link",
            ]);
        } else if ($request->length) {
            foreach ($files as $k => $val) {
                $file = Input::file('files' . $k);
                $file_name = $event->site_id . '/' . uniqid() . '.' . $file->getClientOriginalExtension();
                Storage::disk('uploads')->put($file_name, File::get($file));
                $file_path = '/uploads/files/' . $file_name;
                $file = Input::file('files' . $k);
                $file_type = $file->getClientMimeType();

                if (in_array($file_type, ['image/png', 'image/gif', 'image/jpeg', 'image/png'])) {
                    if ($request->type == 'slide') {
                        Image::make($file->getRealPath())->resize(1200, 750)->save('uploads/files/' . $file_name);
                    } else {
                        Image::make($file->getRealPath())->resize(600, 400)->save('uploads/files/' . $file_name);
                    }

                } else {
                    Storage::disk('uploads')->put($file_name, File::get($file));
                }

                $event->files()->create([
                    'user_id' => $user_id,
                    'path' => $file_path,
                    'name' => $file->getClientOriginalName(),
                ]);
            }
        }


        return response()->json(['message' => 'Successfully Saved!', 'mode' => 'save'], 200);
    }

    public function update(Request $request)
    {
//        return $request;

        // try {
        // \Log::info($request);

        $the_event = $this->event->findOrFail($request->id);
        if ($request->web_publish_time) {
            $the_event->web_publish_time = $request->web_publish_time;
            $the_event->web_publish_by = Auth::user()->id;

            $this->logNoticeSentDetails($the_event, '<b>Publish on web </b> ');
            $the_event->save();
            return response()->json(['message' => $the_event->notice_name . ' Will Be Published To Web!', 'mode' => 'Update'], 200);

        }

        $this->validate($request, [
            'event_title' => 'required',
            'event_description' => 'required'
        ]);


        $files = range(1, $request->length);
        $live_url = $request->live_url;
        $file_path = null;
        $deletes = $request->deletes ? explode(',', $request->deletes) : [];
        $user_id = Auth::user()->id;


        $the_event = $this->event->findOrFail($request->id);

        foreach ($the_event->ownFields as $k => $ownField) {
            if ($request->{$ownField}) {
                $the_event->{$ownField} = $request->{$ownField};
            }
        }
        $the_event->status = $request->status;
        $the_event->save();


        if ($live_url != 'undefined') {
            $this->deleteFiles($the_event);

            $the_event->files()->create([

                'user_id' => $user_id,
                'path' => $live_url,
                'name' => "Live Link",
            ]);
        } else
            if ($request->length) {
                foreach ($files as $k => $val) {

                    $file = Input::file('files' . $k);
                    $file_type = $file->getClientMimeType();

                    $file_name = $the_event->site_id . '/' . uniqid() . '.' . $file->getClientOriginalExtension();
                    $file_path = '/uploads/files/' . $file_name;

                    if (in_array($file_type, ['image/png', 'image/gif', 'image/jpeg', 'image/png'])) {

                        if ($request->type == 'slide') {
                            Image::make($file->getRealPath())->resize(600, 280)->save('uploads/files/' . $file_name);
                        } else {
                            Image::make($file->getRealPath())->resize(600, 400)->save('uploads/files/' . $file_name);
                        }

                    } else {
                        Storage::disk('uploads')->put($file_name, File::get($file));
                    }

                    $this->deleteFiles($the_event);


                    $the_event->files()->create([
                        'user_id' => Auth::user()->id,
                        'path' => $file_path,
                        'name' => $file->getClientOriginalName(),
                    ]);
                }
            }

        if (count($deletes)) {

            foreach ($deletes as $k => $id) {
                $the_photo = Photo::where('id', $id)->first();
                if ($the_photo) {
                    $image_path = public_path($the_photo->path);
                    if (File::exists($image_path)) {
                        unlink($image_path);
                    }
                }

            }
        }


        return response()->json(['data' => $the_event, 'message' => $the_event->event_title . ' Successfully Updated!', 'mode' => 'Update'], 200);
        /* } catch (ModelNotFoundException $exception) {
             throw new Error($exception->getMessage());

         } catch (Exception $exception) {
             throw new Error($exception->getMessage());
         }*/

    }


    public function getEventDetails($id)
    {
        try {
            $the_event = $this->event
                ->with('files')
                ->findOrFail($id);

            return response()->json($the_event, 200);

        } catch (Exception $ex) {
            return Response::json([$ex->getMessage()], 405);
        }

    }

    public function getEventGalleryListWithPagination(Request $request)
    {
//        return $request;
//        $site_id = (int)session()->get('SITE_ID');
//        return $site_id;

        try {
            $status = $request->status;
            $search_txt = $request->search_txt ?? "";
            $type = $request->type;
            $paginate = $request->paginate ?? 20;
            $txt = '%' . $search_txt . '%';


            $noticeList = $this->event
                ->where('status', $status)
                ->when($type, function ($qr) use ($type) {
                    return $qr->where('type', $type);
                })
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->whereTranslationLike('event_title', $txt)
                            ->orWhereTranslationLike('event_description', $txt);
                    });
                })
                ->with('files')
                ->orderBy('id', 'DESC')
                ->paginate($paginate);

            return $noticeList;
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }


    public function delete($id)
    {
        try {

            $the_event = $this->event->findOrFail($id);
            $the_event->delete();
            $the_event->deleteTranslations();
            $this->deleteFiles($the_event);

            return Response::json(['message' => 'Successfully Deleted!'], 200);


        } catch (ModelNotFoundException $ex) {
            return Response::json(['message' => 'The Notice Not Found!'], 405);

        } catch (Exception $ex) {
            return Response::json(['message' => 'Something went Wrong!'], 405);
        }
    }

    private function deleteFiles($the_event)
    {


        foreach ($the_event->files as $k => $file) {
            $the_photo = Photo::where('id', $file->id)->first();
            $image_path = public_path($the_photo->path);
            if (File::exists($image_path)) {
                unlink($image_path);
            }
            $the_photo->delete();
        }
    }

    public function getEventGalleryListWithPaginationTest()
    {
        return (int)session()->get('SITE_ID');
    }

    //=============================website video======================

    public function getVideoListWithPagination(Request $request, Video $video)
    {
//        return $request;
        return (int)session()->get('SITE_ID');
//       return \Session::get('SITE_ID');
//        return Session::get('SITE_ID');

        try {
            $status = $request->status;
            $search_txt = $request->search_txt;
            $paginate = $request->paginate ?? 20;
            $txt = '%' . $search_txt . '%';


//\Log::info($this->aboutUs->toSql());


            $videoList = $video
                ->where('status', $status)
                ->when($search_txt, function ($q) use ($search_txt) {
                    $q->where('title', $search_txt)
                        ->orWhere('description', $search_txt);
                })
                ->orderBy('id', 'DESC')
                ->paginate($paginate);

            return $videoList;
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function getVideoDetails($id)
    {
        $video = new Video();
        try {
            $video_date = $video->findOrFail($id);

            return response()->json($video_date, 200);

        } catch (Exception $ex) {
            return Response::json([$ex->getMessage()], 405);
        }

    }

    public function createWebsiteVideo(Video $video, Request $request)
    {
//        return $request;


        $this->validate($request, [
            'date' => 'required',
            'video_link' => 'required',
            'title' => 'required',
        ]);


        $user_id = Auth::user()->id;

        $abc = explode('/', $request->video_link);
        $last = end($abc);
        $again = explode('?', $last);
        if ($again) {
            $mid_last = end($again);
            $last_last = explode('v=', $mid_last);
            $final_link_last = end($last_last);

        } else {
            $final_link_last = $last;
        }
        $final_link = 'https://www.youtube.com/embed/' . $final_link_last;

        $video->title = $request->title;
        $video->video_link = $final_link;
        $video->description = $request->description;
        $video->date = $request->date;
        $video->created_by = $user_id;
        $video->status = $request->status;
        $video->save();

        return response()->json(['message' => 'Successfully Saved!', 'mode' => 'save'], 200);
    }

    public function updateWebsiteVideo(Request $request)
    {
//        return $request;

//        \Log::info($request);

        // try {
        $this->validate($request, [
            'date' => 'required',
            'video_link' => 'required',
            'title' => 'required',
        ]);

        $video = new Video();

        $user_id = Auth::user()->id;

        $abc = explode('/', $request->video_link);
        $last = end($abc);
        $again = explode('?', $last);
        if ($again) {
            $mid_last = end($again);
            $last_last = explode('v=', $mid_last);
            $final_link_last = end($last_last);

        } else {
            $final_link_last = $last;
        }
        $final_link = 'https://www.youtube.com/embed/' . $final_link_last;

        $video_data = $video->findOrFail($request->id);

        foreach ($video_data->ownFields as $k => $ownField) {
            if ($request->{$ownField}) {
                $video_data->{$ownField} = $request->{$ownField};
            }
        }
        $video_data->status = $request->status;
        $video_data->video_link = $final_link;
        $video_data->home_page_show_status = $request->home_page_show_status == "true" ? 1 : 0;
        $video_data->save();

        return response()->json(['message' => ' Successfully Updated!'], 200);

    }

    public function deleteWebsiteVideo($id)
    {
        try {
            $video = new Video();
            $video_data = $video->findOrFail($id);
            $video_data->delete();

            return Response::json(['message' => 'Successfully Deleted!'], 200);


        } catch (ModelNotFoundException $ex) {
            return Response::json(['message' => 'The Notice Not Found!'], 405);

        } catch (Exception $ex) {
            return Response::json(['message' => 'Something went Wrong!'], 405);
        }
    }
}
