<?php

namespace App\Http\Controllers\Api\Site\Web\Setting;

use App\Models\Site\Web\Message\Message;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Input;
use App\Models\Image\Photo;
use Auth;
use Error;
use Exception;
use File;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Image;
use Response;
use Storage;

class MessageController extends Controller
{
    private $message;

    public function __construct(Message $message)
    {
        $this->middleware('auth:api');
        $this->middleware('api.access');
        $this->middleware('sitepagechecker2');

       //  $this->middleware('auth');
       //  $this->middleware('sitepagechecker');
        $this->message = $message;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    public function getMessageListWithPagination(Request $request)
    {
        try {
            $status = $request->status;
            $search_txt = $request->search_txt;
            $paginate = $request->paginate ?? 20;
            $txt = '%' . $search_txt . '%';

            $messageList = $this->message
                ->where('status', $status)
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->whereTranslationLike('message', $txt);
                    });
                })->with('files')
                ->with(['user' => function ($q) {
                    $q->with('latestPhoto', 'designation');
                }])
                ->orderBy('serial', 'ASC')
                ->paginate($paginate);


            $messageList->transform(function ($value){

                return [
                    'id' => $value->id ?? null,
                    'picture' => $value->user->latestPhoto->path ?? $value->files[0]->path ?? null,
                    'full_name' => $value->user->full_name ??   $value->name ??  null,
                    'designation' => $value->user->designation->name ??  $value->designation ?? null,
                    'message' => $value->message  ?? null,
                    'message_from' => $value->message_from  ?? null,
                    'serial' => $value->serial  ?? null,
                ];

            });



            return response()->json($messageList, 200);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function getMessageDetails($id)
    {
//        return $id;
        try {
            $message = $this->message
                ->with('files')
                ->with(['user' => function ($q) {
                    $q->with('latestPhoto', 'designation');
                }])
                ->findOrFail($id);

            return response()->json($message, 200);

        } catch (Exception $ex) {
            return Response::json([$ex->getMessage()], 405);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Message $message, Request $request)
    {


        if ($request->from == 'employee') {

//            $this->validate($request, [
//                'message' => 'required',
//                'employee_id' => 'required',
//            ]);

            if (!$request->message || !$request->employee_id) {
                throw new Error('Please, fill the required field!');
            }

            $message->message_from = $request->from;
            $message->user_id = $request->employee_id;
            $message->message = $request->message;
            $message->created_by = request()->user()->id;
            $message->status = $request->status;
            $message->serial = $request->serial;
            $message->created_date = Carbon::today();
            $message->site_id = Auth::user()->site_id;
            $message->save();

        } else if ($request->from == 'management') {

            $this->validate($request, [
                'message' => 'required',
                'name' => 'required',
                'designation' => 'required',
            ]);

            $files = range(1, $request->length);
            $file_path = null;
            $user_id = Auth::user()->id;

            $message->message_from = $request->from;
            $message->message = $request->message;
            $message->name = $request->name;
            $message->designation = $request->designation;
            $message->created_by = request()->user()->id;
            $message->status = $request->status;
            $message->serial = $request->serial;
            $message->created_date = Carbon::today();
            $message->site_id = Auth::user()->site_id;
            $message->save();

            if ($request->length) {
                foreach ($files as $k => $val) {
                    $file = Input::file('files' . $k);
                    $file_name = $message->site_id . '/' . uniqid() . '.' . $file->getClientOriginalExtension();
                    Storage::disk('uploads')->put($file_name, File::get($file));
                    $file_path = '/uploads/files/' . $file_name;
                    $file = Input::file('files' . $k);
                    $file_type = $file->getClientMimeType();

                    if (in_array($file_type, ['image/png', 'image/gif', 'image/jpeg', 'image/png'])) {
                        Image::make($file->getRealPath())->resize(700, null, function ($constraint) {
                            $constraint->aspectRatio();
                        })->save('uploads/files/' . $file_name);

                    } else {
                        Storage::disk('uploads')->put($file_name, File::get($file));
                    }

                    $message->files()->create([
                        'user_id' => $user_id,
                        'path' => $file_path,
                        'name' => $file->getClientOriginalName(),
                    ]);
                }
            }


        }

        return response()->json(['message' => 'Successfully Saved!', 'mode' => 'save'], 200);

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
//        return $request;

        // try {
        \Log::info($request);
        if ($request->from == 'employee') {

            $this->validate($request, [
                'message' => 'required',
                'employee_id' => 'required'
            ]);

            $message = $this->message->findOrFail($request->id);

            $message->message_from = $request->from;
            $message->user_id = $request->employee_id;
            $message->message = $request->message;
            $message->created_by = request()->user()->id;
            $message->status = $request->status;
            $message->serial = $request->serial;
            $message->site_id = Auth::user()->site_id;
            $message->save();

        } else if ($request->from == 'management') {

            $this->validate($request, [
                'message' => 'required',
                'name' => 'required',
                'designation' => 'required',
            ]);

            $files = range(1, $request->length);
            $file_path = null;
            $deletes = $request->deletes ? explode(',', $request->deletes) : [];
            $user_id = Auth::user()->id;

            $message = $this->message->findOrFail($request->id);

            $message->message_from = $request->from;
            $message->user_id = $request->employee_id;
            $message->message = $request->message;
            $message->name = $request->name;
            $message->designation = $request->designation;
            $message->created_by = request()->user()->id;
            $message->status = $request->status;
            $message->serial = $request->serial;
            $message->site_id = Auth::user()->site_id;
            $message->save();

            if ($request->length) {
                foreach ($files as $k => $val) {

                    $file = Input::file('files' . $k);
                    $file_type = $file->getClientMimeType();

                    $file_name = $message->site_id . '/' . uniqid() . '.' . $file->getClientOriginalExtension();
                    $file_path = '/uploads/files/' . $file_name;

                    if (in_array($file_type, ['image/png', 'image/gif', 'image/jpeg', 'image/png'])) {
                        Image::make($file->getRealPath())->resize(700, null, function ($constraint) {
                            $constraint->aspectRatio();
                        })->save('uploads/files/' . $file_name);

                    } else {
                        Storage::disk('uploads')->put($file_name, File::get($file));
                    }

                    $this->deleteFiles($message);


                    $message->files()->create([
                        'user_id' => Auth::user()->id,
                        'path' => $file_path,
                        'name' => $file->getClientOriginalName(),
                    ]);
                }
            }

            if (count($deletes)) {

                foreach ($deletes as $k => $id) {
                    $the_photo = Photo::where('id', $id)->first();
                    if ($the_photo) {
                        $image_path = public_path($the_photo->path);
                        if (File::exists($image_path)) {
                            unlink($image_path);
                        }
                    }

                }
            }


        }


        return response()->json(['data' => $message, 'message' => 'Message Successfully Updated!', 'mode' => 'Update'], 200);
        /* } catch (ModelNotFoundException $exception) {
             throw new Error($exception->getMessage());

         } catch (Exception $exception) {
             throw new Error($exception->getMessage());
         }*/

    }

    public function delete($id)
    {
        try {

            $message = $this->message->findOrFail($id);
            $message->delete();
            $message->deleteTranslations();
            $this->deleteFiles($message);

            return Response::json(['message' => 'Successfully Deleted!'], 200);


        } catch (ModelNotFoundException $ex) {
            return Response::json(['message' => 'The Notice Not Found!'], 405);

        } catch (Exception $ex) {
            return Response::json(['message' => 'Something went Wrong!'], 405);
        }
    }

    private function deleteFiles($message)
    {


        foreach ($message->files as $k => $file) {
            $the_photo = Photo::where('id', $file->id)->first();
            $image_path = public_path($the_photo->path);
            if (File::exists($image_path)) {
                unlink($image_path);
            }
            $the_photo->delete();
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
