<?php

namespace App\Http\Controllers\Api\Site\Web\Setting\Video;

use App\Models\Site\Web\Video\Video;
use Auth;
use Error;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Storage;
use Session;

class VideoController extends Controller
{
    private $video;

    public function __construct(Video $video)
    {
//        $this->middleware('auth:api');
//        $this->middleware('api.access');
        $this->middleware('auth');
        $this->video = $video;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }


    public function getVideoListWithPagination(Request $request)
    {
//        return $request;
//        return (int)session()->get('SITE_ID');


        try {
            $status = $request->status;
            $search_txt = $request->search_txt;
            $paginate = $request->paginate ?? 20;
            $txt = '%' . $search_txt . '%';


            $videoList = $this->video
                ->where('status', $status)
                ->when($search_txt, function ($q) use ($search_txt) {
                    $q->where('title', $search_txt)
                        ->orWhere('description', $search_txt);
                })
                ->orderBy('id', 'DESC')
                ->paginate($paginate);

            return $videoList;
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function getVideoDetails($id)
    {
        try {
            $video = $this->video->findOrFail($id);

            return response()->json($video, 200);

        } catch (Exception $ex) {
            return Response::json([$ex->getMessage()], 405);
        }

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Video $video, Request $request)
    {
//        return $request;


        $this->validate($request, [
            'date' => 'required',
            'video_link' => 'required',
            'title' => 'required',
        ]);


        $user_id = Auth::user()->id;

        $abc = explode('/', $request->video_link);
        $last = end($abc);
        $again = explode('?', $last);
        if ($again) {
            $mid_last = end($again);
            $last_last = explode('v=', $mid_last);
            $final_link_last = end($last_last);

        } else {
            $final_link_last = $last;
        }
        $final_link = 'https://www.youtube.com/embed/' . $final_link_last;

        $video->title = $request->title;
        $video->video_link = $final_link;
        $video->description = $request->description;
        $video->date = $request->date;
        $video->created_by = $user_id;
        $video->status = $request->status;
        $video->home_page_show_status = $request->home_page_show_status == "true" ? 1 : 0;
        $video->home_page_show_main_status = $request->home_page_show_main_status == "true" ? 1 : 0;
        $video->serial = $request->serial;
        $video->save();

        return response()->json(['message' => 'Successfully Saved!', 'mode' => 'save'], 200);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }


    public function update(Request $request)
    {
//        return $request;

//        \Log::info($request);

        // try {
        $this->validate($request, [
            'date' => 'required',
            'video_link' => 'required',
            'title' => 'required',
        ]);



        $user_id = Auth::user()->id;

        $abc = explode('/', $request->video_link);
        $last = end($abc);
        $again = explode('?', $last);
        if ($again) {
            $mid_last = end($again);
            $last_last = explode('v=', $mid_last);
            $final_link_last = end($last_last);

        } else {
            $final_link_last = $last;
        }
        $final_link = 'https://www.youtube.com/embed/' . $final_link_last;

        $about = $this->video->findOrFail($request->id);

        foreach ($about->ownFields as $k => $ownField) {
            if ($request->{$ownField}) {
                $about->{$ownField} = $request->{$ownField};
            }
        }
        $about->status = $request->status;
        $about->video_link = $final_link;
        $about->home_page_show_status = $request->home_page_show_status == "true" ? 1 : 0;
        $about->home_page_show_main_status = $request->home_page_show_main_status == "true" ? 1 : 0;
        $about->serial = $request->serial;
        $about->created_by = $user_id;
        $about->save();

        return response()->json(['message' => ' Successfully Updated!'], 200);

    }

    public function delete($id)
    {
        try {

            $about = $this->video->findOrFail($id);
            $about->delete();

            return Response::json(['message' => 'Successfully Deleted!'], 200);


        } catch (ModelNotFoundException $ex) {
            return Response::json(['message' => 'The Notice Not Found!'], 405);

        } catch (Exception $ex) {
            return Response::json(['message' => 'Something went Wrong!'], 405);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}