<?php

namespace App\Http\Controllers\Api\StudentPanel;

use App\Http\Controllers\Api\ApiProjectController;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicCalendarHead;
use App\Models\Edu\GlobalAcademicCalendar\GlobalAcademicCalendarEvent;
use App\Models\Edu\HelpDesk\EduSiteHelpDeskMenu;
use App\Models\Edu\HelpDesk\EduSiteHelpDeskSetting;
use App\Models\Edu\HelpDesk\EduSiteHelpDeskSettingDetail;
use App\Models\Site\Quiz\Question\SiteQuizQuestionForStudent;
use App\Models\Site\Quiz\Question\StudentQuizAnswerDetails;
use App\Models\Site\Quiz\QuizDeclareSettings;
use App\Models\Site\Quiz\QuizDeclareStudents;
use App\Models\Student\StudentHistory;
use App\Models\Site\Quiz\QuizDeclares;
use App\Models\Site\Role\SiteRole;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Traits\PaginationTrait;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Session;
use Response;
use DB;


class StudentQuizController extends ApiProjectController
{
    use PaginationTrait;
    private $studentHistory;
    public function __construct(GlobalStudentHistory $studentHistory)
    {
        $this->middleware('auth:apps-api');
        $this->middleware('api.app.access');

        $this->studentHistory = $studentHistory;
    }

    

    public function getActiveQuizListForStudent()
    {

        try{

        $current_date = Carbon::now()->format('Y-m-d');
        $current_time = Carbon::now()->format('H:i:s');
        $current_date_time = Carbon::now()->format('Y-m-d H:i:s');


        $student_history_id = $this->studentHistory->where('user_id', Auth::user()->id)->orderBy('id','DESC')->first()->id;

        $present_active_quiz = QuizDeclareStudents::with(['quizDeclare'=>function($q) use ($current_date,$current_time,$current_date_time){
                $q->with(['quizDeclareSettings'=>function($qq) use ($current_date,$current_time,$current_date_time){
                 $qq
                 ->where('end_date_time', '>=', $current_date_time)
                    ->select('id', 'duration','start_date','start_time','end_time','start_date_time','end_date_time','is_cancel','is_end','is_start',
                    'question_per_student','quiz_declare_id','result_show_to_student_panel_status');

                },'quiz'=>function($qqq){
                    $qqq->select('id','quiz_key','quiz_name','status');
                }])->select('id','quiz_id','declare_key');
                    
                }])
                ->whereHas('quizDeclare', function($qu) use ($current_date_time) {
                $qu->whereHas('quizDeclareSettings', function($q) use ($current_date_time){
                        $q->where('end_date_time', '>=', $current_date_time);
                    });
                })
                ->where('student_history_id',$student_history_id)
               // ->where('join_status',0)
                ->where('end_status',0)
             
                ->get()
                ->sortBy('quizDeclare.quizDeclareSettings.start_date_time')
                ->first();

                if(!$present_active_quiz){
                    return response()->json(['present_active_quiz'=>null]);
                }


              if($present_active_quiz){
                
                $quiz_second = $present_active_quiz->quizDeclare->quizDeclareSettings->quiz_time_by_second;
                $start_date_time = $present_active_quiz->quizDeclare->quizDeclareSettings->start_date_time;
                $end_date_time = $present_active_quiz->quizDeclare->quizDeclareSettings->end_date_time;
               
                // if($quiz_second!==null){
                //     $quiz_end_current_time = Carbon::parse($start_date_time)->AddSeconds(522525252525)->format('Y-m-d H:i:s');
                //     $end_date_time_with_extra_minutes=$quiz_end_current_time;
                  

                // }else{
                    $end_date_time_with_extra_minutes = Carbon::parse($end_date_time)->addMinutes(1)->format('Y-m-d H:i:s');
                   
               // }
              
              //  if($end_date_time>=$current_date_time){
              
                if($present_active_quiz->quizDeclare->quizDeclareSettings->result_show_to_student_panel_status){

                    $quiz_data=[
                        'student_history_id'=>$present_active_quiz->student_history_id,
                        'quiz_declare_id'=>$present_active_quiz->quiz_declare_id,
                        'join_status'=>$present_active_quiz->join_status,
                        'end_status'=>$present_active_quiz->end_status,
                        'total_question'=>$present_active_quiz->total_question,
                        'quiz_declare'=>$present_active_quiz->quizDeclare,
                        'current_date_time'=>$current_date_time,

                        'total_answer'=>$present_active_quiz->total_answer,
                        'total_right_answer'=>$present_active_quiz->total_right_answer,
                        'total_wrong_answer'=>$present_active_quiz->total_wrong_answer,
                        'quiz_time'=>$present_active_quiz->quiz_time,
                        'mark'=>$present_active_quiz->mark,
                        'rank'=>$present_active_quiz->rank,
                    ];
                }else{
                    $quiz_data=[
                        'student_history_id'=>$present_active_quiz->student_history_id,
                        'quiz_declare_id'=>$present_active_quiz->quiz_declare_id,
                        'join_status'=>$present_active_quiz->join_status,
                        'end_status'=>$present_active_quiz->end_status,
                        'total_question'=>$present_active_quiz->total_question,
                        'quiz_declare'=>$present_active_quiz->quizDeclare,
                        'current_date_time'=>$current_date_time,

                        'total_answer'=>"",
                        'total_right_answer'=>"",
                        'total_wrong_answer'=>"",
                        'quiz_time'=>"",
                        'mark'=>"",
                        'rank'=>"",
                    ];
                }

                $data=[
                    'present_active_quiz'=>$quiz_data,
                    'mode'=>'success',
                    'status'=>'200',
                ];
        
                return response()->json($data,200);
            // }

            }

        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
      
    }

    private function asortArray($arr){
        sort($arr);
        $arrlength = count($arr);
        $data=[];
        for($x = 0; $x < $arrlength; $x++) {
            $data[]=$arr[$x];
           }
        return $data;
    }

    public function getActiveQuizListForStudent2()
    {

        try {
            $student_history_id = $this->studentHistory->where('user_id', Auth::user()->id)->orderBy('id','DESC')->first()->id;
      
            $student_declare_quiz_ids = QuizDeclareStudents::where('student_history_id',$student_history_id)->pluck('quiz_declare_id');
            $current_date = Carbon::now()->format('Y-m-d');
    
          
            $student_declared_quiz = QuizDeclareSettings::with(['quizDeclare'=>function($query){
                $query->with('quiz');
            }])
                ->whereIn('quiz_declare_id', $student_declare_quiz_ids)
                ->where('start_date', '>=', $current_date)
                ->get();
         
          //  return response()->json(['quizList'=>$student_declared_quiz]);
            $data=[
                'quiz_list'=>$student_declared_quiz,
                'mode'=>'success',
                'status'=>'200',
            ];
    
            return response()->json($data,200);

        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
      
      
      
    }

    public function quizStartByStudnet(Request $request){

        try{
      //  dd('sf');
        $validation = $this->quizValidation($request);

        if($validation){
            return $validation;
        }
   
        $student_history_id = $this->studentHistory->where('user_id', Auth::user()->id)->orderBy('id','DESC')->first()->id;
      
        $student_quiz_update = QuizDeclareStudents::where('student_history_id',$student_history_id)
                                ->where('quiz_declare_id',$request->quiz_declare_id)
                                ->update(['Join_status'=>1]);

                    
            if($student_quiz_update){
                return response()->json(['message'=>'Quiz Start Succefully', 'mode'=>'success', 'status'=>'200'],200);
            }

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
          
    }

    
    private function quizValidation($request){
        $quiz_declares = QuizDeclareSettings::where('quiz_declare_id', $request->quiz_declare_id)->first();

      //  dd($request->quiz_declare_id);
        $quiz_date= Carbon::parse($quiz_declares->start_date)->format('Y-m-d');
        $quizDateTime = Carbon::createFromFormat('Y-m-d H:i:s', "$quiz_date $quiz_declares->start_time");

        $today=Carbon::now();
        $onlyCurrentTodate=$today->format('Y-m-d');

        $onlyCurrentTime=$today->toTimeString();

       // dd($quiz_declares->end_time);

        if($onlyCurrentTodate==$quiz_date){
            if($onlyCurrentTime<$quiz_declares->start_time){
                $minutes = $today->diffInSeconds($quizDateTime)/60;
                if($minutes>21){
                    $left_time=$minutes-20;
                    return Response::json(['message' => 'You can apply after'. ' '.ceil($left_time).' minutes.', 'mode' => 'error'], 412);
                }
            }
            // else if($onlyCurrentTime>$quiz_declares->end_time){
            //     return Response::json(['message' => 'Your Apply Time is Over', 'mode' => 'error'], 412);
            // }
        }
        else{
            return Response::json(['message' => 'Please select today\'s Quiz.' , 'mode' => 'error'], 412);
        }


    }


    
    public function getQuizQuestionListForStudent(Request $request){
    
        
        try {
            if(!$request->quiz_declare_id){
                return response()->json(['message'=>'Paramitter Missing', 'status'=>'422', 'mode'=>'errors', 422]); 
            }

        $this->authInfoSessionPut();

           // dd('dff');
        $student_history_id = $this->studentHistory->where('user_id', Auth::user()->id)->orderBy('id','DESC')->first()->id;
        $quiz_declare_id = (int) $request->quiz_declare_id;
      
        $student_quiz = QuizDeclareStudents::with(['quizDeclare'=>function($qqqqr){
            $qqqqr->with('quizDeclareSettings','quiz');
              
        }])->where('student_history_id',$student_history_id)
        ->where('quiz_declare_id',$quiz_declare_id)
      
        ->where('join_status',1)
        ->where('end_status',0)
        ->first();
       
            if($student_quiz){
            $duration=$student_quiz->quizDeclare->quizDeclareSettings->duration;
            $quiz_start_status = $student_quiz->quizDeclare->quizDeclareSettings->is_start;
            $quiz_end_status = $student_quiz->quizDeclare->quizDeclareSettings->is_end;
            $que_per_student = $student_quiz->quizDeclare->quizDeclareSettings->question_per_student;


            $start_date_time=$student_quiz->quizDeclare->quizDeclareSettings->start_date_time;
            $end_date_time=$student_quiz->quizDeclare->quizDeclareSettings->end_date_time;
            $quiz_start_data=$student_quiz->quizDeclare->quizDeclareSettings->start_date;
            $quiz_start_time=$student_quiz->quizDeclare->quizDeclareSettings->start_time;
            $quiz_end_time=$student_quiz->quizDeclare->quizDeclareSettings->end_time;

            $quiz_date = Carbon::parse($quiz_start_data)->format('Y-m-d');
            $quiz_start_date_time = Carbon::parse($quiz_start_data.' '.$quiz_start_time)->format('Y-m-d H:i:s');
        
            $quiz_end_date_time1 = Carbon::parse($quiz_start_data.' '.$quiz_end_time)->format('Y-m-d H:i:s');
            $quiz_end_date_time2 = Carbon::parse($start_date_time)->addMinutes($duration)->format('Y-m-d H:i:s');
        
            $today = Carbon::now();
            $now = Carbon::now()->format('Y-m-d H:i:s');
            // $examDateTimeStart = Carbon::createFromFormat('Y-m-d H:i:s', $quiz_start_data.' '.$quiz_start_time);
            // $examDateTimeEnd = Carbon::createFromFormat('Y-m-d H:i:s', $quiz_start_data.' '.$quiz_end_time);
    
            $onlyCurrentTodate = $today->format('Y-m-d');
        //  $onlyCurrentTime = $today->toTimeString();
        
            $startTimeInteger = strtotime($quiz_start_date_time);
            $endTimeInteger = strtotime($quiz_end_date_time2);
            $prsentTimeInteger = strtotime($now);
        // $dateobj = new DateTime();
            
        // dd($quiz_end_date_time1);
        if($onlyCurrentTodate==$quiz_date) {
            if($startTimeInteger <= $prsentTimeInteger && $endTimeInteger >= $prsentTimeInteger && $quiz_start_status){
                $quiz_details= [
                    'student_quiz_declare_id'=>$student_quiz->id,
                    'quiz_declare_id'=>$student_quiz->quizDeclare->id,
                    'student_history_id'=>$student_history_id,
                    'quiz_name'=>$student_quiz->quizDeclare->quiz->quiz_name,
                    'start_date'=>$quiz_start_data,
                    'start_time'=>$quiz_start_time,
                    'end_time'=>$quiz_end_time,
                    'duration'=>$duration,
                    'question_per_student'=>$que_per_student,
                    'is_start'=>$quiz_start_status,
                    'is_end'=>$quiz_end_status,
                    'end_status'=>$student_quiz->end_status,
                ];

                $backup_second = 30;


                $all_question_ids = $student_quiz->quizDeclare->question_ids[1];
                $question_ids = collect($all_question_ids);

                $quiz_questions = SiteQuizQuestionForStudent::with(['siteQuizQuestionDetailsForStudent'=>function($query){
                                        $query->inRandomOrder();
                                    }])
                                    ->withCount('answer')
                                    ->whereIn('id', $question_ids)
                                    ->where('module_key','quiz')
                                    ->inRandomOrder()
                                    ->limit($que_per_student)
                                    ->get();
             //   $quiz_questions[] = $quiz_questions->push([ 'student_answer_ids' => []]);

                $studentAnswerList = StudentQuizAnswerDetails::where('declare_student_id',$student_quiz->id)
                            ->where('quiz_declare_id', $quiz_declare_id)
                            ->select('quiz_declare_id','declare_student_id','question_id','answer_ids')
                            ->get();

                $question_array=[];
                $question_arr=Array();
                foreach($quiz_questions as $key=>$question){
                    
                        $answer_item = $studentAnswerList->where('question_id',$question->id)->first();

                        $answer_array=$answer_item?$answer_item->answer_ids:[];
                        if($answer_array){
                            $question_arr['student_answer_ids']=explode(",", $answer_array);
                        }else{
                            $question_arr['student_answer_ids']=[];
                        }
                     
                        $question_array[$key]=array_merge($question_arr, $question->toArray());
                    }

                    $data=[
                        'QuestionList' => $question_array,
                        'QuizDetails' => $quiz_details,
                      //  'student_answer_list' => $student_answer_list,
                        'backup_second' => $backup_second,
                        'mode'=>'success',
                        'status'=>'200',
                    ];
                            
                return response()->json($data,200);

                }else{
                    return Response::json(['message' => 'Not Time Yet.!',
                                'mode' => 'error!'], 412);
                }
            }else{
                return Response::json(['message' => 'Unexpected Entry. This is not your Exam Date.!',
                        'mode' => 'error!'], 412);
            }
        }


        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
  
    }


    public function studentQuizAnswerSilentSubmit(Request $requests, $end_status=0){
        
        $data = $requests->all();

    

        $student_quiz_declare_id = $data['QuizDetails']['student_quiz_declare_id'];
        $quiz_declare_id = $data['QuizDetails']['quiz_declare_id'];
        $total_question = $data['QuizDetails']['question_per_student'];
        $quiz_start_data = $data['QuizDetails']['start_date'];
        $quiz_start_data = $data['QuizDetails']['start_date'];
        $quiz_end_time = $data['QuizDetails']['end_time'];
        $quiz_duration = ($data['QuizDetails']['duration']*60)-($data['time_left']);
       // dd($quiz_end_time);
        $backup_second = $data['backup_second'];

        $hours = floor($quiz_duration / 3600);
        $minutes = floor(($quiz_duration / 60) % 60);
        $seconds = $quiz_duration % 60;

        $quiz_time = ($hours.':'.$minutes.':'.$seconds);
      
      //  add extra second add;
      $quiz_end_date_time_with_extra = Carbon::parse($quiz_start_data.' '.$quiz_end_time)->addSeconds($backup_second)->format('Y-m-d H:i:s');
      $now = Carbon::now()->format('Y-m-d H:i:s');
      if($quiz_end_date_time_with_extra>=$now){

        
        $student_quiz = QuizDeclareStudents::where('id',$student_quiz_declare_id)
            ->where('quiz_declare_id', $quiz_declare_id)
            ->where('end_status', 0)
            ->withCount('answerDetails')
            ->withCount('correctAnswerDetails')
            ->withCount('incorrectAnswerDetails')
            ->first();
        if(!$student_quiz){
            return response()->json(['message'=>'You have already submitted the quiz.', 'status'=>'422', 'mode'=>'errors', 422]); 
        }

        foreach ($requests->QuestionList as $re_key => $re_question) {
           // dd($re_question['student_answer_ids']);
            if($re_question['student_answer_ids']){

            $quiz_question = SiteQuizQuestionForStudent::with(['siteQuizQuestionDetails'])
                            ->withCount('answer')
                            ->where('id', $re_question['id'])
                            ->where('module_key','quiz')
                            ->where('module_key','quiz')
                            ->first();
                          
                  
                         $answer_ids=[];
                        foreach($quiz_question->siteQuizQuestionDetails as $key2 => $que_details){
                            if($que_details->answer_status){
                                $answer_ids[]=$que_details->id;
                            }
                         
                        }

                    //    $que_answer_ids = $answer_ids;
                        $req_answer_ids =  (array) $re_question['student_answer_ids'];
                       
                        $question_ans_ids = $this->asortArray($answer_ids);
                        $request_ans_ids = $this->asortArray($req_answer_ids);
                      
                       
                        if($question_ans_ids==$request_ans_ids){
                            $req_answer_status=1;
                            $question_mark = $quiz_question->mark;
                        }else{
                            $req_answer_status=0;
                            $question_mark = 0;
                        }

                $checkAnswer = StudentQuizAnswerDetails::where('declare_student_id',$student_quiz_declare_id)
                                    ->where('quiz_declare_id', $quiz_declare_id)
                                    ->where('question_id', $re_question['id'])
                                    ->first();
               // dd($checkAnswer);
                $answer_ids = implode(',',$req_answer_ids);

                 if($checkAnswer){
                  
                    StudentQuizAnswerDetails::where('id',$checkAnswer->id)->update([
                        'answer_ids'=>$answer_ids,
                        'right_answer_status'=>$req_answer_status,
                        'mark'=>$question_mark,
                    ]);

                 }else{
                  
                    StudentQuizAnswerDetails::insert([
                        'quiz_declare_id'=>$quiz_declare_id,
                        'declare_student_id'=>$student_quiz_declare_id,
                        'question_id'=>$re_question['id'],
                        'answer_ids'=>$answer_ids,
                        'right_answer_status'=>$req_answer_status,
                        'mark'=>$question_mark,
                    ]);
                 }

                }
            }

            $student_total_mark = StudentQuizAnswerDetails::where('declare_student_id',$student_quiz_declare_id)
                ->where('quiz_declare_id', $quiz_declare_id)
                ->sum('mark');


            if($student_quiz){

                $right_ans_percentage=($student_quiz->correct_answer_details_count/$total_question)*100;
              
                $student_quiz->total_question    =   $total_question;
                $student_quiz->total_answer      =   $student_quiz->answer_details_count;
                $student_quiz->total_right_answer=   $student_quiz->correct_answer_details_count;
                $student_quiz->total_wrong_answer=   $student_quiz->incorrect_answer_details_count;
                $student_quiz->mark              =   $student_total_mark;
                $student_quiz->end_status        =   $end_status;
                $student_quiz->quiz_time         =   $quiz_time;
                $student_quiz->quiz_time_by_second = $quiz_duration;
                $student_quiz->right_ans_percentage = $right_ans_percentage;
                $student_quiz->save();
            }
             return response()->json(['message'=>'save','mode'=>'success','status'=>'200'], 200);
      }
    }


    
    public function studentQuizAnswerSubmit(Request $requests){
        // dd('dfsf');
      
            try{
             $end_status=1;
             $this->studentQuizAnswerSilentSubmit($requests,$end_status);
             return response()->json(['message'=>'save','mode'=>'success','status'=>'200'], 200);
           
 
            } catch (ValidationException $exception) {
                DB::rollBack();
                return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
            }catch (ModelNotFoundException $exception) {
                DB::rollBack();
                return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
            } catch (Exception $exception) {
                DB::rollBack();
                return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
            }
 
 
     }

     public function getActiveQuizRoutineList(Request $request){

        try{

        if(!$request->paginate){
            return response()->json(['message'=>'Paramitter Missing', 'status'=>'422', 'mode'=>'errors', 422]); 
        }
    
        $this->authInfoSessionPut();
        

        $current_date = Carbon::now()->format('Y-m-d');
        $current_time = Carbon::now()->format('H:i:s');
       
                    
        $student_history_id = $this->studentHistory->where('user_id', Auth::user()->id)->orderBy('id','DESC')->first()->id;

        $student_quiz_list = QuizDeclareStudents::with(['quizDeclare'=>function($q){
                                 $q->with(['quizDeclareSettings'=>function($qq){
                                    $qq->select('id', 'duration','start_date','start_time','start_date_time','end_date_time','is_cancel','is_end','is_start',
                                    'question_per_student','quiz_declare_id','result_show_to_student_panel_status');
                                 },'quiz'=>function($qqq){
                                    $qqq->select('id','quiz_key','quiz_name','status');
                                }])->select('id','quiz_id','declare_key');
                            }])
                            ->whereHas('quizDeclare', function($qu) use ($current_date, $current_time) {
                            $qu->whereHas('quizDeclareSettings', function($q) use ($current_date, $current_time){
                                    $q->where('end_date_time', '>=', $current_date.' '.$current_time);
                                });
                            })
                            ->where('student_history_id',$student_history_id)
                            //->where('join_status',0)
                            ->where('end_status',0)
                            ->select('id','quiz_declare_id','student_history_id','join_status')
                            ->paginate(10);

                            $data=[
                                'quiz_routine_list' => $student_quiz_list,
                                'mode'=>'success',
                                'status'=>'200',
                            ];
                                    
                        return response()->json($data,200);
        
      
        
        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    }


     public function getPreviewsQuizReportListForStudent(Request $request){

        try{

        if(!$request->paginate){
            return response()->json(['message'=>'Paramitter Missing', 'status'=>'422', 'mode'=>'errors', 422]); 
        }

        $this->authInfoSessionPut();


        $current_date = Carbon::now()->format('Y-m-d');
        $current_time = Carbon::now()->format('H:i:s');
       
                    
        $student_history_id = $this->studentHistory->where('user_id', Auth::user()->id)->orderBy('id','DESC')->first()->id;
            
        $student_pre_quiz_list = QuizDeclareStudents::with(['quizDeclare'=>function($q)  use ($current_date,$current_time){
                    $q->with(['quizDeclareSettings'=>function($qq) use ($current_date,$current_time){
                        $qq->where('end_date_time', '<=', $current_date.' '.$current_time)
                        ->select('id', 'duration','start_date_time','end_date_time','is_cancel','is_end','is_start',
                    'question_per_student','quiz_declare_id','result_show_to_student_panel_status');

                    },'quiz'=>function($qqq){
                        $qqq->select('id','quiz_key','quiz_name','status');
                    }])->select('id','quiz_id','declare_key');
                }])
                ->whereHas('quizDeclare', function($qu) use ($current_date, $current_time) {
                $qu->whereHas('quizDeclareSettings', function($q) use ($current_date, $current_time){
                        $q->where('end_date_time', '<=', $current_date.' '.$current_time);
                    });
                })
            
                ->where('student_history_id',$student_history_id)
              //  ->where('join_status',1)
               // ->where('end_status',1)
                ->get();

                $data=[];
                foreach($student_pre_quiz_list as $key=>$item){
                    $data[$key]['student_history_id']=$item->student_history_id;
                    $data[$key]['quiz_declare_id']=$item->quiz_declare_id;
                    $data[$key]['join_status']=$item->join_status;
                    $data[$key]['end_status']=$item->end_status;
                    $data[$key]['total_question']=$item->total_question;

                    $data[$key]['quiz_declare']=$item->quizDeclare;

                    if($item->quizDeclare->quizDeclareSettings->result_show_to_student_panel_status){
                    
                        $data[$key]['total_answer']=$item->total_answer;
                        $data[$key]['total_right_answer']=$item->total_right_answer;
                        $data[$key]['total_wrong_answer']=$item->total_wrong_answer;
                        $data[$key]['quiz_time']=$item->quiz_time;
                        $data[$key]['mark']=$item->mark;
                        $data[$key]['right_ans_percentage']=$item->right_ans_percentage;
                        $data[$key]['rank']=$item->rank;
                    }else{
                        $data[$key]['total_answer']="";
                        $data[$key]['total_right_answer']="";
                        $data[$key]['total_wrong_answer']="";
                        $data[$key]['quiz_time']="";
                        $data[$key]['mark']="";
                        $data[$key]['right_ans_percentage']="";
                        $data[$key]['rank']="";
                    }
                }
               
                $quiz_list = $this->paginate($data,$request->paginate);

                $quiz_list->withPath(\Request::url());
              
                $data=[
                    'quiz_list' => $quiz_list,
                    'mode'=>'success',
                    'status'=>'200',
                ];
                        
            return response()->json($data,200);
    
        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }

    }



   
}
