<?php

namespace App\Http\Controllers\Api\Web;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicGroup;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicVersion;
use App\Models\Academic\GroupBaseDetail;
use App\Models\Academic\SubjectCondition;
use App\Models\AcademicYear\AcademicYear;
use App\Models\ClassGroup\ClassGroup;
use App\Models\Country\Country;
use App\Models\Designation\Designation;
use App\Models\District\District;
use App\Models\Division\Division;
use App\Models\Gender\Gender;
use App\Models\Religion\Religion;
use App\Models\Thana\Thana;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class AcademicApiController extends Controller
{

    public function __construct()
    {
        // $this->middleware('guest:api');
        $this->middleware('api.access');
    }



    public function getAcademicList()
    {
//        return [$site_group_id,$academic_group_id,$site_info_id_for_edit];

        try {

            $CountryList = Country::select('id')->where('status', 1)->get();

            $academicGroup = AcademicGroup::select('id', 'academic_group_name')->get();
            $genderList = Gender::select('id')->get();
            $ShiftList = AcademicShift::select('id')->get();
            $academicSubject = AcademicSubject::select('id')->get();
            $academicVersionList = AcademicVersion::select('id', 'version_name')->get();

            $academicSessionList = AcademicSession::select('id', 'session_name')->get();

            $academicStudentCategoryList = AcademicStudentCategory::select('id', 'category_name')->get();


            $academicYearList = AcademicYear::get();


            $religionList = Religion::get();

            return response()->json(
                [
                    'country'=>$CountryList,
                    'gender' => $genderList,
                    'student_category' => $academicStudentCategoryList,
                    'shift' => $ShiftList,
                    'subject' => $academicSubject,
                    'version' => $academicVersionList,
                    'session' => $academicSessionList,
                    'year' => $academicYearList,
                    'religion' => $religionList,
                    'acc_group' => $academicGroup
                ]);


        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function getDivisionListByCountryID($country_id)
    {
        $division_list =  Division::where('country_id', $country_id)->get();
        return $division_list;

    }
    public function getDistrictListByDivisionID($division_id)
    {
        $district_list =  District::where('division_id', $division_id)->get();
        return $district_list;

    }
    public function getTanaListByDistrictID($district_id)
    {
        $thana_list =  Thana::where('district_id', $district_id)->get();
        return $thana_list;

    }


    public function getAcademicDataByGroup($academic_group_id)//rejected
    {

     //   try {


            $classes = AcademicClass::whereStatus(1)->get(); //DB::select('SELECT id, class_name, academic_group_present FROM academic_classes WHERE STATUS=1');
            $sections = AcademicSection::all();// DB::select('SELECT id, section_name FROM academic_sections');
            $groups = AcademicClassGroup::all();// DB::select('SELECT id, group_name FROM academic_class_groups');
            $subjectCondition = SubjectCondition::all();// DB::select('SELECT id, name, status FROM academic_subject_conditions');
            $groupBasedDetail = GroupBaseDetail::whereAcademicGroupId($academic_group_id)->first() ?? null;
            $academicSession = AcademicSession::all();
            $subjectList = AcademicSubject::all();
            $departmentList = AcademicDepartment::all();
            $designationList = Designation::all();


            $details_array = null;

            $details_array['academic_class_ids'] = $groupBasedDetail->academic_class_ids ? explode(',', $groupBasedDetail->academic_class_ids) : [];
            $details_array['academic_class_group_ids'] = $groupBasedDetail->academic_class_group_ids ? explode(',', $groupBasedDetail->academic_class_group_ids) : [];
            $details_array['academic_section_ids'] = $groupBasedDetail->academic_section_ids ? explode(',', $groupBasedDetail->academic_section_ids) : [];
            $details_array['academic_subject_ids'] = $groupBasedDetail->academic_subject_ids ? explode(',', $groupBasedDetail->academic_subject_ids) : [];
            $details_array['academic_subject_condition_ids'] = $groupBasedDetail->academic_subject_condition_ids ? explode(',', $groupBasedDetail->academic_subject_condition_ids) : null;
            $details_array['academic_session_ids'] = $groupBasedDetail->academic_session_ids ? explode(',', $groupBasedDetail->academic_session_ids) : [];
            $details_array['academic_department_ids'] = $groupBasedDetail->academic_department_ids ? explode(',', $groupBasedDetail->academic_department_ids) : [];
            $details_array['designation_ids'] = $groupBasedDetail->designation_ids ? explode(',', $groupBasedDetail->designation_ids) : [];


            $academicClassList = AcademicClass::whereIn('id', $details_array['academic_class_ids'])->select('id', 'class_name')->get();
            $academicDepartmentList = AcademicDepartment::whereIn('id', $details_array['academic_department_ids'])->select('id', 'name')->get();
            $academicClassGroupList = ClassGroup::whereIn('id', $details_array['academic_class_group_ids'])->select('id', 'group_name')->get();
            $academicSectionList = AcademicSection::whereIn('id', $details_array['academic_section_ids'])->select('id', 'section_name')->get();
            $designationList = Designation::whereIn('id', $details_array['designation_ids'])->select('id', 'name')->get();



            $genderList = Gender::select('id')->get();
            $ShiftList = AcademicShift::select('id')->get();
            $academicVersionList = AcademicVersion::select('id', 'version_name')->get();

            return response()->json(
                [
                    'class' => $academicClassList,
                    'class_group' => $academicClassGroupList,
                    'section' => $academicSectionList,
                    'gender' => $genderList,
                    'shift' => $ShiftList,
                    'version' => $academicVersionList,
                    'department' => $academicDepartmentList,
                    'designation' => $designationList,
                ]);

      /*  } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }*/


    }

 


}
