<?php

namespace App\Http\Controllers\Assessment\Setting;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicClassWiseSubject;
use App\Models\Academic\AcademicSubject;
use App\Models\Assessment\AssessmentExpertise;
use App\Models\Assessment\AssessmentExpertiseWiseTopic;
use App\Models\Assessment\AssessmentType;
use App\Models\Assessment\AssessmentTypeNo;

class AcademicAssessmentTopicController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
      //  $this->middleware('eduworlduserchecker');
    }

    public function index()
    {
        $viewType = 'Assessment Expertise List';
       
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function classWiseExpertiseSubject(Request $request){

        $data=$request->all();
        $assessmentExpertise=AssessmentExpertise::with('assessmentType')
            // ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
            //     return $query->where('academic_class_id', $data['academic_class_id']);
            // })
            ->when(!empty($data['assessment_type_id']), function ($query) use ($data) {
                return $query->where('assessment_type_id', $data['assessment_type_id']);
            })
            // ->when(!empty($data['academic_subject_id']), function ($query) use ($data) {
            //     return $query->where('academic_subject_id', $data['academic_subject_id']);
            // })
            ->get();

    //    $academic_subject_ids= $assessmentExpertise->pluck('academic_subject_id')
    //         ->unique()
    //         ->filter();

       $academic_type_ids= $assessmentExpertise->pluck('assessment_type_id')
            ->unique()
            ->filter();

            $subject_id_array=[
                '0'=>1,
                '1'=>2,
                '2'=>3,
                '3'=>8,
                '4'=>9,
                '5'=>10,
                '6'=>11,
                '7'=>48,
                '8'=>282,
                '9'=>278,
                '10'=>279,
                '11'=>280,
                '12'=>281,
            ];
            $academic_subject_ids = AcademicClassWiseSubject::when(!empty($request->academic_class_id), function($q) use ($request){
                return $q->where('academic_class_id',$request->academic_class_id);
            })
            ->pluck('academic_subject_id')
            ->filter()
            ->unique();


        $academic_subject_list = AcademicSubject::with('classes')
            ->whereIn('id',$subject_id_array)
            ->whereIn('id',$academic_subject_ids)
            ->get();;

    

       // $academic_subject_list=AcademicSubject::whereIn('id',$subject_id_array)->get();
        $academic_type_list=AssessmentType::whereIn('id',$academic_type_ids)->get();

        return [$academic_subject_list, $academic_type_list, $assessmentExpertise];

    }



    public function createExpertiseWiseTopic(Request $request)
    {
    
        $request->validate([
           // 'academic_class_id'=> 'required',
          //  'academic_subject_id'=> 'required',
            'assessment_type_id'=> 'required',
            'expertise_id'=> 'required',
            'topic_name'=> 'required',
            'topic_no'=> 'required',
        ]);

        if($request->assessment_type_id==1){
            $request->validate([
                 'academic_class_id'=> 'required',
                 'academic_subject_id'=> 'required',
             ]);
        }

        $existTopic=AssessmentExpertiseWiseTopic::where('expertise_id',$request->expertise_id)
            ->where('topic_no',$request->topic_no)
            ->whereNotIn('academic_subject_id',[8,9,10,11])
            ->first();

        if($existTopic){
            return response()->json(['message'=>'This type no already added'],422);
        }

        $expertiseWiseTopic = new AssessmentExpertiseWiseTopic();
        if($request->assessment_type_id==1){
            $expertiseWiseTopic->academic_class_id     = $request->academic_class_id;
            $expertiseWiseTopic->academic_subject_id     = $request->academic_subject_id;
        }
       
        $expertiseWiseTopic->assessment_type_id     = $request->assessment_type_id;
        $expertiseWiseTopic->expertise_id     = $request->expertise_id;
        $expertiseWiseTopic->topic_name     = $request->topic_name;
        $expertiseWiseTopic->topic_no     = $request->topic_no;
        $expertiseWiseTopic->serial     = $request->serial;
        $expertiseWiseTopic->description      = $request->description;
        $expertiseWiseTopic->status      = $request->status;
        $expertiseWiseTopic->save();
        return response()->json(['message'=>'Created Successfully!'],200);
    }

    public function expertiseWiseTopicList (Request $request){

        $data=$request->all();
        //'academicClass','academicSubject'
        $expertise_ids=AssessmentExpertise::with('assessmentType')
    //     ->when($request->academic_class_id!='null',function($q) use ($request){
    //         $q->where('academic_class_id',$request->academic_class_id);
    //     })
    //    ->when($data['academic_subject_id']!='null',function($q) use ($data){
    //         $q->where('academic_subject_id',$data['academic_subject_id']);
    //     })
        // ->when($request->assessment_type_id!='null', function($q) use ($request){
        //     $q->where('assessment_type_id',$request->assessment_type_id);
        // })
        ->when($data['assessment_type_id']!='null',function($q) use ($data){
            $q->where('assessment_type_id',$data['assessment_type_id']);
        })
      
       ->pluck('id');
    //   dd($expertise_ids);

        $topicList=AssessmentExpertiseWiseTopic::with(['expertise'=>function($q) use ($request){
            return $q->with('assessmentType');
            },'academicClass','academicSubject'])
            ->when($request->academic_class_id!='null',function($q) use ($data){
                    $q->where('academic_class_id',$data['academic_class_id']);
                })  
            ->when($data['academic_subject_id']!='null',function($q) use ($data){
                    $q->where('academic_subject_id',$data['academic_subject_id']);
                })
            ->when($data['assessment_type_id']!='null',function($q) use ($data){
                    $q->where('assessment_type_id',$data['assessment_type_id']);
                })
            // ->where('academic_class_id',$request->academic_class_id)
            // ->where('academic_subject_id',$request->academic_subject_id)
            ->whereIn('expertise_id',$expertise_ids)
            ->orderBy('expertise_id')
            ->orderBy('serial')
            ->paginate(20);
        
        return response()->json($topicList);
    }

    public function expertiseWiseTopicUpdate(Request $request , $id){
       // dd($request->all());
        $request->validate([
           // 'academic_class_id'=> 'required',
           // 'academic_subject_id'=> 'required',
            'expertise_id'=> 'required',
            'topic_name'=> 'required',
            'topic_no'=> 'required',
        ]);


        // $existTopic = AssessmentExpertiseWiseTopic::where('expertise_id',$request->expertise_id)
        //     ->where('academic_class_id',$request->academic_class_id)
        //     ->where('academic_subject_id',$request->academic_subject_id)
        //     ->where('assessment_type_id',$request->assessment_type_id)
        //     ->where('topic_no',$request->topic_no)
        //     ->where('id','!=', $id)
        //     ->first();

           // dd($existTopic);

            // if($existTopic){
            //     return response()->json(['message'=>'This type no already added'],422);
            // }

        $expertiseWiseTopic = AssessmentExpertiseWiseTopic::findOrFail($id);

        if($request->assessment_type_id==1){
            $expertiseWiseTopic->academic_class_id     = $request->academic_class_id;
            $expertiseWiseTopic->academic_subject_id     = $request->academic_subject_id;
        }
        $expertiseWiseTopic->assessment_type_id     = $request->assessment_type_id;
        $expertiseWiseTopic->expertise_id     = $request->expertise_id;
        $expertiseWiseTopic->topic_name     = $request->topic_name;
        $expertiseWiseTopic->topic_no     = $request->topic_no;
        $expertiseWiseTopic->serial     = $request->serial;
        $expertiseWiseTopic->description      = $request->description;
        $expertiseWiseTopic->status      = $request->status;
        $expertiseWiseTopic->save();
        return response()->json(['message'=>'Updated Successfully!']);
    }
}
