<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/2/2016
 * Time: 12:40 PM
 */

namespace App\Http\Controllers\Building;

use App\Http\Controllers\Controller;
use App\Models\Building\Building;
use Illuminate\Http\Request;
use Response;

class BuildingController extends Controller
{

    private $building;

    public function __construct(Building $building)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->building = $building;

    }

    public function index()
    {
        $viewType = 'Building Floor Room';
        return view('default.admin.layouts.master', compact('viewType'));

    }

    public function getBuildingList(){
        $building_list=Building::get();

        return compact('building_list');
    }


    public function createBuilding(Request $request){

        $check_data=$this->building->where('building_name', $request->building_name)->first();

        if($check_data){
            if($check_data->status==0){
                $check_data->status=1;
                $check_data->save();
            }
            else if($check_data->status==1){
                return Response::json(['message' => 'This Building Name already present!.',
                    'mode' => 'Error!'], 200);
            }
        }
        else{
            $this->building->create([
                'building_name'=>$request->building_name,
                'status'=>1,
            ]);

            return Response::json(['message' => 'Save Successfully!', 'mode' => 'save!'], 200);
        }


    }


    public function editBuilding(Request $request){

        $check_same_name=$this->building->where('building_name', $request->building_name)
            ->where('id', '!=', $request->id)
            ->first();

        if($check_same_name){
            return Response::json(['message' => 'This Building Name already present!.',
                'mode' => 'Error!'], 200);
        }
        else{
            $this->building->where('id', $request->id)
                ->update([
                    'building_name'=>$request->building_name,
                    'status'=>1,
            ]);
        }
        return Response::json(['message' => 'Update Successfully!', 'mode' => 'save!'], 200);

    }


    public function deleteBuilding(Request $request){

        $this->building->where('id', $request->id)
            ->delete();


        return Response::json(['message' => 'Delete Successfully!', 'mode' => 'save!'], 200);
    }









}