<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/7/2016
 * Time: 5:49 PM
 */

namespace App\Http\Controllers\District;

use App\Http\Controllers\Controller;
use App\Forms\DistrictForm;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\District\District;
use App\Models\Division\Division;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use App\Http\Requests;
use DB;
use Response;
use Intervention\Image\Exception\NotFoundException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class DistrictController extends ProjectController
{
    use Lang, FormControll;

    private $district;
    private $division;

    /**
     * @param District $district
     */
    public function __construct(District $district, Division $division)
    {

        $this->middleware('auth')->except('getDistrictByDivisionId');
        $this->division = $division;
        $this->district = $district;
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $viewType = 'District List';

        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.district.index', compact('viewType', 'districtList'));
    }

    public function getDistrictList()
    {
        $districtList = $this->district->with('division')->get();
        return $districtList;

    }

    public function getDistrictListPagination(Request $request)
    {
        $paginate = $request->paginate;
        $search_country_id = $request->search_country_id;
        $search_division_id = $request->search_division_id;
        $search_district_id = $request->search_district_id;
//        return $search_country_id;

        $districtList = $this->district->with(['division'=>function ($qq){
                $qq->with('country');
            }])
            ->when($search_country_id, function ($q) use($search_country_id){
            $q->whereHas('division', function ($q1) use ($search_country_id) {
                return $q1->where('country_id', $search_country_id);
            });
        })->when($search_division_id, function ($qr) use($search_division_id){
            return $qr->where('division_id', $search_division_id);

        })->when($search_district_id, function ($qrr) use($search_district_id){
            return $qrr->where('id', $search_district_id);

        })->paginate($paginate);
        return $districtList;

    }

    public function getDistrictByDivisionId($divisionId)
    {
        $districtOfDivision = $this->district->whereDivisionId($divisionId)->get();
        return $districtOfDivision;
    }


    /**
     * @param Requests\Validator $validatedRequest
     */
    public function createDistrict(Request $request)
    {

        $this->district->division_id = $request->get('division_id');
        $this->district->district_name = $request->get('district_name');
        $this->district->govt_code = $request->get('govt_code');
        $this->district->status = $request->get('status');

        if($this->district->save()){
            $country_check = Division::where('id', $request->get('division_id'))->first();
            $country_check->update([
                'district_check' => 1
            ]);
            return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);
        }

    }


    /**
     * @param $id
     * @param Requests\Validator $validatedRequest
     */
    public function editDistrict($id, Request $request)
    {
        $districtToEdit = $this->district->findOrFail($id);

        $districtToEdit->division_id = $request->get('division_id');
        $districtToEdit->district_name = $request->get('district_name');
        $districtToEdit->govt_code = $request->get('govt_code');
        $districtToEdit->status = $request->get('status');

        if($districtToEdit->save()){
            $country_check = Division::where('id', $request->get('division_id'))->first();
            $country_check->update([
                'district_check' => 1
            ]);
            return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
        }

    }

    /**
     * @param $id
     * @return $this
     */
    public function deleteDistrict($id)
    {
        $districtToDelete = $this->district->findOrFail($id);
//        return $districtToDelete;

        if ($districtToDelete->thana_check == 0){
            $division_id = $districtToDelete->division_id;
            if($districtToDelete->delete()){
                $division_wise_district_check = Division::where('id', $division_id)->get();
                if(!count($division_wise_district_check)){
                    $division_check = Division::where('id', $division_id)->first();
                    $division_check->update([
                        'district_check' => 0
                    ]);
                }
                return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Delete'], 200);


            }
        }else{
            throw new Error('There is a dependecy');

        }

    }
}