<?php

namespace App\Http\Controllers\Edu\FileManager;

use App\Models\Image\Photo;
use Auth;
use Error;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Input;
use Image;
use Storage;

class EduNonSiteFileManagerController extends Controller
{

    private $image;

    public function __construct(Photo $image)
    {
        $this->middleware('eduworlduserchecker');
        $this->middleware('auth');

        $this->image = $image;
    }



    public function getEduNonSiteFile(Request $request)
    {
        try {


            // $date_range = $request->date_range ? json_decode($request->date_range) : null;
            $paginate = $request->paginate ?? 20;
            //  $txt = '%' . $search_txt . '%';

            /*   if (!$date_range) {
                   throw new Error('Please select Date');
               }*/

            //  $date_start = $date_range->start;//.' 00:00:00';
            //  $date_end = $date_range->end ?? $date_start;


            $fileList = $this->image
                ->where('user_id', Auth::user()->id)
                ->where('imageable_type', null)
                /*->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('doc_number', 'LIKE', $txt)
                            ->orWhere('track_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('notice_name', $txt);
                    });
                })*/
                ->orderBy('created_at', 'DESC')
                ->paginate($paginate);
            //  ->toSql();

            return response()->json($fileList, 200);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }





    public function saveEduNonSiteFile(Request $request)
    {

        $files = range(1, $request->length);
//        $site_id = Session::get('SITE_ID');
        $count = 0;
        $paths = array();

        if ($request->length) {
            foreach ($files as $k => $val) {


                $file = Input::file('files' . $k);

//                \Log::info($file);

                $file_type = $file->getClientMimeType();

                $file_name = 'edu' . '-' . uniqid() . '.' . $file->getClientOriginalExtension();
                $file_path = '/uploads/files/edu/' . $file_name;

//                File::isDirectory($file_path) or File::makeDirectory($file_path, 0777, true, true);

                //   $path = '/uploads/files/'.$site_id . '/all37' ;

                /*    if(!File::exists($file_path)){
                        File::makeDirectory($file_path);
                        return response()->json(['message' => 'crewatre Successfully Uploaded To:' . Storage::exists($path)], 400);

                    }

                    return response()->json(['message' => 'Successfully Uploaded To:' . Storage::exists($path)], 400);*/


                if (in_array($file_type, ['image/png', 'image/gif', 'image/jpeg', 'image/png'])) {
                    Image::make($file->getRealPath())
//                        ->resize(300, 246, function ($constraint) {
//                        $constraint->aspectRatio();
//                        })
                        ->save('uploads/files/edu/' . $file_name);

                } else {
                    Storage::disk('uploads')->put($file_name, File::get($file));
                }


                $this->image->create([
                    'user_id' => Auth::user()->id,
                    'path' => $file_path,
                    'extension' => $file->getClientOriginalExtension(),
                    'name' => uniqid() . '.' . $file->getClientOriginalExtension(),
                ]);
                $count++;
                $paths[] = $file_path;


            }

            return response()->json(['paths' => $paths, 'message' => 'Successfully Uploaded To:' . $count], 200);


        }
    }



}
