<?php

namespace App\Http\Controllers\Edu\HelpDesk;

use App\Models\Edu\HelpDesk\EduSiteHelpDeskMenu;
use App\Models\Edu\HelpDesk\EduSiteHelpDeskSetting;
use App\Models\Edu\HelpDesk\EduSiteHelpDeskSettingDetail;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;

class EduSiteHelpDeskSettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

    }


    public function index()
    {

        $viewType = 'Help Desk';
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function getEduSiteHelpDeskMenuList(){
        $eduSiteHelpDeskMenu= EduSiteHelpDeskMenu::orderBy('menu_serial')->get();

        return $eduSiteHelpDeskMenu;
    }


    public function addEduSiteHelpDeskMenu(Request $request){

        $this->validate($request, [
            'name' => 'required|max:200|unique:modules',

        ]);

        EduSiteHelpDeskMenu::create([
            'name' => $request->name,
            'menu_serial' => $request->menu_serial,
        ]);

        return Response::json(['message' => 'New Menu Successfully Added!']);
    }



    public function updateEduSiteHelpDeskMenu(Request $request, $id){
        $this->validate($request, [
            'name' => 'required|max:200',


        ]);

        $theModule = EduSiteHelpDeskMenu::findOrFail($id);
        $theModule->update([
            'name' => $request->name,
            'menu_serial' => $request->menu_serial,

        ]);

        return Response::json(['message' => 'Menu Successfully Updated!']);
    }


    public function deleteEduSiteHelpDeskMenu($id){

//        $subModuleExist = EduSiteHelpDeskMenu::whereModuleId($id)->first();
//
//        if ($subModuleExist) {
//            return Response::json(['message' => 'Menu Has Sub Module!'], 301);
//
//        }

        $theModule = EduSiteHelpDeskMenu::findOrFail($id);
        $theModule->delete();
        return Response::json(['message' => 'Menu Successfully Deleted!']);
    }




//============Setting===========


    private function getGroupRoleList(){

        $site_group_list=[
            [
                'id'=>1,
                'name'=>'Site',
                'name_key'=>'site',
                'select_name_key'=>false,
                'role_list'=>[
                    [
                        'id'=>1,
                        'name'=>'Admin',
                        'name_key'=>'admin',
                        'select_name_key'=>false,
                    ],
                    [
                        'id'=>2,
                        'name'=>'Employee',
                        'name_key'=>'employee',
                        'select_name_key'=>false,
                    ],
                    [
                        'id'=>3,
                        'name'=>'Student',
                        'name_key'=>'student',
                        'select_name_key'=>false,
                    ],
                    [
                        'id'=>4,
                        'name'=>'Guardian',
                        'name_key'=>'guardian',
                        'select_name_key'=>false,
                    ],

                ]
            ],
            [
                'id'=>2,
                'name'=>'Site Group',
                'name_key'=>'sitegroup',
                'select_name_key'=>false,
                'role_list'=>[
                    [
                        'id'=>1,
                        'name'=>'Admin',
                        'name_key'=>'admin',
                        'select_name_key'=>false,
                    ],
                    [
                        'id'=>2,
                        'name'=>'Employee',
                        'name_key'=>'employee',
                        'select_name_key'=>false,
                    ],
                    [
                        'id'=>3,
                        'name'=>'Student',
                        'name_key'=>'student',
                        'select_name_key'=>false,
                    ],
                    [
                        'id'=>4,
                        'name'=>'Guardian',
                        'name_key'=>'guardian',
                        'select_name_key'=>false,
                    ],

                ]
            ],


        ];

        return $site_group_list;
    }


    public function getHelpDeskMenuSiteGroupRoleList(){

        $eduSiteHelpDeskMenu= EduSiteHelpDeskMenu::orderBy('menu_serial')->get();

        $site_group_list= $this->getGroupRoleList();



        return response()->json(
            [
                'eduSiteHelpDeskMenu'=>$eduSiteHelpDeskMenu,
                'site_group_list'=>$site_group_list

            ]);



    }




    public function createHelpDeskMenuSiteGroupRole(Request $request){


        $site_list=collect($request->siteGroupList)->where('select_name_key', true);


        $abc = explode('/', $request->video_link);
        $last = end($abc);
        $again = explode('?', $last);
        if ($again) {
            $mid_last = end($again);
            $last_last = explode('v=', $mid_last);
            $final_link_last = end($last_last);

        } else {
            $final_link_last = $last;
        }
        $final_link = 'https://www.youtube.com/embed/' . $final_link_last;

        if(count($site_list)>0){

            $setting=new EduSiteHelpDeskSetting();

            $setting->edu_site_help_desk_menu_id=$request->edu_site_help_desk_menu_id;
            $setting->help_title=$request->help_title;
            $setting->help_description=$request->help_description;
            $setting->video_link=$final_link;
            $setting->serial=$request->serial;
            $setting->status=true;

            $setting->save();

            $setting_id=$setting->id;


            foreach ($site_list as $key => $value) {

                $role_list=collect($value['role_list'])->where('select_name_key', true);

                if(count($role_list)>0){

                    foreach ($role_list as $keys => $values) {

                        $setting_detail=new EduSiteHelpDeskSettingDetail();


                        $setting_detail->edu_site_help_desk_setting_id=$setting_id;
                        $setting_detail->menu_for=$value['name_key'];
                        $setting_detail->menu_role=$values['name_key'];

                        $setting_detail->save();
                    }

                }

            }



        }



        return JsonResponse::create(['message' => 'Successfuly Save Help Desk Topic'], 200);



    }



    public function getHelpDeskSettingList(Request $request){

        $help_desk=EduSiteHelpDeskSetting::with(['eduSiteHelpDeskSettingDetail'])
            ->where('edu_site_help_desk_menu_id', $request->edu_site_help_desk_menu_id)
            ->orderBy('serial')
            ->get();


        return response()->json(
            [
                'helpDeskSettingList'=>$help_desk,
            ]);
    }


    public function updateHelpDeskSetting(Request $request){


        $abc = explode('/', $request->video_link);
        $last = end($abc);
        $again = explode('?', $last);
        if ($again) {
            $mid_last = end($again);
            $last_last = explode('v=', $mid_last);
            $final_link_last = end($last_last);

        } else {
            $final_link_last = $last;
        }
        $final_link = 'https://www.youtube.com/embed/' . $final_link_last;


        $help_setting_list=EduSiteHelpDeskSetting::where('id', $request->id)->first();


        $help_setting_list->edu_site_help_desk_menu_id=$request->edu_site_help_desk_menu_id;
        $help_setting_list->help_title=$request->help_title;
        $help_setting_list->help_description=$request->help_description;
        $help_setting_list->video_link=$final_link;
        $help_setting_list->serial=$request->serial;
        $help_setting_list->status=true;

        $help_setting_list->save();

        $setting_id=$request->id;



        $site_list=collect($request->siteGroupList)->where('select_name_key', true);


        $all_setting_detail_list=EduSiteHelpDeskSettingDetail::where('edu_site_help_desk_setting_id', $request->id)->get();


        $all_setting_detail_list_ids=$all_setting_detail_list->pluck('id');


        $detail_ids=[];
        if(count($site_list)>0){

            foreach ($site_list as $key => $value) {

                $role_list=collect($value['role_list'])->where('select_name_key', true);

                if(count($role_list)>0){

                    foreach ($role_list as $keys => $values) {

                        $check_data=$all_setting_detail_list->where('menu_for', $value['name_key'])
                            ->where('menu_role', $values['name_key'])
                            ->first();

                        if($check_data){

                            $detail_ids[]=$check_data->id;
                        }
                        else{
                            $setting_detail=new EduSiteHelpDeskSettingDetail();


                            $setting_detail->edu_site_help_desk_setting_id=$setting_id;
                            $setting_detail->menu_for=$value['name_key'];
                            $setting_detail->menu_role=$values['name_key'];

                            $setting_detail->save();
                        }


                    }

                }

            }



        }


        $detailSettingChecks=array_diff($all_setting_detail_list_ids->toArray(), $detail_ids);
        EduSiteHelpDeskSettingDetail::whereIn('id', $detailSettingChecks)->delete();

        return JsonResponse::create(['message' => 'Successfuly Update Help Desk Topic'], 200);



    }



}
