<?php

namespace App\Http\Controllers\Edu\PaymentGateway;

use App\Models\Academic\AcademicOnlinePaymentMarchentType;
use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Academic\AcademicPaymentType;
use App\Models\Edu\PaymentGateway\EduPaymentGateway;
use App\Models\Site\Payment\PaymentGateway;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Error;


class AcademicOnlinePaymentMarchentTypeController extends Controller
{
    private $academicOnlinePaymentMarchentType;

    /**
     * DesignationController constructor.
     * @param Designation $designation
     */
    public function __construct(AcademicOnlinePaymentMarchentType $academicOnlinePaymentMarchentType)
    {

        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->academicOnlinePaymentMarchentType = $academicOnlinePaymentMarchentType;
    }

    public function index()
    {

        $viewType = 'Academic Online Payment Marchent Type';

        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.designation.index', compact('viewType', 'model'));

    }

    /**
     * @param Request $validatedRequest
     * @return \Illuminate\Http\RedirectResponse|null
     */
    public function getAcademicOnlinePaymentMarchentTypeList()
    {
        $payment_marchent_type_list =  $this->academicOnlinePaymentMarchentType->where('status', 1)->get();
        return $payment_marchent_type_list;
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getAcademicOnlinePaymentMarchentTypeListWithPagination(Request $request)
    {
//        return 'ok';
        $paginate = $request->paginate ?? 15;
        $search_txt = $request->search_txt;
//        return $search_with_payment_type;

        $txt = '%' . $search_txt . '%';

//
//        $academic_payment_list =  AcademicPaymentType::where('status', 1)
//            ->paginate($paginate);

        $academic_online_payment_marchent_type_list =  AcademicOnlinePaymentMarchentType::when($search_txt, function ($q) use($txt){
                $q->where('name', 'LIKE', $txt)
                    ->orWhere('name_key', 'LIKE', $txt);

            })
            ->where('status', 1)
            ->with('accOnlinePaymentMethod')
            ->paginate($paginate);



        return $academic_online_payment_marchent_type_list ;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request, AcademicOnlinePaymentMarchentType $academicOnlinePaymentMarchentType)
    {
//        return $request;
        //==============validation=============
        $this->validate($request, [

            "name" => "required",
            "name_key" => "required",


        ]);


        if (count($academicOnlinePaymentMarchentType->ownFields) > 0) {
            foreach ($academicOnlinePaymentMarchentType->ownFields as $field) {
                if ($request->{$field}) {
                    $academicOnlinePaymentMarchentType->{$field} = $request->{$field};
                }
            }
            $academicOnlinePaymentMarchentType->status = $request->status;
            $academicOnlinePaymentMarchentType->academic_online_payment_method_id = $request->academic_online_payment_method_id;
            $academicOnlinePaymentMarchentType->save();
        }

        return Response::json(['message' => 'Payment Marchent Type Successfully Saved!', 'mode' => 'Saved!'], 200);

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
//        return $request->academic_online_payment_marchent_type_id['id'];
        //==============validation=============


        $academicOnlinePaymentMarchentType = AcademicOnlinePaymentMarchentType::findOrFail($request->id);
        if (count($academicOnlinePaymentMarchentType->ownFields) > 0) {
            foreach ($academicOnlinePaymentMarchentType->ownFields as $field) {
                if ($request->{$field}) {
                    $academicOnlinePaymentMarchentType->{$field} = $request->{$field};
                }
            }

            $academicOnlinePaymentMarchentType->status = $request->status;
            $academicOnlinePaymentMarchentType->academic_online_payment_method_id = $request->academic_online_payment_method_id;
            $academicOnlinePaymentMarchentType->save();
        }
        return Response::json(['message' => 'Payment Marchent Type Successfully Updated!', 'mode' => 'Updated!'], 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        //====================check used in site or edu================
        $check_site_use = PaymentGateway::where('academic_online_payment_marchent_type_id', $id)->first();
        $check_edu_use = EduPaymentGateway::where('academic_online_payment_marchent_type_id', $id)->first();
        if($check_site_use || $check_edu_use){
            throw new Error('Sorry! can not be deleted! data used site or edu!');
        }else{
            $paymentMarchentType = AcademicOnlinePaymentMarchentType::where('id',$id)->delete();
            return Response::json(['message' => 'Payment Marchent Type Successfully Deleted!', 'mode' => 'Deleted!'], 200);
        }


    }
}
