<?php

namespace App\Http\Controllers\Edu\PaymentGateway;

use App\Models\Academic\AcademicOnlinePaymentMarchentType;
use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Academic\AcademicPaymentType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Error;


class AcademicOnlinePaymentMethodController extends Controller
{
    private $academicOnlinePaymentMethod;

    /**
     * DesignationController constructor.
     * @param Designation $designation
     */
    public function __construct(AcademicOnlinePaymentMethod $academicOnlinePaymentMethod)
    {

        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->academicOnlinePaymentMethod = $academicOnlinePaymentMethod;
    }

    public function index()
    {

        $viewType = 'Academic Online Payment Method';

        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.designation.index', compact('viewType', 'model'));

    }

    /**
     * @param Request $validatedRequest
     * @return \Illuminate\Http\RedirectResponse|null
     */
    public function getAcademicOnlinePaymentMethodList()
    {
        $payment_type_list =  $this->academicOnlinePaymentMethod->where('status', 1)->get();
        return $payment_type_list;
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getAcademicOnlinePaymentMethodListWithPagination(Request $request)
    {
//        return 'ok';
        $paginate = $request->paginate ?? 15;
        $search_txt = $request->search_txt;
//        return $search_with_payment_type;

        $txt = '%' . $search_txt . '%';

//
//        $academic_payment_list =  AcademicPaymentType::where('status', 1)
//            ->paginate($paginate);

        $academic_online_payment_method_list =  AcademicOnlinePaymentMethod::when($search_txt, function ($q) use($txt){
                $q->where('name', 'LIKE', $txt)
                    ->orWhere('name_key', 'LIKE', $txt);

            })
            ->where('status', 1)
            ->with('academicPaymentType')
            ->paginate($paginate);



        return $academic_online_payment_method_list ;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request, AcademicOnlinePaymentMethod $academicOnlinePaymentMethod)
    {
//        return $request;
        //==============validation=============
        $this->validate($request, [

            "name" => "required",
            "name_key" => "required",


        ]);


        if (count($academicOnlinePaymentMethod->ownFields) > 0) {
            foreach ($academicOnlinePaymentMethod->ownFields as $field) {
                if ($request->{$field}) {
                    $academicOnlinePaymentMethod->{$field} = $request->{$field};
                }
            }
            $academicOnlinePaymentMethod->status = $request->status;
            $academicOnlinePaymentMethod->payment_type_key = $request->academic_payment_type_key;
            $academicOnlinePaymentMethod->save();
        }

        return Response::json(['message' => 'Payment Method Successfully Saved!', 'mode' => 'Saved!'], 200);

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
//        return $request->academic_online_payment_marchent_type_id['id'];
        //==============validation=============


        $academicOnlinePaymentMethod = AcademicOnlinePaymentMethod::findOrFail($request->id);
        if (count($academicOnlinePaymentMethod->ownFields) > 0) {
            foreach ($academicOnlinePaymentMethod->ownFields as $field) {
                if ($request->{$field}) {
                    $academicOnlinePaymentMethod->{$field} = $request->{$field};
                }
            }

            $academicOnlinePaymentMethod->status = $request->status;
            $academicOnlinePaymentMethod->payment_type_key = $request->academic_payment_type_key;
            $academicOnlinePaymentMethod->save();
        }
        return Response::json(['message' => 'Payment Method Successfully Updated!', 'mode' => 'Updated!'], 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $check_used = AcademicOnlinePaymentMarchentType::where('academic_online_payment_method_id', $id)->first();
        if($check_used){
            throw new Error('Sorry! can not be deleted! data used in marchent type!');
        }else{
            $paymentMethod = AcademicOnlinePaymentMethod::where('id',$id)->delete();
            return Response::json(['message' => 'Payment Method Successfully Deleted!', 'mode' => 'Deleted!'], 200);
        }

    }
}
