<?php

namespace App\Http\Controllers\Edu\Permission;

use App\Http\Controllers\Module\ModuleController;
use App\Models\Edu\EduRoleAccess;
use App\Models\Permission\UserExtraPermission;
use App\User;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Validation\ValidationException;
use Response;
use Session;

class AssignExtraPermissionController extends Controller
{
    private $module;

    public function __construct(ModuleController $module)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->module = $module;


    }

    public function index()
    {
        //
    }

    public function assignExtraPermissionForm()
    {
        $viewType = 'Assign Extra Permission For Edu User';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.permission.assign_extra_permission', compact('viewType'));
    }


    public function getAssignedListForEduUser($user_id)
    {
        try {
            $module_list = $this->module->getModuleListWithSubModule();

            $user = User::find($user_id);
            $role_ids = $user->eduRoles->pluck('id');

            $get_user_role_access = EduRoleAccess::whereIn('edu_role_id', $role_ids)->pluck('sub_module_ids');
            $role_access_arr = [];

            foreach ($get_user_role_access as $acces) {
                $exploded = explode(',', $acces) ?? [];
                $role_access_arr = array_unique(array_merge($role_access_arr, $exploded));
            }

            $get_user_access = explode(',', UserExtraPermission::whereUserId($user_id)->first()->sub_module_ids ?? null) ?? [];


            return [$module_list, $role_access_arr, $get_user_access];


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function assignSubModuleToEduUser(Request $req)
    {
        try {

            $this->validate($req, [
                'user_id' => 'required',
            ]);

            $user_roles_access_list = $req->userRolesAccessList;
            $sub_module_ids = $req->sub_module_ids;
            $user_id = $req->user_id;


            if (file_exists(base_path("resources/views/default/admin/layouts/sidebars/" . Session::get('ALIAS') . '/' . $user_id . '.blade.php'))) {
                unlink(base_path("resources/views/default/admin/layouts/sidebars/" . Session::get('ALIAS') . '/' . $user_id . '.blade.php'));
            }


            foreach ($sub_module_ids as $k=> $item) {
                if (in_array($item, $user_roles_access_list)) {
                    unset($sub_module_ids[$k]);
                }
            }

            $sub_module_ids_exploded = implode($sub_module_ids, ',');
            $total = count($sub_module_ids);
            $userAlreadyAssigned = UserExtraPermission::whereUserId($user_id)->first();


            if ($userAlreadyAssigned) {
                $userAlreadyAssigned->update([
                    'sub_module_ids' => $sub_module_ids_exploded
                ]);
            } else {
                UserExtraPermission::create([
                    'sub_module_ids' => $sub_module_ids_exploded,
                    'user_id' => $user_id,
                    'status' => true,
                ]);
            }


            return Response::json(['message' => "<b>".$total . "</b> Extra Sub Module Assigned To <b>".$req->users_name ."</b>"]);


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
