<?php

namespace App\Http\Controllers\Edu\Site\Invoice;

use App\Models\Edu\Transaction\EduStudentInvoiceItem;
use App\Models\Site\Student\Student;
use App\Models\User\GlobalUser;
use App\Models\User\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Models\Academic\AcademicGroup;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Edu\Item\ItemDetail;
use App\Models\Edu\Transaction\EduStudentInvoice;
use App\Models\Edu\Transaction\EduStudentInvoiceDeclare;
use App\Models\Edu\Transaction\EduStudentInvoiceDeclareItem;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Student\StudentHistory;
use DB;
use Exception;
use Illuminate\Http\JsonResponse;
use JsonSchema\Exception\ValidationException;
use Response;

class SiteStudentInvoiceDeclareController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

    }


    public function index()
    {

        $viewType = 'invoice Declare';
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function getSiteAcademicGroupList(Request $request){



        $group_list_ids=GlobalSiteInfoSetting::where('site_id', $request->site_id)
            ->pluck('academic_group_id');

        $group_list=AcademicGroup::whereIn('id', $group_list_ids)
            ->get();


        $invoice_item=ItemDetail::where('category_code', 'charge')
            ->select('id', 'category_code', 'item_name')
            ->get();

        $academic_year=AcademicYear::get();


        return response()->json(
            [
                'group_list'=>$group_list,
                'invoice_item'=>$invoice_item,
                'academic_year'=>$academic_year,
            ]);


    }



    public function getAcademicGroupBaseInvoiceDeclareList(Request $request){



        $getDeclareList=EduStudentInvoiceDeclare::with(['academicGroup',
            'eduStudentInvoiceDeclareItem'=>function($query){
                $query->with(['eduItemDetail'=>function($querys){
                    $querys->select('id', 'category_code', 'item_name');
                }]);
            }])
            ->where('site_id', $request->site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->get();


        return response()->json(
            [
                'getInvoiceDeclareList'=>$getDeclareList,
            ]);
    }





    private function studentListWithSerial($request){
        $get_all_student=GlobalStudentHistory::where('site_id', $request->site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('status', true)
//            ->where('id', '!=', 10616)
            ->select('id', 'user_id')
            ->orderBy('id', 'asc')
            ->get();


        $student_arr=Array();
        $student_array=[];
        foreach ($get_all_student as $key => $value){
            $student_arr['student_history_id']=$value->id;
            $student_arr['user_id']=$value->user_id;
            $student_arr['serial']=$key+1;


            $student_array[$key]=$student_arr;
        }


        return $student_array;

    }




    public function createEduSiteStudentInvoiceDeclare(Request $request){



        $this->validate($request, [
            "edu_student_panel_close_date" =>$request->student_panel_close_status? "required":'',
            "payment_to_date" => "required",
            "payment_from_date" => "required",
            "payment_amount" => "required",
            "academic_year_id" => "required",
            "academic_group_id" => "required",

        ]);


        DB::beginTransaction();


        try {

            $selected_item_list=collect($request->paymentItemList)->where('select_edu_item_detail_id', true);

            $selected_item_sum=$selected_item_list->sum('payment_amount');

            if(count($selected_item_list)<=0){
                return Response::json(['message' => 'Plese Select Payment Item!', 'mode' => 'Error'], 412);
            }

            if($selected_item_sum!=$request->payment_amount){
                return Response::json(['message' => 'Your payment amount & selected item payment amount sum is not same.!', 'mode' => 'Error'], 412);
            }


            $studentListWithSerial=$this->studentListWithSerial($request);



            $student_range=50;

            if($request->first_time==1){
                $start_range=0;
                $end_range=49;
            }
            else{
                $start_range=$request->start_range+$student_range;
                $end_range=$request->end_range+$student_range;
            }


            $get_all_student=collect($studentListWithSerial)
                ->where('serial', '>=', $start_range)
                ->where('serial', '<=', $end_range);



            if(count($studentListWithSerial)<$end_range){
                $parcentage=100;
            }
            else{
                $parcentage=floor($end_range*100/count($studentListWithSerial));
            }




            if($request->first_time==1){


                $invoice_declare=new EduStudentInvoiceDeclare();

                $invoice_declare->site_id= $request->site_id;
                $invoice_declare->academic_group_id= $request->academic_group_id;
                $invoice_declare->academic_year_id= $request->academic_year_id;
                $invoice_declare->payment_from_date= $request->payment_from_date;
                $invoice_declare->payment_to_date= $request->payment_to_date;
                $invoice_declare->edu_student_panel_close_date= $request->edu_student_panel_close_date;
                $invoice_declare->payment_amount= $request->payment_amount;
                $invoice_declare->student_panel_close_status= $request->student_panel_close_status;
                $invoice_declare->status= true;




                $invoice_declare->save();

                $invoice_declare_id=$invoice_declare->id;

                $selected_items=collect($request->paymentItemList)->where('select_edu_item_detail_id', true);

                if(count($selected_items)>0){

                    foreach ($selected_items as $key => $value){

                        $invoice_declare_item=new EduStudentInvoiceDeclareItem();

                        $invoice_declare_item->edu_student_invoice_declare_id= $invoice_declare_id;
                        $invoice_declare_item->edu_item_detail_id= $value['id'];
                        $invoice_declare_item->amount= $value['payment_amount'];
                        $invoice_declare_item->site_id= $request->site_id;
                        $invoice_declare_item->status= true;

                        $invoice_declare_item->save();

                    }

                }

            }
            else{
                $invoice_declare_id=$request->invoice_declare_id;
            }



            $cehck_payment_last_date=EduStudentInvoiceDeclare::where('site_id', $request->site_id)
                ->where('academic_group_id', $request->academic_group_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('status', true)
                ->orderBy('edu_student_panel_close_date', 'asc')
                ->pluck('edu_student_panel_close_date');


            $selected_itemst=collect($request->paymentItemList)->where('select_edu_item_detail_id', true);
            $created=[];
            if(count($get_all_student)>0){

                foreach ($get_all_student as $key => $value){



                    $invoice=new EduStudentInvoice();

                    $invoice->student_history_id= $value['student_history_id'];
                    $invoice->user_id= $value['user_id'];
                    $invoice->edu_student_invoice_declare_id= $invoice_declare_id;
                    $invoice->academic_group_id= $request->academic_group_id;
                    $invoice->payable_amount= $request->payment_amount;

                    $invoice->payment_from_date= $request->payment_from_date;
                    $invoice->payment_to_date= $request->payment_to_date;
                    $invoice->edu_student_panel_close_date= $request->edu_student_panel_close_date;

                    $invoice->online_payment_status= false;
                    $invoice->manual_payment_status= false;
                    $invoice->status= true;
                    $invoice->site_id= $request->site_id;

                    $invoice->save();
                    $invoice_id= $invoice->id;


                    if(count($selected_itemst)>0){

                        foreach ($selected_itemst as $keys => $values){

                            $created[] = [
                                'edu_student_invoice_id'=>$invoice_id,
                                'edu_item_detail_id'=>$values['id'],
                                'payment_amount'=>$values['payment_amount'],
                                'status'=>true,
                                'site_id'=>$request->site_id,
                            ];

                        }

                    }




                    if($request->student_panel_close_status){



                        $get_student_invoice_payment_last_date_list=EduStudentInvoice::where('student_history_id', $value['student_history_id'])
                            ->where('online_payment_status', false)
                            ->where('manual_payment_status', false)
                            ->whereIn('edu_student_panel_close_date', $cehck_payment_last_date)
                            ->orderBy('edu_student_panel_close_date', 'asc')
                            ->select('edu_student_panel_close_date')
                            ->first();


                        if($get_student_invoice_payment_last_date_list){
                            GlobalUser::where('id', $value['user_id'])
                                ->update([
                                    'student_edu_payment_status'=>false,
                                    'edu_student_panel_close_date'=>$get_student_invoice_payment_last_date_list->edu_student_panel_close_date
                                ]);

                            GlobalStudentHistory::where('id', $value['student_history_id'])
                                ->update([
                                    'student_edu_payment_status'=>false,
                                    'edu_student_panel_close_date'=>$get_student_invoice_payment_last_date_list->edu_student_panel_close_date
                                ]);
                        }


                    }






                }


            }



            if(count($created)>0){
                EduStudentInvoiceItem::insert($created);
            }


            DB::commit();
            if(count($studentListWithSerial)>$end_range){



                return response()->json(
                    [
                        'start_range'=>$start_range,
                        'end_range'=>$end_range,
                        'parcentage'=>$parcentage,
                        'invoice_declare_id'=>$invoice_declare_id,
                    ]);
            }
            else{


                return Response::json(['message' => 'Save Successfully!', 'mode' => 'Update!'], 200);
            }






        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }




    }


    public function updateEduSiteStudentInvoiceDeclare(Request $request){


        $this->validate($request, [
            "edu_student_panel_close_date" =>$request->student_panel_close_status? "required":'',
            "payment_to_date" => "required",
            "payment_from_date" => "required",
            "payment_amount" => "required",
            "academic_year_id" => "required",
            "academic_group_id" => "required",

        ]);

        DB::beginTransaction();


        try {



            $selected_item_list=collect($request->paymentItemList)->where('select_edu_item_detail_id', true);

            $selected_item_sum=$selected_item_list->sum('payment_amount');

            if(count($selected_item_list)<=0){
                return Response::json(['message' => 'Plese Select Payment Item!', 'mode' => 'Error'], 412);
            }

            if($selected_item_sum!=$request->payment_amount){
                return Response::json(['message' => 'Your payment amount & selected item payment amount sum is not same.!', 'mode' => 'Error'], 412);
            }


            $studentListWithSerial=$this->studentListWithSerial($request);


            $student_range=50;

            if($request->first_time==1){
                $start_range=0;
                $end_range=49;
            }
            else{
                $start_range=$request->start_range+$student_range;
                $end_range=$request->end_range+$student_range;
            }


            $get_all_student=collect($studentListWithSerial)
                ->where('serial', '>=', $start_range)
                ->where('serial', '<=', $end_range);



            if(count($studentListWithSerial)<$end_range){
                $parcentage=100;
            }
            else{
                $parcentage=floor($end_range*100/count($studentListWithSerial));
            }

            $invoice_declare_id=$request->edu_invoice_declare_id;





            if($request->first_time==1){



                $invoice_declare= EduStudentInvoiceDeclare::where('id', $request->edu_invoice_declare_id)->first();

                $invoice_declare->site_id= $request->site_id;
                $invoice_declare->academic_group_id= $request->academic_group_id;
                $invoice_declare->payment_from_date= $request->payment_from_date;
                $invoice_declare->payment_to_date= $request->payment_to_date;
                $invoice_declare->edu_student_panel_close_date= $request->edu_student_panel_close_date;
                $invoice_declare->payment_amount= $request->payment_amount;
                $invoice_declare->student_panel_close_status= $request->student_panel_close_status;
                $invoice_declare->status= true;

                $invoice_declare->save();

//            $invoice_declare_id=$request->edu_invoice_declare_id;

                $selected_items=collect($request->paymentItemList)->where('select_edu_item_detail_id', true);

                $check_invoice_declare_item_list= EduStudentInvoiceDeclareItem::where('edu_student_invoice_declare_id', $request->edu_invoice_declare_id)
                    ->get();

                $check_invoice_declare_item_ids=[];
                if(count($check_invoice_declare_item_list)>0){
                    $check_invoice_declare_item_ids=$check_invoice_declare_item_list->pluck('id');
                }



                $present_item_id=[];
                if(count($selected_items)>0){

                    foreach ($selected_items as $key => $value){

                        $check_invoice_declare_item= $check_invoice_declare_item_list->where('edu_invoice_item_id', $value['id'])
                            ->first();

                        $invoice_declare_item=new EduStudentInvoiceDeclareItem();

                        if($check_invoice_declare_item){

                            $present_item_id[]=$check_invoice_declare_item->id;

                            $check_invoice_declare_item->edu_student_invoice_declare_id= $invoice_declare_id;
                            $check_invoice_declare_item->edu_item_detail_id= $value['id'];
                            $check_invoice_declare_item->amount= $value['payment_amount'];
                            $check_invoice_declare_item->site_id= $request->site_id;
                            $check_invoice_declare_item->status= true;

                            $check_invoice_declare_item->save();
                        }
                        else{
                            $invoice_declare_item->edu_student_invoice_declare_id= $invoice_declare_id;
                            $invoice_declare_item->edu_item_detail_id= $value['id'];
                            $invoice_declare_item->amount= $value['payment_amount'];
                            $invoice_declare_item->site_id= $request->site_id;
                            $invoice_declare_item->status= true;

                            $invoice_declare_item->save();
                        }
                    }
                }


                $invoiceCheck=array_diff(
                    ($check_invoice_declare_item_ids?$check_invoice_declare_item_ids->toArray():null),
                    $present_item_id);

                EduStudentInvoiceDeclareItem::whereIn('id', $invoiceCheck)->delete();



            }





            $selected_items=collect($request->paymentItemList)
                ->where('select_edu_item_detail_id', true);



            $created=[];

            if(count($get_all_student)>0){


                //=========Non Paid Student
                $check_unpaid_student_list=EduStudentInvoice::select('id', 'student_history_id',
                    'payable_amount')
                    ->whereIn('student_history_id', $get_all_student->pluck('student_history_id'))
                    ->where('edu_student_invoice_declare_id', $request->edu_invoice_declare_id)
                    ->where('online_payment_status', false)
                    ->where('manual_payment_status', false)
                    ->where('status', true)
                    ->get();



                $non_paid_invoice=EduStudentInvoiceItem::whereIn('edu_student_invoice_id',
                    $check_unpaid_student_list->pluck('id'))
                    ->get();

                $non_paid_invoice_ids=$non_paid_invoice->pluck('id');

                $check_unpaid_student_ids=$check_unpaid_student_list->pluck('student_history_id');



                $cehck_payment_last_date=EduStudentInvoiceDeclare::where('site_id', $request->site_id)
                    ->where('academic_group_id', $request->academic_group_id)
                    ->where('academic_year_id', $request->academic_year_id)
                    ->where('status', true)
                    ->orderBy('edu_student_panel_close_date', 'asc')
                    ->pluck('edu_student_panel_close_date');



                $invoice_item_ids=[];
                if(count($check_unpaid_student_ids)>0){

                    foreach ($check_unpaid_student_ids as $key => $value){

                        $check_invoice=$check_unpaid_student_list->where('student_history_id', $value)->first();

                        $check_invoice->update([
                            'payable_amount'=> $request->payment_amount,
                            'payment_from_date'=> $request->payment_from_date,
                            'payment_to_date'=> $request->payment_to_date,
                            'edu_student_panel_close_date'=> $request->edu_student_panel_close_date,
                        ]);





                        if(count($selected_items)>0){

                            foreach ($selected_items as $keys => $values){

                                $check_invoice_item=$non_paid_invoice->where('edu_item_detail_id', $values['id'])
                                    ->where('edu_student_invoice_id', $check_invoice->id)->first();

                                if($check_invoice_item){

                                    $invoice_item_ids[]=$check_invoice_item->id;

                                    $check_invoice_item->payment_amount=$values['payment_amount'];
                                    $check_invoice_item->save();

                                }else{

                                    $created[] = [
                                        'edu_student_invoice_id'=>$check_invoice->id,
                                        'edu_item_detail_id'=>$values['id'],
                                        'payment_amount'=>$values['payment_amount'],
                                        'status'=>true,
                                        'site_id'=>$request->site_id,
                                    ];
                                }

                            }
                        }




                        if($request->student_panel_close_status){



                            $get_student_invoice_payment_last_date_list=EduStudentInvoice::where('student_history_id',  $value)
                                ->where('online_payment_status', false)
                                ->where('manual_payment_status', false)
                                ->whereIn('edu_student_panel_close_date', $cehck_payment_last_date)
                                ->orderBy('edu_student_panel_close_date', 'asc')
                                ->select('edu_student_panel_close_date')
                                ->first();

                            $get_user_id=GlobalStudentHistory::where('id', $value)
                                ->pluck('user_id')
                                ->unique();



                            if($get_student_invoice_payment_last_date_list){
                                GlobalUser::whereIn('id', $get_user_id)
                                    ->update([
                                        'student_edu_payment_status'=>false,
                                        'edu_student_panel_close_date'=>$get_student_invoice_payment_last_date_list->edu_student_panel_close_date
                                    ]);

                                GlobalStudentHistory::where('id', $value)
                                    ->update([
                                        'student_edu_payment_status'=>false,
                                        'edu_student_panel_close_date'=>$get_student_invoice_payment_last_date_list->edu_student_panel_close_date
                                    ]);
                            }


                        }



                    }
                }

                $student_invoice_item_ids=array_diff($non_paid_invoice_ids->toArray(), $invoice_item_ids);


                if(count($student_invoice_item_ids)>0){
                    EduStudentInvoiceItem::whereIn('id', $student_invoice_item_ids)
                        ->delete();
                }





                //=======Paid Student

                $check_paid_student_ids=EduStudentInvoice::whereIn('student_history_id', $get_all_student->pluck('student_history_id'))
                    ->where('edu_student_invoice_declare_id', $request->edu_invoice_declare_id)
                    ->where(function ($query) {
                        $query->where('online_payment_status', true)
                            ->orWhere('manual_payment_status', true);
                    })
                    ->where('status', true)
                    ->pluck('student_history_id')
                    ->unique();







                $already_present_student=array_merge(($check_paid_student_ids?$check_paid_student_ids->toArray():[]), $check_unpaid_student_ids->toArray());



                $rest_student_ids=array_diff($get_all_student->pluck('student_history_id')->toArray(),
                    $already_present_student);



                if(count($rest_student_ids)>0){

                    foreach ($rest_student_ids as $key => $value){

                        $invoice=new EduStudentInvoice();

                        $invoice->student_history_id= $value['student_history_id'];
                        $invoice->user_id= $value['user_id'];
                        $invoice->edu_student_invoice_declare_id= $invoice_declare_id;
                        $invoice->academic_group_id= $request->academic_group_id;
                        $invoice->payable_amount= $request->payment_amount;


                        $invoice->payment_from_date= $request->payment_from_date;
                        $invoice->payment_to_date= $request->payment_to_date;
                        $invoice->edu_student_panel_close_date= $request->edu_student_panel_close_date;


                        $invoice->online_payment_status= false;
                        $invoice->manual_payment_status= false;
                        $invoice->status= true;
                        $invoice->site_id= $request->site_id;

                        $invoice->save();
                        $invoice_id= $invoice->id;


                        if(count($selected_items)>0){

                            foreach ($selected_items as $keys => $values){

                                $created[] = [
                                    'edu_student_invoice_id'=>$invoice_id,
                                    'edu_item_detail_id'=>$values['id'],
                                    'payment_amount'=>$values['payment_amount'],
                                    'status'=>true,
                                    'site_id'=>$request->site_id,
                                ];

                            }
                        }
                    }
                }

            }

            if(count($created)>0){
                EduStudentInvoiceItem::insert($created);
            }




            DB::commit();
            if(count($studentListWithSerial)>$end_range){
                return response()->json(
                    [
                        'start_range'=>$start_range,
                        'end_range'=>$end_range,
                        'parcentage'=>$parcentage,
                        'invoice_declare_id'=>$invoice_declare_id,
                    ]);
            }
            else{
                return Response::json(['message' => 'Save Successfully!', 'mode' => 'Update!'], 200);
            }



        }
        catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }

    }




    public function pauseEduSiteStudentInvoiceDeclare(Request $request){

        EduStudentInvoiceDeclare::where('id', $request->edu_invoice_declare_id)
            ->update([
                'status'=>false,
            ]);


        EduStudentInvoice::where('edu_student_invoice_declare_id', $request->edu_invoice_declare_id)
            ->where('online_payment_status', false)
            ->where('manual_payment_status', false)
            ->where('status', true)
            ->update([
                'status'=>false,
            ]);

        return Response::json(['message' => 'Pause Successfully!', 'mode' => 'Update!'], 200);
    }


    public function activateEduSiteStudentInvoiceDeclare(Request $request){

        $invoice_declare= EduStudentInvoiceDeclare::where('site_id', $request->site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->where('status', true)
            ->first();

        if($invoice_declare){
            $invoice_declare->status=false;
            $invoice_declare->save();

        }


        EduStudentInvoiceDeclare::where('id', $request->edu_invoice_declare_id)
            ->update([
                'status'=>true,
            ]);


        EduStudentInvoice::where('edu_student_invoice_declare_id', $request->edu_invoice_declare_id)
            ->update([
                'status'=>true,
            ]);

        return Response::json(['message' => 'Pause Successfully!', 'mode' => 'Update!'], 200);
    }




}
