<?php

namespace App\Http\Controllers\Edu\Site;

use App\Forms\DataHelper;
use App\Forms\FormControll;
use App\Http\Controllers\ProjectController;
use App\Models\Edu\Device\DeviceDetail;
use App\Models\Menu\Menu;
use App\Models\Modules\SubModule;
use App\Models\Package\EduPackage;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteMembership;
use App\Models\WebSite\WebsiteMenu;
use Error;
use Exception;
use Illuminate\Http\Request;
use Response;

class SiteMembershipController extends ProjectController
{
    use DataHelper;

    private $siteMembership;
    private $accessController;

    public function __construct(SiteMembership $siteMembership, SiteAccessController $accessController)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->siteMembership = $siteMembership;
        $this->accessController = $accessController;
    }


    public function index()
    {

        $menus = Menu::where('is_displayable', true)
            ->where('menu_for', 'website')
            ->get();


        //  dd($menus);
        $serial = 1;
        foreach ($menus as $k => $menu) {
            $web_menu = new WebsiteMenu();
            $web_menu->menu_id = $menu->id;
            $web_menu->parent_id = $menu->parent_id;
            $web_menu->type = 'site';
            $web_menu->type_id = 10;
            $web_menu->serial = $serial++;

            //$web_menu->save();


        }


        $viewType = 'Institution Membership Details';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.site_membership.index', compact('viewType'));

    }

    public function getMembershipDetailsBySite($id)
    {
        try {
            $result = $this->siteMembership->whereSiteId($id)->where('status', 1)->first();
            $masking = $this->maskingList();
            $smsCompany = $this->smsCompany();
            $active_device_count = DeviceDetail::where('site_id', $id)->where('status', 1)->count();
           
            return response()->json([$result, $masking, $smsCompany, $active_device_count], 200);


        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }

    }

    public function createSiteMembership(Request $request)
    {
        $siteMemberToCreate = $this->getMembershipInfo($this->siteMembership, $request);
        if ($siteMemberToCreate->save()) {
            return back()->withSuccess('Successfully Created');
        }
    }


    public function saveOrUpdateMembership($id = null, Request $request)
    {

        $this->validate($request, [
            'site_id' => 'required',
            'edu_package_id' => 'required',
            'payment_type' => 'required',
            'payment_amount' => 'required'
        ]);

        $total = 0;
        $message = '';
        $mode = '';
        if ($id) {
            $siteMemberToEdit = $this->siteMembership->findOrFail($id);
            $siteMemberToEdit = $this->getMembershipInfo($siteMemberToEdit, $request);
            if ($siteMemberToEdit->save()) {
                $total = $this->accessController->assignPackageToSite($request->site_id);
                $message = 'Site Membership Successfully Updated!';
                $mode = 'Update';
            }

        } else {
            $siteMemberToEdit = $this->getMembershipInfo($this->siteMembership, $request);

            if ($siteMemberToEdit->save()) {
                $total = $this->accessController->assignPackageToSite($request->site_id);
                $message = 'Site Membership Successfully Saved!';
                $mode = 'Save';
            }
        }

        if ($siteMemberToEdit->sms_bearer == 'site') {
            $siteMemberToEdit->sms_bearer_id = $siteMemberToEdit->site_id;
            $siteMemberToEdit->save();
        }

        $this->createWebMenu($siteMemberToEdit);
        return Response::json(['message' => $message . ' (' . $total . ')', 'mode' => $mode], 200);
    }

    private function getMembershipInfo(SiteMembership $siteMembership, Request $request)
    {

        if (count($siteMembership->ownFields) > 0) {
            foreach ($siteMembership->ownFields as $k => $ownField) {
                if ($request->{$ownField}) {
                    $siteMembership->{$ownField} = $request->{$ownField};
                }
            }
        }
        $siteMembership->late_payment_status = $request->get('late_payment_status');
        $siteMembership->alumni_login = $request->get('alumni_login');
        $siteMembership->status = $request->get('status');

        return $siteMembership;

    }


    private function createWebMenu(SiteMembership $siteMembership)
    {

        /* $menus = Menu::where('is_displayable', true)
             ->where('menu_for', 'website')
             ->get();*/
        $site_info = SiteInfo::where('id', $siteMembership->site_id)->first();


        $web_menus = Menu::where('menu_for', 'website')
            ->where('is_displayable', true)
            ->get();
           
           
        $deleted_menu_ids = [];
        
        $serial = 1;
        foreach ($web_menus as $k => $menu) {

            // \Log::info($menu->id . ' parent: ' . $menu->parent_id);


            $exited = (new WebsiteMenu())
                ->where('menu_id', $menu->id)
                ->where('type', 'site')
                ->where('type_id', $siteMembership->site_id)
                ->first();

            $deleted_menu_ids[] = $menu->id;

            if ($exited) {
                continue;
            }
            $parent_id = 0;
            if ($menu->parent_id) {

                $exited_p = (new WebsiteMenu())
                    ->where('menu_id', $menu->parent_id)
                    ->where('type', 'site')
                    ->where('type_id', $siteMembership->site_id)
                    ->first();

                if ($exited_p) {
                    $parent_id = $exited_p->id;
                } else {

                    $web_menu_p = new WebsiteMenu();
                    $web_menu_p->menu_id = $menu->parent_id;
                    $web_menu_p->parent_id = 0;
                    $web_menu_p->type = 'site';
                    $web_menu_p->type_id = $siteMembership->site_id;
                    $web_menu_p->serial = $serial++;
                    $web_menu_p->save();
                    $parent_id = $web_menu_p->id;
                }
                $deleted_menu_ids[] = $menu->parent_id;

            }


            $web_menu = new WebsiteMenu();
            $web_menu->menu_id = $menu->id;
            $web_menu->parent_id = $parent_id;
            $web_menu->type = 'site';
            $web_menu->type_id = $siteMembership->site_id;
            $web_menu->serial = $serial++;
            $web_menu->save();
        }

        $delete = (new WebsiteMenu())
            ->whereNotIn('menu_id', $deleted_menu_ids)
            ->where('type', 'site')
            ->where('type_id', $siteMembership->site_id)
            ->delete();

        return true;


    }

    public function saveOrUpdateWebMenu($site_id)
    {
       // dd('fsfsf');

        $site_info = SiteInfo::where('id', $site_id)->first();

        $package = EduPackage::find($site_info->siteMembership->edu_package_id ?? null);
        $package_module_ids = $package ? ($package->modules->pluck('id')->toArray()) : [];
        $assigned_package_sub_modules = SubModule::whereIn('module_id', $package_module_ids)->pluck('id')->toArray();
        $menus_array = SubModule::whereIn('id', $assigned_package_sub_modules)->pluck('menu_ids');

      

        $web_menu_ids_final = [];
        if ($menus_array) {
            foreach ($menus_array as $k => $value) {
                $exploded = explode(',', $value) ?? [];
                $web_menu_ids_final = array_unique(array_merge($web_menu_ids_final, $exploded));
            }
        }
      
        $web_menus = Menu::whereIn('id', $web_menu_ids_final)
            ->where('menu_for', 'website')
            ->where('is_displayable', true)
            ->get();
      ///     return $web_menus;
           
        $exited = (new WebsiteMenu())
            ->where('type', 'site')
            ->where('type_id', $site_id)
            ->delete();

        $serial = 1;
       // dd($web_menus);
        foreach ($web_menus as $k => $menu) {

//             \Log::info($menu->id . ' parent: ' . $menu->parent_id);
            $parent_id = 0;
            if ($menu->parent_id) {

                $parent_exited = (new WebsiteMenu())
                    ->where('type', 'site')
                    ->where('type_id', $site_id)
                    ->where('menu_id', $menu->parent_id)
                    ->first();

                if ($parent_exited) {
                    $parent_id = $parent_exited->id;

                } else {
                    $web_menu_p = new WebsiteMenu();
                    $web_menu_p->menu_id = $menu->parent_id;
                    $web_menu_p->parent_id = 0;
                    $web_menu_p->type = 'site';
                    $web_menu_p->type_id = $site_id;
                    $web_menu_p->serial = $serial++;
                    $web_menu_p->save();
                    $parent_id = $web_menu_p->id;
                }
            }

            $web_menu = new WebsiteMenu();
            $web_menu->menu_id = $menu->id;
            $web_menu->parent_id = $parent_id;
            $web_menu->type = 'site';
            $web_menu->type_id = $site_id;
            $web_menu->serial = $serial++;
            $web_menu->save();
        }
      //  dd(WebsiteMenu::where('type_id',154)->get());

        return Response::json(['message' => ' Total web menu regenerated:' . $serial, 'mode' => 'success'], 200);


    }

}
