<?php

namespace App\Http\Controllers\Edu\SitePayment;

use App\Models\Academic\AcademicMonthName;
use App\Models\Edu\SitePayment\EduInvoicePayment;
use App\Models\Edu\SitePayment\SiteInvoice;
use App\Models\Edu\SitePayment\SiteInvoiceDetail;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteMembership;

use App\Traits\SmsApiTrait;
use Auth;
use Carbon\Carbon;
use DB;
use Error;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Edu\SitePayment\SiteChallan;
use Illuminate\Validation\ValidationException;
use PDF;
use Session;

class SiteChallanController extends Controller
{

    private $sitePayment;
    private $siteMembership;
    private $siteInfo;
    private $invoice;
    private $invoiceDetail;

    public function __construct(SiteInvoice $invoice, SiteInvoiceDetail $invoiceDetail, EduInvoicePayment $sitePayment, SiteInfo $siteInfo, SiteMembership $siteMembership)
    {
        $this->middleware('auth');
        //  $this->middleware('sitepagechecker');
        $this->middleware('eduworlduserchecker');
        $this->siteInfo = $siteInfo;
        $this->siteMembership = $siteMembership;
        $this->sitePayment = $sitePayment;
        $this->invoice = $invoice;
        $this->invoiceDetail = $invoiceDetail;
    }
    public function index()
    {
        $viewType = 'Site challan';
        return view('default.admin.layouts.master', compact('viewType'));
    }
    public static function generateChalanNo()
    {
        $datePart = now()->format('Ymd');
        $prefix = 'CHL-' . $datePart . '-';

        $latest = SiteChallan::where('challan_no', 'like', $prefix . '%')
            ->orderBy('challan_no', 'desc')
            ->first();

        if ($latest) {
            $lastNumber = (int) substr($latest->challan_no, -4);
            $nextNumber = str_pad($lastNumber + 1, 4, '0', STR_PAD_LEFT);
        } else {
            $nextNumber = '0001';
        }

        return $prefix . $nextNumber;
    }
    public function create(Request $request)
    {
        $this->validate($request, [
            'invoice_date' => 'required',
            'site_id' => 'required|numeric|min:1',
        ]);
        SiteChallan::create([
            'site_id' => $request->site_id,
            'challan_date' => $request->invoice_date,
            'note' => $request->note,
            'challan_no' => $this->generateChalanNo(),
            'challan_details' => json_encode($request->details),
        ]);
        return 'dibe';
        // return $this->belongsTo(ItemDetail::class, self::ITEM_DETAILS_ID);

    }
    public function update(Request $request)
    {

        try {

            $this->validate($request, [
                'invoice_date' => 'required',
                'site_id' => 'required|numeric|min:1',
            ]);
            $SiteChallan = SiteChallan::where('id', $request->id)
                ->first();

            $SiteChallan->challan_date = $request->invoice_date;
            $SiteChallan->note = $request->note;
            $SiteChallan->challan_details = json_encode($request->details);
            $SiteChallan->save();

            return response()->json(['message' => $SiteChallan->challan_no . ' Successfully Updated!'], 200);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {

            throw new Error($exception->getMessage());
        }
    }

    public function getChallanList(Request $request)
    {

        $site_id    = $request->site_id;
        $paginate   = $request->paginate ?? 20;
        $invoice_no = $request->invoice_no;


        // Decode the JSON string into an associative array
        $date_range_array = json_decode($request->input('date_range'), true);
        if ($date_range_array !== null) {
            $start_date = isset($date_range_array['start']) ? $date_range_array['start'] : null;
            $end_date = isset($date_range_array['end']) ? $date_range_array['end'] : null;
        } else {
            $start_date = null;
            $end_date = null;
        }

        if ($date_range_array) {
            if (!$start_date || !$end_date) {
                throw new Error('Please Select Both Date');
            }
        }

        $list = SiteChallan::with('siteInfo')->when(isset($site_id), function ($query) use ($site_id) {
            return $query->where('site_id', $site_id);
        })
            ->when(isset($start_date) && isset($end_date), function ($query) use ($start_date, $end_date) {
                return $query->whereBetween('challan_date', [$start_date, $end_date]);
            })
            ->when(isset($invoice_no), function ($query) use ($invoice_no) {
                return $query->where('challan_no', 'like', '%' . $invoice_no . '%');
            })
            ->orderBy('id', 'DESC')
            ->paginate($paginate);


        return response()->json([$list], 200);
    }

    public function getChallanDetailsForPayment($id)
    {

        $list = SiteChallan::with('siteInfo')
            ->where('id', $id)
            ->first();

        $list->challan_details = json_decode($list->challan_details);
        $list->grand_total = array_sum(array_column($list->challan_details, 'item_final_amount'));
        return $list;
    }
    public function getChallanPdfReport($id)
    {
        $challan = $this->getChallanDetailsForPayment($id);

        //        dd($the_invoice->payments->last()->payment_date ??  '');
        $report_tittle = 'Challan Report-' . $challan->chdillan_no;


        // return view('default.admin.edu.site-payment.payment-report', compact('report_tittle', 'the_invoice'));
        $pdf = PDF::loadView('default.admin.edu.site-payment.challan-report', compact('report_tittle', 'challan'));
        return $pdf->stream(time() . '-invoice-no-' . $id . '.pdf');
    }
    public function deleteSiteChallan($id)
    {
        try {

            $the_invoice = SiteChallan::findOrFail($id);


            $the_invoice->delete();



            return response()->json(['message' => 'Deleted Successfully'], 200, []);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }
}
