<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/2/2016
 * Time: 3:42 PM
 */
namespace App\Http\Controllers\Floor;

use App\Http\Controllers\Controller;
use App\Forms\FloorForm;
use App\Forms\DataHelper;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Http\Requests\Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use App\Models\Building\Building;
use App\Models\Floor\Floor;
use Response;

class FloorController extends ProjectController
{
    use Lang, FormControll, DataHelper;

    private $floor;

    /**
     * @param Floor $floor
     */
    public function __construct(Floor $floor)
    {

        $this->middleware('auth');

        $this->floor = $floor;
    }


    public function index(){


        $viewType = 'Floor';
        return view('default.admin.layouts.master', compact('viewType', 'building_floor_list'));


//        return compact('building_floor_list');
    }

    public function getFloorList(Request $request){

        $data = $request->all();

        $building_floor_list=Building::with(['floors'])
            ->when(!empty($data['building_id']), function ($query) use ($data) {
                return $query->where('id', $data['building_id']);
            })
            ->get();

       return $building_floor_list;


//        return compact('building_floor_list');
    }



    /**
     * @param Validator $validatedRequest
     * @return mixed
     */
    public function createFloor(Request $request)
    {
        $check_data=$this->floor
            ->where('building_id', $request->building_id)
            ->where('floor_name', $request->floor_name)
            ->first();

        if($check_data){
            if($check_data->status==0){
                $check_data->status=1;
                $check_data->save();
            }
            else if($check_data->status==1){
                return Response::json(['message' => 'This Floor Name already present!.',
                    'mode' => 'Error!'], 200);
            }
        }
        else{
            $this->floor->create([
                'building_id'=>$request->building_id,
                'floor_name'=>$request->floor_name,
                'status'=>1,
            ]);

            return Response::json(['message' => 'Save Successfully!', 'mode' => 'save!'], 200);
        }
    }


    /**
     * @param $id
     * @param Validator $validatedRequest
     * @return null
     */
    public function editFloor(Request $request)
    {
        $check_same_name=$this->floor->where('floor_name', $request->floor_name)
            ->where('building_id', $request->building_id)
            ->where('id', '!=', $request->id)
            ->first();

        if($check_same_name){
            return Response::json(['message' => 'This Floor Name already present!.',
                'mode' => 'Error!'], 200);
        }
        else{
            $this->floor->where('id', $request->id)
                ->update([
                    'floor_name'=>$request->floor_name,
                    'status'=>1,
                ]);
        }
        return Response::json(['message' => 'Update Successfully!', 'mode' => 'save!'], 200);
    }

    /**
     * @param $id
     * @return $this
     */
    public function deleteFloor(Request $request)
    {
        $this->floor->where('id', $request->id)
            ->delete();


        return Response::json(['message' => 'Delete Successfully!', 'mode' => 'save!'], 200);

    }

    /**
     * @param $buildId
     * @param Floor $floor
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function floorOfBuilding($buildId, Building $building, Request $request)
    {
        $selectedBuilding = $building->findOrFail($buildId);
        //dd($selectedBuilding);
        $floorForBuilding = $selectedBuilding->floors;
        if( $request->ajax()){
            return response()->json( [$floorForBuilding]);
        }
    }
}