<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/26/2016
 * Time: 4:03 PM
 */
namespace App\Http\Controllers\GeneralReport;

use App\Http\Controllers\Controller;
use App\Forms\DataHelper;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\Result\TotalResultSetting;
use App\Models\Result\TotalResultSystem;
use App\Models\Role\Role;
use App\Models\Student\Section;
use App\Models\Student\StudentClass;
use App\Models\Subject\Subject;
use App\Models\User\User;
use App\Models\Examinations\Examination;
use App\Models\Examinations\ExaminationSchedule;
use App\Models\Routine\Routine;
use App\Models\Marks\Marks;
use App\Models\Marks\MarksType;
use App\Models\Result\ResultSetting;
use Illuminate\Http\Request;
use App\Http\Requests;

class GeneralReportController extends ProjectController
{
    use Lang, FormControll, DataHelper;


    public function __construct(Subject $subject)
    {
        $this->middleware('auth');
        $this->subject = $subject;
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function generalReportPage()
    {

        $viewType = 'Get General report';
        return view('default.admin.reports.general-report', compact('viewType'));
    }

    /**
     * @param null $teacherId
     */
    public function generateTeacherReport(Request $request, User $user, Role $role)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $teacherId = $request->teacherId;
        //dd($teacherId);

        if ((int)$teacherId == 0) {
            $roleId = $this->role('Teacher');
            $roleOfTeacher = $role->findOrFail($roleId);
            $teacherList = $roleOfTeacher->users;
            $teachersWithPhotos = array();
            foreach ($teacherList as $teacher) {

                if (count($teacher->photos) > 0)

                    $teachersWithPhotos[$teacher->photos->last()->name] = $teacher;
            }
            //dd($teachersWithPhotos);
            return view('default.admin.reports.teacher-report-all', compact('teacherList', 'locale', 'defaultLocale', 'teachersWithPhotos'));
        } else {
            $teacherProfile = $user->findOrFail($teacherId);
            $photo = $teacherProfile->photo->last()->name;
            $teacherReport = $user->with('designation', 'gender', 'religion', 'department')->findOrFail($teacherId);

            return view('default.admin.reports.teacher-report-individual', compact('teacherReport', 'locale', 'defaultLocale', 'photo'));
        }

    }

    /**
     * @param Request $request
     * @param User $user
     * @param Role $role
     */
    public function generateStudentReport(Request $request, User $user, Role $role, StudentClass $studentClass, Section $section)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $studentClassId = $request->studentClassId;
        $sectionId = $request->sectionId;
        $studentId = $request->studentId;
        //dd($studentClassId);

        if ((int)$studentClassId == 0 && (int)$sectionId == 0 && (int)$studentId == 0) {
            $roleId = $this->role('Student');
            $roleOfStudent = $role->findOrFail($roleId);
            $studentList = $roleOfStudent->users;
            $studentsWithPhotos = array();
            foreach ($studentList as $student) {
                $student->stclass = $student->stClass->class_name;
                $student->Section = $student->section->section_name;

                //dd($student->stclass->class_name);
                if (count($student->photos) > 0)

                    $studentsWithPhotos[$student->photos->last()->name] = $student;
            }
            //dd($studentsWithPhotos);
            return view('default.admin.reports.student-report-all', compact('studentList', 'locale', 'defaultLocale', 'studentsWithPhotos'));
        } else if ((int)$studentClassId != 0 && (int)$sectionId == 0 && (int)$studentId == 0) {
            $studentClass = $studentClass->findOrFail($studentClassId);
            $roleId = $this->role('Student');
            $roleOfStudent = $role->findOrFail($roleId);
            $studentList = $roleOfStudent->users()
                ->whereStudentClassId($studentClassId)
                ->get();
            $studentsWithPhotos = array();
            foreach ($studentList as $student) {
                $student->Section = $student->section->section_name;
                if (count($student->photos) > 0)

                    $studentsWithPhotos[$student->photos->last()->name] = $student;
            }
            //dd($studentsWithPhotos);
            return view('default.admin.reports.student-report-class-wise', compact('studentClass', 'studentList', 'locale', 'defaultLocale', 'studentsWithPhotos'));
        } else if ((int)$studentClassId != 0 && (int)$sectionId != 0 && (int)$studentId == 0) {
            $studentClass = $studentClass->findOrFail($studentClassId);
            $studentSection = $section->findOrFail($sectionId);
            $roleId = $this->role('Student');
            $roleOfStudent = $role->findOrFail($roleId);
            $studentList = $roleOfStudent->users()
                ->whereStudentClassId($studentClassId)
                ->whereSectionId($sectionId)
                ->get();
            $studentsWithPhotos = array();
            foreach ($studentList as $student) {
                $student->Section = $student->section->section_name;
                if (count($student->photos) > 0)

                    $studentsWithPhotos[$student->photos->last()->name] = $student;
            }
            //dd($studentSection);
            return view('default.admin.reports.student-report-section-wise', compact('studentClass', 'studentSection', 'studentList', 'locale', 'defaultLocale', 'studentsWithPhotos'));
        } else {
            $studentClass = $studentClass->findOrFail($studentClassId);
            $studentSection = $section->findOrFail($sectionId);
            $singleStudent = $user->findOrFail($studentId);
            $guardianId = $singleStudent->guardian_id;
            $guardianData = $user->findOrFail($guardianId);
            //dd($singleStudent);
            $photo = $singleStudent->photo->last()->name;
            return view('default.admin.reports.student-report-individual', compact('studentClass', 'studentSection', 'singleStudent', 'guardianData', 'locale', 'defaultLocale', 'photo'));
        }
    }

    public function generateRoutineReport(Request $request, User $user, Role $role, StudentClass $studentClass, Section $section, Routine $routine)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $studentClassId = $request->studentClassId;
        $sectionId = $request->sectionId;
        $studentClass = $studentClass->findOrFail($studentClassId);
        $section = $section->findOrFail($sectionId);
        $routineList = $routine->with('subject', 'building', 'floor', 'room', 'teacher', 'coordinator')
            ->whereStudentClassId($studentClassId)
            ->whereSectionId($sectionId)
            ->get();

        $routineArray = [];
//        dd($routineList);
        foreach ($routineList as $routine) {

            $routineArray[$routine->weekday][] = $routine;

        }


        return view('default.admin.reports.class-routine-report', compact('studentClass', 'section', 'routineList', 'mostNumberOfClasses', 'routineArray', 'locale', 'defaultLocale'));
    }

    public function generateExamRoutineReport(Request $request, StudentClass $studentClass, Section $section, Examination $examination, ExaminationSchedule $examinationSchedule)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $examId = $request->examId;
        $studentClassId = $request->studentClassId;
        $sectionId = $request->sectionId;
        $examName = $examination->findOrFail($examId);
        $className = $studentClass->findOrFail($studentClassId);
        $sectionName = $section->findOrFail($sectionId);
//        dd($examName);

        $examinationScheduleList = $examinationSchedule->with('subject', 'building', 'floor', 'room')
            ->whereExaminationId($examId)
            ->whereStudentClassId($studentClassId)
            ->whereSectionId($sectionId)
            ->get();
//        dd($examinationScheduleList);

        return view('default.admin.reports.exam-routine-report', compact('examName', 'className', 'sectionName', 'examinationScheduleList', 'locale', 'defaultLocale'));
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */

    private function subjectMarksType($studentClassId)
    {

        $marksTypes = \DB::table('subjects')
            ->join('student_classes', 'student_classes.id', '=', 'subjects.student_class_id')
            ->select('subjects.subject_name', 'subjects.subject_marks_type', 'subjects.marks_type_info')
            ->get();


        return $marksTypes;
    }


    private function rejected()
    {
        /*$studentClass =$studentClasses
           ->with('subjects','resultSystem','classTeacher','students')
           ->findOrFail($studentClassId);

       $section = $sections->with('users','classTeacher','studentClass')->findOrFail($sectionId);
       $students = $studentClass->students->where('section_id',$section->id);
//        dd($students);
       $subjectsOfTheClass = collect([]);

       if (isset($studentClass) && !is_null($studentClass)) {

           $subjectsOfTheClass = $studentClass->subjects;
       }
       $numberOfSubjects = $subjectsOfTheClass->count();
       $resultSystem = $studentClass->resultSystem;
       $resultSystemForTheClass = explode(',',json_decode($resultSystem->setting_ids));




       $resultRule = 'grade';
       if(!is_null($resultSystem)){
           $resultRule = $resultSystem->result_rule;
       }

       if ($resultRule == 'grade') {

       }

       if ($resultRule=='division') {

       }

       $resultSettings = new ResultSetting();*/
    }
}