<?php

namespace App\Http\Controllers\Language;

use App\Http\Controllers\Login\LoginController;
use App\Http\Controllers\ProjectController;
use App\Models\Site\SiteInfo;
use App\Models\Status\Status;
use App\User;
use DB;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Foundation\Application;

class LanguageController extends ProjectController
{
    private $app;

    public function __construct(Application $app)
    {

          $this->middleware('auth');

        $this->app = $app;
    }


    /**
     * @return Application
     */
    public function testApi(Request $r)
    {
        $json = $r->data;


//    dd($r->data);
//    dd($_GET["data"]);


        $datas = json_decode($json, true);

        foreach ($datas as $data) {
            $values = $data['id'];

            //   dd($values);
            $status = new  Status();
            $status->NAME = $values;
            $status->save();
        }


    }

    public function langChooser($locale)
    {
   
        if (is_null($locale))
            abort(404);

        !array_key_exists($locale, $this->app->config->get('app.locales')) ? $locale = $this->app->config->get('app.fallback_locale') : $locale = $locale;
        Session::put('locale', $locale);
      
        
        //dd($locale);
        $this->app->setLocale($locale);
     //   dd($this->app->config->get('app.locales'));
        $user_id = request()->user()->id;
        if (file_exists(base_path("resources/views/default/sidebars/" . Session::get('ALIAS') . '/' . $user_id . '.blade.php'))) {
            unlink(base_path("resources/views/default/sidebars/" . Session::get('ALIAS') . '/' . $user_id . '.blade.php'));
        }

        $get_user=User::findOrFail($user_id);
        $get_user->locale=$locale;
        $get_user->save();
      //  dd($get_user);
        $this->checkUserAliasDetails();


        return redirect()->back();


    }

    public function checkUserAliasDetails()
    {

        $user_type = Session::get('USER_TYPE');
        $user_alias = Session::get('ALIAS1');
       // dd($user_alias);

        if ($user_type == 'eduworld') {

            if ($user_alias != 'eduworld') {

                $site_info = SiteInfo::where('id', Session::get('SITE_ID'))->first();


                if ($site_info) {
                    Session::put('FULL_NAME', $site_info->site_name);
                } else {

                    $site_group = DB::table('site_groups')->where('group_alias', $user_alias)->first();

                    Session::put('FULL_NAME', $site_group->name);
                }
            }
        } else if ($user_type == 'site') {

            $site_info = SiteInfo::where('id', Session::get('SITE_ID'))->first();

            Session::put('FULL_NAME', $site_info->site_name);


        } else if ($user_type == 'site_group') {//site_group

            $site_group = DB::table('site_groups')->where('group_alias', $user_alias)->first();

            Session::put('FULL_NAME', $site_group->name);


        }


    }
}
