<?php

namespace App\Http\Controllers\Login;

use App;
use App\Http\Controllers\Edu\Fetch\FetchLogController;
use App\Models\Academic\AcademicGroup;
use App\Models\Company\GlobalCompany;
use App\Models\Edu\Device\DeviceLog;
use App\Models\Site\SiteInfo;
use App\Models\Site\StudentRegistration\GlobalSiteBaseStudentRegistrationDeclare;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\SiteGroup\GlobalSiteGroupSetting;
use App\Traits\RequestHandlingWithMachine;
use App\User;
use Carbon\Carbon;
use DB;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Auth\RedirectsUsers;
use Illuminate\Http\Request;
use Artisan;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\Controller;
use App\Http\Requests\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Contracts\Auth\Guard;

class LoginController extends Controller
{

    use RedirectsUsers, RequestHandlingWithMachine;

    /*
     *
     * @newly added properties
     *
     * $redirectPath works when u r registered or logged in successfully
     *
     * $loginPath works after unsccesfull try to log in
     *
     */
    protected $redirectPath = 'employee';
    protected $loginPath = 'auth/login';
    private $user;
    private $request;
    private $auth;
    private $app;


    /**
     * LoginController constructor.
     * @param User $user
     * @param Request $request
     * @param Guard $auth
     */
    public function __construct(User $user, Request $request, Guard $auth, Application $app)
    {
        $this->user = $user;
        $this->request = $request;
        $this->auth = $auth;
        $this->app = $app;

    }

    public function loginRedirectResponse(){
        return response()->json(['message'=>'Token Mission', 'mode'=>'errors', 'status'=>'401'],401);
        //dd('page');
    }

    public function loginPage()
    {

        $viewType = 'Login';

      //  dd(Session::get("USER_TYPE"));

        /*if (!$this->checkUserAlias()) {
            return view('default.auth.wrong-url', compact('viewType'));
        }*/

        if ($this->auth->guest()) {
            if (!$this->checkUserAlias()) {
                return view('default.auth.wrong-url', compact('viewType'));
            }

//dd(Session::get("USER_TYPE"));
       

            if (Session::get("USER_TYPE") == 'eduworld') {
              return  redirect()->to('/edu/login');
            }
            // if (Session::get("USER_TYPE") == 'site_group') {
            //     return redirect()->route('site-group-login-form');
            // //  return  redirect()->to('/login');
            // }
            //dd($this->auth->guest());


            return view('web.index', compact('viewType'));


           // return view('layouts.auth', compact('viewType', 'std_registration_declared_time_present'));

           // return view('default.auth.login', compact('viewType', 'std_registration_declared_time_present'));
        }
        return redirect()->intended(route('admin'));
    }

    



    public function apiLogin(Request $request)
    {
       // \Log::info($request);

        $this->validate($request, [
            'username' => 'required',
            'password' => 'required'
        ]);


        $credentials = [
            'username' => $request->username,
            'password' => $request->password
        ];

        if (Auth::attempt($credentials)) {
            // $token = auth()->user()->createToken('AppName')->accessToken;
            // $success['token'] =  $token;
            // $success['name'] =  auth()->user()->name;
            // $success['id'] =  auth()->user()->id;
            $user = Auth::user();
            //$success['token'] = $user->createToken('AppName')->accessToken;
            $success['user'] = $user;
            $success['token'] = $user->createToken('AppName')->accessToken;
            return response()->json($success, 200);
        } else {
            return response()->json(['message' => 'UnAuthorised'], 401);
        }
    }




    private function getSiteActivity()
    {
        $domain = "";
        if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
            $getHost = explode(".", $_SERVER['HTTP_HOST']);
            $domain = array_shift($getHost);
        }

        $site_list = SiteInfo::select('id', 'site_logo')->where('site_alias', $domain)->first();


        $date_formate = Carbon::today();
        $today = $date_formate->format('Y-m-d');


        if ($site_list) {
            $registration_declare_group_ids = GlobalSiteBaseStudentRegistrationDeclare::where('site_id', $site_list->id)
                ->where('duration_from_date', '<=', $today)
                ->where('duration_to_date', '>=', $today)
                ->where('status', true)
                ->pluck('academic_group_id')
                ->unique();

        } else {
            $registration_declare_group_ids = [];
        }


        if (count($registration_declare_group_ids) > 0) {
            $std_registration_declared_time_present = 1;
        } else {
            $std_registration_declared_time_present = 0;

        }


        return $std_registration_declared_time_present;
    }


    /**
     * @param Validator $validatedRequest
     */
    public function login(Request $validatedRequest)
    {

        $this->validate($validatedRequest, [
            'username' => 'required',
            'password' => 'required'
        ]);
       // dd('sf');
     
        if ($this->auth->guest()) {
         //   dd(Auth::attempt(['email' => $validatedRequest->username, 'password' => $validatedRequest->password]));

            if (isEmail($validatedRequest->username)) {
                if (Auth::attempt(['email' => $validatedRequest->username, 'password' => $validatedRequest->password], request('remember', false))) {
                    $userStatus = Auth::User()->status;
                  
                    if ($userStatus == '1') {
                        $this->checkAfterLogin();
                        return redirect()->intended(route('admin'));
                    } else {
                        Auth::logout();
                        Session::flush();
                        return back()->withErrors('Sorry !!! You are temporary blocked. please contact to admin');
                    }
                } else {
                    return response()->json(['message' => 'Incorrect Username Or Password!'], 412);
                  //  return back()->withErrors('Incorrect email or password!');

                }
            } else {

                if (Auth::attempt($this->loginByUsernameOrContactNumber($validatedRequest), request('remember', false))) {
                    $userStatus = Auth::User()->status;
                    if ($userStatus == '1') {
                        $this->checkAfterLogin();
                        return redirect()->intended(route('admin'));
                    } else {
                        Auth::logout();
                        Session::flush();
                        return back()->withErrors('Sorry !!! You are temporary blocked. please contact to admin');
                    }
                } else {
                    return response()->json(['message' => 'Incorrect Username Or Password!'], 412);

                  //  return back()->withErrors('Incorrect username or password!');

                }
            }
        }
        //locale

        //  dd(Auth::user()->locale);

        if (Session::get('locale')) {
            $locale = Session::get('locale');
        } else {
            $locale = $this->app->config->get('app.fallback_locale');
            Session::put('locale', $locale);
        }
        Session::put('language', $this->app->config->get('app.locales')[$locale]);
        $this->app->setLocale(Auth::user()->locale);


        return redirect()->route('admin');
    }


    /**
     * @return string
     */
    public function loginUsername()
    {
        return property_exists($this, 'username') ? $this->username : 'email';
    }

    /**
     * @param $validatedRequest
     * @return array
     */
    protected function credentials(Request $validatedRequest)
    {

        return [
            'email' => $validatedRequest->email,
            'password' => $validatedRequest->password
        ];
    }


    public function loginByUsernameOrContactNumber($validatedRequest)
    {

        return [
            'username' => $validatedRequest->username,
            'password' => $validatedRequest->password
        ];
    }

    /**
     * @return \Illuminate\Http\RedirectResponse
     */
    public function roleCheck()
    {
        return redirect()->intended(route('admin'));
    }

    /**
     * @return \Illuminate\Http\RedirectResponse
     */
    public function logout()
    {
        Auth::logout();
        Session::flush();
        if ($this->auth->check()) {
            Auth::logout();
            Session::flush();
        }
        return redirect()->route('login-form');
    }

    public function checkUserAlias()
    {
        $domain = "";
        if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
            $getHost = explode(".", $_SERVER['HTTP_HOST']);
            $domain = array_shift($getHost);
        }

        // Session::flush();


        $edu = ['eduworld', 'eduworlderp', 'eduworldapp', 'artshop'];

        // in_array($domain, $number_list)

        if (in_array($domain, $edu)) {

            //dd('edu');
            Session::put('USER_TYPE', 'eduworld');
            Session::put('ALIAS', 'eduworld');
            Session::put('ALIAS1', 'eduworld');
          //  Session::put('LOGO', 'edu.png');
            Session::put('LOGO_PATH', 'image/edu.png');
            Session::forget('FULL_NAME');

            return true;


        } else {//site_group or site


            $site_info = SiteInfo::where('site_alias', $domain)->first();
            if ($site_info) {//site

              //  $s_setting = $site_info->siteInfoSettings()->first();

                Session::put('SITE_ID', $site_info->id);
               // Session::put('ACADEMIC_GROUP_ID', $s_setting->academic_group_id ?? 0);
               // Session::put('ACADEMIC_GROUP_NAME', $s_setting->academicGroup->academic_group_name ?? 0);

                Session::put('ALIAS', $site_info->site_alias);
                Session::put('ALIAS1', $site_info->site_alias);
                Session::put('USER_TYPE', 'site');
              //  Session::put('FULL_NAME', $site_info->site_name);
              //  Session::put('LOGO', $site_info->site_logo);
                Session::put('LOGO_PATH', $site_info->site_logo);

                return true;

            } else if ($site_group = GlobalSiteGroup::where('group_alias', $domain)->first()) {//site_group

                Session::put('SITE_GROUP_ID', $site_group->id);
                Session::put('ALIAS', $site_group->group_alias);
                Session::put('ALIAS1', $site_group->group_alias);
                Session::put('USER_TYPE', 'site_group');
                Session::put('FULL_NAME', $site_group->name);
                Session::put('LOGO_PATH', 'img/site_group/logo/' . $site_group->group_logo);

                $academic_group_ids=explode(',',$site_group->academic_group_ids);

                $get_acc_group_ids = GlobalSiteGroupSetting::where('site_group_id', Session::get('SITE_GROUP_ID'))
                    ->pluck('academic_group_id')
                    ->unique()
                    ->values();
                if (count($get_acc_group_ids) && count($academic_group_ids)) {
                 //   \Log::info('site Group');
                    $acc_gr = AcademicGroup::whereIn('id', $get_acc_group_ids)
                        ->whereIn('id',$academic_group_ids)
                        ->orderBy('serial')
                        ->first();

                    Session::put('ACADEMIC_GROUP_ID', $acc_gr->id ?? 0);
                    Session::put('ACADEMIC_GROUP_NAME', $acc_gr->academic_group_name ?? 0);
                    Session::put('ACADEMIC_KEY', $acc_gr->academicGroup->academic_key ?? 0);


                    return true;

                }


            } else if ($company = GlobalCompany::where('alias', $domain)->first()) {//company

                Session::put('COMPANY_ID', $company->id);
                Session::put('ALIAS', $company->alias);
                Session::put('ALIAS1', $company->alias);
                Session::put('USER_TYPE', 'company');
                Session::put('FULL_NAME', $company->name);
               // Session::put('LOGO', $company->logo);
                Session::put('LOGO_PATH', 'img/company/' . $company->logo);

                return true;

            }
        }


        return false;

    }

    public function checkAfterLogin()
    {


    }

}
