<?php

namespace App\Http\Controllers\Menu;

use App\Forms\DataHelper;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\Menu\Menu;
use App\Models\Menu\MenuUsingRoute;
use App\Models\Modules\Module;
use App\Models\Modules\SubModule;
use DB;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use League\Flysystem\Exception;
use PDF;

class
MenuController extends ProjectController
{
    use Lang, FormControll, DataHelper;


    private $menu;
    private $subModule;

    public function __construct(Menu $menu, SubModule $subModule)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->menu = $menu;
        $this->subModule = $subModule;
    }

    public function index()
    {
        $viewType = 'Menu List';
        $model = $this->menu;
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $menus = $this->menu->orderBy('id', 'DESC')->paginate(5000);

        return view('default.admin.menus.index', compact('menus', 'locale', 'defaultLocale', 'viewType', 'model'));
    }

    public function createMenuForm()
    {
        $viewType = 'Create Menu';
        return view('default.admin.menus.create', compact('viewType'));
    }

    public function menuUsingRouteAttachment($id = null)
    {
        $viewType = 'Menu Using Route';

        if ($id) {
            $menu_id = $id;
            $sub_modules = $this->subModule->pluck('menu_ids', 'id');

            $sub_module_ids = [];
            foreach ($sub_modules as $k => $sub_module) {

                $exploded = explode(',', $sub_module);

                if (count($exploded) > 0 && in_array($menu_id, $exploded)) {

                    $sub_module_ids[] = $k;
                }
            }

            $got_sub_modules = (new SubModule())
                ->whereIn('id', $sub_module_ids)
                //->with('module')
                ->get();

            /*       $got_modules = Module::whereHas('subModule',function ($q) use ($sub_module_ids) {
                       $q->whereIn('id', $sub_module_ids);
                   })->pluck('name', 'id');*/


           //    dd($got_sub_modules);

            $page_tittle = "menu usage to module and sub module";

             return view('edu.menu-usages-to-module', compact('got_sub_modules','page_tittle'));
            $pdf = PDF::loadView('edu.menu-usages-to-module', compact('got_sub_modules', 'page_tittle'));
            return $pdf->stream(time() . '-menu-usage.pdf');


        }


        return view('default.admin.layouts.master', compact('viewType'));

        return view('default.admin.menus.menu-using-routes-attachment', compact('viewType'));
    }

    public function createMenu(Requests\Validator $validatedRequest)
    {
        if ($validatedRequest->parent_id && $this->parentLevelInCorrect($validatedRequest->parent_id, $validatedRequest->is_displayable)) {
            return back()->withErrors('Parent Level InCorrect!')->withInput();
        }
        if (!$validatedRequest->parent_id && !$validatedRequest->is_displayable) {
            return back()->withErrors('Api Should have parent!')->withInput();
        }

        if (isset($this->menu->ownFields)) {
            foreach ($this->menu->ownFields as $ownField) {
                if ($validatedRequest->{$ownField} || $validatedRequest->status || $validatedRequest->is_displayable || $validatedRequest->is_common_access || $validatedRequest->is_logged_common_access) {
                    $this->menu->{$ownField} = $validatedRequest->{$ownField};
                }
            }
        }

        foreach ($this->menu->translatedAttributes as $field) {
            foreach (config('app.locales') as $locale => $value) {
                if ($validatedRequest->get($field . '_' . $locale)) {
                    $this->menu->translateOrNew($locale)->{$field} = $validatedRequest->get($field . '_' . $locale);
                }
            }
        }

        $this->menu->save();
        return back()->withSuccess('Menu Successfully Created');
    }

    public function editMenuForm($id)
    {
        $viewType = 'Edit Menu';
        $menuToEdit = $this->editFormModel($this->menu->findOrFail($id));
        return view('default.admin.menus.edit', compact('menuToEdit', 'viewType'));

    }


    public function editMenu($id, Requests\Validator $validatedRequest)
    {

        if ($validatedRequest->parent_id && $this->parentLevelInCorrect($validatedRequest->parent_id, $validatedRequest->is_displayable)) {
            return back()->withErrors('Parent Level InCorrect!')->withInput();
        }
        if (!$validatedRequest->parent_id && !$validatedRequest->is_displayable) {
            return back()->withErrors('Api Should have parent!')->withInput();
        }

        $menuToEdit = $this->menu->findOrFail($id);

        if (isset($menuToEdit->ownFields)) {
            foreach ($menuToEdit->ownFields as $ownField) {
                if ($validatedRequest->{$ownField} || $validatedRequest->status || $validatedRequest->is_displayable || $validatedRequest->is_common_access || $validatedRequest->is_logged_common_access) {
                    $menuToEdit->{$ownField} = $validatedRequest->{$ownField};
                }
            }
        }

        foreach ($menuToEdit->translatedAttributes as $field) {
            foreach (config('app.locales') as $locale => $value) {
                if ($validatedRequest->get($field . '_' . $locale)) {
                    $menuToEdit->translateOrNew($locale)->{$field} = $validatedRequest->get($field . '_' . $locale);
                }
            }
        }

        return $menuToEdit->save() ? back()->withSuccess('Successfully Updated') : null;
    }

    public function deleteMenu($id)
    {


        $subModuleHasTheRoute = DB::select('SELECT * FROM sub_modules WHERE FIND_IN_SET(?,menu_ids) > 0 LIMIT 1;', [$id]);


        if (count($subModuleHasTheRoute) > 0) {
            return back()->withError('Dependency Found in Sub Module: ' . $subModuleHasTheRoute[0]->name . ' ID: (' . $subModuleHasTheRoute[0]->id . ')');
        }
        $menuToDelete = $this->menu->findOrFail($id);
        if ($menuToDelete->delete()) {
            $menuToDelete->deleteTranslations();
            return back()->withSuccess('The Route Successfully Deleted');
        }
    }

    public function searchMenu(Request $request)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $menuName = $request->menuName;

        $menus = \DB::table('menus')
            ->join('menu_translations', 'menus.id', '=', 'menu_translations.menu_id')
            ->select('menus.*', 'menu_translations.menu_name')
            ->where('menus.route_name', 'LIKE', '%' . $menuName . '%')
            ->get();

        return view('default.admin.menus.menu_search', compact('menus', 'locale', 'defaultLocale'));
    }


    public function getPositionForParentMenu(Request $request)
    {
        $parent_ids = Menu::whereParentId($request->parent_id)->orderBy('position')->pluck('position');
        return $parent_ids;
    }


    public function getMenuReport($id = null)
    {
        $viewType = 'Menu report';
        $locale = $this->chosenLanguage();
        $menu_using_route = null;
        $menus = [];

        if ($id) {
            $menu_using_route = $this->menu
                ->whereId($id)
                ->first();
        } else {

            $menus = $this->menu->with('childMenu.childMenu')
                ->whereStatus(1)
                ->where('route_name', 'NOT LIKE', '%#%')
                ->where('is_displayable', 1)
                ->whereIsCommonAccess(0)
                ->orderBy('position', 'Asc')
                ->get();
        }
//        $viewType = 'Room';
        return view('default.admin.layouts.master', compact('menus', 'viewType', 'locale', 'menu_using_route'));
        return view('default.admin.menus.menu-report', compact('menus', 'viewType', 'locale', 'menu_using_route'));
    }

//Custom methods=====================
    public function getForList($for)
    {
        try {

            if ($for) {

                $this->menuForList();

            } else {

            }

        } catch (Exception $exception) {

        }
    }


    public function parentLevelInCorrect($parent_id, $is_displayable)
    {
        $parent = $this->menu->findOrFail($parent_id);

        if ($parent && $parent->parent_id) {
            $parent1 = $this->menu->findOrFail($parent->parent_id);
            if ($parent1 && $parent1->parent_id && $is_displayable) {
                return true;
            }
        }
        return false;
    }


    public function getParentMenuListWithoutPaginate()
    {
        try {
            $parent_menu = $this->menu
                ->with('childMenu.childMenu')
                ->whereStatus(1)
                ->whereparentId(0)
                ->whereIsCommonAccess(0)
                ->orderBy('position', 'Asc')
                ->get();
            return $parent_menu;
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function getDisplayableMenuListWithoutPaginate()
    {
        try {
            $parent_menu = $this->menu
                ->whereStatus(1)
                ->whereIsDisplayable(1)
                ->where('route_name', 'NOT LIKE', '%#%')
                ->whereIsCommonAccess(0)
                ->orderBy('id', 'Asc')
                ->get();
            return $parent_menu;
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }


    public function getMenuListWithRouteAttachedIdsByMenuId($id)
    {

        try {

            //check if the menu has displayable child
            $has_child = $this->menu
                ->whereparentId($id)
                ->where('is_displayable', 1)
                ->first();

            if ($has_child) {
                return JsonResponse::create(['message' => 'This route can"t be A page'], 410);
            }


            $parent_menu = $this->menu
                ->with(['childMenu.childMenu.childMenu' => function ($query) {
                    $query->where('is_displayable', 0);
                }])/*->whereHas('childMenu.childMenu', function ($query) {
                $query->where('is_displayable', 0);
            }, '>=', 1)*/
                ->has('childMenu', '>=', 1)
                ->whereStatus(1)
                ->whereParentId(0)
                ->whereIsCommonAccess(0)
                ->orderBy('position', 'ASC')
                ->paginate(100);


            $theMenu = Menu::findOrFail($id);
            $using_routes_ids = $theMenu->routes()->pluck('route_id');
            $already_used_route = Menu::whereIn('id', $using_routes_ids)
                ->orderBy('position', 'ASC')
                ->get();
            // return $parent_menu;


            return response()->json([$parent_menu, $using_routes_ids, $already_used_route], 200, [], JSON_NUMERIC_CHECK);

        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function saveRouteIdsForMenu(Request $request)
    {
        try {

            $this->validate($request, [
                'menu_id' => 'required'
            ]);

            $menu_id = $request->menu_id;
            $attached_route_ids = $request->attached_route_ids;
            $total_route = count($attached_route_ids);
            $theMenu = Menu::findOrFail($menu_id);
            $theMenu->routesForInsert()->sync($attached_route_ids);

            return JsonResponse::create(['message' => $total_route . ' Route Attached Successfully!'], 200);

        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function getAttachedListByMenu($menu_id)
    {
        try {
            $theMenu = Menu::findOrFail($menu_id);
            $using_routes_ids = $theMenu->routes()->pluck('route_id');
            $already_used_route = Menu::whereIn('id', $using_routes_ids)
                ->orderBy('id', 'DESC')
                ->get();
            return $already_used_route;

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'message' => 'Sub Module not found',
            ], 410);
        } catch (Exception $exception) {
            return response()->json([
                'message' => 'Something Went Wrong!',
            ], 410);
        }
    }

}
