<?php

namespace App\Http\Controllers\Package;

use App\Models\Modules\Module;
use App\Models\Package\EduPackage;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;

class EduPackageController extends Controller
{

    private $eduPackage;

    public function __construct(EduPackage $eduPackage)
    {
        $this->middleware('auth');
        $this->eduPackage = $eduPackage;
        $this->middleware('eduworlduserchecker');

    }

    public function attachedList()
    {
        $viewType = 'Module Attachment To Package';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.package.attached-list', compact('viewType'));
    }

    public function getAllEduPackages()
    {
        try {
            return $this->eduPackage
                ->get();
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 411);

        }

    }

    public function getEduPackagesForCompany()
    {
        try {
            return $this->eduPackage
                ->where('type', 'company')
                ->get();
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 411);

        }

    }

    public function getEduPackagesForSite()
    {
        try {
            return $this->eduPackage
                ->where('type', 'site')
                ->get();
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 411);
        }
    }

    public function getEduPackagesForSiteGroup()
    {
        try {
            return $this->eduPackage
                ->where('type', 'site_group')
                ->get();
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 411);

        }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return JsonResponse
     */
    public function getAttachedModuleForThePackage($id)
    {
        try {

            $package = $this->eduPackage->findOrFail($id);

            // dd($package->type);

            $module_for = [];

            if ($package->type == 'edu') {
                $module_for = ['all', 'edu', 'company', 'site_group', 'site', 'ecsgs', 'ecsg'];
            } elseif ($package->type == 'company') {
                $module_for = ['all', 'company', 'site_group', 'site', 'ecsgs', 'ecsg'];
            } elseif ($package->type == 'site_group') {
                $module_for = ['all', 'site_group', 'site', 'ecsgs', 'ecsg'];

            } elseif ($package->type == 'site') {
                $module_for = ['all', 'site', 'ecsgs'];

            }

            $moduleList = Module::with('subModule')
                ->whereIn('module_for', $module_for)
                ->orderBy('id', 'DESC')
                ->get();


            $assignedModules = $package->modules->pluck('id') ?? [];
            return Response::json([$moduleList, $assignedModules]);

        } catch (Exception $e) {

            if ($e instanceof ModelNotFoundException) {
                return Response::json([
                    'message' => 'Sub Module not found',
                ], 404);
            }
        }
    }

    public function assignSubModuleToGroup(Request $req)
    {

        $this->validate($req, [
            'selectedModule' => 'required',
            'selected' => 'required'
        ]);

        $module_ids = $req->selectedModule;
        $package_id = $req->selected;
        $total = count($module_ids);

        $thePackage = EduPackage::findOrFail($package_id);
        $thePackage->modules()->sync($module_ids);


        return Response::json(['message' => $total . 'Module Attached Done Successfully!'], 200);
    }


}
