<?php

namespace App\Http\Controllers\Role;

use App\Forms\AssignRole;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\Menu\Menu;
use App\Models\Permission\GroupAccess;
use App\Models\Role\Role;
use App\Models\Site\SiteAccess;
use App\Models\User\User;
use Illuminate\Http\Request;
use App\Http\Requests\Validator;
use App\Models\Site\SiteInfo;
use App\Http\Requests;
use App\Http\Controllers\Controller;


class RolesController extends ProjectController
{
    use Lang, FormControll;

    private $role;

    /**
     * RolesController constructor.
     * @param Request $request
     * @param Role $role
     */
    public function __construct( Role $role)
    {

        $this->middleware('auth');
        $this->role = $role;
    }


    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $model = $this->role->paginate(15);
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $viewType = 'Role List';

        return view('default.admin.role.index',compact('locale','defaultLocale','viewType','model'));
    }

    public function viewRole($id)
    {
        $viewType = 'Role View';

        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $roleToView = $this->role->findOrFail($id);
        //dd($roleToView);
        return view('default.admin.role.view',compact('roleToView', 'locale','viewType', 'defaultLocale'));

    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function createForm()
    {
        $viewType = 'Create Role';
        \Log::info('form loaded') ;
        return view('default.admin.role.create',compact('viewType'));

    }

    /**
     * @param Role $role
     * @param Validator $validatedRequest
     */
    public function createRole(Validator $validatedRequest)
    {
        $isCreated =  $this->role->create([
            'name'=>$validatedRequest->get('name'),
            'role_description'=>$validatedRequest->get('role_description')
        ]);
        \Log::info($validatedRequest->get('name')) ;

        if ($isCreated){
            return \Redirect::route('role-list')->with('Successfully Created');
            //return route('role-list')->withSuccess('Successfully Created');
        }else{
            return back()->withError('Something Went Wrong');
        }
    }



    /**
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function editRoleForm($id)
    {
        $viewType = 'Edit Role';

        $eachRole =$this->editFormModel($this->role->findOrFail($id)) ;

        return view('default.admin.role.edit',compact('eachRole','viewType'));
    }


    /**
     * @param $id
     * @param Validator $validatedRequest
     * @return \Illuminate\Http\RedirectResponse|null
     */
    public function editRole($id,Validator $validatedRequest)
    {
        $roleToEdit = $this->role->findOrFail($id);

        $isEdited =  $roleToEdit->update([
            'name'=>$validatedRequest->get('name'),
            'role_description'=>$validatedRequest->get('role_description')
        ]);
        if ($isEdited) {
            return redirect()->route('role-list')->withSuccess('Successfully Updated!');
        }
        return back()->withError('Something Went Wrong');
    }

    /**
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */

    public function deleteRole($id)
    {
        $roleToDelete = $this->role->findOrFail($id);

        if($roleToDelete->delete()){

            return redirect()->route('role-list')->withSuccess('Successfully Deleted!');
        }
        return back()->withErrors('Not successfully deleted');
    }

    /**
     * @return $this
     */
    public function roleAssignForm(AssignRole $assignRole)
    {
        $viewType = 'Assign Role';
        $assignRole = $assignRole;
        return view('default.admin.role.assign_role',compact('viewType','assignRole'));

    }

    /**
     * @param Validator $validatedRequest
     * @param User $user
     * @return \Illuminate\Http\RedirectResponse
     */
    public function assignRole(Validator $validatedRequest, User $user)
    {
//        dd($validatedRequest->user_id);
        $assignedUser = $user->findOrFail($validatedRequest->user_id);
        $roleChecked = $this->role->findOrFail($validatedRequest->role_id);
//        dd($roleChecked);
        foreach( $assignedUser->roles()->get() as $assignedRole){
            if($assignedRole->id == $roleChecked->id ){
                return back()->withErrors("$assignedUser->first_name $assignedUser->last_name already holds the $assignedRole->name role");
            }
        }
        $assignedUser->roles()->attach($validatedRequest->role_id);

        return back();
    }



}
