<?php

namespace App\Http\Controllers\Site\Academic;

use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Academic\AcademicPeriodType;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicSessionType;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Relation\Relation;
use App\Models\Site\Batch\BatchDetail;
use App\Models\Site\Employee\TeacherAssignToClassSection;
use App\Models\Site\SiteClassSessionSerialSetting;
use App\Models\Site\Fee\SiteStudentFeeSubHeadAllocation;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicGroup;
use App\Models\Site\Batch\GlobalBatchDetail;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Site\GlobalSiteClassSessionSerialSetting;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use Illuminate\Support\Facades\Auth;
use Response;
use Session;

class AcademicController extends Controller
{

    private $SiteShiftClassGroupSectionSetting;
    private $academicClassGroup;
    private $academicFeeSubHead;
    private $feeSubHeadAllocation;

    public function __construct(SiteShiftClassGroupSectionSetting $SiteShiftClassGroupSectionSetting, AcademicClassGroup $academicClassGroup,
                                AcademicFeeSubHead $academicFeeSubHead, SiteStudentFeeSubHeadAllocation $feeSubHeadAllocation)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->SiteShiftClassGroupSectionSetting = $SiteShiftClassGroupSectionSetting;
        $this->academicClassGroup = $academicClassGroup;
        $this->academicFeeSubHead = $academicFeeSubHead;
        $this->feeSubHeadAllocation = $feeSubHeadAllocation;
    }

    public function getYearPeriodTypeForAcademicGroup()
    {
        $site_id = Session::get('SITE_ID');
        $the_site_info_setting = SiteInfoSetting::first();
        $the_site_info = SiteInfo::findOrFail($site_id);
        $academicYear = explode(',', $the_site_info_setting->academic_year_ids ?? null);
        $academicYearList = AcademicYear::whereIn('id', $academicYear)->orderBy('serial_no', 'desc')->get();

        $academic_period_type_ids = explode(',', $the_site_info->academic_period_type_ids ?? null);
        $academicPeriodTypeList = AcademicPeriodType::whereIn('id', $academic_period_type_ids)
            ->get();

        return [$academicYearList, $academicPeriodTypeList];
    }


//    public function getSiteAcademicYearList()
//    {
//        try {
//
//            $the_site_info_setting = SiteInfoSetting::first();
//
//            if (!$the_site_info_setting) {
//                return Response::json(['message' => 'No "SiteInfoSetting" Found'], 422);
//            }
//
//            $academicYear = explode(',', $the_site_info_setting->academic_year_ids ?? null);
//            $academicYearList = AcademicYear::whereIn('id', $academicYear)->get();
//
//
//
//
//            return compact('academicYearList');
//
//
//        } catch (Exception $exception) {
//            return Response::json(['message' => $exception->getMessage()], 410);
//        }
//
//    }


    /**
     * @param $classid
     * @param $groupid
     * @return mixed
     */
    public function getVersionYearShiftDeptClassGroupSectionSessionPeriodTypeAndSessionTypeList()
    {
        try {

            $site_id = Session::get('SITE_ID');

            $the_site_info_setting = SiteInfoSetting::first();
            $the_site_info = GlobalSiteInfo::findOrFail($site_id);

            if (!$the_site_info_setting) {
                return Response::json(['message' => 'No "SiteInfoSetting" Found'], 422);
            }

            $academicShift = explode(',', $the_site_info_setting->shift_ids ?? null);
            $academicShiftList = AcademicShift::whereIn('id', $academicShift)
                ->get();

            $academicYear = explode(',', $the_site_info_setting->academic_year_ids ?? null);
            $academicYearList = AcademicYear::whereIn('id', $academicYear)->orderBy('serial_no', 'desc')->get();

            $academicDepartmentList = [];
            $academicClassList = [];

            if ($the_site_info_setting->academic_department_ids ?? null) {
                $academicDepartment = explode(',', $the_site_info_setting->academic_department_ids ?? null) ?? null;
                $academicDepartmentList = AcademicDepartment::select('id', 'name')
                    ->whereIn('id', $academicDepartment)->get();
            } else {
                $academicClass = SiteShiftClassGroupSectionSetting::groupBy('academic_class_id')->pluck('academic_class_id')->toArray();//explode(',', $SiteInfoTableData->academic_class_ids) ?? [];
                $academicClassList = AcademicClass::whereIn('id', $academicClass)
                    ->orderBy('serial_no', 'ASC')
                    ->get();
            }

            $academic_session_type_ids = explode(',', $the_site_info_setting->academic_session_type_ids ?? null);
            $academicSessionTypeList = AcademicSessionType::whereIn('id', $academic_session_type_ids)
                ->get();


            $academic_period_type_ids = explode(',', $the_site_info->academic_period_type_ids ?? null);
            $academicPeriodTypeList = AcademicPeriodType::whereIn('id', $academic_period_type_ids)
                ->get();

            $academicVersionIDs = explode(',', $the_site_info_setting->academic_version_ids);
            $academicVersionList = AcademicVersion::whereIn('id', $academicVersionIDs)->get();
            $admissionlistdata = AcademicAdmissionType::where('status', 1)->get();
            $academicStudentTypeIDs = explode(',', $the_site_info_setting->academic_student_type_ids);
            $academicStudentTypeList = AcademicStudentType::whereIn('id', $academicStudentTypeIDs)->get();
            $Sessionlistsplite = explode(',', $the_site_info_setting->academic_session_ids);
            $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
            $relationList = Relation::all();


            //  dd($academicDepartmentList);


            return [
                $academicVersionList,
                $academicYearList,
                $academicShiftList,
                $academicClassList,
                $Sessionlist,
                $admissionlistdata,
                $academicStudentTypeList,
                $relationList,
                $academicDepartmentList,
                $academicSessionTypeList,
                $academicPeriodTypeList
            ];
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }

    }


    /**
     * @param $classid
     * @param $groupid
     * @return mixed
     */
    public function getVersionYearShiftDeptList()
    {
        try {

            $site_id = Session::get('SITE_ID');

            $the_site_info_setting = SiteInfoSetting::first();
            $the_site_info = GlobalSiteInfo::findOrFail($site_id);

            if (!$the_site_info_setting) {
                return Response::json(['message' => 'No "SiteInfoSetting" Found'], 422);
            }

            $academicShift = explode(',', $the_site_info_setting->shift_ids ?? null);
            $academicShiftList = AcademicShift::whereIn('id', $academicShift)
                ->get();

            $academicYear = explode(',', $the_site_info_setting->academic_year_ids ?? null);
            $academicYearList = AcademicYear::whereIn('id', $academicYear)->orderBy('serial_no', 'desc')->get();

         //   dd($academicYearList);

            $academicStudentCategory = explode(',', $the_site_info_setting->academic_student_category_ids ?? null);
            $academicStudentCategoryList = AcademicStudentCategory::whereIn('id', $academicStudentCategory)->get();


            $admissionlist = explode(',', $the_site_info_setting->academic_admission_type_ids ?? null);
            $admissionlistdata = AcademicAdmissionType::whereIn('id', $admissionlist)->get();


//            $academicDepartmentList = [];
//            $academicClassList = [];
//
//            if ($the_site_info_setting->academic_department_ids ?? null) {
//                $academicDepartment = explode(',', $the_site_info_setting->academic_department_ids ?? null) ?? null;
//                $academicDepartmentList = AcademicDepartment::select('id', 'name as department_name')
//                    ->whereIn('id', $academicDepartment)->get();
//            } else {
//                $academicClass = SiteShiftClassGroupSectionSetting::groupBy('academic_class_id')->pluck('academic_class_id')->toArray();//explode(',', $SiteInfoTableData->academic_class_ids) ?? [];
//                $academicClassList = AcademicClass::whereIn('id', $academicClass)
//                    ->orderBy('serial_no', 'ASC')
//                    ->get();
//            }
//
//            $academic_session_type_ids = explode(',', $the_site_info_setting->academic_session_type_ids ?? null);
//            $academicSessionTypeList = AcademicSessionType::whereIn('id', $academic_session_type_ids)
//                ->get();
//
//
//            $academic_period_type_ids = explode(',', $the_site_info->academic_period_type_ids ?? null);
//            $academicPeriodTypeList = AcademicPeriodType::whereIn('id', $academic_period_type_ids)
//                ->get();

            $academicVersionIDs = explode(',', $the_site_info_setting->academic_version_ids);
            $academicVersionList = AcademicVersion::whereIn('id', $academicVersionIDs)->get();

            $academicStudentTypeIDs = explode(',', $the_site_info_setting->academic_student_type_ids);
            $academicStudentTypeList = AcademicStudentType::whereIn('id', $academicStudentTypeIDs)->get();
            $Sessionlistsplite = explode(',', $the_site_info_setting->academic_session_ids);
            $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
            $relationList = Relation::all();

//         return $academicVersionList;


            return [
                $academicVersionList,
                $academicYearList,
                $academicShiftList,
                $admissionlistdata,
                $academicStudentCategoryList,

            ];
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }

    }

    public function getSiteAcademicGroupList(){

        $site_id = Session::get('SITE_ID');

        //   $the_site_info_setting = SiteInfoSetting::first();
          $academic_group_ids = GlobalSiteInfoSetting::where('site_id',$site_id)->pluck('academic_group_id');
          $academic_group_list = AcademicGroup::whereIn('id',$academic_group_ids)->get();

          return $academic_group_list;
    }




    public function getGlobalVersionYearShiftDeptList(Request $request)
    {
        try {

            $site_id = Session::get('SITE_ID');

         //   $the_site_info_setting = SiteInfoSetting::first();
            $the_site_info_setting = GlobalSiteInfoSetting::where('site_id',$site_id)->where('academic_group_id',$request->academic_group_id)->first();



            if (!$the_site_info_setting) {
                return Response::json(['message' => 'No "SiteInfoSetting" Found'], 422);
            }

            $academicShift = explode(',', $the_site_info_setting->shift_ids ?? null);
            $academicShiftList = AcademicShift::whereIn('id', $academicShift)
                ->get();

            $academicShift = explode(',', $the_site_info_setting->shift_ids ?? null);
            $academicShiftList = AcademicShift::whereIn('id', $academicShift)
                ->get();

            $academicYear = explode(',', $the_site_info_setting->academic_year_ids ?? null);
            $academicYearList = AcademicYear::whereIn('id', $academicYear)->orderBy('serial_no', 'desc')->get();

         //   dd($academicYearList);

            $academicStudentCategory = explode(',', $the_site_info_setting->academic_student_category_ids ?? null);
            $academicStudentCategoryList = AcademicStudentCategory::whereIn('id', $academicStudentCategory)->get();


            $admissionlist = explode(',', $the_site_info_setting->academic_admission_type_ids ?? null);
            $admissionlistdata = AcademicAdmissionType::whereIn('id', $admissionlist)->get();


//            $academicDepartmentList = [];
//            $academicClassList = [];
//
//            if ($the_site_info_setting->academic_department_ids ?? null) {
//                $academicDepartment = explode(',', $the_site_info_setting->academic_department_ids ?? null) ?? null;
//                $academicDepartmentList = AcademicDepartment::select('id', 'name as department_name')
//                    ->whereIn('id', $academicDepartment)->get();
//            } else {
//                $academicClass = SiteShiftClassGroupSectionSetting::groupBy('academic_class_id')->pluck('academic_class_id')->toArray();//explode(',', $SiteInfoTableData->academic_class_ids) ?? [];
//                $academicClassList = AcademicClass::whereIn('id', $academicClass)
//                    ->orderBy('serial_no', 'ASC')
//                    ->get();
//            }
//
//            $academic_session_type_ids = explode(',', $the_site_info_setting->academic_session_type_ids ?? null);
//            $academicSessionTypeList = AcademicSessionType::whereIn('id', $academic_session_type_ids)
//                ->get();
//
//
//            $academic_period_type_ids = explode(',', $the_site_info->academic_period_type_ids ?? null);
//            $academicPeriodTypeList = AcademicPeriodType::whereIn('id', $academic_period_type_ids)
//                ->get();

            $academicVersionIDs = explode(',', $the_site_info_setting->academic_version_ids);
            $academicVersionList = AcademicVersion::whereIn('id', $academicVersionIDs)->get();

            $academicStudentTypeIDs = explode(',', $the_site_info_setting->academic_student_type_ids);
            $academicStudentTypeList = AcademicStudentType::whereIn('id', $academicStudentTypeIDs)->get();
            $Sessionlistsplite = explode(',', $the_site_info_setting->academic_session_ids);
            $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
            $relationList = Relation::all();

//         return $academicVersionList;


            return [
                $academicVersionList,
                $academicYearList,
                $academicShiftList,
                $admissionlistdata,
                $academicStudentCategoryList,

            ];
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }

    }

    public function getVersionYearShiftListByUser(Request $request)
    {
//        $user_role = request()->user()->roles()->pluck('key')->first();
//        return $user_role;
        $academic_class_id = $request->academic_class_id;
        $academic_department_id = $request->academic_department_id;
        $academic_shift_id = $request->academic_shift_id;
        $academic_version_id = $request->academic_version_id;
        $academic_year_id = $request->academic_year_id;
//        return $request;

        try {

            $site_id = Session::get('SITE_ID');
            $user_id = Auth::user()->id;

            $user_role = request()->user()->roles()->pluck('key')->first();
            if ($user_role == 'admin') {
                $site_info_setting = SiteInfoSetting::first();
                $version_ids = explode(',', $site_info_setting->academic_version_ids);
                $year_ids = explode(',', $site_info_setting->academic_year_ids);
                $shift_ids = explode(',', $site_info_setting->shift_ids);

            } else {


                $teacher_assign_to_class_section = TeacherAssignToClassSection::where('employee_id', $user_id)->get();
//            $teacher_assign_to_class_section = TeacherAssignToClassSection::where('employee_id', $user_id)
//                                                ->when($academic_version_id, function ($q) use($academic_version_id){
//                                                    $q->where('academic_version_id',$academic_version_id);
//                                                })
//                                                ->when($academic_year_id, function ($q) use($academic_year_id){
//                                                    $q->where('academic_year_id',$academic_year_id);
//                                                })
//                                                ->when($academic_shift_id, function ($q) use($academic_shift_id){
//                                                    $q->where('academic_shift_id',$academic_shift_id);
//                                                })
//                                                ->when($academic_department_id, function ($q) use($academic_department_id){
//                                                    $q->where('academic_department_id',$academic_department_id);
//                                                })
//                                                ->when($academic_class_id, function ($q) use($academic_class_id){
//                                                    $q->where('academic_class_id',$academic_class_id);
//                                                })
//                                                ->get();

                $version_ids = $teacher_assign_to_class_section->pluck('academic_version_id');
                $year_ids = $teacher_assign_to_class_section->pluck('academic_year_id');
                $shift_ids = $teacher_assign_to_class_section->pluck('academic_shift_id');


//            //===============department======================
//            $academicDepartmentList = [];
//            $department_ids = $teacher_assign_to_class_section->pluck('academic_department_id');
//            $academicDepartmentList = AcademicDepartment::whereIn('id', $department_ids)->get();
//
//            //===============class======================
//            $academicClassList = [];
//            $class_ids = $teacher_assign_to_class_section->pluck('academic_class_id');
//            $academicClassList = AcademicClass::whereIn('id', $class_ids)->get();
            }

            //===============version======================
            $academicVersionList = [];
//                $version_ids = $teacher_assign_to_class_section->pluck('academic_version_id');
            $academicVersionList = AcademicVersion::whereIn('id', $version_ids)->get();

            //===============year======================
            $academicYearList = [];
//                $year_ids = $teacher_assign_to_class_section->pluck('academic_year_id');
            $academicYearList = AcademicYear::whereIn('id', $year_ids)->orderBy('serial_no', 'desc')->get();

            //===============shift======================
            $academicShiftList = [];
//                $shift_ids = $teacher_assign_to_class_section->pluck('academic_shift_id');
            $academicShiftList = AcademicShift::whereIn('id', $shift_ids)->get();

        //    dd($user_id);
            return [
                $academicVersionList,
                $academicYearList,
                $academicShiftList
            ];
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }

    }

    /**
     * @param $classid
     * @param $groupid
     * @return mixed
     */
    public function getStudentShiftList()
    {
        try {

            $the_site_info_setting = SiteInfoSetting::first();

            if (!$the_site_info_setting) {
                return Response::json(['message' => 'No "SiteInfoSetting" Found'], 422);
            }

            $academicShift = explode(',', $the_site_info_setting->shift_ids ?? null);
            $academicShiftList = AcademicShift::whereIn('id', $academicShift)
                ->get();


            return [
                $academicShiftList,
            ];
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }

    }

    public function versionYearShiftBasedSectionsOrClassGroupsAndSessionByClass($version_id, $year_id, $shift_id, $class_id, $dept_id = null)
    {//this function returns class groups by version,year, and shift if groups not present then sections


        $data = [];
        $data['academic_version_id'] = $version_id;
        $data['academic_year_id'] = $year_id;
        $data['academic_shift_id'] = $shift_id == 'null' ? null : $shift_id;
        $data['academic_class_id'] = $class_id;
        $data['academic_department_id'] = $dept_id == 'null' ? null : $dept_id;


        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id'] || !$data['academic_class_id']) {
            return Response::json(['message' => 'Select * Marked Field!'], 411);
        }


        $SiteInfoTableData = SiteInfoSetting::select('id', 'batch_present_status')->first();


        if ($SiteInfoTableData->batch_present_status) {
            $batch_list = BatchDetail::where('academic_class_id', $class_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_shift_id', $shift_id)
                ->where('academic_year_id', $year_id)
                ->select('id', 'batch_name', 'batch_code')
                ->get();

            //   dd($class_id,$version_id,$shift_id,$year_id);


        } else {
            $batch_list = [];
        }


        $group_list = [];
        $section_list = [];

        $group_present = $this->SiteShiftClassGroupSectionSetting
            ->where('academic_version_id', $version_id)
            ->where('academic_year_id', $year_id)
            ->where('academic_shift_id', $shift_id)
            ->where('academic_class_id', $class_id)
            ->whereNotNull('academic_class_group_id')
            ->get();
//        return $group_present;



        if (count($group_present) > 0) {
            $group_ids = $group_present->pluck('academic_class_group_id')->toArray();
            $group_list = $this->academicClassGroup
                ->whereIn('id', $group_ids)
                ->get();


        } else {

            $section_present = $this->SiteShiftClassGroupSectionSetting
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_shift_id', $shift_id)
                ->where('academic_class_id', $class_id)
                ->first();

            $exploded_section_ids = explode(',', $section_present->academic_section_ids ?? null);

            $section_list = AcademicSection::select('id', 'section_name')
                ->whereIn('id', $exploded_section_ids)
                ->get();

        }


        $session_exist = SiteClassSessionSerialSetting::where('academic_class_id', $data['academic_class_id'])
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_department_id', $data['academic_department_id'])
            ->first();

//check session existed
        if ($session_exist && $session_exist->session_present) {
            $exploded_session_list = explode(',', $session_exist->session_ids);
            $session_list = AcademicSession::whereIn('id', $exploded_session_list)->get();
        } else {
            $session_list = [];
        }

        return [$group_list, $section_list, $session_list, $batch_list];
    }

    public function globalVersionYearShiftBasedSectionsOrClassGroupsAndSessionByClass($academic_group_id,$version_id, $year_id, $shift_id, $class_id, $dept_id = null)
    {//this function returns class groups by version,year, and shift if groups not present then sections


        $data = [];
        $data['academic_group_id'] = $academic_group_id;
        $data['academic_version_id'] = $version_id;
        $data['academic_year_id'] = $year_id;
        $data['academic_shift_id'] = $shift_id == 'null' ? null : $shift_id;
        $data['academic_class_id'] = $class_id;
        $data['academic_department_id'] = $dept_id == 'null' ? null : $dept_id;


        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id'] || !$data['academic_class_id']) {
            return Response::json(['message' => 'Select * Marked Field!'], 411);
        }


        $SiteInfoTableData = GlobalSiteInfoSetting::where('site_id',Session::get('SITE_ID'))
            ->where('academic_group_id',$data['academic_group_id'])
            ->select('id', 'batch_present_status')
            ->first();


        if ($SiteInfoTableData->batch_present_status) {
            $batch_list = GlobalBatchDetail::where('site_id',Session::get('SITE_ID'))
                ->where('academic_group_id',$data['academic_group_id'])
                ->where('academic_class_id', $class_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_shift_id', $shift_id)
                ->where('academic_year_id', $year_id)
                ->select('id', 'batch_name', 'batch_code')
                ->get();

            //   dd($class_id,$version_id,$shift_id,$year_id);


        } else {
            $batch_list = [];
        }


        $group_list = [];
        $section_list = [];

        $group_present = GlobalSiteShiftClassGroupSectionSetting::where('site_id',Session::get('SITE_ID'))
            ->where('academic_group_id',$data['academic_group_id'])
            ->where('academic_version_id', $version_id)
            ->where('academic_year_id', $year_id)
            ->where('academic_shift_id', $shift_id)
            ->where('academic_class_id', $class_id)
            ->whereNotNull('academic_class_group_id')
            ->get();
//        return $group_present;



        if (count($group_present) > 0) {
            $group_ids = $group_present->pluck('academic_class_group_id')->toArray();
            $group_list = $this->academicClassGroup
                ->whereIn('id', $group_ids)
                ->get();


        } else {

            $section_present =  GlobalSiteShiftClassGroupSectionSetting::where('site_id',Session::get('SITE_ID'))
                ->where('academic_group_id',$data['academic_group_id'])
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_shift_id', $shift_id)
                ->where('academic_class_id', $class_id)
                ->first();

            $exploded_section_ids = explode(',', $section_present->academic_section_ids ?? null);

            $section_list = AcademicSection::select('id', 'section_name')
                ->whereIn('id', $exploded_section_ids)
                ->get();

        }


        $session_exist = GlobalSiteClassSessionSerialSetting::where('site_id',Session::get('SITE_ID'))
            ->where('academic_group_id',$data['academic_group_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_department_id', $data['academic_department_id'])
            ->first();

//check session existed
        if ($session_exist && $session_exist->session_present) {
            $exploded_session_list = explode(',', $session_exist->session_ids);
            $session_list = AcademicSession::whereIn('id', $exploded_session_list)->get();
        } else {
            $session_list = [];
        }

        return [$group_list, $section_list, $session_list, $batch_list];
    }


    public function versionYearShiftBasedSectionsOrClassGroupsAndSessionByClassByUser($version_id, $year_id, $shift_id, $class_id, $dept_id = null)
    {//this function returns class groups by version,year, and shift if groups not present then sections


        $data = [];
        $data['academic_version_id'] = $version_id;
        $data['academic_year_id'] = $year_id;
        $data['academic_shift_id'] = $shift_id;
        $data['academic_class_id'] = $class_id;
        $data['academic_department_id'] = $dept_id == 'null' ? null : $dept_id;

        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id'] || !$data['academic_class_id']) {
            return Response::json(['message' => 'Select * Marked Field!'], 411);
        }


        $group_list = [];
        $section_list = [];

        $group_present = $this->SiteShiftClassGroupSectionSetting
            ->where('academic_version_id', $version_id)
            ->where('academic_year_id', $year_id)
            ->where('academic_shift_id', $shift_id)
            ->where('academic_class_id', $class_id)
            ->whereNotNull('academic_class_group_id')
            ->get();


        if (count($group_present) > 0) {
            $group_ids = $group_present->pluck('academic_class_group_id')->toArray();
            $user_group_ids = TeacherAssignToClassSection::where('employee_id', Auth::user()->id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_shift_id', $shift_id)
                ->where('academic_class_id', $class_id)
                ->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->whereIn('academic_class_group_id', $group_ids)
                ->where('status', 1)
                ->pluck('academic_class_group_id')
                ->filter()
                ->unique();

            $group_list = $this->academicClassGroup
                ->whereIn('id', $user_group_ids)
                ->get();




        } else {

            $section_present = $this->SiteShiftClassGroupSectionSetting
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_shift_id', $shift_id)
                ->where('academic_class_id', $class_id)
                ->first();

            $exploded_section_ids = explode(',', $section_present->academic_section_ids ?? null);

            $user_section_ids = TeacherAssignToClassSection::where('employee_id', Auth::user()->id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_shift_id', $shift_id)
                ->where('academic_class_id', $class_id)
                ->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->whereIn('academic_section_id', $exploded_section_ids)
                ->where('status', 1)
                ->pluck('academic_section_id')
                ->filter()
                ->unique();

            $section_list = AcademicSection::select('id', 'section_name')
                ->whereIn('id', $user_section_ids)
                ->get();
        }


        $session_exist = SiteClassSessionSerialSetting::where('academic_class_id', $data['academic_class_id'])
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->first();

        //dd($session_exist);
//check session existed
        if ($session_exist && $session_exist->session_present) {
            $exploded_session_list = explode(',', $session_exist->session_ids);
            $session_list = AcademicSession::whereIn('id', $exploded_session_list)->get();
        } else {
            $session_list = [];
        }

        return [$group_list, $section_list, $session_list];
    }


    public function siteClassBaseSectionByUser($class_id, $shift_id, $class_group_id, $year_id)
    {

        $data = [];
        $data['academic_year_id'] = $year_id;
        $data['academic_shift_id'] = $shift_id;
        $data['academic_class_id'] = $class_id;
        $data['academic_class_group_id'] = $class_group_id;


        $groupPresentCount = SiteShiftClassGroupSectionSetting::select('academic_class_group_id')
            ->where('academic_class_id', $class_id)
            ->whereNotNull('academic_class_group_id')
            ->get()
            ->count();


        $sessionPresentCheck = SiteClassSessionSerialSetting::where('academic_class_id', $class_id)->first();
        if ($sessionPresentCheck) {
            if ($sessionPresentCheck->session_present) {
                $SiteInfoTableData = SiteInfoSetting::first();
                $Sessionlistsplite = explode(',', $SiteInfoTableData->academic_session_ids);
                $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
            } else {
                $Sessionlist = [];
            }
        } else {
            $Sessionlist = [];
        }


        if (!$groupPresentCount) {

            $SiteClassBaseSectionCount = SiteShiftClassGroupSectionSetting::select('academic_shift_id')
                ->where('academic_class_id', $class_id)
                ->get()
                ->count();


            if (!$shift_id && $SiteClassBaseSectionCount > 1) {
                return 4001;
            } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
                $SiteClassBaseSection = SiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('academic_class_id', $class_id)
                    ->first();
            } else if ($shift_id && $class_id) {
                $SiteClassBaseSection = SiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('academic_class_id', $class_id)
                    ->where('academic_shift_id', $shift_id)
                    ->first();
            }
        } else {
            if (!$shift_id && !$class_group_id) {
                return 4001;
            } else if ($shift_id && !$class_group_id) {
                $SiteGroup = SiteShiftClassGroupSectionSetting::select('academic_class_group_id')
                    ->where('academic_class_id', $class_id)
                    ->where('academic_shift_id', $shift_id)
                    ->get();


                $sectionDataList = AcademicClassGroup::select('id', 'group_name')
                    ->whereIn('id', $SiteGroup)
                    ->get();


                return [2001, $sectionDataList, $Sessionlist];
            } else {
                $SiteClassBaseSectionCount = SiteShiftClassGroupSectionSetting::select('academic_shift_id')
                    ->where('academic_class_id', $class_id)
                    ->where('academic_class_group_id', $class_group_id)
                    ->get()
                    ->count();


                if (!$shift_id && $SiteClassBaseSectionCount > 1) {
                    return 4001;
                } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
                    $SiteClassBaseSection = SiteShiftClassGroupSectionSetting::select('academic_section_ids')
                        ->where('academic_class_id', $class_id)
                        ->where('academic_class_group_id', $class_group_id)
                        ->first();
                } else if ($shift_id && $class_id) {
                    $SiteClassBaseSection = SiteShiftClassGroupSectionSetting::select('academic_section_ids')
                        ->where('academic_class_id', $class_id)
                        ->where('academic_shift_id', $shift_id)
                        ->where('academic_class_group_id', $class_group_id)
                        ->first();
                }
            }
        }


        $SectionData = explode(',', $SiteClassBaseSection->academic_section_ids ?? null);


        $assigned_emp_section_ids = TeacherAssignToClassSection::where('employee_id', Auth::user()->id)
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', 1)
            ->whereIn('academic_section_id', $SectionData)
            ->pluck('academic_section_id')
            ->filter()
            ->unique();

        $SectionDataList = AcademicSection::select('id', 'section_name')
            ->whereIn('id', $assigned_emp_section_ids)
            ->get();


        return [$SectionDataList, $Sessionlist];
    }


    public function versionYearShiftBasedSectionsByClassAndClassGroup($version_id, $year_id, $shift_id, $class_id, $class_group_id)
    {//this function returns class groups by version,year, and shift if groups not present then sections


        if (!$version_id || !$year_id || !$shift_id || !$class_id || !$class_group_id) {
            return Response::json(['message' => 'Select * Marked Field!'], 411);
        }

        $section_list = [];

        $group_present = $this->SiteShiftClassGroupSectionSetting
            ->where('academic_version_id', $version_id)
            ->where('academic_year_id', $year_id)
            ->where('academic_shift_id', $shift_id)
            ->where('academic_class_id', $class_id)
            ->where('academic_class_group_id', $class_group_id)
            ->whereNotNull('academic_class_group_id')
            ->first();


        if ($group_present) {


            $section_present = $this->SiteShiftClassGroupSectionSetting
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_shift_id', $shift_id)
                ->where('academic_class_id', $class_id)
                ->first();

            $exploded_section_ids = explode(',', $section_present->academic_section_ids ?? null);

            $section_list = AcademicSection::select('id', 'section_name')
                ->whereIn('id', $exploded_section_ids)
                ->get();
        }

        return $section_list;
    }


    public function getFeeSubHeadListByFeeHeadIdFeeGroupId($feeHead, $feeGroup)
    {

        try {
            $siteInfos = new SiteInfoSetting();
            $siteInfo = $siteInfos->first();
            $siteFeeSubHeadIds = $siteInfo->academic_fee_sub_head_ids;
            $explode_id = array_map('intval', explode(',', $siteFeeSubHeadIds));//array_map function is used to convert array string
            $fee_sub_head = $this->academicFeeSubHead->whereIn('id', $explode_id)->get();

            $final = Array();

            foreach ($fee_sub_head as $key => $value) {

                $get_fee_sub_head_allocation = $this->feeSubHeadAllocation
                    ->where(
                        ['academic_fee_head_id' => $feeHead,
                            'academic_fee_group_id' => $feeGroup,

                        ])->orderBy('id', 'DESC')
                    ->first();

                if ($get_fee_sub_head_allocation) {

                    $fee_sub_head_ids = explode(",", $get_fee_sub_head_allocation->academic_fee_sub_head_ids);

                    if (in_array($value->id, $fee_sub_head_ids)) {
                        $final[$key]['name'] = $value->name;
                        $final[$key]['status'] = true;
                        $final[$key]['id'] = $value->id;

                    } else {
                        $final[$key]['name'] = $value->name;
                        $final[$key]['status'] = false;
                        $final[$key]['id'] = $value->id;
                    }


                } else {
                    $final[$key]['name'] = $value->name;
                    $final[$key]['status'] = false;
                    $final[$key]['id'] = $value->id;

                }

            }
            return $final;
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);

        }

        //return $feeHead;
    }


}
