<?php

namespace App\Http\Controllers\Site\Academic;

use App\Models\Academic\AcademicPeriodType;
use App\Models\Site\Academic\SitePeriodTypeDuration;
use App\Models\Site\SiteInfo;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;

class PeriodTypeController extends Controller
{

    private $academicPeriodType;
    private $sitePeriodTypeDuration;

    public function __construct(AcademicPeriodType $academicPeriodType, SitePeriodTypeDuration $sitePeriodTypeDuration)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->academicPeriodType = $academicPeriodType;
        $this->sitePeriodTypeDuration = $sitePeriodTypeDuration;
    }


    public function sessionTypeSetting()
    {

        $viewType = 'Academic Period Type Setting';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.sites.academic.period-type-setting', compact('viewType'));
    }


    public function getPeriodTypeForSite()
    {
        $site_id = Session::get('SITE_ID');
        $the_site_info = SiteInfo::findOrFail($site_id);
        $academic_period_type_ids = explode(',', $the_site_info->academic_period_type_ids ?? null);
        $academicPeriodTypeList = AcademicPeriodType::whereIn('id', $academic_period_type_ids)
            ->get();

        return response()->json($academicPeriodTypeList, 200);
    }

    public function createPeriodTypeSetting(Request $request)
    {
        $this->validate($request, [
            'academic_period_type_id' => 'required',
            'start_date' => 'required',
            'end_date' => 'required'
        ]);

        //  return $request->start_date;


        if (date('Y-m-d', strtotime($request->start_date)) >= date('Y-m-d', strtotime($request->end_date))) {
            return Response::json(['message' => 'Start Date Must Be Less Than End Date'], 411);
        }

        $all_settings = $this->sitePeriodTypeDuration->get();

        foreach ($all_settings as $all_setting) {

            $check_st = $this->check_in_range($all_setting->start_date, $all_setting->end_date, $request->start_date);
            $check_end = $this->check_in_range($all_setting->start_date, $all_setting->end_date, $request->end_date);

            if ($check_st || $check_end) {
                return Response::json(['message' => 'Duplicate Entry Found!'], 410);
            }
        }
        $siteSessionTypeDuration = new SitePeriodTypeDuration();

        $siteSessionTypeDuration->academic_period_type_id = $request->academic_period_type_id;
        $siteSessionTypeDuration->start_date = $request->start_date;
        $siteSessionTypeDuration->end_date = $request->end_date;
        $siteSessionTypeDuration->save();

        return Response::json(['message' => 'Setting Successfully Saved!'], 200);


    }


    public function updateSessionTypeSetting($id, Request $request)
    {
        $this->validate($request, [
            'academic_period_type_id' => 'required',
            'start_date' => 'required',
            'end_date' => 'required'
        ]);

        if (date('Y-m-d', strtotime($request->start_date)) >= date('Y-m-d', strtotime($request->end_date))) {
            return Response::json(['message' => 'Start Date Must Be Less Than End Date'], 411);
        }

        $all_settings = $this->sitePeriodTypeDuration
            ->where('id', '!=', $id)
            ->get();

        foreach ($all_settings as $all_setting) {

            $check_st = $this->check_in_range($all_setting->start_date, $all_setting->end_date, $request->start_date);
            $check_end = $this->check_in_range($all_setting->start_date, $all_setting->end_date, $request->start_date);
            if ($check_st || $check_end) {
                return Response::json(['message' => 'Duplicate Entry Found!'], 410);
            }
        }


        $the_type = $this->sitePeriodTypeDuration->findOrFail($id);
        $the_type->academic_period_type_id = $request->academic_period_type_id;
        $the_type->start_date = $request->start_date;
        $the_type->end_date = $request->end_date;
        $the_type->save();
        return Response::json(['message' => 'Setting Successfully Updated!'], 200);

    }


    public function deleteSessionTypeSetting($id)
    {

        $the_type = $this->sitePeriodTypeDuration->findOrFail($id);
        $the_type->delete();

        return Response::json(['message' => 'Setting Successfully Deleted! ' . $id], 200);

    }


    private function check_in_range($start_date, $end_date, $date_from_user)
    {

        $start_ts = date('Y-m-d', strtotime($start_date));
        $end_ts = date('Y-m-d', strtotime($end_date));
        $user_ts = date('Y-m-d', strtotime($date_from_user));


        //  dd($start_ts, $end_ts, $user_ts,$date_from_user);

        return (($user_ts >= $start_ts) && ($user_ts <= $end_ts));
    }

//API---------------------------------------------------


    public function getPeriodTypeSettingList()
    {
        $list = $this->sitePeriodTypeDuration
            ->with(['AcademicPeriodType'])
            ->orderBy('start_date')
            ->get();
        return response()->json($list, 200); // $list;
    }

}
