<?php

namespace App\Http\Controllers\Site\Accounts\Bank;

use App\Models\Site\Accounts\Bank;
use App\Models\Site\Accounts\BankAccountDetails;
use App\Models\Site\Accounts\ChequeRegister;
use App\Models\Site\Accounts\SiteAccountsBankAccountTransferCostRecord;
use App\Models\Site\Accounts\SiteAccountsVoucherChequeRegisterRecords;
use App\Models\Site\Accounts\SiteAccountsVoucherDetailsBankAccountDepositRecord;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Error;
use Auth;
use Response;
use Storage;
use Session;

class AccountsBankController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = "Accounts Bank";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getAccountsBankList()
    {
        $bank_list = Bank::where('status', 1)->get();
        if (!count($bank_list)) {
            throw new Error('Sorry! no bank found!');
        }
        return $bank_list;
    }

    public function getAccountsBankAccountListWithPaginationByBankID(Request $request)
    {


        $bank_id        = $request->bankID;
        $search_account = $request->search_account;
        $paginate       = $request->paginate;

        $bank_account_list_with_pagination = BankAccountDetails::where('site_accounts_bank_id', $request->bankID)
            ->with('siteAccountsVoucherDetailsBankAccountDepositRecord')
            ->when($search_account, function ($q) use ($search_account) {
                $q->where('id', $search_account);
            })
            ->where('status', 1)->paginate($paginate);

        $bank_account_list_with_pagination->getCollection()->transform(function ($item) {
            $total_bank_withdraw_amount = 0;
            $total_bank_deposit_amount  = 0;
            $bank_deposit_balance       = 0;

            if ($item['siteAccountsVoucherDetailsBankAccountDepositRecord']) {
                foreach ($item['siteAccountsVoucherDetailsBankAccountDepositRecord'] as $key => $value) {
                    if ($value->withdraw_amount) {
                        $total_bank_withdraw_amount += $value->withdraw_amount;
                    } elseif ($value->deposit_amount) {
                        $total_bank_deposit_amount += $value->deposit_amount;
                    }
                }
                $bank_deposit_balance = $total_bank_deposit_amount - $total_bank_withdraw_amount;
            }
            $cheque_amount = ChequeRegister::where('site_accounts_bank_account_detail_id', $item->id)->sum('cheque_amount');
            $final_amount  = ($item->account_balance + $bank_deposit_balance) - $cheque_amount;
            $item->final_amount               = $final_amount;
            $item->total_bank_withdraw_amount = $total_bank_withdraw_amount;
            $item->total_bank_deposit_amount  = $total_bank_deposit_amount;

            return $item;
        });

        $bank_account_list = BankAccountDetails::where('site_accounts_bank_id', $request->bankID)->where('status', 1)->get();

        return [$bank_account_list_with_pagination, $bank_account_list];
    }

    public function getAccountsBankAccountListByBankID($bankID)
    {

        $bank_account_list = BankAccountDetails::where('site_accounts_bank_id', $bankID)->where('status', 1)->get();
        return $bank_account_list;
    }
    public function getAccountsBankAccountBalance($account_id)
    {
        

        $bank_account = BankAccountDetails::where('id', $account_id)
            ->with('siteAccountsVoucherDetailsBankAccountDepositRecord')
            ->where('status', 1)
            ->first();

        if ($bank_account) {
            $total_bank_withdraw_amount = 0;
            $total_bank_deposit_amount  = 0;
            $bank_deposit_balance       = 0;

            if ($bank_account->siteAccountsVoucherDetailsBankAccountDepositRecord) {
                foreach ($bank_account->siteAccountsVoucherDetailsBankAccountDepositRecord as $value) {
                    if ($value->withdraw_amount) {
                        $total_bank_withdraw_amount += $value->withdraw_amount;
                    } elseif ($value->deposit_amount) {
                        $total_bank_deposit_amount += $value->deposit_amount;
                    }
                }
                $bank_deposit_balance = $total_bank_deposit_amount - $total_bank_withdraw_amount;
            }

            $cheque_amount = ChequeRegister::where('site_accounts_bank_account_detail_id', $bank_account->id)->sum('cheque_amount');
            $final_amount  = ($bank_account->account_balance + $bank_deposit_balance) - $cheque_amount;

            $bank_account->final_amount               = $final_amount;

        }
        return $bank_account->final_amount;



        // $total_deposit_balance = 0;
        // $total_bank_withdraw_amount = 0;
        // $total_cheque_reconcile_balance = 0;
        // //==========================bank deposit total amount======================
        // $deposit_balance_list = SiteAccountsVoucherDetailsBankAccountDepositRecord::where('site_accounts_bank_account_detail_id', $account_id)->get();
        // if (count($deposit_balance_list)) {
        //     foreach ($deposit_balance_list as $k => $v) {

        //         $total_deposit_balance += $v->deposit_amount;
        //     }
        // }
        // // return $total_deposit_balance;
        // //==========================cheque reconcile amount======================
        // $cheque_reconcile_balance_list = ChequeRegister::where('site_accounts_bank_account_detail_id', $account_id)
        //     ->where('cheque_status', 'reconcile')
        //     ->orWhere('cheque_status', 'active')->get();

        // if (count($cheque_reconcile_balance_list)) {
        //     foreach ($cheque_reconcile_balance_list as $kk => $vv) {
        //         $total_cheque_reconcile_balance += $vv->cheque_amount;
        //     }
        // }
        // //==========================bank transaction cost======================
        // $transaction_cost = 0;
        // $bank_account_transaction_cost = SiteAccountsBankAccountTransferCostRecord::where('site_accounts_bank_account_detail_id', $account_id)->get();
        // if (count($bank_account_transaction_cost)) {
        //     foreach ($bank_account_transaction_cost as $kkk => $vvv) {
        //         $transaction_cost += $vvv->transaction_cost;
        //     }
        // }
        // //===========================total balance=============================
        // return  $account_balance = BankAccountDetails::where('id', $account_id)->first();
        // $total_balance = ($account_balance->account_balance + $total_deposit_balance) - ($total_cheque_reconcile_balance + $transaction_cost);
        // $total_balance = ($account_balance->account_balance + $total_deposit_balance) - $total_cheque_reconcile_balance;

        // return $total_balance;
    }

    public function getAccountsBankListWithPagination(Request $request)
    {
        //        $df = (int)session()->get('SITE_ID');
        //        $rt = (int)session()->get('ACADEMIC_GROUP_ID');
        //        return [$df, $rt];
        $search_text = $request->search_text;
        $txt = '%' . $search_text . '%';
        $paginate = $request->paginate;

        //=================bank data list===============
        $accounts_bank_list = Bank::where('status', 1)
            ->when($txt, function ($qr) use ($txt) {
                $qr->where('name', 'LIKE', $txt);
            })
            ->orderBy('id', 'ASC')->paginate($paginate);

        return $accounts_bank_list;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request, Bank $bank)
    {
        //=============validation==========
        if (!$request->name || !$request->contact_no) {
            throw new Error('Please, fill the required fields!');
        }
        //==============create=============
        if (count($bank->ownFields) > 0) {
            foreach ($bank->ownFields as $field) {
                if ($request->{$field}) {
                    $bank->{$field} = $request->{$field};
                }
            }
            $bank->created_date = Carbon::today();
            $bank->status = (int)$request->status;
            $bank->created_by = Auth::user()->id;

            if ($bank->save()) {
                return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);
            }
        }
    }

    public function createBankAccount(Request $request, BankAccountDetails $bankAccountDetails)
    {

        //=============validation==========
        if (!$request->account_number) {
            throw new Error('Please, fill the required fields!');
        }
        //==============create=============
        if (count($bankAccountDetails->ownFields) > 0) {
            foreach ($bankAccountDetails->ownFields as $field) {
                if ($request->{$field}) {
                    $bankAccountDetails->{$field} = $request->{$field};
                }
            }
            $bankAccountDetails->created_date = Carbon::today();
            $bankAccountDetails->status = (int)$request->status;
            $bankAccountDetails->created_by = Auth::user()->id;

            if ($bankAccountDetails->save()) {
                return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);
            }
        }
    }



    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //=============validation==========
        if (!$request->name || !$request->contact_no) {
            throw new Error('Please, fill the required fields!');
        }
        //==============update=============
        $bank = Bank::findOrFail($request->id);
        if (count($bank->ownFields) > 0) {
            foreach ($bank->ownFields as $field) {
                if ($request->{$field}) {
                    $bank->{$field} = $request->{$field};
                }
            }
            $bank->created_date = Carbon::today();
            $bank->status = (int)$request->status;
            $bank->created_by = Auth::user()->id;

            if ($bank->save()) {
                return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
            }
        }
    }

    public function updateBankAccount(Request $request)
    {
        //        return $request;
        //=============validation==========
        if (!$request->account_number) {
            throw new Error('Please, fill the required fields!');
        }
        //==============update=============
        $bank = BankAccountDetails::findOrFail($request->id);
        if (count($bank->ownFields) > 0) {
            foreach ($bank->ownFields as $field) {
                if ($request->{$field}) {
                    $bank->{$field} = $request->{$field};
                }
            }
            $bank->created_date = Carbon::today();
            $bank->status = (int)$request->status;
            $bank->created_by = Auth::user()->id;

            if ($bank->save()) {
                return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $bank = Bank::findOrFail($id);
        if ($bank->delete()) {
            return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Delete'], 200);
        }
    }

    public function deleteBankAccount($id)
    {
        $bank = BankAccountDetails::findOrFail($id);
        if ($bank->delete()) {
            return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Delete'], 200);
        }
    }
}
