<?php

namespace App\Http\Controllers\Site\Assessment;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Assessment\Assessment;
use App\Models\Assessment\AssessmentExpertiseWiseTopic;
use App\Models\Assessment\AssessmentType;
use App\Models\Assessment\AssessmentTypeNo;
use App\Models\Assessment\ExpertiseAssessmentTypeAndTypeNoSetting;
use App\Models\Site\Assessment\SiteAssessmentDeclare;
use App\Models\Site\Assessment\SiteAssessmentDeclareStudent;
use App\Models\Site\Assessment\SiteAssessmentDeclareStudentSubject;
use App\Models\Site\Assessment\SiteAssessmentRoutine;
use App\Models\Site\Assessment\SiteAssessmentTypeAndTypeNoSetting;
use App\Models\Site\Assessment\SiteClassSubjectAssessmentTopic;
use App\Models\Site\Assessment\SiteSubjectTopicAssessmentAndTypeAndTypeNo;
 use App\Models\Student\StudentHistory;

use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Auth;
use DB;
use Dotenv\Exception\ValidationException;
use Exception;
use Illuminate\Http\JsonResponse;
use Response;
use Session;

class SiteAssessmentDeclareController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    public function index()
    {
        $viewType = 'Subject Assesment Topic';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getAssessmentListForAssessmentDeclare(Request $requests){

        $data = $requests->all();

        $assessment_ids=ExpertiseAssessmentTypeAndTypeNoSetting::where('academic_year_id', $data['academic_year_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->pluck('assessment_id')
            ->unique()
            ->filter();

        $assessment=Assessment::whereIn('id', $assessment_ids)->get();
        $assessmentType=AssessmentType::get();
        return [$assessment,$assessmentType];

    }

    public function getStudentSubjectListSettingForAssessmentDeclare(Request $requests){

       // ini_set('memory_limit', '-1');

        DB::beginTransaction();

     //   try {

            $data=$requests->all();
       


            $check_declared_list=SiteAssessmentDeclare::where('academic_version_id', $requests->academic_version_id)
                ->where('academic_year_id', $requests->academic_year_id)
                ->where('academic_shift_id', $requests->academic_shift_id)
                ->where('academic_class_id', $requests->academic_class_id)
                ->where('assessment_id', $requests->assessment_id)
                ->where('assessment_type_id', $requests->assessment_type_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->first();

            $student_array = StudentHistory::select('id', 'user_id', 'student_roll_number')
                ->with(['student' => function ($query) {
                    $query->select('id');
                    $query->where('user_type', 'student');
                }])
                ->where('academic_version_id', $requests->academic_version_id)
                ->where('academic_year_id', $requests->academic_year_id)
                ->where('academic_shift_id', $requests->academic_shift_id)
                ->where('academic_class_id', $requests->academic_class_id)
              
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->where('status', true)
                ->orderBy('student_roll_number')
                ->orderBy('academic_section_id')
                ->orderBy('academic_class_group_id')
                ->orderBy('academic_class_id')
                ->orderBy('academic_department_id')
                ->orderBy('academic_shift_id')
                ->orderBy('academic_year_id')
                ->get();

               

      //      $declaredStudent=SiteAssessmentDeclareStudent::where('site_assessment_declare_id', $check_declared_list->id)->get();


            $student_arr=Array();
            $studentList=[];
            foreach ($student_array as $key => $value) {

                // $checkStudent=$declaredStudent->where('student_history_id',$value['id'])->first();
                // if($checkStudent){
                //     $student_arr['select_student']=true;
                // }else{
                //     $student_arr['select_student']=false;
                // }
                $student_arr['id']=$value->id;
                $student_arr['full_name']=$value->full_name;
                $student_arr['student_roll_number']=$value->student_roll_number;
                $student_arr['student_full_roll_number']=$value->student_full_roll_number;

                $studentList[$key]=$student_arr;
            }


            // student list end

            // selected student start
            $active_student_history_id = $student_array->pluck('id');

            if($check_declared_list){
                $declared_student_ids=SiteAssessmentDeclareStudent::where('site_assessment_declare_id',$check_declared_list->id)
                ->whereIn('student_history_id',$active_student_history_id)
                ->where('assessment_type_id',$requests->assessment_type_id)
                ->where('status',true)
                ->pluck('student_history_id')
                ->unique()
                ->filter();
            }else{
                $declared_student_ids=[];
            }
        
           //     dd($declared_student_ids);
            // selected student end

            $subjects=SubjectGroupConditionSetting::select('id', 'academic_subject_id', 'academic_class_group_ids')
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('status', true)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
              //  ->where('id',9899)
                ->get();

              

        $subjects_condition_arrray=[];
        foreach ($subjects as $key => $value) {
            if(count($value->academic_class_groups)>0 ){

                $check_subject_group= $value->academic_class_groups
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('id', $data['academic_class_group_id']);
                })
                ->first();

                if($check_subject_group){
                    $subjects_condition_arrray[]=$value;
                }

            }else{
                $subjects_condition_arrray[]=$value;
            }

        }


    $assessmentSettings=ExpertiseAssessmentTypeAndTypeNoSetting::where('academic_year_id', $data['academic_year_id'])
        ->where('academic_class_id', $data['academic_class_id'])
        ->where('assessment_id',$data['assessment_id'])
        ->where('assessment_type_id',$data['assessment_type_id'])
        ->get();

    $expertise_ids=$assessmentSettings->pluck('expertise_id')->unique()->filter();

    $assessmentTopics=AssessmentExpertiseWiseTopic::where('status',true)
        ->whereIn('expertise_id', $expertise_ids)
        ->orderBy('serial')
        ->get();
     //   dd($assessmentSettings);
  
        $subject_array=[];
       
        $key=0;
        foreach($subjects_condition_arrray as $subject_condition){

            if($check_declared_list){
                $checkRroutineSubject=SiteAssessmentRoutine::where('site_assessment_declare_id',$check_declared_list->id)
                ->where('assessment_id',$data['assessment_id'])
                ->where('assessment_type_id',$data['assessment_type_id'])
                ->where('site_subject_group_condition_setting_id',$subject_condition->id)
                ->where('status',true)
                ->get();

                if(count($checkRroutineSubject)){
                    $subject_array[$key]['select_subject']=true;
                }else{
                    $subject_array[$key]['select_subject']=false;
                }
            }else{
                $subject_array[$key]['select_subject']=false;
                $checkRroutineSubject=[];
            }
            


           $assessmentSubjectSettings = $assessmentSettings->where('academic_subject_id',$subject_condition->academicSubject->id);

          // dd($assessmentSubjectSettings);

           $assessment_type_ids = $assessmentSubjectSettings->pluck('assessment_type_id')->unique();

           // $assessmentType=AssessmentType::whereIn('id',$assessment_type_ids)->get();
           
            //  $ass_type_array=[];
              $ass_type_key=0;
              
            //  foreach($assessmentType as $ass_type){

                if(count($checkRroutineSubject)){
                    $checkRoutineAssessmentType=$checkRroutineSubject->where('assessment_type_id',$requests->assessment_type_id);

                    // if(count($checkRoutineAssessmentType)){
                    //     $ass_type_array[$ass_type_key]['select_assessment_type']=true;
                    // }else{
                    //     $ass_type_array[$ass_type_key]['select_assessment_type']=false;
                    // }
                }else{
                 //   $ass_type_array[$ass_type_key]['select_assessment_type']=false;
                    $checkRoutineAssessmentType=[];
                }

              

               $assessmentTypeSettings = $assessmentSubjectSettings->where('assessment_type_id',$requests->assessment_type_id);
               $assessment_subject_topic_ids = $assessmentSubjectSettings->pluck('topic_id')->unique();
              
               $assessmentTopicList=$assessmentTopics->whereIn('id',$assessment_subject_topic_ids);
               $ass_topics_array=[];
               $ass_topic_key=0;
 
                foreach($assessmentTopicList as $ass_topic){
                    if($checkRoutineAssessmentType){
                        $checkRoutineAssessmentTopics=$checkRoutineAssessmentType->where('subject_topic_id',$ass_topic->id);
                    }else{
                        $checkRoutineAssessmentTopics=[];
                    }

                    if(count($checkRoutineAssessmentTopics)){
                        $ass_topics_array[$ass_topic_key]['select_assessment_topic']=true;
                    }else{
                        $ass_topics_array[$ass_topic_key]['select_assessment_topic']=false;
                        $checkRoutineAssessmentTopics=[];
                    }

                    $assessmentTopicSettings = $assessmentTypeSettings->where('topic_id',$ass_topic->id);
                    $assessment_type_no_ids = $assessmentTopicSettings->pluck('assessment_type_no_id')->unique();
                    $assessmentTypeNo=AssessmentTypeNo::whereIn('id',$assessment_type_no_ids)->get();

                   // dd($assessment_type_no_ids);

                    $ass_type_no_array=[];
                    $ass_type_no_key=0;
                    foreach($assessmentTypeNo as $asse_type_no){
                        if($checkRoutineAssessmentTopics){
                            $checkRoutine=$checkRoutineAssessmentTopics->where('assessment_type_no_id',$asse_type_no->id)->first();

                        }else{
                            $checkRoutineAssessmentTopics=[];;
                            $checkRoutine=[];
                        }

                        if($checkRoutine){
                            $ass_type_no_array[$ass_type_no_key]['select_assessment_type_no']=true;
                            $ass_type_no_array[$ass_type_no_key]['routine_id']=$checkRoutine->id;
                            $ass_type_no_array[$ass_type_no_key]['assessment_type_id']=$requests->assessment_type_id;
                            $ass_type_no_array[$ass_type_no_key]['assessment_type_no_id']=$checkRoutine->assessment_type_no_id;
                            $ass_type_no_array[$ass_type_no_key]['subject_topic_id']=$checkRoutine->subject_topic_id;

                            $ass_type_no_array[$ass_type_no_key]['assessment_start_date']=$checkRoutine->assessment_start_date;
                            $ass_type_no_array[$ass_type_no_key]['assessment_end_date']=$checkRoutine->assessment_end_date;
                            $ass_type_no_array[$ass_type_no_key]['assessment_start_time']=date("H:i", strtotime($checkRoutine->assessment_start_time));
                            $ass_type_no_array[$ass_type_no_key]['assessment_end_time']=date("H:i", strtotime($checkRoutine->assessment_end_time));
                            $ass_type_no_array[$ass_type_no_key]['assessment_duration']=$checkRoutine->assessment_duration;
                        }else{
                            $ass_type_no_array[$ass_type_no_key]['select_assessment_type_no']=false;
                            $ass_type_no_array[$ass_type_no_key]['routine_id']=null;
                            $ass_type_no_array[$ass_type_no_key]['assessment_type_id']=$requests->assessment_type_id;
                            $ass_type_no_array[$ass_type_no_key]['assessment_type_no_id']=$asse_type_no->id;
                            $ass_type_no_array[$ass_type_no_key]['subject_topic_id']=$ass_topic->id;
                            $ass_type_no_array[$ass_type_no_key]['assessment_start_date']=null;
                            $ass_type_no_array[$ass_type_no_key]['assessment_end_date']=null;
                            $ass_type_no_array[$ass_type_no_key]['assessment_start_time']=null;
                            $ass_type_no_array[$ass_type_no_key]['assessment_end_time']=null;
                            $ass_type_no_array[$ass_type_no_key]['assessment_duration']=null;
                        }
                        $ass_type_no_array[$ass_type_no_key]['type_no']=$asse_type_no->type_no;
                        $ass_type_no_array[$ass_type_no_key]['assessment_id']=$data['assessment_id'];

                        $ass_type_no_key++;
                    }

                    $ass_topics_array[$ass_topic_key]['assessment_topic_id']=$ass_topic->id;
                    $ass_topics_array[$ass_topic_key]['topic_no']=$ass_topic->topic_no;
                    $ass_topics_array[$ass_topic_key]['topic_name']=$ass_topic->topic_name;
                    $ass_topics_array[$ass_topic_key]['type_no_array']=$ass_type_no_array;
                    $ass_topic_key++;
                }

            //     $ass_type_array[$ass_type_key]['assessment_type_id']=$ass_type->id;
            //     $ass_type_array[$ass_type_key]['type_name']=$ass_type->type_name;
            //     $ass_type_array[$ass_type_key]['ass_topics_array']=$ass_topics_array;
            //     $ass_type_key++;
            //   }

            $subject_array[$key]['ass_topics_array']=$ass_topics_array;
            $subject_array[$key]['site_subject_group_condition_setting_id']=$subject_condition->id;
            $subject_array[$key]['subject_name']=$subject_condition->academicSubject->subject_name;
         //   $subject_array[$key]['assessment_type_list']=$ass_type_array;
            $key++;
        }



        DB::commit();
        return Response::json([
            'studentList'=>$studentList,
            'select_student_user_id'=>$declared_student_ids,
            'subjectArray'=>$subject_array
        ]);

    // } catch (ValidationException $exception) {
    //     DB::rollBack();
    //     return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
    // } catch (Exception $exception) {
    //     DB::rollBack();
    //     return Response::json(['message' => $exception->getMessage()], 410);
    // }

    }

    public function createUpdateAssessmentDeclare(Request $requests){

        
        $data = $requests->all();
     
        DB::beginTransaction();

        $check_declared_list=SiteAssessmentDeclare::where('academic_version_id', $requests->academic_version_id)
            ->where('academic_year_id', $requests->academic_year_id)
            ->where('academic_shift_id', $requests->academic_shift_id)
            ->where('academic_class_id', $requests->academic_class_id)
            ->where('assessment_id', $requests->assessment_id)
            ->where('assessment_type_id', $requests->assessment_type_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->first();

         

            // $assessment_type_list=AssessmentType::get();

            // foreach($assessment_type_list as $type){

            // }
            if($check_declared_list){
                $assessmentRoutinePresent=SiteAssessmentRoutine::where('site_assessment_declare_id', $check_declared_list->id)
                ->where('assessment_type_id',$requests->assessment_type_id)
                ->get();

                $presentIDArray=$assessmentRoutinePresent->pluck('id');
            }else{
                $presentIDArray=[];
            }
     
        if($requests->first_time_update==1){
           
    
            if($check_declared_list){

                $siteAssessmentDeclare=SiteAssessmentDeclare::where('id', $check_declared_list->id)->first();

              //  $selected_subject_ids= collect($subjects)->unique()->values()->toArray();

            //     $siteAssessmentDeclare->academic_version_id=$requests->academic_version_id;
            //     $siteAssessmentDeclare->academic_year_id=$requests->academic_year_id;
            //     $siteAssessmentDeclare->academic_shift_id=$requests->academic_shift_id;
            //     $siteAssessmentDeclare->academic_department_id=$requests->academic_department_id;
            //     $siteAssessmentDeclare->academic_class_id=$requests->academic_class_id;
            //     $siteAssessmentDeclare->academic_class_group_id=$requests->academic_class_group_id;
            //     $siteAssessmentDeclare->academic_session_id=$requests->academic_session_id;
            //     $siteAssessmentDeclare->academic_section_id=$requests->academic_section_id;

            //     $siteAssessmentDeclare->assessment_id=$requests->assessment_id;
            //     $siteAssessmentDeclare->assessment_type_id=$requests->assessment_type_id;
            //   //  $siteAssessmentDeclare->site_subject_group_condition_setting_ids=implode(',', $selected_subject_ids);
            //     $siteAssessmentDeclare->save();

                $siteAssessmentDeclare_id=$siteAssessmentDeclare->id;

            }
            else{

                $siteAssessmentDeclare= new SiteAssessmentDeclare;

                $siteAssessmentDeclare->academic_version_id=$requests->academic_version_id;
                $siteAssessmentDeclare->academic_year_id=$requests->academic_year_id;
                $siteAssessmentDeclare->academic_shift_id=$requests->academic_shift_id;
                $siteAssessmentDeclare->academic_department_id=$requests->academic_department_id;
                $siteAssessmentDeclare->academic_class_id=$requests->academic_class_id;
                $siteAssessmentDeclare->academic_class_group_id=$requests->academic_class_group_id;
                $siteAssessmentDeclare->academic_session_id=$requests->academic_session_id;
                $siteAssessmentDeclare->academic_section_id=$requests->academic_section_id;

                $siteAssessmentDeclare->assessment_id=$requests->assessment_id;
                $siteAssessmentDeclare->assessment_type_id=$requests->assessment_type_id;
     //           $siteAssessmentDeclare->site_subject_group_condition_setting_ids=implode(',', $selected_subject_ids);
                $siteAssessmentDeclare->created_by=Auth::user()->id;
                $siteAssessmentDeclare->academic_group_id=Session::get('ACADEMIC_GROUP_ID');
                $siteAssessmentDeclare->site_id=Session::get('SITE_ID');
                $siteAssessmentDeclare->status=true;

                if($siteAssessmentDeclare->save()){
                    $siteAssessmentDeclare_id = $siteAssessmentDeclare->id;
                }
            }
        }
        else{
            $siteAssessmentDeclare_id=$check_declared_list->id;
           
        }

      
        //////////////////////
        $count_student=count($requests->select_student_user_id);

        if($requests->first_time_update==1){

            $ten_student_history_id=collect($requests->select_student_user_id)->take(20);
            $studentRest=array_diff($requests->select_student_user_id, $ten_student_history_id->toArray());

            $completed_student_id_array=$ten_student_history_id;
           
        }
        else if($requests->first_time_update==0){

            $ten_student_history_id=collect($requests->select_student_rest_history_id)->take(20);
            $studentRest=array_diff($requests->select_student_rest_history_id, $ten_student_history_id->toArray());

            $completed_student_id_array=array_merge($requests->completed_student_id_array, $ten_student_history_id->toArray());
        }

        $completed_percent=ceil(count($completed_student_id_array)*100/$count_student);

        /////////////////



        $row_key=0;
        $charges=[];
        $presentID=Array();
        $presentTableIDArray=[];

        foreach($requests->SubjectArray as $key=>$subject){
         //   dd($subject);

            if($subject['select_subject']){
                foreach($subject['ass_topics_array'] as $keys=>$topic){
                    // if($assement_type['select_assessment_type']){
                    //     foreach($assement_type['ass_topics_array'] as $keyss=>$topic){
                            if($topic['select_assessment_topic']){
                                foreach($topic['type_no_array'] as $keysss=>$type_no_item){
                                    if($type_no_item['select_assessment_type_no']){
                                      //  dd($subject);
                                       $checkRoutine = SiteAssessmentRoutine::where('id',$type_no_item['routine_id'])
                                                // ->where('site_assessment_declare_id',$siteAssessmentDeclare_id)
                                                // ->where('site_subject_group_condition_setting_id',$subject['site_subject_group_condition_setting_id'])
                                                // ->where('assessment_id',$type_no_item['assessment_id'])
                                                // ->where('assessment_type_id',$requests->assessment_type_id)
                                                ->first();

                                        if($checkRoutine){

                                            $checkRoutine->status=true;
                                            $checkRoutine->save();

                                            $presentID[$row_key]=$checkRoutine->id;
                                              $row_key++;
                                        }else{
                                            $charges[] = [
                                                'site_id'=>Session::get('SITE_ID'),
                                                'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                                                'site_assessment_declare_id'=>$siteAssessmentDeclare_id,
    
                                                'site_subject_group_condition_setting_id'=>$subject['site_subject_group_condition_setting_id'],
                                                'assessment_id'=>$type_no_item['assessment_id'],
                                                'assessment_type_id'=>$type_no_item['assessment_type_id'],
                                                'assessment_type_no_id'=>$type_no_item['assessment_type_no_id'],
                                                'subject_topic_id'=>$type_no_item['subject_topic_id'],
                                                'assessment_start_date'=>$type_no_item['assessment_start_date'],
                                                'assessment_end_date'=>$type_no_item['assessment_end_date'],
                                                'assessment_start_time'=>$type_no_item['assessment_start_time'],
                                                'assessment_end_time'=>$type_no_item['assessment_end_time'],
                                                'assessment_duration'=>$type_no_item['assessment_duration'],
                                                'status'=>true,
                                            ];
                                        }


                                        
                                    }
                                }
                            }

                    //     }

                    // }

                }
            }

            $presentTableIDArray[$key]=array_merge($presentID);
        }
        if(count($charges)>0){
            SiteAssessmentRoutine::insert($charges);
        }
        $site_subject_condition_se_ids=SiteAssessmentRoutine::where('site_assessment_declare_id',$siteAssessmentDeclare_id)
                ->where('assessment_type_id',$requests->assessment_type_id)
                //->where('status',true)
                ->pluck('site_subject_group_condition_setting_id')
                ->unique()
                ->filter();
        $subject_ids=implode(',',$site_subject_condition_se_ids->toArray());
        $siteAssessmentDec = SiteAssessmentDeclare::where('id',$siteAssessmentDeclare_id)->first();
       
        $siteAssessmentDec->site_subject_group_condition_setting_ids=$subject_ids;
        $siteAssessmentDec->save();
        // dd($site_subject_group_condition_setting_id);

        $collection = collect($presentTableIDArray);
        $routineArrayCollapsed = ($collection->collapse())->unique();
       
        if(count($presentIDArray)){
            $routineAbsentCheck=array_diff($presentIDArray->toArray(), $routineArrayCollapsed->toArray());
       
            SiteAssessmentRoutine::whereIn('id', $routineAbsentCheck)
            ->where('assessment_type_id',$requests->assessment_type_id)
            ->update([
                'status'=>false
            ]);
        }else{
            $routineAbsentCheck=[];
        }
       


        //// student assessment declare start

        
        if($siteAssessmentDeclare_id){
            $declaredStudent=SiteAssessmentDeclareStudent::where('site_assessment_declare_id', $siteAssessmentDeclare_id)
                            ->where('assessment_type_id',$requests->assessment_type_id)
                            ->get();

            $declaredStudentIds=$declaredStudent->pluck('id');
      
        if($requests->first_time_update==1){


            $declared_student_id=[];
            $created=[];
            if(count($requests->select_student_user_id)>0 ){

                foreach ($requests->select_student_user_id as $key => $value) {
                  

                    $checkStudent=$declaredStudent->where('student_history_id', $value)->first();
                   
                    if($checkStudent){
                        $declared_student_id[]=$checkStudent->id;

                        $checkStudent->update([
                            'status' => true
                        ]);

                    }else{
                        $created[] = [
                            'site_assessment_declare_id' => $siteAssessmentDeclare_id,
                            'student_history_id' => $value,
                            'assessment_type_id' => $requests->assessment_type_id,
                            'status' => true,
                            'site_id' => Session::get('SITE_ID'),
                            'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                        ];
                    }
                }


            }
           
            if($check_declared_list){

                // $check_student_exam_attendance=SiteAssessmentDeclareStudentSubject::where('site_assessment_declare_id', $check_declared_list->id)
                //     ->where('assessment_id', $requests->assessment_id)
                //    // ->where('assessment_attendance_status', true)
                //     ->pluck('site_assessment_declare_student_id')
                //     ->unique()
                //     ->values()
                //     ->toArray();

          //      $array_combine=collect(array_merge($check_student_exam_attendance, $declared_student_id))->unique()->values()->toArray();
         
                $siteExamStudentCheck=array_diff($declaredStudentIds->toArray(), $declared_student_id);
              //  dd($siteExamStudentCheck);
              //  SiteAssessmentDeclareStudentSubject::whereIn('site_exam_declare_student_id', $siteExamStudentCheck)->delete();
              //  SiteAssessmentDeclareStudent::whereIn('id', $siteExamStudentCheck)->delete();
                SiteAssessmentDeclareStudent::whereIn('id', $siteExamStudentCheck)
                ->where('assessment_type_id',$requests->assessment_type_id)
                ->update(['status'=>false]);

              //  dd()
              
                SiteAssessmentDeclareStudentSubject::whereIn('site_assessment_declare_student_id', $siteExamStudentCheck)
                ->where('assessment_type_id',$requests->assessment_type_id)
                ->update(['status'=>false]);

            }
          //  dd($created);

            if(count($created)>0){
                SiteAssessmentDeclareStudent::insert($created);
            }
        }
        }
        //// student assessment declare end

        $assessmentRoutine=SiteAssessmentRoutine::where('site_assessment_declare_id',$siteAssessmentDeclare_id)
                        ->where('assessment_type_id',$requests->assessment_type_id)
                        ->where('status',true)
                        ->get();
        $declaredStudentList=SiteAssessmentDeclareStudent::where('site_assessment_declare_id', $siteAssessmentDeclare_id)
                    ->where('assessment_type_id',$requests->assessment_type_id)
                    ->where('status',true)
                    ->get();
      
            
        foreach($assessmentRoutine as $routine){
            foreach($declaredStudentList as $keys=>$declared_student){
              
                $checkStudentSubject=SiteAssessmentDeclareStudentSubject::where('student_history_id',$declared_student->student_history_id)
                    ->where('site_assessment_routine_id',$routine->id)
                    ->where('assessment_type_id',$requests->assessment_type_id)
                    ->first();
                   
                    $topic=AssessmentExpertiseWiseTopic::where('status',true)
                        ->where('id', $routine->subject_topic_id)
                        ->first();
                    
                    if($checkStudentSubject){
                        $checkStudentSubject->status=true;
                      //  $checkStudentSubject->expertise_id = $topic->expertise_id;

                        $checkStudentSubject->save();
                    }else{

                       $studentSubject = new SiteAssessmentDeclareStudentSubject;

                       $studentSubject->site_subject_group_condition_setting_id = $routine->site_subject_group_condition_setting_id;
                       $studentSubject->site_assessment_declare_id = $siteAssessmentDeclare_id;
                       $studentSubject->site_assessment_declare_student_id = $declared_student->id;
                       $studentSubject->student_history_id = $declared_student->student_history_id;
                       $studentSubject->site_assessment_routine_id = $routine->id;
                       $studentSubject->assessment_id = $routine->assessment_id;
                       $studentSubject->expertise_id = $topic->expertise_id;
                       $studentSubject->assessment_type_id = $routine->assessment_type_id;
                       $studentSubject->assessment_type_no_id = $routine->assessment_type_no_id;
                       $studentSubject->subject_topic_id = $routine->subject_topic_id;
                       $studentSubject->assessment_attendance_status=true;
                    //   $checkStudentSubject->assessment_type_no_mark='circle';
                       $studentSubject->status = true;
                       $studentSubject->save();
                      
                    }
            }
        }

       
        if(count($routineAbsentCheck)){
            SiteAssessmentDeclareStudentSubject::whereIn('site_assessment_routine_id', $routineAbsentCheck)
            ->where('assessment_type_id',$requests->assessment_type_id)
            ->update(['status'=>false]);
        }
        

        DB::commit();

        if(count($studentRest)>0){
            return compact('studentRest', 'count_student',
                'completed_student_id_array', 'completed_percent', 'siteAssessmentDeclare_id');
        }else{
            return Response::json(['message' => 'information Update Successfully!', 'mode' => 'Update',
                'completed_student_id_array' => $completed_student_id_array,
                'count_student' => $count_student ], 200);
        }


    }

}
