<?php

namespace App\Http\Controllers\Site\Assessment;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Assessment\Assessment;
use App\Models\Assessment\AssessmentExpertiseWiseTopic;
use App\Models\Assessment\AssessmentType;
use App\Models\Assessment\AssessmentTypeNo;
use App\Models\Site\Assessment\SiteAssessmentDeclare;
use App\Models\Site\Assessment\SiteAssessmentDeclareStudent;
use App\Models\Site\Assessment\SiteAssessmentDeclareStudentSubject;
use App\Models\Site\Assessment\SiteAssessmentRoutine;
use App\Models\Site\Assessment\SiteClassSubjectAssessmentTopic;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Auth;
use Response;
use Session;

class SiteBaseAssessmentMarkEntryController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    public function index()
    {
        $viewType = 'Subject Assesment Topic';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getSiteAssessmentListForMarkEntry(Request $requests){
        $data = $requests->all();
       
        $check_declared_ids=SiteAssessmentDeclare::where('academic_version_id', $requests->academic_version_id)
            ->where('academic_year_id', $requests->academic_year_id)
            ->where('academic_shift_id', $requests->academic_shift_id)
            ->where('academic_class_id', $requests->academic_class_id)
            ->where('status', true)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->pluck('id')
            ->unique();

        $subject_type_ids=SiteAssessmentDeclareStudentSubject::whereIn('site_assessment_declare_id',$check_declared_ids)
                ->where('status', true)
                ->pluck('assessment_id')
                ->unique()
                ->filter();

        $subjects=Assessment::whereIn('id', $subject_type_ids)->get();

        return $subjects;

    }


    public function getSiteAssessmentDeclaredSubjectList(Request $requests){

        $data = $requests->all();
       
        $check_declared_list=SiteAssessmentDeclare::where('academic_version_id', $requests->academic_version_id)
            ->where('academic_year_id', $requests->academic_year_id)
            ->where('academic_shift_id', $requests->academic_shift_id)
            ->where('academic_class_id', $requests->academic_class_id)
            ->where('assessment_id', $requests->assessment_id)
            ->where('status', true)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->first();

        $subject_type_ids=SiteAssessmentDeclareStudentSubject::where('site_assessment_declare_id',$check_declared_list->id)
                ->where('assessment_id', $requests->assessment_id)
                ->where('status', true)
                ->pluck('site_subject_group_condition_setting_id')
                ->unique()
                ->filter();

        $subjects=SubjectGroupConditionSetting::whereIn('id', $subject_type_ids)->get();

        return $subjects;


    }

    public function getSiteAssessmentWiseAssessmentTypeForMarkEntry(Request $requests){

        $data=$requests->all();
       
        $check_declared_list_ids=SiteAssessmentDeclare::where('academic_version_id', $requests->academic_version_id)
        ->where('academic_year_id', $requests->academic_year_id)
        ->where('academic_shift_id', $requests->academic_shift_id)
        ->where('academic_class_id', $requests->academic_class_id)
        ->where('assessment_id', $requests->assessment_id)
        ->where('status', true)
        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })
        ->pluck('id')
        ->unique()
        ->filter();

        //$check_declared_list->pluck('assessment_type_id')->unique()->filter();

    $subject_type_ids=SiteAssessmentDeclareStudentSubject::whereIn('site_assessment_declare_id',$check_declared_list_ids)
            ->where('assessment_id', $requests->assessment_id)
            ->where('status', true)
            ->pluck('assessment_type_id')
            ->unique()
            ->filter();

        $assessment_types=AssessmentType::whereIn('id',$subject_type_ids)->get();

        return $assessment_types;
    }

    public function getSiteAssessmentDeclaredSubjectTopicList(Request $requests){

        $data=$requests->all();

        $check_declared_list_ids=SiteAssessmentDeclare::where('academic_version_id', $requests->academic_version_id)
            ->where('academic_year_id', $requests->academic_year_id)
            ->where('academic_shift_id', $requests->academic_shift_id)
            ->where('academic_class_id', $requests->academic_class_id)
            ->where('assessment_id', $requests->assessment_id)
            ->where('assessment_type_id', $requests->assessment_type_id)
            ->where('status', true)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->pluck('id')
            ->unique()
            ->filter();

        $subject_topic_ids=SiteAssessmentDeclareStudentSubject::whereIn('site_assessment_declare_id',$check_declared_list_ids)
            ->where('assessment_id', $requests->assessment_id)
            ->where('assessment_type_id', $requests->assessment_type_id)
            ->where('site_subject_group_condition_setting_id', $requests->site_subject_group_condition_setting_id)
            ->where('status', true)
            ->pluck('subject_topic_id')
            ->unique()
            ->filter();

            $assessment_topics=AssessmentExpertiseWiseTopic::whereIn('id',$subject_topic_ids)->orderBy('serial')->get();

            return $assessment_topics;
    }


    public function getSiteBaseStudentListForAssessmentMarkEntry(Request $request){
        $data = $request->all();

      
        $asessmentDeclaredList = SiteAssessmentDeclare::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('assessment_id', $request->assessment_id)
            ->where('assessment_type_id', $request->assessment_type_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->pluck('id');

        $assessment_type_no_ids=SiteAssessmentDeclareStudentSubject::whereIn('site_assessment_declare_id', $asessmentDeclaredList)
            ->where('assessment_id', $request->assessment_id)
            ->where('assessment_type_id', $request->assessment_type_id)
            ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->where('assessment_id', $request->assessment_id)
            ->where('subject_topic_id', $request->subject_topic_id)
            ->where('status', true)
            ->pluck('assessment_type_no_id')
            ->unique()
            ->filter();

          
    
        $type_no_list=AssessmentTypeNo::whereIn('id',$assessment_type_no_ids)->orderBy('serial')->get();
    
       

        $studentIds=StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            // ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            //     return $query->where('academic_session_id', $data['academic_session_id']);
            // })
            ->where('status', true)
            ->orderBy('student_roll_number', 'asc')
            ->pluck('id');




        $declaredStudentList=SiteAssessmentDeclareStudent::with([ 'studentHistory'=>function($querys) use ($data){
            $querys->select('id', 'user_id', 'student_roll_number');
            $querys->when(!empty($data['academic_class_group_id']), function ($q) use ($data) {
                return $q->where('academic_class_group_id', $data['academic_class_group_id']);
            });

        },
        // 'siteAssessmentDeclareStudentSubject'=>function($query) use ($request){
        //     $query->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id);
        //     $query->where('subject_topic_id', $request->subject_topic_id);
        //     $query->with(['assessmentTypeNo']);
        //     $query->where('status',true);
        //     $query->with(['marksInputBy'=>function($q) use ($request){
        //         $q->select('id');
        //     }]);

        // }
        ])
            ->whereIn('site_assessment_declare_id', $asessmentDeclaredList)
            ->whereIn('student_history_id', $studentIds)
            ->where('status',true)
            ->get();

            $student_list=[];
            $key=0;
            foreach($declaredStudentList as $item){
                $type_no_array=[];
                $keys=0;
                $studentSubject=SiteAssessmentDeclareStudentSubject::where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
                    ->where('student_history_id', $item->student_history_id)
                    ->where('site_assessment_declare_id', $item->site_assessment_declare_id)
                    ->where('subject_topic_id', $request->subject_topic_id)
                    ->whereIn('assessment_type_no_id', $assessment_type_no_ids)
                    ->where('status',true)
                    ->get();

                  //  dd($studentSubject);

                // foreach($item->siteAssessmentDeclareStudentSubject as $items){
               foreach($studentSubject as $items){
                    $type_no_array[$keys]['id']=$items?$items->id:'';
                    $type_no_array[$keys]['type_name']=$items->assessmentTypeNo?$items->assessmentTypeNo->type_no:'';
                    $type_no_array[$keys]['type_no_id']=$items->assessmentTypeNo?$items->assessmentTypeNo->id:'';
                    $type_no_array[$keys]['assessment_attendance_status']=$items->assessment_attendance_status;
                    $type_no_array[$keys]['assessment_type_no_mark']=$items->assessment_type_no_mark;
                    $type_no_array[$keys]['marks_input_by']=$items->marksInputBy?$items->marksInputBy->full_name:'';
                  //  dd($items);
                    $keys++;
                }
             //   dd($type_no_array);
                $student_list[$key]['student_name']=$item->studentHistory?$item->studentHistory->full_name:'';
                $student_list[$key]['student_roll_number']=$item->studentHistory?$item->studentHistory->student_roll_number:'';
                $student_list[$key]['student_roll']=$item->studentHistory?$item->studentHistory->student_full_roll_number:'';
                $student_list[$key]['type_no_array']=$type_no_array;

                $key++;
            }


            $student_asc_list=array_values(array_sort(collect($student_list), function ($value) {
                return $value['student_roll_number'];
            }));

           return [$student_asc_list, $type_no_list];


    }

    public function createUpdateAssessmentStudentMarkEntry(Request $request){

        foreach($request->StudentListForMarksEntry as $key=>$student){
            foreach($student['type_no_array'] as $keys=>$item){

                $checkStudentMark=SiteAssessmentDeclareStudentSubject::find($item['id']);
                if($checkStudentMark->assessment_type_no_mark != $item['assessment_type_no_mark']){
                  
                        if($item['assessment_type_no_mark']=='triangle'){
                            $mark_text_value='advanced';
                        }elseif($item['assessment_type_no_mark']=='circle'){
                            $mark_text_value='mediam';
                        }elseif($item['assessment_type_no_mark']=='rectangle'){
                            $mark_text_value='elementary';
                        }else{
                            $mark_text_value=null;
                        }
                        
                        SiteAssessmentDeclareStudentSubject::where('id',$item['id'])->update([
                            'assessment_type_no_mark'=>$item['assessment_type_no_mark'],
                            'mark_text_value'=>$mark_text_value,
                            'marks_input_by'=>Auth::user()->id,
                        ]);
                    }
                }
               
        }
           
        

        return Response::json(['message'=>'Assessment Save Successfully'],200);

    }





}
