<?php

namespace App\Http\Controllers\Site\AssessmentResult\Report;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicAssessmentPrimaryResultType;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Assessment\AssessmentType;
use App\Models\Assessment\AssessmentTypeNo;
use App\Models\Site\Assessment\SiteAssessmentDeclare;
use App\Models\Site\Assessment\SiteAssessmentDeclareStudent;
use App\Models\Site\Assessment\SiteAssessmentDeclareStudentSubject;
use App\Models\Site\Assessment\SiteIndividualCombineSubjectAssessmentResultStore;
use App\Models\Site\AssessmentResult\SiteStudentAssessmentResultDetail;
use App\Models\Site\AssessmentResult\SiteAssessmentResultPrimarySetting;
use App\Models\Site\AssessmentResult\SiteStudentAssessmentPrimaryResultDetail;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\Site\Employee\Employee;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Response;
use Session;
use PDF;
use View;
use Auth;
use Carbon\Carbon;
use Intervention\Image\Gd\Decoder;

class SiteBaseAssessmentPrimaryResultReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    public function index()
    {
        $viewType = 'Assessment Primary Result Report';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    
    public function getSiteBaseAssessmentPrimaryResultList(Request $request){

        $data=$request->all();

        $student_history_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
        ->where('academic_year_id', $request->academic_year_id)
        ->where('academic_shift_id', $request->academic_shift_id)
        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })
        ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
            return $query->where('academic_class_id', $data['academic_class_id']);
        })
        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
        })
        ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            return $query->where('academic_session_id', $data['academic_session_id']);
        })
//                ->where('status', true)
        ->pluck('id')
        ->unique()
        ->filter();

        $academic_assessment_result_primary_type_ids = SiteStudentAssessmentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
            ->pluck('academic_assessment_result_primary_type_id')
            ->unique()
            ->filter();

        $academic_primary_result_type=AcademicAssessmentPrimaryResultType::whereIn('id', $academic_assessment_result_primary_type_ids)->get();
    
        return $academic_primary_result_type;

    }

//     public function getAssessmentTypeListForPrimaryResult(Request $request){

//         $data = $request->all();
//       //  dd('sf');

//         $student_history_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
//         ->where('academic_year_id', $request->academic_year_id)
//         ->where('academic_shift_id', $request->academic_shift_id)
//         ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
//             return $query->where('academic_department_id', $data['academic_department_id']);
//         })
//         ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
//             return $query->where('academic_class_id', $data['academic_class_id']);
//         })
//         ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
//             return $query->where('academic_class_group_id', $data['academic_class_group_id']);
//         })
//         ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
//             return $query->where('academic_session_id', $data['academic_session_id']);
//         })
// //                ->where('status', true)
//         ->pluck('id')
//         ->unique()
//         ->filter();
      
//         $assessment_type_ids = SiteStudentAssessmentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
//             ->where('academic_assessment_result_primary_type_id', $request->academic_assessment_result_primary_type_id)
//             ->pluck('assessment_type_id')
//             ->unique()
//             ->filter();

//           $assessment_type =  AssessmentType::whereIn('id',$assessment_type_ids)->get();
       
//         return $assessment_type;
// }




  
    public function getSiteStudentListForPrimaryList(Request $request){

        $data = $request->all();
       
        $student_history_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
        ->where('academic_year_id', $request->academic_year_id)
        ->where('academic_shift_id', $request->academic_shift_id)
        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })
        ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
            return $query->where('academic_class_id', $data['academic_class_id']);
        })
        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
        })
        ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            return $query->where('academic_session_id', $data['academic_session_id']);
        })
//                ->where('status', true)
        ->pluck('id')
        ->unique()
        ->filter();
      
        $student_ids = SiteStudentAssessmentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
            ->where('academic_assessment_result_primary_type_id', $request->academic_assessment_result_primary_type_id)
            ->pluck('student_history_id')
            ->unique()
            ->filter();

        $studentHistories = StudentHistory::whereIn('id', $student_ids)->get();

        return $studentHistories;
        
    }


    public function getSiteStudentAssessmentPrimaryResultDetails(Request $requests){

        $studentList=$this->studentHistoryList($requests);

        $student_historys=$studentList->whereIn('id', $requests->select_student_user_ids);
        $student_ids=$student_historys->pluck('id')->unique();

        ////
       // dd($student_ids);

       $assessmentResultDetailList=SiteStudentAssessmentPrimaryResultDetail::with(['studentHistory'=>function ($query) {
        $query->select('id', 'user_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id',
            'academic_session_id', 'academic_student_category_id', 'board_registration_number',
            'academic_class_group_id', 'academic_section_id', 'academic_year_id', 'student_roll_number',
            'registration_no');
            $query->with(['student' => function ($q) {
                $q->with('latestPhoto');
                $q->select('id');
                $q->where('user_type', 'student');
            },
                'year', 'shift','department','stClass','classGroup','session','section'
            ]);
        }])
        ->whereIn('student_history_id', $requests->select_student_user_ids)
        ->whereIn('student_history_id', $student_ids)
        ->where('academic_assessment_result_primary_type_id', $requests->academic_assessment_result_primary_type_id)
    //    ->where('assessment_type_id',$request->assessment_type_id)
        ->where('status', true)
        ->get();


        $student_array=[];

        $s_key=0;
        foreach($student_historys as $student_history){
           
           $assessment_type_list=AssessmentType::get();
     
            $type_list=[];
            $type_key=0;

         //   dd($assessmentResultDetailList->where('student_history_id',$student_history->id));

           foreach($assessment_type_list as $assessment_type){
            $studentTypeResult=$assessmentResultDetailList->where('student_history_id',$student_history->id)
                    ->where('assessment_type_id',$assessment_type->id)
                    ->first();
                  
            if($studentTypeResult){

           
            $resutl=SiteStudentAssessmentPrimaryResultDetail::where('id',$studentTypeResult->id)->first();
        //    dd($resutl);
              //  dd($studentTypeResult->result_details);
         
            $assessment_type_ids=[];
            $subject_condition_setting_ids=[];
            $sc_key=0;
            $t_key=0;

           // dd($resutl);
               foreach($resutl['result_details'] as $result_item){

                $subject_condition_setting_ids[$sc_key]=$result_item['site_subject_group_condition_setting_id'];

                    foreach($result_item['type_no_list'] as $type_no){
                        $assessment_type_ids[$t_key]=$type_no['type_no_id'];
                        $t_key++;
                    }
                    $sc_key++;
               
               }

               $subject_condition=SubjectGroupConditionSetting::whereIn('id', $subject_condition_setting_ids)->orderBy('subject_position')->get();
             
              
               $type_ids=collect($assessment_type_ids)->unique()->filter();
         
               $type_no_list=AssessmentTypeNo::whereIn('id',$type_ids)->orderBy('serial')->get();
          
               $type_list[$type_key]['assessment_type']=$assessment_type;
               $type_list[$type_key]['result_details']=$studentTypeResult['result_details'];
               $type_list[$type_key]['type_no_wise_result_details']=$studentTypeResult['type_no_wise_result_details'];
               $type_list[$type_key]['type_no_list']=$type_no_list;
               $type_list[$type_key]['subject_condition_list']=$subject_condition;
               $type_key++;
           }
           }

           $student_array[$s_key]['student_history']=$student_history;           
           $student_array[$s_key]['student_photo']=$student_history->student->latestPhoto?$student_history->student->latestPhoto->name:'image-not.png';

           $student_array[$s_key]['assessment_type_result']=$type_list;

           $s_key++;
        }

        return $student_array;

    }

    
   

    public function getSiteAssessmentPrimaryResultSheetPdf(Request $request){

        ini_set('memory_limit', '-1');
        $data = $request->all();

    //   $is_qrcode = $data['is_qrcode'];
       $is_stdImage = $data['is_stdImage'];
    //   $is_academic_perform = $data['is_academic_perform'];
       $head_signature_status =$data['head_signature_status'];

        $report_tittle='';
        $report_tittle2='';

       $student_array =  $this->getSiteStudentAssessmentPrimaryResultDetails($request);
      
     
        //============ domain name =============
        $result_type =  AcademicAssessmentPrimaryResultType::findOrFail($request->academic_assessment_result_primary_type_id);
        $site_info =  SiteInfo::findOrFail(Session::get('SITE_ID'));
        if($site_info->domain_name==null){
             $alias = $site_info->site_alias;
            $url = config('app.url');
            $parsedUrl = parse_url($url);
            $host = $parsedUrl['host'];
            $host_names = explode(".", $host);
            $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];

            if ($host_names[count($host_names) - 1] == 'bd') {
                $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];
            }
            if (count($host_names) == 2) {
                $bottom_host_name = $host_names[count($host_names) - 1];
            }
            $domain = $parsedUrl['scheme'] . '://' . $alias . '.' . $bottom_host_name;
      
        }else{
            $domain = $site_info->domain_name;
        }

        $institute_head = Employee::where('institute_head', 1)->first();
 
        $head_signature = $institute_head->signature ?? '/img/signature/signature.png';
        $head_designation = $institute_head->designation->name ?? 'Institution Head';
        $academic_year = AcademicYear::findOrFail($request->academic_year_id);

         //===========
      //  dd($student_array);

      $view = View::make('default.admin.site.assessment.site-base-multiple-student-assessment-primary-result-detail-report',
              compact('student_array','site_info','result_type', 'report_tittle', 'report_tittle2', 'domain',
              'head_signature','head_designation','is_stdImage','head_signature_status','academic_year'));
     // ->setWarnings(false);


        $contents = $view->render();

        $path = storage_path() . '/pdf';

        $mpdf = new \Mpdf\Mpdf();
      
        $mpdf->autoScriptToLang = true;
        $mpdf->autoLangToFont = true;
        $mpdf->allow_charset_conversion = false;
        $mpdf->WriteHTML($contents);
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $mpdf->Output($path . '/' . $time . '.pdf', 'F');
        $name = $time . '.pdf';

        return Response::json(['link' => route('open-pdf-file-storage', [$name]),
          'message' => 'Successfully Created Card Report'], 200);



        // $pdf = PDF::loadView('default.admin.site.assessment.site-base-multiple-student-assessment-primary-result-detail-report',
        //         compact('student_array','site_info','result_type', 'report_tittle', 'report_tittle2', 'domain',
        //         'head_signature','head_designation','is_stdImage','head_signature_status'))
        //         ->setWarnings(false);
       


        // $path = storage_path() . '/pdf';
        // $time = Auth::user()->id . '-' . Carbon::now()->unix();
        // $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        // $name = $time . '.pdf';


        // return Response::json(['link' => route('open-pdf-file-storage', [$name]),
        //     'message' => 'Successfully Created Card Report'], 200);

    }


    private function studentHistoryList(Request $requests){

        $data=$requests->all();
       
        $studentList=StudentHistory::with('year', 'shift','department','stClass','classGroup','session','section')
            ->where('academic_version_id', $requests->academic_version_id)
            ->where('academic_year_id', $requests->academic_year_id)
            ->where('academic_shift_id', $requests->academic_shift_id)
            ->where('academic_class_id', $requests->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_class_id')
            ->get();

      
        return $studentList;

    }



}
