<?php

namespace App\Http\Controllers\Site\AssessmentResult\Report;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Assessment\Assessment;
use App\Models\Assessment\AssessmentType;
use App\Models\Assessment\AssessmentTypeNo;
use App\Models\Site\Assessment\SiteAssessmentDeclare;
use App\Models\Site\Assessment\SiteAssessmentDeclareStudentSubject;
use App\Models\Site\AssessmentResult\SiteStudentAssessmentResultDetail;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\Site\Employee\Employee;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Carbon\Carbon;
use PDF;
use Response;
use Session;
use View;

class SiteBaseAssessmentResultReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    public function index()
    {
        $viewType = 'Subject Assesment Topic';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getAssessmentDeclarListForResult(Request $requests){
        $data = $requests->all();
       
        $assessment_declared_ids=SiteAssessmentDeclare::where('academic_version_id', $requests->academic_version_id)
            ->where('academic_year_id', $requests->academic_year_id)
            ->where('academic_shift_id', $requests->academic_shift_id)
            ->where('academic_class_id', $requests->academic_class_id)
            ->where('status', true)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->pluck('id')
            ->unique();


        $assessment_ids=SiteStudentAssessmentResultDetail::whereIn('assessment_declare_id', $assessment_declared_ids)
            ->pluck('assessment_id')
            ->unique();

        $assessmentList=Assessment::whereIn('id', $assessment_ids)->get();

        return $assessmentList;

    }

    public function getAssessmentTypeListForResult(Request $requests){

        $assessment_declared_ids=SiteAssessmentDeclare::where('academic_version_id', $requests->academic_version_id)
            ->where('academic_year_id', $requests->academic_year_id)
            ->where('academic_shift_id', $requests->academic_shift_id)
            ->where('academic_class_id', $requests->academic_class_id)
            ->where('status', true)
            ->pluck('id')
            ->unique();


        $type_ids=SiteStudentAssessmentResultDetail::whereIn('assessment_declare_id', $assessment_declared_ids)
            ->pluck('assessment_type_id')
            ->unique();

        $assessmentTypeList=AssessmentType::whereIn('id', $type_ids)->get();

        return $assessmentTypeList;

    }

    public function getSiteStudentAssessmentTabulationSheet(Request $requests){

        $data=$requests->all();
       
        $studentList=$this->studentHistoryList($requests);

        $student_ids=$studentList->pluck('id')->unique();
        
        $placeholders = implode(',',array_fill(0, count($student_ids), '?'));

        $restultList=SiteStudentAssessmentResultDetail::with('studentHistory','subjectList')->where('assessment_declare_id', $requests->assessment_declare_id)
            ->where('assessment_type_id',$requests->assessment_type_id)
            ->whereIn('student_history_id',$student_ids)
            ->where('status',true)
            ->orderByRaw("field(student_history_id,{$placeholders})", $student_ids)
            ->get();


    // subject list
    
       $siteAssessmentDeclareStudentSubject=SiteAssessmentDeclareStudentSubject::where('site_assessment_declare_id',$requests->assessment_declare_id)
                ->where('assessment_type_id',$requests->assessment_type_id) 
                ->whereIn('student_history_id',$student_ids)
                ->where('status', true)
                ->get();

      $subject_type_ids=$siteAssessmentDeclareStudentSubject
                ->pluck('site_subject_group_condition_setting_id')
                ->unique()
                ->filter();

        $subjects=SubjectGroupConditionSetting::whereIn('id', $subject_type_ids)->get();

        return [$restultList, $subjects];

    }

    public function getSiteStudentList(Request $request){

        $studentList=$this->studentHistoryList($request);

        $student_history_ids=$studentList->pluck('id');

        $student_ids = SiteStudentAssessmentResultDetail::whereIn('student_history_id', $student_history_ids)
            ->where('assessment_id', $request->assessment_id)
            ->where('assessment_type_id', $request->assessment_type_id)
            ->pluck('student_history_id')
            ->unique()
            ->filter();

        $studentHistories = StudentHistory::whereIn('id', $student_ids)->get();

        return $studentHistories;

    }

    private function studentHistoryList(Request $requests){

        $data=$requests->all();
       
        $studentList=StudentHistory::where('academic_version_id', $requests->academic_version_id)
            ->where('academic_year_id', $requests->academic_year_id)
            ->where('academic_shift_id', $requests->academic_shift_id)
            ->where('academic_class_id', $requests->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_class_id')
            ->get();

      
        return $studentList;

    }

    public function getSiteAssessmentStudentResultDetails(Request $request){
        

        $assessment_declared=SiteAssessmentDeclare::where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->where('assessment_id', $request->assessment_id)
                ->where('assessment_type_id', $request->assessment_type_id)
                ->where('status', true)
                ->first();
                
     
        $studentList=$this->studentHistoryList($request);
        $student_ids=$studentList->pluck('id')->unique();
        
        $siteAssessmentDeclareStudentSubject=SiteAssessmentDeclareStudentSubject::where('site_assessment_declare_id',$assessment_declared->id)
            ->where('assessment_type_id',$request->assessment_type_id) 
            ->whereIn('student_history_id',$student_ids)
            ->where('status', true)
            ->get();

        $subject_group_condition_setting_ids=$siteAssessmentDeclareStudentSubject->pluck('site_subject_group_condition_setting_id')->unique();
        $assessment_type_no_ids=$siteAssessmentDeclareStudentSubject->pluck('assessment_type_no_id')->unique();
        
        $subjects=SubjectGroupConditionSetting::whereIn('id', $subject_group_condition_setting_ids)->get();
       
        $typeNOList=AssessmentTypeNo::whereIn('id', $assessment_type_no_ids)->orderBy('serial')->get();
      
        $assessmentResultDetails=SiteStudentAssessmentResultDetail::with(['studentHistory'=>function ($query) {
            $query->select('id', 'user_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id',
                'academic_session_id', 'academic_student_category_id', 'board_registration_number',
                'academic_class_group_id', 'academic_section_id', 'academic_year_id', 'student_roll_number',
                'registration_no');
            $query->with(['student' => function ($q) {
                $q->with('latestPhoto');
                $q->select('id');
                $q->where('user_type', 'student');
            },
                'year', 'shift','department','stClass','classGroup','session','section'
            ]);
        }, 'subjectList'=>function($qu){
                $qu->where('status',true);
            }])
            ->whereIn('student_history_id', $request->select_student_user_ids)
            ->whereIn('student_history_id', $student_ids)
            ->where('assessment_declare_id', $assessment_declared->id)
            ->where('assessment_type_id',$request->assessment_type_id)
            ->where('status', true)
            ->get();

         //   dd($assessmentResultDetails);

         
            $result_array=[];
            $key=0;
            foreach($assessmentResultDetails as $item){

                // $assessmentBIResult=SiteStudentAssessmentResultDetail::where('student_history_id',$item->student_history_id)
                //         ->where('assessment_declare_id', $request->assessment_declare_id)
                //         //->where('result_type_key', 'BI')
                //         ->first();

                $result_array[$key]['assessment_name']=$item->assessment_name;
                $result_array[$key]['assessment_type_name']=$item->assessmentType->type_name;
                $result_array[$key]['student_history']=$item->studentHistory;
             
             //   $result_array[$key]['subject_list']=$item->subjectList;
                $result_array[$key]['result_details']=$item->result_details;
               
                $result_array[$key]['total_marks']=$item->total_marks;
                $result_array[$key]['total_subject_count']=$item->total_subject_count;
                $result_array[$key]['result_subject_count']=$item->result_subject_count;
                $result_array[$key]['student_photo']=$item->studentHistory->student->latestPhoto?$item->studentHistory->student->latestPhoto->name:'image-not.png';
                
                $key++;
            }
      
     
     
        return [$result_array,$subjects,$typeNOList];
             
    }

    public function getSiteAssessmentTabulationSheetPdf(Request $request){
        
        $data=$request->all();
       // dd('$tabulation_array');
        $tabulation_array=$this->getSiteStudentAssessmentTabulationSheet($request);
     //   return $tabulation_array;
        $student_result_list=$tabulation_array[0];
        $subject_list=$tabulation_array[1];

        ////////////////
        $declared_assessment=SiteAssessmentDeclare::where('id',$request->assessment_declare_id)->first();

        $result_name=$declared_assessment->assessment_name;

        $assessment_type=AssessmentType::find($request->assessment_type_id);
        $assessment_type_name=$assessment_type->type_name;

        $report_tittle="";
         $report_tittle .= $result_name;
        $report_tittle .= ", ";
        $report_tittle .= $assessment_type_name;
        $report_tittle .= ", ";
        $report_tittle .= "Assessment Tabulation Sheet";


       $report_tittle2="<br>";
        $report_tittle2 .= "<b>Year: </b>" . ($student_result_list[0]['studentHistory']['year']['year_name'] ?? '');
        $report_tittle2 .= " <b>Shift: </b>" . ($student_result_list[0]['studentHistory']['shift']['shift_name'] ?? '');


        $report_tittle .= "<br>";
        if ($student_result_list[0]['studentHistory']['department']) {
            $report_tittle2 .= "<b> Dept: </b>" . $student_result_list[0]['studentHistory']['department']['name'];
        }

        if ($student_result_list[0]['studentHistory']['st_class']) {
            $report_tittle2 .= "  <b> Class: </b>" . ($student_result_list[0]['studentHistory']['st_class']['class_name'] ?? '');
        }

        if ($student_result_list[0]['studentHistory']['class_group']) {
            $report_tittle2 .= "<b> Group: </b>" . ($student_result_list[0]['studentHistory']['class_group']['group_name'] ?? '');
        }

        if ($student_result_list[0]['studentHistory']['section']) {
            $report_tittle2 .= "<b> Section: </b>" . ($student_result_list[0]['studentHistory']['section']['section_name'] ?? '');
        }

        if ($student_result_list[0]['studentHistory']['session']) {
            $report_tittle2 .= "<b> Session: </b>" . ($student_result_list[0]['studentHistory']['session']['session_name'] ?? '');
        }

            $view = View::make('default.admin.site.assessment.site-base-student-assessment-result-tabulation-sheet',
            compact('student_result_list','subject_list','report_tittle', 'report_tittle2', 'result_name'))
            ->setPaper('a4', 'landscape');
            //->setWarnings(false);


            /////
            $contents = $view->render();

            $path = storage_path() . '/pdf';
    
            $mpdf = new \Mpdf\Mpdf();
            $mpdf->autoScriptToLang = true;
            $mpdf->autoLangToFont = true;
            $mpdf->allow_charset_conversion = false;
            $mpdf->WriteHTML($contents);
            $time = \Auth::user()->id . '-' . Carbon::now()->unix();
            $mpdf->Output($path . '/' . $time . '.pdf', 'F');
            $name = $time . '.pdf';
            
            return Response::json(['link' => route('open-pdf-file-storage', [$name]),
                'message' => 'Successfully Created Card Report'], 200);
       
        

        // $pdf = PDF::loadView('default.admin.site.result.result_report.site-base-student-result-tabulation-sheet-report',
        //     compact('primary_result_tabulation', 'report_tittle', 'report_tittle2', 'final_subject_array', 'examinationList', 'result_name'))
        //     ->setPaper('a4', 'landscape')->setWarnings(false);

        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json(['link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'], 200);
    }

    public function getSiteAssessmentResultSheetPdf(Request $request){

        ini_set('memory_limit', '-1');
        $data = $request->all();

    //   $is_qrcode = $data['is_qrcode'];
       $is_stdImage = $data['is_stdImage'];
    //   $is_academic_perform = $data['is_academic_perform'];
       $head_signature_status =$data['head_signature_status'];

        $report_tittle='';
        $report_tittle2='';

       $primaryResultList =  $this->getSiteAssessmentStudentResultDetails($request);
      // return 
      //dd($primaryResultList);

       $result_list_array=$primaryResultList[0];
       $subjects_list=$primaryResultList[1];
       $type_no_list=$primaryResultList[2];

  //     dd($result_list_array);

     
        //============ domain name =============
        $site_info =  SiteInfo::findOrFail(Session::get('SITE_ID'));
        if($site_info->domain_name==null){
             $alias = $site_info->site_alias;
            $url = config('app.url');
            $parsedUrl = parse_url($url);
            $host = $parsedUrl['host'];
            $host_names = explode(".", $host);
            $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];

            if ($host_names[count($host_names) - 1] == 'bd') {
                $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];
            }
            if (count($host_names) == 2) {
                $bottom_host_name = $host_names[count($host_names) - 1];
            }
            $domain = $parsedUrl['scheme'] . '://' . $alias . '.' . $bottom_host_name;
      
        }else{
            $domain = $site_info->domain_name;
        }

        $institute_head = Employee::where('institute_head', 1)->first();
 
        $head_signature = $institute_head->signature ?? '/img/signature/signature.png';
        $head_designation = $institute_head->designation->name ?? 'Institution Head';
        $academic_year = AcademicYear::findOrFail($request->academic_year_id);
         //===========
       //  dd($result_list_array);
        

       $view = View::make('default.admin.site.assessment.site-base-multiple-student-assessment-result-detail-report',
                compact('result_list_array','subjects_list','type_no_list', 'site_info', 'report_tittle', 'report_tittle2', 'domain',
                'head_signature','head_designation','is_stdImage','head_signature_status','academic_year'));
               // ->setWarnings(false);
       

        $contents = $view->render();

        $path = storage_path() . '/pdf';

        $mpdf = new \Mpdf\Mpdf();
        $mpdf->autoScriptToLang = true;
        $mpdf->autoLangToFont = true;
        $mpdf->allow_charset_conversion = false;
        $mpdf->WriteHTML($contents);
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $mpdf->Output($path . '/' . $time . '.pdf', 'F');
        $name = $time . '.pdf';
        
        return Response::json(['link' => route('open-pdf-file-storage', [$name]),
                    'message' => 'Successfully Created Card Report'], 200);

        ///////

        // $path = storage_path() . '/pdf';
        // $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        // $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        // $name = $time . '.pdf';


        // return Response::json(['link' => route('open-pdf-file-storage', [$name]),
        //     'message' => 'Successfully Created Card Report'], 200);
    }
}
